/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyCommandAddonAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.confirmations.ConfirmationTransaction;
import com.palmergames.bukkit.towny.event.PlotClearEvent;
import com.palmergames.bukkit.towny.event.PlotPreChangeTypeEvent;
import com.palmergames.bukkit.towny.event.PlotPreClearEvent;
import com.palmergames.bukkit.towny.event.TownBlockPermissionChangeEvent;
import com.palmergames.bukkit.towny.event.TownBlockSettingsChangedEvent;
import com.palmergames.bukkit.towny.event.TownPreAddResidentEvent;
import com.palmergames.bukkit.towny.event.plot.PlayerChangePlotTypeEvent;
import com.palmergames.bukkit.towny.event.plot.PlotNotForSaleEvent;
import com.palmergames.bukkit.towny.event.plot.PlotSetForSaleEvent;
import com.palmergames.bukkit.towny.event.plot.PlotTrustAddEvent;
import com.palmergames.bukkit.towny.event.plot.PlotTrustRemoveEvent;
import com.palmergames.bukkit.towny.event.plot.district.DistrictAddEvent;
import com.palmergames.bukkit.towny.event.plot.district.DistrictCreatedEvent;
import com.palmergames.bukkit.towny.event.plot.district.DistrictDeletedEvent;
import com.palmergames.bukkit.towny.event.plot.group.PlotGroupAddEvent;
import com.palmergames.bukkit.towny.event.plot.group.PlotGroupCreatedEvent;
import com.palmergames.bukkit.towny.event.plot.group.PlotGroupDeletedEvent;
import com.palmergames.bukkit.towny.event.plot.toggle.PlotToggleExplosionEvent;
import com.palmergames.bukkit.towny.event.plot.toggle.PlotToggleFireEvent;
import com.palmergames.bukkit.towny.event.plot.toggle.PlotToggleMobsEvent;
import com.palmergames.bukkit.towny.event.plot.toggle.PlotTogglePvpEvent;
import com.palmergames.bukkit.towny.event.plot.toggle.PlotToggleTaxedEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.CancelledEventException;
import com.palmergames.bukkit.towny.exceptions.NoPermissionException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.huds.HUDManager;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.District;
import com.palmergames.bukkit.towny.object.PermissionData;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnPointLocation;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownBlockTypeHandler;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyPermissionChange;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translator;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.regen.WorldCoordMaterialRemover;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.tasks.PlotClaim;
import com.palmergames.bukkit.towny.utils.AreaSelectionUtil;
import com.palmergames.bukkit.towny.utils.MoneyUtil;
import com.palmergames.bukkit.towny.utils.NameUtil;
import com.palmergames.bukkit.towny.utils.OutpostUtil;
import com.palmergames.bukkit.towny.utils.PermissionGUIUtil;
import com.palmergames.bukkit.towny.utils.ProximityUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.MathUtil;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class PlotCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> plotTabCompletes;
    private static final List<String> plotGroupTabCompletes;
    private static final List<String> districtTabCompletes;
    private static final List<String> plotSetTabCompletes;
    private static final List<String> plotRectCircleCompletes;
    private static final List<String> plotToggleTabCompletes;
    private static final List<String> plotPermTabCompletes;

    public PlotCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (plugin.isError()) {
                TownyMessaging.sendErrorMsg((Object)sender, "Locked in Safe mode!");
                return false;
            }
            if (!TownyAPI.getInstance().isTownyWorld(player.getWorld())) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_set_use_towny_off"));
                return false;
            }
            if (args == null) {
                HelpMenu.PLOT_HELP.send((CommandSender)player);
                return false;
            }
            try {
                this.parsePlotCommand(player, args);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
            }
        } else {
            HelpMenu.PLOT_HELP.send(sender);
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            switch (args[0].toLowerCase(Locale.ROOT)) {
                case "set": {
                    if (args.length == 2) {
                        return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.PLOT_SET, this.getPlotSetCompletions()), args[1]);
                    }
                    if (args.length == 3 && args[1].equalsIgnoreCase("outpost")) {
                        return Arrays.asList("spawn");
                    }
                    if (args.length == 3 && (args[1].equalsIgnoreCase("minjoindays") || args[1].equalsIgnoreCase("maxjoindays"))) {
                        ArrayList<String> numbersAndClear = new ArrayList<String>(numbers);
                        numbersAndClear.add("clear");
                        return NameUtil.filterByStart(numbersAndClear, args[2]);
                    }
                    if (args.length > 2 && args[1].equalsIgnoreCase("perm")) {
                        return PlotCommand.permTabComplete(StringMgmt.remArgs(args, 2));
                    }
                    if (args.length <= 2 || !TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.PLOT_SET, args[1])) break;
                    return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.PLOT_SET, args[1]).getTabCompletion(sender, StringMgmt.remFirstArg(args)), args[args.length - 1]);
                }
                case "toggle": {
                    if (args.length == 2) {
                        return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.PLOT_TOGGLE, plotToggleTabCompletes), args[1]);
                    }
                    if (args.length != 3) break;
                    return NameUtil.filterByStart(BaseCommand.setOnOffCompletes, args[2]);
                }
                case "claim": 
                case "unclaim": 
                case "notforsale": 
                case "nfs": {
                    if (args.length != 2) break;
                    return NameUtil.filterByStart(plotRectCircleCompletes, args[1]);
                }
                case "evict": {
                    if (args.length != 2) break;
                    return NameUtil.filterByStart(Collections.singletonList("forsale"), args[1]);
                }
                case "forsale": 
                case "fs": {
                    switch (args.length) {
                        case 2: {
                            return NameUtil.filterByStart(Collections.singletonList("within"), args[1]);
                        }
                        case 3: {
                            return NameUtil.filterByStart(plotRectCircleCompletes, args[2]);
                        }
                    }
                    return Collections.emptyList();
                }
                case "district": {
                    if (args.length == 2) {
                        return NameUtil.filterByStart(districtTabCompletes, args[1]);
                    }
                    if (args.length < 2) break;
                }
                case "group": {
                    if (args.length == 2) {
                        return NameUtil.filterByStart(plotGroupTabCompletes, args[1]);
                    }
                    if (args.length < 2) break;
                    switch (args[1].toLowerCase(Locale.ROOT)) {
                        case "set": {
                            if (args.length == 3) {
                                return NameUtil.filterByStart(Arrays.asList("perm", "maxjoindays", "minjoindays"), args[2]);
                            }
                            if (args.length > 3 && args[2].equalsIgnoreCase("perm")) {
                                return PlotCommand.permTabComplete(StringMgmt.remArgs(args, 3));
                            }
                        }
                        case "trust": {
                            if (args.length == 3) {
                                return NameUtil.filterByStart(Arrays.asList("add", "remove"), args[2]);
                            }
                            if (args.length == 4) {
                                return NameUtil.filterByStart(PlotCommand.getTownyStartingWith(args[3], "r"), args[3]);
                            }
                        }
                        case "perm": {
                            if (args.length == 3) {
                                return NameUtil.filterByStart(Arrays.asList("add", "remove", "gui"), args[2]);
                            }
                            if (args.length == 4) {
                                return NameUtil.filterByStart(PlotCommand.getTownyStartingWith(args[3], "r"), args[3]);
                            }
                        }
                        case "toggle": {
                            if (args.length != 3) break;
                            return NameUtil.filterByStart(plotToggleTabCompletes, args[2]);
                        }
                    }
                    return Collections.emptyList();
                }
                case "jailcell": {
                    if (args.length != 2) break;
                    return NameUtil.filterByStart(TownCommand.townAddRemoveTabCompletes, args[1]);
                }
                case "perm": {
                    if (args.length == 2) {
                        return NameUtil.filterByStart(plotPermTabCompletes, args[1]);
                    }
                    if (args.length != 3 || !args[1].equalsIgnoreCase("remove") && !args[1].equalsIgnoreCase("add")) break;
                    return NameUtil.filterByStart(PlotCommand.getTownyStartingWith(args[2], "r"), args[2]);
                }
                case "trust": {
                    if (args.length == 2) {
                        return NameUtil.filterByStart(Arrays.asList("add", "remove"), args[1]);
                    }
                    if (args.length == 3) {
                        if ("remove".equalsIgnoreCase(args[1])) {
                            TownBlock townBlock = WorldCoord.parseWorldCoord((Entity)player).getTownBlockOrNull();
                            if (townBlock != null) {
                                return townBlock.getTrustedResidents().stream().map(TownyObject::getName).toList();
                            }
                        } else {
                            return PlotCommand.getTownyStartingWith(args[2], "r");
                        }
                    }
                }
                default: {
                    if (args.length == 1) {
                        return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.PLOT, plotTabCompletes), args[0]);
                    }
                    if (args.length <= 1 || !TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.PLOT, args[0])) break;
                    return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.PLOT, args[0]).getTabCompletion(sender, args), args[args.length - 1]);
                }
            }
        }
        return Collections.emptyList();
    }

    public void parsePlotCommand(Player player, String[] split) throws TownyException {
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            HelpMenu.PLOT_HELP.send((CommandSender)player);
            return;
        }
        Resident resident = PlotCommand.getResidentOrThrow(player);
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(player);
        if (townBlock == null && !this.plotCommandAllowedInWilderness(split[0])) {
            throw new TownyException(Translatable.of("msg_not_claimed_1"));
        }
        if (townBlock != null && townBlock.getTownOrNull().isRuined()) {
            throw new TownyException(Translatable.of("msg_err_cannot_use_command_because_town_ruined"));
        }
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "claim": {
                this.parsePlotClaim(player, StringMgmt.remFirstArg(split), resident, townBlock);
                break;
            }
            case "clear": {
                this.parsePlotClear(resident, townBlock);
                break;
            }
            case "evict": {
                this.parsePlotEvict(resident, townBlock, StringMgmt.remFirstArg(split));
                break;
            }
            case "fs": 
            case "forsale": {
                this.parsePlotForSale(player, StringMgmt.remFirstArg(split), resident, townBlock);
                break;
            }
            case "group": {
                this.parsePlotGroup(StringMgmt.remFirstArg(split), resident, townBlock, player);
                break;
            }
            case "district": {
                this.parseDistrict(StringMgmt.remFirstArg(split), resident, townBlock, player);
                break;
            }
            case "info": {
                this.sendPlotInfo(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "jailcell": {
                this.parsePlotJailCell(player, resident, townBlock, StringMgmt.remFirstArg(split));
                break;
            }
            case "nfs": 
            case "notforsale": {
                this.parsePlotNotForSale(player, StringMgmt.remFirstArg(split), resident, townBlock);
                break;
            }
            case "perm": {
                this.parsePlotPermCommand(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "set": {
                this.parsePlotSet(player, StringMgmt.remFirstArg(split), resident, townBlock);
                break;
            }
            case "toggle": {
                this.plotToggle(player, resident, townBlock, StringMgmt.remFirstArg(split));
                break;
            }
            case "trust": {
                PlotCommand.parsePlotTrustCommand(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "unclaim": {
                this.parsePlotUnclaim(player, split, resident);
                break;
            }
            default: {
                if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.PLOT, split[0])) {
                    TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.PLOT, split[0]).execute((CommandSender)player, "plot", split);
                    break;
                }
                throw new TownyException(Translatable.of("msg_err_invalid_property", split[0]));
            }
        }
    }

    public void parsePlotClaim(Player player, String[] args, Resident resident, TownBlock townBlock) throws TownyException {
        Town town;
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_CLAIM.getNode());
        List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(resident, WorldCoord.parseWorldCoord((Entity)player), args, true);
        if (selection.size() == 1 && selection.get(0).hasTownBlock() && selection.get(0).getTownBlock().hasResident()) {
            if (!selection.get(0).getTownBlock().isForSale()) {
                Translatable message = Translatable.of("msg_already_claimed", selection.get(0).getTownBlock().getResidentOrNull());
                if (player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_EVICT.getNode())) {
                    try {
                        TownyAPI.getInstance().testPlotOwnerOrThrow(resident, townBlock);
                        message.append(Translatable.of("msg_plot_claim_consider_evict_instead"));
                    }
                    catch (TownyException townyException) {
                        // empty catch block
                    }
                }
                throw new TownyException(message);
            }
            if (selection.get(0).getTownBlock().hasResident(resident)) {
                throw new TownyException(Translatable.of("msg_err_you_already_own_this_plot"));
            }
        }
        selection = AreaSelectionUtil.filterPlotsForSale(resident, selection);
        if ((selection = AreaSelectionUtil.filterUnownedBlocks(resident, selection)).size() == 0) {
            throw new TownyException(Translatable.of("msg_err_empty_area_selection"));
        }
        if (selection.size() + resident.getTownBlocks().size() > TownySettings.getMaxResidentPlots(resident)) {
            throw new TownyException(Translatable.of("msg_max_plot_own", TownySettings.getMaxResidentPlots(resident)));
        }
        Town town2 = town = townBlock != null ? townBlock.getTownOrNull() : selection.get(0).getTownOrNull();
        if (this.playerIsAbleToJoinViaPlotClaim(resident, townBlock, town)) {
            List<WorldCoord> coords = selection;
            Confirmation.runOnAccept(() -> {
                try {
                    resident.setTown(town);
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {
                    // empty catch block
                }
                try {
                    this.continuePlotClaimProcess(coords, resident, player);
                }
                catch (TownyException e) {
                    TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
                }
            }).setTitle(Translatable.of("msg_you_must_join_this_town_to_claim_this_plot", town.getName())).setCancellableEvent(new TownPreAddResidentEvent(town, resident)).sendTo((CommandSender)player);
            return;
        }
        this.continuePlotClaimProcess(selection, resident, player);
    }

    private boolean playerIsAbleToJoinViaPlotClaim(Resident resident, TownBlock townBlock, Town town) {
        return !resident.hasTown() && town.isOpen() && !townBlock.getType().equals(TownBlockType.EMBASSY) && !town.isAllowedThisAmountOfResidents(town.getNumResidents() + 1, town.isCapital()) && !town.hasOutlaw(resident) && resident.hasPermissionNode(PermissionNodes.TOWNY_COMMAND_TOWN_JOIN.getNode());
    }

    public void parsePlotClear(Resident resident, TownBlock townBlock) throws TownyException {
        PlotCommand.checkPermOrThrow((Permissible)resident.getPlayer(), PermissionNodes.TOWNY_COMMAND_PLOT_CLEAR.getNode());
        if (townBlock == null) {
            throw new TownyException(Translatable.of("msg_err_empty_area_selection"));
        }
        if (!townBlock.getWorld().isUsingPlotManagementMayorDelete()) {
            throw new TownyException(Translatable.of("msg_err_plot_clear_disabled_in_this_world"));
        }
        TownyAPI.getInstance().testPlotOwnerOrThrow(resident, townBlock);
        BukkitTools.ifCancelledThenThrow(new PlotPreClearEvent(townBlock));
        Collection<Material> materialsToDelete = townBlock.getWorld().getPlotManagementMayorDelete();
        if (materialsToDelete.isEmpty()) {
            return;
        }
        WorldCoordMaterialRemover.queueDeleteWorldCoordMaterials(townBlock.getWorldCoord(), materialsToDelete);
        TownyMessaging.sendMsg(resident, Translatable.of("msg_clear_plot_material", StringMgmt.join(materialsToDelete, ", ")));
        BukkitTools.fireEvent(new PlotClearEvent(townBlock));
    }

    public void parsePlotEvict(Resident resident, TownBlock townBlock, String[] split) throws TownyException {
        boolean resell;
        PlotCommand.checkPermOrThrow((Permissible)resident.getPlayer(), PermissionNodes.TOWNY_COMMAND_PLOT_EVICT.getNode());
        if (!townBlock.hasResident()) {
            throw new TownyException(Translatable.of("msg_no_one_to_evict"));
        }
        TownyAPI.getInstance().testPlotOwnerOrThrow(resident, townBlock);
        boolean bl = resell = split.length > 0 && split[0].equalsIgnoreCase("forsale");
        if (townBlock.hasPlotObjectGroup()) {
            townBlock.getPlotObjectGroup().getTownBlocks().stream().forEach(TownBlock::evictOwnerFromTownBlock);
            TownyMessaging.sendMsg(resident, Translatable.of("msg_plot_evict_group", townBlock.getPlotObjectGroup().getName()));
            return;
        }
        townBlock.evictOwnerFromTownBlock(resell);
        TownyMessaging.sendMsg(resident, Translatable.of("msg_plot_evict"));
    }

    public void parsePlotForSale(Player player, String[] split, Resident resident, TownBlock townBlock) throws TownyException {
        List<Object> selection;
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_FORSALE.getNode());
        WorldCoord pos = WorldCoord.parseWorldCoord((Entity)player);
        Town town = townBlock.getTownOrNull();
        if (town == null) {
            throw new TownyException(Translatable.of("msg_err_empty_area_selection"));
        }
        double plotPrice = Math.max(town.getPlotTypePrice(townBlock.getType()), 0.0);
        if (split.length == 0) {
            if (pos.getTownBlock().hasPlotObjectGroup()) {
                throw new TownyException(Translatable.of("msg_err_plot_belongs_to_group_plot_fs2", pos));
            }
            this.setPlotForSale(resident, pos, plotPrice);
            return;
        }
        int areaSelectPivot = AreaSelectionUtil.getAreaSelectPivot(split);
        if (areaSelectPivot >= 0) {
            selection = AreaSelectionUtil.selectWorldCoordArea(resident, pos, StringMgmt.subArray(split, areaSelectPivot + 1, split.length));
            if (resident.hasPermissionNode(PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode()) && town.hasResident(resident) || resident.hasPermissionNode(PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYORINUNOWNED.getNode()) && town.hasResident(resident) && !townBlock.hasResident()) {
                selection = AreaSelectionUtil.filterOwnedBlocks(resident.getTown(), selection);
                selection = AreaSelectionUtil.filterOutResidentBlocks(resident, selection);
            } else {
                selection = AreaSelectionUtil.filterOwnedBlocks(resident, selection);
            }
            if (selection.isEmpty()) {
                throw new TownyException(Translatable.of("msg_err_empty_area_selection"));
            }
        } else {
            selection = new ArrayList<WorldCoord>();
            selection.add(pos);
        }
        if (areaSelectPivot != 0) {
            plotPrice = MoneyUtil.getMoneyAboveZeroOrThrow(split[0]);
        }
        for (WorldCoord worldCoord : selection) {
            TownBlock tb = worldCoord.getTownBlock();
            if (tb.hasPlotObjectGroup()) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_belongs_to_group_plot_fs2", worldCoord));
                continue;
            }
            this.setPlotForSale(resident, worldCoord, plotPrice);
        }
    }

    public void parsePlotSet(Player player, String[] split, Resident resident, TownBlock townBlock) throws TownyException {
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            HelpMenu.PLOT_SET.send((CommandSender)player);
            return;
        }
        if (townBlock.hasPlotObjectGroup() && !"name".equalsIgnoreCase(split[0]) && !TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.PLOT_SET, split[0])) {
            throw new TownyException(Translatable.of("msg_err_plot_belongs_to_group_set"));
        }
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "minjoindays": {
                this.parsePlotSetMinJoinDays(player, resident, townBlock, StringMgmt.remFirstArg(split));
                break;
            }
            case "maxjoindays": {
                this.parsePlotSetMaxJoinDays(player, resident, townBlock, StringMgmt.remFirstArg(split));
                break;
            }
            case "perm": {
                PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_SET_PERM.getNode());
                TownyAPI.getInstance().testPlotOwnerOrThrow(resident, townBlock);
                PlotCommand.setTownBlockPermissions(player, townBlock.getTownBlockOwner(), townBlock, StringMgmt.remFirstArg(split));
                break;
            }
            case "name": {
                PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_SET_NAME.getNode());
                TownyAPI.getInstance().testPlotOwnerOrThrow(resident, townBlock);
                this.parsePlotSetName(player, StringMgmt.remFirstArg(split), townBlock);
                break;
            }
            case "outpost": {
                PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_CLAIM_OUTPOST.getNode());
                TownyAPI.getInstance().testPlotOwnerOrThrow(resident, townBlock);
                boolean spawn = split.length == 2 && split[1].equalsIgnoreCase("spawn");
                this.parsePlotSetOutpost(player, resident, townBlock, spawn);
                break;
            }
            default: {
                if (this.tryPlotSetAddonCommand(player, split)) {
                    return;
                }
                this.tryPlotSetType(player, resident, townBlock, split);
            }
        }
    }

    private void parsePlotSetMinJoinDays(Player player, Resident resident, TownBlock townBlock, String[] args) throws TownyException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode());
        TownyAPI.getInstance().testPlotOwnerOrThrow(resident, townBlock);
        if (args.length == 0 || args[0].equalsIgnoreCase("?")) {
            HelpMenu.PLOT_SET.send((CommandSender)player);
            return;
        }
        if (args[0].equalsIgnoreCase("clear")) {
            townBlock.setMinTownMembershipDays(-1);
            townBlock.save();
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_townblock_min_join_days_removed"));
            return;
        }
        int days = MathUtil.getPositiveIntOrThrow(args[0]);
        if (days == 0) {
            throw new TownyException(Translatable.of("msg_err_days_must_be_greater_than_0"));
        }
        townBlock.setMinTownMembershipDays(days);
        townBlock.save();
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_townblock_min_join_days_set_to", townBlock.getMinTownMembershipDays()));
    }

    private void parsePlotSetMaxJoinDays(Player player, Resident resident, TownBlock townBlock, String[] args) throws TownyException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode());
        TownyAPI.getInstance().testPlotOwnerOrThrow(resident, townBlock);
        if (args.length == 0 || args[0].equalsIgnoreCase("?")) {
            HelpMenu.PLOT_SET.send((CommandSender)player);
            return;
        }
        if (args[0].equalsIgnoreCase("clear")) {
            townBlock.setMaxTownMembershipDays(-1);
            townBlock.save();
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_townblock_max_join_days_removed"));
            return;
        }
        int days = MathUtil.getPositiveIntOrThrow(args[0]);
        if (days == 0) {
            throw new TownyException(Translatable.of("msg_err_days_must_be_greater_than_0"));
        }
        townBlock.setMaxTownMembershipDays(days);
        townBlock.save();
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_townblock_max_join_days_set_to", townBlock.getMaxTownMembershipDays()));
    }

    private void tryPlotSetType(Player player, Resident resident, TownBlock townBlock, String[] split) throws TownyException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_SET.getNode(split[0].toLowerCase(Locale.ROOT)));
        String plotTypeName = split[0];
        if (plotTypeName.equalsIgnoreCase("reset")) {
            plotTypeName = "default";
        }
        TownBlockType townBlockType = TownBlockTypeHandler.getType(plotTypeName);
        TownBlockType oldType = townBlock.getType();
        if (townBlockType == null) {
            throw new TownyException(Translatable.of("msg_err_not_block_type"));
        }
        if (townBlockType == oldType) {
            throw new TownyException(Translatable.of("msg_plot_already_of_type", townBlockType.getName()));
        }
        TownyAPI.getInstance().testPlotOwnerOrThrow(resident, townBlock);
        if (TownBlockType.ARENA.equals(townBlockType) && TownySettings.getOutsidersPreventPVPToggle()) {
            for (Player target : Bukkit.getOnlinePlayers()) {
                if (townBlock.getTownOrNull().hasResident(target) || player.getName().equals(target.getName()) || !townBlock.getWorldCoord().equals(WorldCoord.parseWorldCoord((Entity)target))) continue;
                throw new TownyException(Translatable.of("msg_cant_toggle_pvp_outsider_in_plot"));
            }
        }
        BukkitTools.ifCancelledThenThrow(new PlotPreChangeTypeEvent(townBlockType, townBlock, resident));
        double cost = townBlockType.getData().getCost();
        if (cost > 0.0 && TownyEconomyHandler.isActive() && !resident.getAccount().canPayFromHoldings(cost)) {
            throw new TownyException(Translatable.of("msg_err_cannot_afford_plot_set_type_cost", townBlockType, PlotCommand.prettyMoney(cost)));
        }
        if (cost > 0.0 && TownyEconomyHandler.isActive()) {
            Confirmation.runOnAccept(() -> {
                TownyMessaging.sendMsg(resident, Translatable.of("msg_plot_set_cost", PlotCommand.prettyMoney(cost), townBlockType));
                try {
                    townBlock.setType(townBlockType, resident);
                }
                catch (TownyException e) {
                    TownyMessaging.sendErrorMsg(resident, e.getMessage((CommandSender)player));
                    return;
                }
                BukkitTools.fireEvent(new PlayerChangePlotTypeEvent(townBlockType, oldType, townBlock, player));
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plot_set_type", townBlockType));
            }).setCost(new ConfirmationTransaction(() -> cost, resident, String.format("Plot set to %s", townBlockType), Translatable.of("msg_err_cannot_afford_plot_set_type_cost", townBlockType, PlotCommand.prettyMoney(cost)))).setTitle(Translatable.of("msg_confirm_purchase", PlotCommand.prettyMoney(cost))).sendTo((CommandSender)BukkitTools.getPlayerExact(resident.getName()));
        } else {
            townBlock.setType(townBlockType, resident);
            BukkitTools.fireEvent(new PlayerChangePlotTypeEvent(townBlockType, oldType, townBlock, player));
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plot_set_type", plotTypeName));
        }
    }

    private boolean tryPlotSetAddonCommand(Player player, String[] split) {
        if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.PLOT_SET, split[0])) {
            TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.PLOT_SET, split[0]).execute((CommandSender)player, "plot", split);
            return true;
        }
        return false;
    }

    public void parsePlotSetOutpost(Player player, Resident resident, TownBlock townBlock, boolean spawn) throws TownyException {
        if (!TownySettings.isAllowingOutposts()) {
            throw new TownyException(Translatable.of("msg_outpost_disable"));
        }
        Town town = townBlock.getTownOrNull();
        if (spawn) {
            PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_SET_OUTPOST.getNode());
            if (!townBlock.isOutpost()) {
                throw new TownyException(Translatable.of("msg_err_location_is_not_within_an_outpost_plot"));
            }
            town.addOutpostSpawn(player.getLocation());
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_set_outpost_spawn"));
            return;
        }
        TownyWorld townyWorld = townBlock.getWorld();
        Coord key = Coord.parseCoord(player.getLocation());
        OutpostUtil.OutpostTests(town, resident, townyWorld, key, resident.isAdmin(), true);
        if (TownySettings.getOutpostCost() > 0.0) {
            Confirmation.runOnAccept(() -> {
                town.addOutpostSpawn(player.getLocation());
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plot_set_cost", PlotCommand.prettyMoney(TownySettings.getOutpostCost()), Translatable.of("outpost")));
            }).setCost(new ConfirmationTransaction(() -> TownySettings.getOutpostCost(), town, "PlotSetOutpost", Translatable.of("msg_err_cannot_afford_to_set_outpost"))).setTitle(Translatable.of("msg_confirm_purchase", PlotCommand.prettyMoney(TownySettings.getOutpostCost()))).sendTo((CommandSender)player);
        } else {
            town.addOutpostSpawn(player.getLocation());
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plot_set_cost", PlotCommand.prettyMoney(TownySettings.getOutpostCost()), Translatable.of("outpost")));
        }
    }

    public void parsePlotSetName(Player player, String[] name, TownBlock townBlock) throws TownyException {
        if (name.length == 0) {
            townBlock.setName("");
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plot_name_removed"));
            townBlock.save();
            return;
        }
        String newName = NameValidation.checkAndFilterPlotNameOrThrow(StringMgmt.join(name, "_"));
        townBlock.setName(newName);
        townBlock.save();
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plot_name_set_to", townBlock.getName()));
    }

    public void parsePlotNotForSale(Player player, String[] args, Resident resident, TownBlock townBlock) throws TownyException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_NOTFORSALE.getNode());
        List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(resident, WorldCoord.parseWorldCoord((Entity)player), args);
        selection = AreaSelectionUtil.filterPlotsForSale(selection);
        if (resident.isAdmin()) {
            for (WorldCoord worldCoord : selection) {
                if (worldCoord.getTownBlock().hasPlotObjectGroup()) {
                    throw new TownyException(Translatable.of("msg_err_plot_belongs_to_group_plot_nfs", worldCoord));
                }
                this.setPlotForSale(resident, worldCoord, -1.0);
            }
            return;
        }
        Town town = townBlock.getTownOrNull();
        if (town == null) {
            throw new TownyException(Translatable.of("msg_err_empty_area_selection"));
        }
        selection = resident.hasPermissionNode(PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode()) && town.hasResident(resident) || resident.hasPermissionNode(PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYORINUNOWNED.getNode()) && town.hasResident(resident) && !townBlock.hasResident() ? AreaSelectionUtil.filterOwnedBlocks(resident.getTown(), selection) : AreaSelectionUtil.filterOwnedBlocks(resident, selection);
        if (selection.isEmpty()) {
            throw new TownyException(Translatable.of("msg_err_empty_area_selection"));
        }
        for (WorldCoord worldCoord : selection) {
            if (worldCoord.getTownBlock().hasPlotObjectGroup()) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_plot_belongs_to_group_plot_nfs", worldCoord));
                continue;
            }
            this.setPlotForSale(resident, worldCoord, -1.0);
        }
    }

    public void parsePlotUnclaim(Player player, String[] split, Resident resident) throws TownyException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_UNCLAIM.getNode());
        if (split.length == 2 && split[1].equalsIgnoreCase("all")) {
            plugin.getScheduler().runAsync(new PlotClaim(plugin, player, resident, null, false, false, false));
            return;
        }
        List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(resident, WorldCoord.parseWorldCoord((Entity)player), StringMgmt.remFirstArg(split));
        if ((selection = AreaSelectionUtil.filterOwnedBlocks(resident, selection)).size() == 0) {
            throw new TownyException(Translatable.of("msg_err_empty_area_selection"));
        }
        Iterator<WorldCoord> iterator = selection.iterator();
        if (iterator.hasNext()) {
            WorldCoord coord = iterator.next();
            TownBlock townBlock = coord.getTownBlock();
            if (!townBlock.hasPlotObjectGroup()) {
                plugin.getScheduler().runAsync(new PlotClaim(plugin, player, resident, selection, false, false, false));
                return;
            }
            List<WorldCoord> groupSelection = townBlock.getPlotObjectGroup().getTownBlocks().stream().map(TownBlock::getWorldCoord).collect(Collectors.toList());
            Confirmation.runOnAcceptAsync(new PlotClaim(plugin, player, resident, groupSelection, false, false, false)).setTitle(Translatable.of("msg_plot_group_unclaim_confirmation", townBlock.getPlotObjectGroup().getTownBlocks().size()).append(" ").append(Translatable.of("are_you_sure_you_want_to_continue"))).sendTo((CommandSender)player);
            return;
        }
    }

    private boolean plotCommandAllowedInWilderness(String command) {
        return command.equalsIgnoreCase("perm") || command.equalsIgnoreCase("claim") || command.equalsIgnoreCase("info");
    }

    private void parsePlotJailCell(Player player, Resident resident, TownBlock townBlock, String[] args) throws TownyException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_JAILCELL.getNode());
        if (args.length == 0 || args[0].equalsIgnoreCase("?") || args[0].equalsIgnoreCase("help")) {
            HelpMenu.PLOT_JAILCELL.send((CommandSender)player);
        }
        if (townBlock == null || !townBlock.isJail()) {
            throw new TownyException("msg_err_location_is_not_within_a_jail_plot");
        }
        TownyAPI.getInstance().testPlotOwnerOrThrow(resident, townBlock);
        Jail jail = townBlock.getJail();
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("add")) {
                SpawnPointLocation cellLoc = SpawnPointLocation.parseSpawnPointLocation(player.getLocation());
                if (jail.hasJailCell(cellLoc)) {
                    throw new TownyException(Translatable.of("msg_err_this_location_already_has_a_jailcell"));
                }
                jail.addJailCell(player.getLocation());
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_jail_cell_set"));
                jail.save();
            } else if (args[0].equalsIgnoreCase("remove")) {
                if (!jail.hasCells()) {
                    throw new TownyException(Translatable.of("msg_err_this_jail_has_no_cells"));
                }
                if (jail.getJailCellCount() == 1) {
                    throw new TownyException(Translatable.of("msg_err_you_cannot_remove_the_last_cell"));
                }
                SpawnPointLocation cellLoc = SpawnPointLocation.parseSpawnPointLocation(player.getLocation());
                if (!jail.hasJailCell(cellLoc)) {
                    throw new TownyException(Translatable.of("msg_err_no_cell_found_at_this_location"));
                }
                jail.removeJailCell(player.getLocation());
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_jail_cell_removed"));
                jail.save();
            } else {
                HelpMenu.PLOT_JAILCELL.send((CommandSender)player);
            }
        }
    }

    public static TownyPermissionChange setTownBlockPermissions(Player player, TownBlockOwner townBlockOwner, TownBlock townBlock, String[] split) throws CancelledEventException {
        TownyPermissionChange permChange;
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split.length > 3) {
            TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle("/... set perm"));
            if (townBlockOwner instanceof Town) {
                TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Level", "[resident/nation/ally/outsider]", "", ""));
            }
            if (townBlockOwner instanceof Resident) {
                TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Level", "[friend/town/ally/outsider]", "", ""));
            }
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Type", "[build/destroy/switch/itemuse]", "", ""));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("", "set perm", "[on/off]", "Toggle all permissions"));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("", "set perm", "[level/type] [on/off]", ""));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("", "set perm", "[level] [type] [on/off]", ""));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("", "set perm", "reset", ""));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Eg", "/plot set perm", "friend build on", ""));
            return null;
        }
        TownyPermission perm = townBlock.getPermissions();
        if (split.length == 1) {
            if (split[0].equalsIgnoreCase("reset")) {
                TownyPermissionChange permChange2 = new TownyPermissionChange(TownyPermissionChange.Action.RESET, false, townBlock);
                BukkitTools.ifCancelledThenThrow(new TownBlockPermissionChangeEvent(townBlock, permChange2));
                perm.change(permChange2);
                townBlock.save();
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_set_perms_reset_single"));
                plugin.resetCache();
                return permChange2;
            }
            try {
                boolean b = StringMgmt.parseOnOff(split[0]);
                permChange = new TownyPermissionChange(TownyPermissionChange.Action.ALL_PERMS, b, new Object[0]);
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_plot_set_perm_syntax_error"));
                return null;
            }
        }
        if (split.length == 2) {
            boolean b;
            try {
                b = StringMgmt.parseOnOff(split[1]);
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_plot_set_perm_syntax_error"));
                return null;
            }
            if (split[0].equalsIgnoreCase("friend")) {
                split[0] = "resident";
            } else if (split[0].equalsIgnoreCase("town")) {
                split[0] = "nation";
            } else if (split[0].equalsIgnoreCase("itemuse")) {
                split[0] = "item_use";
            }
            try {
                TownyPermission.PermLevel permLevel = TownyPermission.PermLevel.valueOf(split[0].toUpperCase(Locale.ROOT));
                permChange = new TownyPermissionChange(TownyPermissionChange.Action.PERM_LEVEL, b, new Object[]{permLevel});
            }
            catch (IllegalArgumentException permLevelException) {
                try {
                    TownyPermission.ActionType actionType = TownyPermission.ActionType.valueOf(split[0].toUpperCase(Locale.ROOT));
                    permChange = new TownyPermissionChange(TownyPermissionChange.Action.ACTION_TYPE, b, new Object[]{actionType});
                }
                catch (IllegalArgumentException actionTypeException) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_plot_set_perm_syntax_error"));
                    return null;
                }
            }
        } else {
            TownyPermission.ActionType actionType;
            TownyPermission.PermLevel permLevel;
            if (split[0].equalsIgnoreCase("friend")) {
                split[0] = "resident";
            } else if (split[0].equalsIgnoreCase("town")) {
                split[0] = "nation";
            }
            if (split[1].equalsIgnoreCase("itemuse")) {
                split[1] = "item_use";
            }
            try {
                permLevel = TownyPermission.PermLevel.valueOf(split[0].toUpperCase(Locale.ROOT));
                actionType = TownyPermission.ActionType.valueOf(split[1].toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ignore) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_plot_set_perm_syntax_error"));
                return null;
            }
            try {
                boolean b = StringMgmt.parseOnOff(split[2]);
                permChange = new TownyPermissionChange(TownyPermissionChange.Action.SINGLE_PERM, b, new Object[]{permLevel, actionType});
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_plot_set_perm_syntax_error"));
                return null;
            }
        }
        BukkitTools.ifCancelledThenThrow(new TownBlockPermissionChangeEvent(townBlock, permChange));
        perm.change(permChange);
        townBlock.setChanged(true);
        townBlock.save();
        if (!townBlock.hasPlotObjectGroup()) {
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_set_perms"));
            TownyMessaging.sendMessage((Object)player, "\u00a72" + Translatable.of("status_perm").forLocale((CommandSender)player) + " " + (townBlockOwner instanceof Resident ? perm.getColourString().replace("n", "t") : perm.getColourString().replace("f", "r")));
            TownyMessaging.sendMessage((Object)player, "\u00a72" + Translatable.of("status_pvp").forLocale((CommandSender)player) + " " + (perm.pvp ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + Translatable.of("explosions").forLocale((CommandSender)player) + " " + (perm.explosion ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + Translatable.of("firespread").forLocale((CommandSender)player) + " " + (perm.fire ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + Translatable.of("mobspawns").forLocale((CommandSender)player) + " " + (perm.mobs ? "\u00a74ON" : "\u00a7aOFF"));
        }
        BukkitTools.fireEvent(new TownBlockSettingsChangedEvent(townBlock));
        plugin.resetCache();
        return permChange;
    }

    public void setPlotForSale(Resident resident, WorldCoord worldCoord, double forSale) throws TownyException {
        TownBlock townBlock = worldCoord.getTownBlockOrNull();
        if (townBlock == null || !townBlock.hasTown()) {
            throw new TownyException(Translatable.of("msg_err_not_part_town"));
        }
        TownyAPI.getInstance().testPlotOwnerOrThrow(resident, townBlock);
        townBlock.setPlotPrice(Math.min(TownySettings.getMaxPlotPrice(), forSale));
        if (forSale != -1.0) {
            Translatable message = TownyEconomyHandler.isActive() ? Translatable.of("msg_plot_for_sale_amount", resident.getName(), worldCoord.toString(), PlotCommand.prettyMoney(townBlock.getPlotPrice())) : Translatable.of("msg_plot_for_sale", resident.getName(), worldCoord.toString());
            TownyMessaging.sendPrefixedTownMessage(townBlock.getTownOrNull(), message);
            if (!resident.hasTown() || resident.hasTown() && townBlock.getTownOrNull() != resident.getTownOrNull()) {
                TownyMessaging.sendMsg(resident, message);
            }
            BukkitTools.fireEvent(new PlotSetForSaleEvent(resident, townBlock.getPlotPrice(), townBlock));
        } else {
            TownyMessaging.sendMsg(resident, Translatable.of("msg_plot_set_to_nfs"));
            BukkitTools.fireEvent(new PlotNotForSaleEvent(resident, townBlock));
        }
        townBlock.save();
    }

    public void plotToggle(Player player, Resident resident, TownBlock townBlock, String[] split) throws TownyException {
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            HelpMenu.PLOT_TOGGLE.send((CommandSender)player);
            return;
        }
        TownyAPI.getInstance().testPlotOwnerOrThrow(resident, townBlock);
        PlotCommand.catchPlotGroup(townBlock, "/plot group toggle ?");
        Town town = townBlock.getTownOrNull();
        if (town == null) {
            throw new TownyException(Translatable.of("msg_not_claimed_1"));
        }
        Optional<Boolean> choice = Optional.empty();
        if (split.length == 2) {
            choice = BaseCommand.parseToggleChoice(split[1]);
        }
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "pvp": {
                PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_TOGGLE_PVP.getNode());
                this.tryToggleTownBlockPVP(player, resident, townBlock, split, town, choice);
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_changed_pvp", "Plot", townBlock.getPermissions().pvp ? Translatable.of("enabled") : Translatable.of("disabled")));
                break;
            }
            case "explosion": {
                PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_TOGGLE_EXPLOSION.getNode());
                this.tryToggleTownBlockExplosion(player, townBlock, split, choice);
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_changed_expl", "the Plot", townBlock.getPermissions().explosion ? Translatable.of("enabled") : Translatable.of("disabled")));
                break;
            }
            case "fire": {
                PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_TOGGLE_FIRE.getNode());
                this.tryToggleTownBlockFire(player, townBlock, split, choice);
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_changed_fire", "the Plot", townBlock.getPermissions().fire ? Translatable.of("enabled") : Translatable.of("disabled")));
                break;
            }
            case "mobs": {
                PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_TOGGLE_MOBS.getNode());
                this.tryToggleTownBlockMobs(player, townBlock, split, choice);
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_changed_mobs", "the Plot", townBlock.getPermissions().mobs ? Translatable.of("enabled") : Translatable.of("disabled")));
                break;
            }
            case "taxed": {
                PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode());
                this.tryToggleTownBlockTaxed(player, townBlock, split, choice);
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_changed_plot_taxed", townBlock.isTaxed() ? Translatable.of("enabled") : Translatable.of("disabled")));
                townBlock.save();
                return;
            }
            default: {
                if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.PLOT_TOGGLE, split[0])) {
                    TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.PLOT_TOGGLE, split[0]).execute((CommandSender)player, "plot", split);
                    break;
                }
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_property", "plot"));
                return;
            }
        }
        townBlock.setChanged(true);
        BukkitTools.fireEvent(new TownBlockSettingsChangedEvent(townBlock));
        townBlock.save();
    }

    private void tryToggleTownBlockPVP(Player player, Resident resident, TownBlock townBlock, String[] split, Town town, Optional<Boolean> choice) throws TownyException {
        this.toggleTest(player, townBlock, StringMgmt.join(split, " "));
        if (TownySettings.getPVPCoolDownTime() > 0 && !resident.isAdmin()) {
            if (CooldownTimerTask.hasCooldown(town.getUUID().toString(), CooldownTimerTask.CooldownType.PVP)) {
                throw new TownyException(Translatable.of("msg_err_cannot_toggle_pvp_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(town.getUUID().toString(), CooldownTimerTask.CooldownType.PVP)));
            }
            if (CooldownTimerTask.hasCooldown(townBlock.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP)) {
                throw new TownyException(Translatable.of("msg_err_cannot_toggle_pvp_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(townBlock.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP)));
            }
        }
        if (town.isAdminDisabledPVP() && !townBlock.getPermissions().pvp) {
            throw new TownyException(Translatable.of("msg_err_admin_controlled_pvp_prevents_you_from_changing_pvp", "adminDisabledPVP", "on"));
        }
        if (town.isAdminEnabledPVP() && townBlock.getPermissions().pvp) {
            throw new TownyException(Translatable.of("msg_err_admin_controlled_pvp_prevents_you_from_changing_pvp", "adminEnabledPVP", "off"));
        }
        if (TownySettings.getOutsidersPreventPVPToggle() && choice.orElse(!townBlock.getPermissions().pvp).booleanValue()) {
            for (Player target : Bukkit.getOnlinePlayers()) {
                if (town.hasResident(target) || player.getName().equals(target.getName()) || !townBlock.getWorldCoord().equals(WorldCoord.parseWorldCoord((Entity)target))) continue;
                throw new TownyException(Translatable.of("msg_cant_toggle_pvp_outsider_in_plot"));
            }
        }
        BukkitTools.ifCancelledThenThrow(new PlotTogglePvpEvent(townBlock, player, choice.orElse(!townBlock.getPermissions().pvp)));
        townBlock.getPermissions().pvp = choice.orElse(!townBlock.getPermissions().pvp);
        if (TownySettings.getPVPCoolDownTime() > 0 && !resident.isAdmin()) {
            CooldownTimerTask.addCooldownTimer(townBlock.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP);
        }
    }

    private void tryToggleTownBlockExplosion(Player player, TownBlock townBlock, String[] split, Optional<Boolean> choice) throws TownyException {
        this.toggleTest(player, townBlock, StringMgmt.join(split, " "));
        BukkitTools.ifCancelledThenThrow(new PlotToggleExplosionEvent(townBlock, player, choice.orElse(!townBlock.getPermissions().explosion)));
        townBlock.getPermissions().explosion = choice.orElse(!townBlock.getPermissions().explosion);
    }

    private void tryToggleTownBlockFire(Player player, TownBlock townBlock, String[] split, Optional<Boolean> choice) throws TownyException {
        this.toggleTest(player, townBlock, StringMgmt.join(split, " "));
        BukkitTools.ifCancelledThenThrow(new PlotToggleFireEvent(townBlock, player, choice.orElse(!townBlock.getPermissions().fire)));
        townBlock.getPermissions().fire = choice.orElse(!townBlock.getPermissions().fire);
    }

    private void tryToggleTownBlockMobs(Player player, TownBlock townBlock, String[] split, Optional<Boolean> choice) throws TownyException {
        this.toggleTest(player, townBlock, StringMgmt.join(split, " "));
        BukkitTools.ifCancelledThenThrow(new PlotToggleMobsEvent(townBlock, player, choice.orElse(!townBlock.getPermissions().mobs)));
        townBlock.getPermissions().mobs = choice.orElse(!townBlock.getPermissions().mobs);
    }

    private void tryToggleTownBlockTaxed(Player player, TownBlock townBlock, String[] split, Optional<Boolean> choice) throws TownyException {
        BukkitTools.ifCancelledThenThrow(new PlotToggleTaxedEvent(townBlock, player, choice.orElse(!townBlock.isTaxed())));
        townBlock.setTaxed(choice.orElse(!townBlock.isTaxed()));
    }

    private void toggleTest(Player player, TownBlock townBlock, String split) throws TownyException {
        if ((split = split.toLowerCase(Locale.ROOT)).contains("mobs")) {
            if (townBlock.getWorld().isForceTownMobs()) {
                throw new TownyException(Translatable.of("msg_world_mobs"));
            }
            if (townBlock.getTownOrNull().isAdminEnabledMobs()) {
                throw new TownyException(Translatable.of("msg_town_mobs"));
            }
        }
        if (split.contains("fire") && townBlock.getWorld().isForceFire()) {
            throw new TownyException(Translatable.of("msg_world_fire"));
        }
        if (split.contains("explosion") && townBlock.getWorld().isForceExpl()) {
            throw new TownyException(Translatable.of("msg_world_expl"));
        }
        if (split.contains("pvp") && townBlock.getWorld().isForcePVP()) {
            throw new TownyException(Translatable.of("msg_world_pvp"));
        }
        if ((split.contains("pvp") || split.trim().equalsIgnoreCase("off")) && townBlock.getType().equals(TownBlockType.ARENA)) {
            throw new TownyException(Translatable.of("msg_plot_pvp"));
        }
    }

    private void parseDistrict(String[] split, Resident resident, TownBlock townBlock, Player player) throws TownyException {
        Town town = townBlock.getTownOrNull();
        if (town == null) {
            throw new TownyException(Translatable.of("msg_not_claimed_1"));
        }
        if (!town.hasResident(player)) {
            throw new TownyException(Translatable.of("msg_err_not_part_town"));
        }
        try {
            PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode());
        }
        catch (NoPermissionException e) {
            throw new TownyException(Translatable.of("msg_not_mayor_ass"));
        }
        if (split.length <= 0 || split[0].equalsIgnoreCase("?")) {
            HelpMenu.PLOT_DISTRICT_HELP.send((CommandSender)player);
            if (townBlock.hasDistrict()) {
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("status_district_name_and_size", townBlock.getDistrict().getName(), townBlock.getDistrict().getTownBlocks().size()));
            }
            return;
        }
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "add": 
            case "new": 
            case "create": {
                this.parseDistrictAdd(split, townBlock, player, town);
                break;
            }
            case "delete": {
                this.parseDistrictDelete(townBlock, player, town);
                break;
            }
            case "remove": {
                this.parseDistrictRemove(townBlock, player, town);
                break;
            }
            case "rename": {
                this.parseDistrictRename(split, townBlock, player);
                break;
            }
            default: {
                HelpMenu.PLOT_DISTRICT_HELP.send((CommandSender)player);
                if (!townBlock.hasDistrict()) break;
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("status_district_name_and_size", townBlock.getDistrict().getName(), townBlock.getDistrict().getTownBlocks().size()));
            }
        }
    }

    public void parseDistrictAdd(String[] split, TownBlock townBlock, Player player, Town town) throws TownyException {
        String districtName;
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_DISTRICT_ADD.getNode());
        Resident resident = PlotCommand.getResidentOrThrow(player);
        if (split.length != 2 && !resident.hasDistrictName()) {
            throw new TownyException(Translatable.of("msg_err_district_name_required"));
        }
        String string = split.length == 2 ? NameValidation.checkAndFilterDistrictNameOrThrow(split[1]) : (districtName = resident.hasDistrictName() ? resident.getDistrictName() : null);
        if (townBlock.hasDistrict()) {
            if (townBlock.getDistrict().getName().equalsIgnoreCase(districtName)) {
                throw new TownyException(Translatable.of("msg_err_this_plot_is_already_part_of_the_district_x", districtName));
            }
            District oldDistrict = townBlock.getDistrict();
            ProximityUtil.testAdjacentRemoveDistrictRulesOrThrow(townBlock.getWorldCoord(), town, oldDistrict, 1);
            String name = districtName;
            Confirmation.runOnAccept(() -> {
                oldDistrict.removeTownBlock(townBlock);
                if (oldDistrict.getTownBlocks().isEmpty() && !BukkitTools.isEventCancelled(new DistrictDeletedEvent(oldDistrict, player, DistrictDeletedEvent.Cause.NO_TOWNBLOCKS))) {
                    String oldName = oldDistrict.getName();
                    town.removeDistrict(oldDistrict);
                    TownyUniverse.getInstance().getDataSource().removeDistrict(oldDistrict);
                    TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_district_deleted", oldName));
                } else {
                    oldDistrict.save();
                }
                try {
                    this.createOrAddOnToDistrict(townBlock, town, player, name);
                    resident.setDistrictName(name);
                    TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_townblock_transferred_from_x_to_x_district", oldDistrict.getName(), townBlock.getDistrict().getName()));
                }
                catch (TownyException e) {
                    TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
                }
            }).setTitle(Translatable.of("msg_district_already_exists_did_you_want_to_transfer", townBlock.getDistrict().getName(), name)).sendTo((CommandSender)player);
        } else {
            this.createOrAddOnToDistrict(townBlock, town, player, districtName);
            resident.setDistrictName(districtName);
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plot_was_put_into_district_x", townBlock.getX(), townBlock.getZ(), townBlock.getDistrict().getName()));
        }
    }

    private void createOrAddOnToDistrict(TownBlock townBlock, Town town, Player player, String districtName) throws TownyException {
        District newDistrict;
        if (town.hasDistrictName(districtName)) {
            newDistrict = town.getDistrictFromName(districtName);
            ProximityUtil.testAdjacentAddDistrictRulesOrThrow(townBlock.getWorldCoord(), town, newDistrict, 1);
            BukkitTools.ifCancelledThenThrow(new DistrictAddEvent(newDistrict, townBlock, player));
        } else {
            newDistrict = new District(UUID.randomUUID(), districtName, town);
            BukkitTools.ifCancelledThenThrow(new DistrictCreatedEvent(newDistrict, townBlock, player));
            TownyUniverse.getInstance().registerDistrict(newDistrict);
        }
        townBlock.setDistrict(newDistrict);
        town.addDistrict(newDistrict);
        newDistrict.save();
        townBlock.save();
    }

    public void parseDistrictDelete(TownBlock townBlock, Player player, Town town) throws TownyException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_DISTRICT_DELETE.getNode());
        District district = this.catchMissingDistrict(townBlock);
        Confirmation.runOnAccept(() -> {
            String name = district.getName();
            if (!BukkitTools.isEventCancelled(new DistrictDeletedEvent(district, player, DistrictDeletedEvent.Cause.DELETED))) {
                town.removeDistrict(district);
                TownyUniverse.getInstance().getDataSource().removeDistrict(district);
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_district_deleted", name));
            }
        }).sendTo((CommandSender)player);
    }

    public void parseDistrictRemove(TownBlock townBlock, Player player, Town town) throws TownyException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_DISTRICT_REMOVE.getNode());
        District district = this.catchMissingDistrict(townBlock);
        String name = district.getName();
        try {
            ProximityUtil.testAdjacentRemoveDistrictRulesOrThrow(townBlock.getWorldCoord(), town, district, 1);
        }
        catch (TownyException e) {
            throw new TownyException(Translatable.of("msg_err_cannot_remove_from_district_not_enough_adjacent_claims", name));
        }
        district.removeTownBlock(townBlock);
        townBlock.removeDistrict();
        townBlock.save();
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plot_was_removed_from_district_x", townBlock.getX(), townBlock.getZ(), name));
        if (district.getTownBlocks().isEmpty() && !BukkitTools.isEventCancelled(new DistrictDeletedEvent(district, player, DistrictDeletedEvent.Cause.NO_TOWNBLOCKS))) {
            town.removeDistrict(district);
            TownyUniverse.getInstance().getDataSource().removeDistrict(district);
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_district_empty_deleted", name));
        }
    }

    public void parseDistrictRename(String[] split, TownBlock townBlock, Player player) throws TownyException, AlreadyRegisteredException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_DISTRICT_RENAME.getNode());
        if (split.length == 1) {
            throw new TownyException(Translatable.of("msg_err_rename_district_name_required"));
        }
        District district = this.catchMissingDistrict(townBlock);
        String newName = split[1];
        NameValidation.checkAndFilterDistrictNameOrThrow(newName);
        String oldName = district.getName();
        TownyUniverse.getInstance().getDataSource().renameDistrict(district, newName);
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_district_renamed_from_x_to_y", oldName, newName));
    }

    private void parsePlotGroup(String[] split, Resident resident, TownBlock townBlock, Player player) throws TownyException {
        Town town = townBlock.getTownOrNull();
        if (town == null) {
            throw new TownyException(Translatable.of("msg_not_claimed_1"));
        }
        TownyAPI.getInstance().testPlotOwnerOrThrow(resident, townBlock);
        if (split.length <= 0 || split[0].equalsIgnoreCase("?")) {
            HelpMenu.PLOT_GROUP_HELP.send((CommandSender)player);
            if (townBlock.hasPlotObjectGroup()) {
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("status_plot_group_name_and_size", townBlock.getPlotObjectGroup().getName(), townBlock.getPlotObjectGroup().getTownBlocks().size()));
            }
            return;
        }
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "add": 
            case "new": 
            case "create": {
                this.parsePlotGroupAdd(split, townBlock, player, town);
                break;
            }
            case "delete": {
                this.parsePlotGroupDelete(townBlock, player, town);
                break;
            }
            case "fs": 
            case "forsale": {
                this.parsePlotGroupForSale(split, resident, townBlock, player, town);
                break;
            }
            case "nfs": 
            case "notforsale": {
                this.parsePlotGroupNotForSale(resident, townBlock, player, town);
                break;
            }
            case "perm": {
                this.parsePlotGroupPerm(split, resident, townBlock, player);
                break;
            }
            case "remove": {
                this.parsePlotGroupRemove(townBlock, player, town);
                break;
            }
            case "rename": {
                this.parsePlotGroupRename(split, townBlock, player);
                break;
            }
            case "set": {
                this.parsePlotGroupSet(split, resident, townBlock, player, town);
                break;
            }
            case "toggle": {
                this.parsePlotGroupToggle(split, townBlock, player, resident);
                break;
            }
            case "trust": {
                this.parsePlotGroupTrust(split, townBlock, player);
                break;
            }
            default: {
                HelpMenu.PLOT_GROUP_HELP.send((CommandSender)player);
                if (!townBlock.hasPlotObjectGroup()) break;
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("status_plot_group_name_and_size", townBlock.getPlotObjectGroup().getName(), townBlock.getPlotObjectGroup().getTownBlocks().size()));
            }
        }
    }

    public void parsePlotGroupAdd(String[] split, TownBlock townBlock, Player player, Town town) throws TownyException {
        String plotGroupName;
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_ADD.getNode());
        Resident resident = PlotCommand.getResidentOrThrow(player);
        if (split.length != 2 && !resident.hasPlotGroupName()) {
            throw new TownyException(Translatable.of("msg_err_plot_group_name_required"));
        }
        String string = split.length == 2 ? NameValidation.checkAndFilterPlotGroupNameOrThrow(split[1]) : (plotGroupName = resident.hasPlotGroupName() ? resident.getPlotGroupName() : null);
        if (town.hasPlotGroupName(plotGroupName)) {
            TownBlockType groupType = town.getPlotObjectGroupFromName(plotGroupName).getTownBlockType();
            if (townBlock.getType() != groupType) {
                throw new TownyException(Translatable.of("msg_err_this_townblock_doesnt_match_the_groups_type", groupType.getName()));
            }
        }
        if (townBlock.hasPlotObjectGroup()) {
            if (townBlock.getPlotObjectGroup().getName().equalsIgnoreCase(plotGroupName)) {
                throw new TownyException(Translatable.of("msg_err_this_plot_is_already_part_of_the_plot_group_x", plotGroupName));
            }
            String name = plotGroupName;
            Confirmation.runOnAccept(() -> {
                PlotGroup oldGroup = townBlock.getPlotObjectGroup();
                oldGroup.removeTownBlock(townBlock);
                if (oldGroup.getTownBlocks().isEmpty() && !BukkitTools.isEventCancelled(new PlotGroupDeletedEvent(oldGroup, player, PlotGroupDeletedEvent.Cause.NO_TOWNBLOCKS))) {
                    String oldName = oldGroup.getName();
                    town.removePlotGroup(oldGroup);
                    TownyUniverse.getInstance().getDataSource().removePlotGroup(oldGroup);
                    TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plotgroup_deleted", oldName));
                } else {
                    oldGroup.save();
                }
                try {
                    this.createOrAddOnToPlotGroup(townBlock, town, player, name);
                    resident.setPlotGroupName(name);
                    TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_townblock_transferred_from_x_to_x_group", oldGroup.getName(), townBlock.getPlotObjectGroup().getName()));
                }
                catch (TownyException e) {
                    TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
                }
            }).setTitle(Translatable.of("msg_plot_group_already_exists_did_you_want_to_transfer", townBlock.getPlotObjectGroup().getName(), split[1])).sendTo((CommandSender)player);
        } else {
            this.createOrAddOnToPlotGroup(townBlock, town, player, plotGroupName);
            resident.setPlotGroupName(plotGroupName);
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plot_was_put_into_group_x", townBlock.getX(), townBlock.getZ(), townBlock.getPlotObjectGroup().getName()));
        }
    }

    private void createOrAddOnToPlotGroup(TownBlock townBlock, Town town, Player player, String plotGroupName) throws TownyException {
        PlotGroup newGroup;
        if (town.hasPlotGroupName(plotGroupName)) {
            newGroup = town.getPlotObjectGroupFromName(plotGroupName);
            BukkitTools.ifCancelledThenThrow(new PlotGroupAddEvent(newGroup, townBlock, player));
            townBlock.setPermissions(newGroup.getPermissions().toString());
            townBlock.setChanged(!townBlock.getPermissions().toString().equals(town.getPermissions().toString()));
            townBlock.setMaxTownMembershipDays(newGroup.getMaxTownMembershipDays());
            townBlock.setMinTownMembershipDays(newGroup.getMinTownMembershipDays());
        } else {
            newGroup = new PlotGroup(UUID.randomUUID(), plotGroupName, town);
            newGroup.setPermissions(townBlock.getPermissions());
            newGroup.setTrustedResidents(townBlock.getTrustedResidents());
            newGroup.setPermissionOverrides(townBlock.getPermissionOverrides());
            BukkitTools.ifCancelledThenThrow(new PlotGroupCreatedEvent(newGroup, townBlock, player));
            TownyUniverse.getInstance().registerGroup(newGroup);
        }
        townBlock.setPlotObjectGroup(newGroup);
        if (townBlock.getPlotPrice() > 0.0) {
            newGroup.addPlotPrice(townBlock.getPlotPrice());
        }
        town.addPlotGroup(newGroup);
        newGroup.save();
        townBlock.save();
    }

    public void parsePlotGroupDelete(TownBlock townBlock, Player player, Town town) throws TownyException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_DELETE.getNode());
        PlotGroup group = this.catchMissingPlotGroup(townBlock);
        Confirmation.runOnAccept(() -> {
            String name = group.getName();
            if (!BukkitTools.isEventCancelled(new PlotGroupDeletedEvent(group, player, PlotGroupDeletedEvent.Cause.DELETED))) {
                town.removePlotGroup(group);
                TownyUniverse.getInstance().getDataSource().removePlotGroup(group);
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plotgroup_deleted", name));
            }
        }).sendTo((CommandSender)player);
    }

    public void parsePlotGroupForSale(String[] split, Resident resident, TownBlock townBlock, Player player, Town town) throws TownyException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_FORSALE.getNode());
        if (split.length < 2 && TownyEconomyHandler.isActive()) {
            throw new TownyException(Translatable.of("msg_err_plot_group_specify_price"));
        }
        PlotGroup group = this.catchMissingPlotGroup(townBlock);
        double price = split.length >= 2 ? MoneyUtil.getMoneyAboveZeroOrThrow(split[1]) : 0.0;
        group.setPrice(Math.min(price, TownySettings.getMaxPlotPrice()));
        group.save();
        Translatable message = TownyEconomyHandler.isActive() ? Translatable.of("msg_player_put_group_up_for_sale_amount", player.getName(), group.getName(), PlotCommand.prettyMoney(group.getPrice())) : Translatable.of("msg_player_put_group_up_for_sale", player.getName(), group.getName());
        TownyMessaging.sendPrefixedTownMessage(town, message);
        if (!resident.hasTown() || resident.getTownOrNull() != town) {
            TownyMessaging.sendMsg((CommandSender)player, message);
        }
    }

    public void parsePlotGroupNotForSale(Resident resident, TownBlock townBlock, Player player, Town town) throws TownyException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_NOTFORSALE.getNode());
        PlotGroup group = this.catchMissingPlotGroup(townBlock);
        group.setPrice(-1.0);
        group.save();
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_player_made_group_not_for_sale", player.getName(), group.getName()));
        if (!resident.hasTown() || resident.getTownOrNull() != town) {
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_player_made_group_not_for_sale", player.getName(), group.getName()));
        }
    }

    public void parsePlotGroupPerm(String[] split, Resident resident, TownBlock townBlock, Player player) throws TownyException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_PERM.getNode());
        if (split.length < 2) {
            HelpMenu.PLOT_GROUP_PERM_HELP.send((CommandSender)player);
            return;
        }
        PlotGroup group = this.catchMissingPlotGroup(townBlock);
        if (split[1].equalsIgnoreCase("gui")) {
            PermissionGUIUtil.openPermissionGUI(resident, townBlock);
            return;
        }
        if (split.length < 3) {
            HelpMenu.PLOT_GROUP_PERM_HELP.send((CommandSender)player);
            return;
        }
        Resident overrideResident = TownyAPI.getInstance().getResident(split[2]);
        if (overrideResident == null || overrideResident.isNPC()) {
            throw new TownyException(Translatable.of("msg_err_not_registered_1", split[2]));
        }
        if (split[1].equalsIgnoreCase("add")) {
            if (group.getPermissionOverrides() != null && group.getPermissionOverrides().containsKey(overrideResident)) {
                throw new TownyException(Translatable.of("msg_overrides_already_set", overrideResident.getName(), Translatable.of("plotgroup_sing")));
            }
            group.putPermissionOverride(overrideResident, new PermissionData(PermissionGUIUtil.getDefaultTypes(), player.getName()));
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_overrides_added", overrideResident.getName()));
        } else if (split[1].equalsIgnoreCase("remove")) {
            if (group.getPermissionOverrides() != null && !group.getPermissionOverrides().containsKey(overrideResident)) {
                throw new TownyException(Translatable.of("msg_no_overrides_set", overrideResident.getName(), Translatable.of("plotgroup_sing")));
            }
            group.removePermissionOverride(overrideResident);
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_overrides_removed", overrideResident.getName()));
        } else {
            throw new TownyException(Translatable.of("msg_err_invalid_property", split[1]));
        }
    }

    public void parsePlotGroupRemove(TownBlock townBlock, Player player, Town town) throws TownyException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_REMOVE.getNode());
        PlotGroup group = this.catchMissingPlotGroup(townBlock);
        String name = group.getName();
        group.removeTownBlock(townBlock);
        townBlock.removePlotObjectGroup();
        townBlock.save();
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plot_was_removed_from_group_x", townBlock.getX(), townBlock.getZ(), name));
        if (group.getTownBlocks().isEmpty() && !BukkitTools.isEventCancelled(new PlotGroupDeletedEvent(group, player, PlotGroupDeletedEvent.Cause.NO_TOWNBLOCKS))) {
            town.removePlotGroup(group);
            TownyUniverse.getInstance().getDataSource().removePlotGroup(group);
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plotgroup_empty_deleted", name));
        }
    }

    public void parsePlotGroupRename(String[] split, TownBlock townBlock, Player player) throws TownyException, AlreadyRegisteredException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_RENAME.getNode());
        if (split.length == 1) {
            throw new TownyException(Translatable.of("msg_err_plot_group_name_required"));
        }
        PlotGroup group = this.catchMissingPlotGroup(townBlock);
        String newName = split[1];
        NameValidation.checkAndFilterPlotGroupNameOrThrow(newName);
        String oldName = group.getName();
        TownyUniverse.getInstance().getDataSource().renameGroup(group, newName);
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_plot_renamed_from_x_to_y", oldName, newName));
    }

    public void parsePlotGroupSet(String[] split, Resident resident, TownBlock townBlock, Player player, Town town) throws TownyException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_SET.getNode());
        PlotGroup group = this.catchMissingPlotGroup(townBlock);
        TownBlockOwner townBlockOwner = townBlock.getTownBlockOwner();
        if (split.length < 2) {
            this.showPlotGroupHelp(player, townBlockOwner);
            return;
        }
        split = StringMgmt.remFirstArg(split);
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "perm": {
                this.parsePlotGroupSetPerm(split, townBlock, player, town, group, townBlockOwner);
                break;
            }
            case "maxjoindays": {
                this.parsePlotGroupSetMaxJoinDays(player, resident, townBlock, group, StringMgmt.remFirstArg(split));
                break;
            }
            case "minjoindays": {
                this.parsePlotGroupSetMinJoinDays(player, resident, townBlock, group, StringMgmt.remFirstArg(split));
                break;
            }
            default: {
                this.parsePlotGroupSetTownBlockType(split, resident, townBlock, group, player, town);
            }
        }
    }

    private void showPlotGroupHelp(Player player, TownBlockOwner townBlockOwner) {
        HelpMenu.PLOT_GROUP_SET.send((CommandSender)player);
        if (townBlockOwner instanceof Town) {
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Level", "[resident/nation/ally/outsider]", "", ""));
        }
        if (townBlockOwner instanceof Resident) {
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Level", "[friend/town/ally/outsider]", "", ""));
        }
        TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Type", "[build/destroy/switch/itemuse]", "", ""));
        TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("/plot group set", "perm", "[on/off]", "Toggle all permissions"));
        TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("/plot group set", "perm", "[level/type] [on/off]", ""));
        TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("/plot group set", "perm", "[level] [type] [on/off]", ""));
        TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("/plot group set", "perm", "reset", ""));
        TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("Eg", "/plot group set perm", "friend build on", ""));
        TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("/plot group set", "[townblocktype]", "", "Farm, Wilds, Bank, Embassy, etc."));
    }

    public void parsePlotGroupSetPerm(String[] args, TownBlock townBlock, Player player, Town town, PlotGroup plotGroup, TownBlockOwner townBlockOwner) {
        Runnable permHandler = () -> {
            TownyPermissionChange permChange = null;
            try {
                permChange = PlotCommand.setTownBlockPermissions(player, townBlockOwner, townBlock, StringMgmt.remFirstArg(args));
            }
            catch (CancelledEventException e) {
                TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
                return;
            }
            for (TownBlock tb2 : plotGroup.getTownBlocks()) {
                try {
                    BukkitTools.ifCancelledThenThrow(new TownBlockPermissionChangeEvent(tb2, permChange));
                }
                catch (CancelledEventException e) {
                    TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
                    return;
                }
            }
            if (permChange != null) {
                plotGroup.getPermissions().change(permChange);
                plotGroup.getTownBlocks().stream().forEach(tb -> {
                    tb.setPermissions(plotGroup.getPermissions().toString());
                    tb.setChanged(!tb.getPermissions().toString().equals(town.getPermissions().toString()));
                    tb.save();
                    BukkitTools.fireEvent(new TownBlockSettingsChangedEvent((TownBlock)tb));
                });
                plugin.resetCache();
                Translator translator = Translator.locale((CommandSender)player);
                TownyPermission perm = plotGroup.getPermissions();
                TownyMessaging.sendMessage((Object)player, translator.of("msg_set_perms"));
                TownyMessaging.sendMessage((Object)player, "\u00a72" + translator.of("status_perm") + " " + (townBlockOwner instanceof Resident ? perm.getColourString().replace("n", "t") : perm.getColourString().replace("f", "r")));
                TownyMessaging.sendMessage((Object)player, "\u00a72" + translator.of("status_pvp") + " " + (perm.pvp ? translator.of("status_on") : translator.of("status_off")) + "\u00a72" + translator.of("explosions") + " " + (perm.explosion ? translator.of("status_on") : translator.of("status_off")) + "\u00a72" + translator.of("firespread") + " " + (perm.fire ? translator.of("status_on") : translator.of("status_off")) + "\u00a72" + translator.of("mobspawns") + " " + (perm.mobs ? translator.of("status_on") : translator.of("status_off")));
            }
        };
        Confirmation.runOnAccept(permHandler).setTitle(Translatable.of("msg_plot_group_set_perm_confirmation", plotGroup.getTownBlocks().size()).append(" ").append(Translatable.of("are_you_sure_you_want_to_continue"))).sendTo((CommandSender)player);
    }

    private void parsePlotGroupSetMinJoinDays(Player player, Resident resident, TownBlock townBlock, PlotGroup plotGroup, String[] args) throws TownyException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode());
        TownyAPI.getInstance().testPlotOwnerOrThrow(resident, townBlock);
        if (args.length == 0 || args[0].equalsIgnoreCase("?")) {
            this.showPlotGroupHelp(player, townBlock.getTownBlockOwner());
            return;
        }
        if (args[0].equalsIgnoreCase("clear")) {
            plotGroup.getTownBlocks().forEach(tb -> {
                tb.setMinTownMembershipDays(-1);
                tb.save();
            });
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_townblock_min_join_days_removed"));
            return;
        }
        int days = MathUtil.getPositiveIntOrThrow(args[0]);
        if (days == 0) {
            throw new TownyException(Translatable.of("msg_err_days_must_be_greater_than_0"));
        }
        plotGroup.getTownBlocks().forEach(tb -> {
            tb.setMinTownMembershipDays(days);
            tb.save();
        });
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_townblock_min_join_days_set_to", townBlock.getMinTownMembershipDays()));
    }

    private void parsePlotGroupSetMaxJoinDays(Player player, Resident resident, TownBlock townBlock, PlotGroup plotGroup, String[] args) throws TownyException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode());
        TownyAPI.getInstance().testPlotOwnerOrThrow(resident, townBlock);
        if (args.length == 0 || args[0].equalsIgnoreCase("?")) {
            this.showPlotGroupHelp(player, townBlock.getTownBlockOwner());
            return;
        }
        if (args[0].equalsIgnoreCase("clear")) {
            plotGroup.getTownBlocks().forEach(tb -> {
                tb.setMinTownMembershipDays(-1);
                tb.save();
            });
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_townblock_max_join_days_removed"));
            return;
        }
        int days = MathUtil.getPositiveIntOrThrow(args[0]);
        if (days == 0) {
            throw new TownyException(Translatable.of("msg_err_days_must_be_greater_than_0"));
        }
        plotGroup.getTownBlocks().forEach(tb -> {
            tb.setMinTownMembershipDays(days);
            tb.save();
        });
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_townblock_max_join_days_set_to", townBlock.getMaxTownMembershipDays()));
    }

    public void parsePlotGroupSetTownBlockType(String[] split, Resident resident, TownBlock townBlock, PlotGroup group, Player player, Town town) throws TownyException {
        TownBlockType type;
        String plotTypeName = split[0];
        if (plotTypeName.equalsIgnoreCase("jail")) {
            throw new TownyException(Translatable.of("msg_err_cannot_set_group_to_jail"));
        }
        if (plotTypeName.equalsIgnoreCase("reset")) {
            plotTypeName = "default";
        }
        if ((type = TownBlockTypeHandler.getType(plotTypeName)) == null) {
            throw new TownyException(Translatable.of("msg_err_not_block_type"));
        }
        Collection<TownBlock> plotGroupTownBlocks = group.getTownBlocks();
        for (TownBlock tb : plotGroupTownBlocks) {
            TownyAPI.getInstance().testPlotOwnerOrThrow(resident, tb);
            if (TownBlockType.ARENA.equals(type) && TownySettings.getOutsidersPreventPVPToggle()) {
                for (Player target : Bukkit.getOnlinePlayers()) {
                    if (town.hasResident(target) || player.getName().equals(target.getName()) || !tb.getWorldCoord().equals(WorldCoord.parseWorldCoord((Entity)target))) continue;
                    throw new TownyException(Translatable.of("msg_cant_toggle_pvp_outsider_in_plot"));
                }
            }
            BukkitTools.ifCancelledThenThrow(new PlotPreChangeTypeEvent(type, tb, resident));
        }
        double cost = type.getCost() * (double)plotGroupTownBlocks.size();
        if (cost > 0.0 && TownyEconomyHandler.isActive() && !resident.getAccount().canPayFromHoldings(cost)) {
            throw new TownyException(Translatable.of("msg_err_cannot_afford_plot_set_type_cost", type, PlotCommand.prettyMoney(cost)));
        }
        if (cost > 0.0 && TownyEconomyHandler.isActive()) {
            Confirmation.runOnAccept(() -> {
                if (townBlock.getPlotObjectGroup() == null) {
                    return;
                }
                TownyMessaging.sendMsg(resident, Translatable.of("msg_plot_set_cost", PlotCommand.prettyMoney(cost), type));
                for (TownBlock tb : townBlock.getPlotObjectGroup().getTownBlocks()) {
                    try {
                        TownBlockType oldType = tb.getType();
                        tb.setType(type, resident);
                        BukkitTools.fireEvent(new PlayerChangePlotTypeEvent(type, oldType, tb, player));
                    }
                    catch (TownyException townyException) {}
                }
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_set_group_type_to_x", type));
            }).setCost(new ConfirmationTransaction(() -> cost, resident, String.format("Plot group (%s) set to %s", plotGroupTownBlocks.size(), type), Translatable.of("msg_err_cannot_afford_plot_set_type_cost", type, PlotCommand.prettyMoney(cost)))).setTitle(Translatable.of("msg_confirm_purchase", PlotCommand.prettyMoney(cost))).sendTo((CommandSender)BukkitTools.getPlayerExact(resident.getName()));
        } else {
            for (TownBlock tb : plotGroupTownBlocks) {
                TownBlockType oldType = tb.getType();
                tb.setType(type, resident);
                BukkitTools.fireEvent(new PlayerChangePlotTypeEvent(type, oldType, tb, player));
            }
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_set_group_type_to_x", plotTypeName));
        }
    }

    public void parsePlotGroupToggle(String[] split, TownBlock townBlock, Player player, Resident resident) throws TownyException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_TOGGLE.getNode());
        PlotGroup group = this.catchMissingPlotGroup(townBlock);
        Confirmation.runOnAccept(() -> {
            try {
                new PlotCommand(Towny.getPlugin()).plotGroupToggle(player, resident, group, StringMgmt.remArgs(split, 1));
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
            }
        }).setTitle(Translatable.of("msg_plot_group_toggle_confirmation", group.getTownBlocks().size()).append(" ").append(Translatable.of("are_you_sure_you_want_to_continue"))).sendTo((CommandSender)player);
    }

    public void plotGroupToggle(Player player, Resident resident, PlotGroup plotGroup, String[] split) throws TownyException {
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            HelpMenu.PLOT_GROUP_TOGGLE.send((CommandSender)player);
            return;
        }
        Translatable endingMessage = null;
        Optional<Boolean> choice = Optional.empty();
        if (split.length == 2) {
            choice = BaseCommand.parseToggleChoice(split[1]);
        }
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "pvp": {
                PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_TOGGLE_PVP.getNode());
                break;
            }
            case "explosion": {
                PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_TOGGLE_EXPLOSION.getNode());
                break;
            }
            case "fire": {
                PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_TOGGLE_FIRE.getNode());
                break;
            }
            case "mobs": {
                PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_TOGGLE_MOBS.getNode());
                break;
            }
            case "taxed": {
                PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode());
            }
        }
        for (TownBlock groupBlock : plotGroup.getTownBlocks()) {
            Town town = groupBlock.getTownOrNull();
            if (town == null) continue;
            try {
                switch (split[0].toLowerCase(Locale.ROOT)) {
                    case "pvp": {
                        this.tryToggleTownBlockPVP(player, resident, groupBlock, split, town, choice);
                        endingMessage = Translatable.of("msg_changed_pvp", Translatable.of("msg_the_plot_group"), groupBlock.getPermissions().pvp ? Translatable.of("enabled") : Translatable.of("disabled"));
                        break;
                    }
                    case "explosion": {
                        this.tryToggleTownBlockExplosion(player, groupBlock, split, choice);
                        endingMessage = Translatable.of("msg_changed_expl", Translatable.of("msg_the_plot_group"), groupBlock.getPermissions().explosion ? Translatable.of("enabled") : Translatable.of("disabled"));
                        break;
                    }
                    case "fire": {
                        this.tryToggleTownBlockFire(player, groupBlock, split, choice);
                        endingMessage = Translatable.of("msg_changed_fire", Translatable.of("msg_the_plot_group"), groupBlock.getPermissions().fire ? Translatable.of("enabled") : Translatable.of("disabled"));
                        break;
                    }
                    case "mobs": {
                        this.tryToggleTownBlockMobs(player, groupBlock, split, choice);
                        endingMessage = Translatable.of("msg_changed_mobs", Translatable.of("msg_the_plot_group"), groupBlock.getPermissions().mobs ? Translatable.of("enabled") : Translatable.of("disabled"));
                        break;
                    }
                    case "taxed": {
                        this.tryToggleTownBlockTaxed(player, groupBlock, split, choice);
                        endingMessage = Translatable.of("msg_changed_plotgroup_taxed", groupBlock.isTaxed() ? Translatable.of("enabled") : Translatable.of("disabled"));
                        break;
                    }
                    default: {
                        TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_property", "plot"));
                        return;
                    }
                }
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
                continue;
            }
            groupBlock.setChanged(true);
            BukkitTools.fireEvent(new TownBlockSettingsChangedEvent(groupBlock));
            groupBlock.save();
        }
        if (endingMessage != null) {
            TownyMessaging.sendMsg((CommandSender)player, endingMessage);
        }
    }

    public void parsePlotGroupTrust(String[] split, TownBlock townBlock, Player player) throws TownyException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_TRUST.getNode());
        if (split.length < 3) {
            HelpMenu.PLOT_GROUP_TRUST_HELP.send((CommandSender)player);
            return;
        }
        PlotGroup group = this.catchMissingPlotGroup(townBlock);
        Resident trustedResident = TownyAPI.getInstance().getResident(split[2]);
        if (trustedResident == null || trustedResident.isNPC()) {
            throw new TownyException(Translatable.of("msg_err_not_registered_1", split[2]));
        }
        if (split[1].equalsIgnoreCase("add")) {
            if (group.hasTrustedResident(trustedResident)) {
                throw new TownyException(Translatable.of("msg_already_trusted", trustedResident.getName(), Translatable.of("plotgroup_sing")));
            }
            if (townBlock.getTownOrNull().hasOutlaw(trustedResident)) {
                throw new TownyException(Translatable.of("msg_err_you_cannot_add_trust_on_outlaw"));
            }
            if (trustedResident.hasNation() && townBlock.getTownOrNull().hasNation() && townBlock.getTownOrNull().getNationOrNull().hasEnemy(trustedResident.getNationOrNull())) {
                throw new TownyException(Translatable.of("msg_err_you_cannot_add_trust_on_enemy"));
            }
            BukkitTools.ifCancelledThenThrow(new PlotTrustAddEvent(new ArrayList<TownBlock>(group.getTownBlocks()), trustedResident, player));
            group.addTrustedResident(trustedResident);
            plugin.deleteCache(trustedResident);
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_trusted_added", trustedResident.getName(), Translatable.of("plotgroup_sing")));
            if (BukkitTools.isOnline(trustedResident.getName()) && !trustedResident.getName().equals(player.getName())) {
                TownyMessaging.sendMsg(trustedResident, Translatable.of("msg_trusted_added_2", player.getName(), Translatable.of("plotgroup_sing"), group.getName()));
            }
            return;
        }
        if (split[1].equalsIgnoreCase("remove")) {
            if (!group.hasTrustedResident(trustedResident)) {
                throw new TownyException(Translatable.of("msg_not_trusted", trustedResident.getName(), Translatable.of("plotgroup_sing")));
            }
            BukkitTools.ifCancelledThenThrow(new PlotTrustRemoveEvent(new ArrayList<TownBlock>(group.getTownBlocks()), trustedResident, player));
            group.removeTrustedResident(trustedResident);
            plugin.deleteCache(trustedResident);
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_trusted_removed", trustedResident.getName(), Translatable.of("plotgroup_sing")));
            if (BukkitTools.isOnline(trustedResident.getName()) && !trustedResident.getName().equals(player.getName())) {
                TownyMessaging.sendMsg(trustedResident, Translatable.of("msg_trusted_removed_2", player.getName(), Translatable.of("plotgroup_sing"), group.getName()));
            }
            return;
        }
        TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_property", split[1]));
    }

    public static void parsePlotTrustCommand(Player player, String[] args) throws TownyException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_TRUST.getNode());
        if (args.length < 2) {
            HelpMenu.PLOT_TRUST_HELP.send((CommandSender)player);
            return;
        }
        TownBlock townBlock = WorldCoord.parseWorldCoord((Entity)player).getTownBlockOrNull();
        if (townBlock == null) {
            throw new TownyException(Translatable.of("msg_not_claimed_1"));
        }
        TownyAPI.getInstance().testPlotOwnerOrThrow(PlotCommand.getResidentOrThrow(player), townBlock);
        PlotCommand.catchPlotGroup(townBlock, "/plot group trust");
        Resident resident = TownyAPI.getInstance().getResident(args[1]);
        if (resident == null || resident.isNPC()) {
            throw new TownyException(Translatable.of("msg_err_not_registered_1", args[1]));
        }
        if (args[0].equalsIgnoreCase("add")) {
            if (townBlock.hasTrustedResident(resident)) {
                throw new TownyException(Translatable.of("msg_already_trusted", resident.getName(), Translatable.of("townblock")));
            }
            if (townBlock.getTownOrNull().hasOutlaw(resident)) {
                throw new TownyException(Translatable.of("msg_err_you_cannot_add_trust_on_outlaw"));
            }
            if (resident.hasNation() && townBlock.getTownOrNull().hasNation() && townBlock.getTownOrNull().getNationOrNull().hasEnemy(resident.getNationOrNull())) {
                throw new TownyException(Translatable.of("msg_err_you_cannot_add_trust_on_enemy"));
            }
            BukkitTools.ifCancelledThenThrow(new PlotTrustAddEvent(townBlock, resident, player));
            townBlock.addTrustedResident(resident);
            plugin.deleteCache(resident);
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_trusted_added", resident.getName(), Translatable.of("townblock")));
            if (BukkitTools.isOnline(resident.getName()) && !resident.getName().equals(player.getName())) {
                TownyMessaging.sendMsg(resident, Translatable.of("msg_trusted_added_2", player.getName(), Translatable.of("townblock"), townBlock.getWorldCoord().getCoord().toString()));
            }
        } else if (args[0].equalsIgnoreCase("remove")) {
            if (!townBlock.hasTrustedResident(resident)) {
                throw new TownyException(Translatable.of("msg_not_trusted", resident.getName(), Translatable.of("townblock")));
            }
            BukkitTools.ifCancelledThenThrow(new PlotTrustRemoveEvent(townBlock, resident, player));
            townBlock.removeTrustedResident(resident);
            plugin.deleteCache(resident);
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_trusted_removed", resident.getName(), Translatable.of("townblock")));
            if (BukkitTools.isOnline(resident.getName()) && !resident.getName().equals(player.getName())) {
                TownyMessaging.sendMsg(resident, Translatable.of("msg_trusted_removed_2", player.getName(), Translatable.of("townblock"), townBlock.getWorldCoord().getCoord().toString()));
            }
        } else {
            throw new TownyException(Translatable.of("msg_err_invalid_property", args[0]));
        }
        townBlock.save();
    }

    private void continuePlotClaimProcess(List<WorldCoord> selection, Resident resident, Player player) throws TownyException {
        double cost = 0.0;
        for (WorldCoord worldCoord : new ArrayList<WorldCoord>(selection)) {
            if (!worldCoord.hasTownBlock()) {
                selection.remove(worldCoord);
                continue;
            }
            TownBlock tb = worldCoord.getTownBlockOrNull();
            if (tb == null) {
                selection.remove(worldCoord);
                continue;
            }
            double price = tb.getPlotPrice();
            if (tb.hasPlotObjectGroup()) {
                PlotGroup group = tb.getPlotObjectGroup();
                if (TownyEconomyHandler.isActive() && !resident.getAccount().canPayFromHoldings(group.getPrice())) {
                    throw new TownyException(Translatable.of("msg_no_funds_claim_plot_group", group.getTownBlocks().size(), PlotCommand.prettyMoney(group.getPrice())));
                }
                tb.testTownMembershipAgePreventsThisClaimOrThrow(resident);
                Confirmation.runOnAccept(() -> {
                    ArrayList<WorldCoord> coords = new ArrayList<WorldCoord>();
                    group.getTownBlocks().forEach(tblock -> coords.add(tblock.getWorldCoord()));
                    plugin.getScheduler().runAsync(new PlotClaim(plugin, player, resident, coords, true, false, true));
                }).setTitle(Translatable.of("msg_plot_group_claim_confirmation", group.getTownBlocks().size()).append(" ").append(PlotCommand.prettyMoney(group.getPrice())).append(". ").append(Translatable.of("are_you_sure_you_want_to_continue"))).sendTo((CommandSender)player);
                return;
            }
            if (price > -1.0) {
                cost += tb.getPlotPrice();
                continue;
            }
            if (tb.getTownOrNull().isMayor(resident)) continue;
            selection.remove(worldCoord);
        }
        int maxPlots = TownySettings.getMaxResidentPlots(resident);
        int extraPlots = TownySettings.getMaxResidentExtraPlots(resident);
        if (maxPlots != -1) {
            maxPlots += extraPlots;
        }
        if (maxPlots >= 0 && resident.getTownBlocks().size() + selection.size() > maxPlots) {
            throw new TownyException(Translatable.of("msg_max_plot_own", maxPlots));
        }
        if (TownyEconomyHandler.isActive() && !resident.getAccount().canPayFromHoldings(cost)) {
            throw new TownyException(Translatable.of("msg_no_funds_claim_plot", PlotCommand.prettyMoney(cost)));
        }
        if (cost != 0.0) {
            Confirmation.runOnAcceptAsync(new PlotClaim(plugin, player, resident, selection, true, false, false)).setTitle(Translatable.of("msg_confirm_purchase", PlotCommand.prettyMoney(cost))).sendTo((CommandSender)player);
        } else {
            plugin.getScheduler().runAsync(new PlotClaim(plugin, player, resident, selection, true, false, false));
        }
    }

    public void parsePlotPermCommand(Player player, String[] args) throws TownyException {
        if (args.length == 0) {
            PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_PERM_INFO.getNode());
            this.sendPlotInfo(player, args);
            return;
        }
        if (args[0].equalsIgnoreCase("hud")) {
            PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_PERM_HUD.getNode());
            HUDManager.togglePermHUD(player);
            return;
        }
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(player);
        if (townBlock == null) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_not_claimed_1"));
            return;
        }
        if (args[0].equalsIgnoreCase("gui")) {
            PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_PERM_GUI.getNode());
            PermissionGUIUtil.openPermissionGUI(PlotCommand.getResidentOrThrow(player), townBlock);
            return;
        }
        if (args.length < 2 || !args[0].equalsIgnoreCase("remove") && !args[0].equalsIgnoreCase("add")) {
            HelpMenu.PLOT_PERM_HELP.send((CommandSender)player);
            return;
        }
        TownyAPI.getInstance().testPlotOwnerOrThrow(PlotCommand.getResidentOrThrow(player), townBlock);
        PlotCommand.catchPlotGroup(townBlock, "/plot group perm " + args[0].toLowerCase(Locale.ROOT));
        Resident resident = PlotCommand.getResidentOrThrow(args[1]);
        if (args[0].equalsIgnoreCase("remove")) {
            PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_PERM_REMOVE.getNode());
            if (!townBlock.getPermissionOverrides().containsKey(resident)) {
                throw new TownyException(Translatable.of("msg_no_overrides_set", resident.getName(), Translatable.of("townblock")));
            }
            townBlock.getPermissionOverrides().remove(resident);
            townBlock.save();
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_overrides_removed", resident.getName()));
        } else if (args[0].equalsIgnoreCase("add")) {
            PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_PERM_ADD.getNode());
            if (townBlock.getPermissionOverrides().containsKey(resident)) {
                throw new TownyException(Translatable.of("msg_overrides_already_set", resident.getName(), Translatable.of("townblock")));
            }
            townBlock.getPermissionOverrides().put(resident, new PermissionData(PermissionGUIUtil.getDefaultTypes(), player.getName()));
            townBlock.save();
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_overrides_added", resident.getName()));
        }
    }

    public void sendPlotInfo(Player player, String[] args) throws NoPermissionException {
        PlotCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_PLOT_PERM_INFO.getNode());
        WorldCoord coord = WorldCoord.parseWorldCoord((Entity)player);
        try {
            coord = new WorldCoord(player.getWorld(), Integer.parseInt(args[0]), Integer.parseInt(args[1]));
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {
            // empty catch block
        }
        if (TownyAPI.getInstance().isWilderness(coord)) {
            TownyMessaging.sendStatusScreen((CommandSender)player, TownyFormatter.getStatus(coord.getTownyWorld(), (CommandSender)player));
        } else {
            TownyMessaging.sendStatusScreen((CommandSender)player, TownyFormatter.getStatus(coord.getTownBlockOrNull(), player));
        }
    }

    private List<String> getPlotSetCompletions() {
        ArrayList<String> completions = new ArrayList<String>(plotSetTabCompletes);
        for (String townBlockType : TownBlockTypeHandler.getTypeNames()) {
            if (completions.contains(townBlockType)) continue;
            completions.add(townBlockType);
        }
        return completions;
    }

    private static void catchPlotGroup(TownBlock townBlock, String command) throws TownyException {
        if (townBlock.hasPlotObjectGroup()) {
            throw new TownyException(Translatable.of("msg_err_plot_belongs_to_group", command));
        }
    }

    private PlotGroup catchMissingPlotGroup(TownBlock townBlock) throws TownyException {
        if (!townBlock.hasPlotObjectGroup()) {
            throw new TownyException(Translatable.of("msg_err_plot_not_associated_with_a_group"));
        }
        return townBlock.getPlotObjectGroup();
    }

    private District catchMissingDistrict(TownBlock townBlock) throws TownyException {
        if (!townBlock.hasDistrict()) {
            throw new TownyException(Translatable.of("msg_err_plot_not_associated_with_a_district"));
        }
        return townBlock.getDistrict();
    }

    static {
        plotTabCompletes = Arrays.asList("claim", "unclaim", "forsale", "fs", "notforsale", "nfs", "evict", "info", "perm", "set", "toggle", "clear", "group", "district", "jailcell", "trust");
        plotGroupTabCompletes = Arrays.asList("add", "delete", "remove", "set", "toggle", "fs", "notforsale", "forsale", "perm", "rename", "trust");
        districtTabCompletes = Arrays.asList("add", "new", "create", "delete", "remove", "rename");
        plotSetTabCompletes = Arrays.asList("reset", "shop", "embassy", "arena", "wilds", "inn", "jail", "farm", "bank", "minjoindays", "maxjoindays", "outpost", "name", "perm");
        plotRectCircleCompletes = Arrays.asList("rect", "circle");
        plotToggleTabCompletes = Arrays.asList("taxed", "fire", "pvp", "explosion", "mobs");
        plotPermTabCompletes = Arrays.asList("hud", "gui", "add", "remove");
    }
}

