/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyCommandAddonAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnType;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translator;
import com.palmergames.bukkit.towny.object.jail.UnJailReason;
import com.palmergames.bukkit.towny.object.resident.mode.ResidentModeHandler;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.utils.JailUtil;
import com.palmergames.bukkit.towny.utils.NameUtil;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.towny.utils.SpawnUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.MathUtil;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class ResidentCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> residentTabCompletes;
    private static final List<String> residentFriendTabCompletes;
    private static final List<String> residentConsoleTabCompletes;
    private static final List<String> residentSetTabCompletes;
    private static final List<String> residentAboutTabCompletes;
    private static final List<String> residentToggleChoices;
    private static final List<String> residentToggleModeTabCompletes;
    private static final List<String> residentSetModeTabCompletesWithClearAndReset;
    private static final List<String> residentCompleteToggleChoices;

    public ResidentCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (plugin.isError()) {
                TownyMessaging.sendErrorMsg((Object)sender, "Locked in Safe mode!");
                return false;
            }
            try {
                this.parseResidentCommand(player, args);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)sender, e.getMessage());
            }
        } else {
            try {
                this.parseResidentCommandForConsole(sender, args);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)sender, e.getMessage());
            }
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        block56: {
            block55: {
                if (!(sender instanceof Player)) break block55;
                Player player = (Player)sender;
                switch (args[0].toLowerCase(Locale.ROOT)) {
                    case "plotlist": {
                        if (args.length == 2) {
                            return ResidentCommand.getTownyStartingWith(args[1], "r");
                        }
                        if (args.length == 3) {
                            return Collections.singletonList("[page #]");
                        }
                        break block56;
                    }
                    case "tax": 
                    case "outlawlist": {
                        if (args.length == 2) {
                            return ResidentCommand.getTownyStartingWith(args[1], "r");
                        }
                        break block56;
                    }
                    case "jail": {
                        if (args.length == 2) {
                            return Collections.singletonList("paybail");
                        }
                        break block56;
                    }
                    case "toggle": {
                        if (args.length == 2) {
                            return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.RESIDENT_TOGGLE, residentCompleteToggleChoices), args[1]);
                        }
                        if (args.length == 3 && residentToggleChoices.contains(args[1].toLowerCase(Locale.ROOT))) {
                            return NameUtil.filterByStart(BaseCommand.setOnOffCompletes, args[2]);
                        }
                        break block56;
                    }
                    case "set": {
                        if (args.length == 2) {
                            return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.RESIDENT_SET, residentSetTabCompletes), args[1]);
                        }
                        if (args.length > 2) {
                            if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.RESIDENT_SET, args[1])) {
                                return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.RESIDENT_SET, args[1]).getTabCompletion(sender, StringMgmt.remFirstArg(args)), args[args.length - 1]);
                            }
                            switch (args[1].toLowerCase(Locale.ROOT)) {
                                case "mode": {
                                    if (args.length == 3) {
                                        return NameUtil.filterByStart(residentSetModeTabCompletesWithClearAndReset, args[2]);
                                    }
                                    return NameUtil.filterByStart(residentToggleModeTabCompletes, args[args.length - 1]);
                                }
                                case "perm": {
                                    return ResidentCommand.permTabComplete(StringMgmt.remArgs(args, 2));
                                }
                                case "about": {
                                    return NameUtil.filterByStart(residentAboutTabCompletes, args[args.length - 1]);
                                }
                            }
                            return Collections.emptyList();
                        }
                        break block56;
                    }
                    case "friend": {
                        switch (args.length) {
                            case 2: {
                                return NameUtil.filterByStart(residentFriendTabCompletes, args[1]);
                            }
                            case 3: {
                                return switch (args[1].toLowerCase(Locale.ROOT)) {
                                    case "remove" -> {
                                        Resident res = TownyUniverse.getInstance().getResident(player.getUniqueId());
                                        if (res != null) {
                                            yield NameUtil.filterByStart(NameUtil.getNames(res.getFriends()), args[2]);
                                        }
                                        yield Collections.emptyList();
                                    }
                                    case "add" -> ResidentCommand.getTownyStartingWith(args[2], "r");
                                    case "list" -> NameUtil.filterByStart(List.of("online"), args[2]);
                                    default -> Collections.emptyList();
                                };
                            }
                        }
                        return Collections.emptyList();
                    }
                    default: {
                        if (args.length == 1) {
                            return ResidentCommand.filterByStartOrGetTownyStartingWith(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.RESIDENT, residentTabCompletes), args[0], "r");
                        }
                        if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.RESIDENT, args[0])) {
                            return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.RESIDENT, args[0]).getTabCompletion(sender, args), args[args.length - 1]);
                        }
                        break block56;
                    }
                }
            }
            if (args.length == 1) {
                return ResidentCommand.filterByStartOrGetTownyStartingWith(residentConsoleTabCompletes, args[0], "r");
            }
        }
        return Collections.emptyList();
    }

    private void parseResidentCommandForConsole(CommandSender sender, String[] split) throws TownyException {
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.RESIDENT_HELP_CONSOLE.send(sender);
        } else if (split[0].equalsIgnoreCase("list")) {
            this.listResidents(sender);
        } else if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.RESIDENT, split[0])) {
            TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.RESIDENT, split[0]).execute(sender, "resident", split);
        } else {
            Optional<Resident> resOpt = Optional.ofNullable(TownyUniverse.getInstance().getResident(split[0]));
            if (resOpt.isPresent()) {
                TownyEconomyHandler.economyExecutor().execute(() -> TownyMessaging.sendStatusScreen(sender, TownyFormatter.getStatus((Resident)resOpt.get(), sender)));
            } else {
                throw new TownyException(Translatable.of("msg_err_not_registered_1", split[0]));
            }
        }
    }

    public void parseResidentCommand(Player player, String[] split) throws TownyException {
        if (split.length == 0) {
            Resident res = ResidentCommand.getResidentOrThrow(player);
            plugin.getScheduler().runAsync(() -> TownyMessaging.sendStatusScreen((CommandSender)player, TownyFormatter.getStatus(res, (CommandSender)player)));
            return;
        }
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "?": 
            case "help": {
                HelpMenu.RESIDENT_HELP.send((CommandSender)player);
                break;
            }
            case "list": {
                this.listResidents((CommandSender)player);
                break;
            }
            case "tax": {
                this.parseResidentTax(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "plotlist": {
                this.parseResidentPlotlist(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "outlawlist": {
                this.parseResidentOutlawlist(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "jail": {
                this.parseResidentJail(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "set": {
                this.residentSet(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "toggle": {
                this.residentToggle(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "friend": {
                ResidentCommand.residentFriend(player, StringMgmt.remFirstArg(split), false, null);
                break;
            }
            case "spawn": {
                ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_SPAWN.getNode());
                SpawnUtil.sendToTownySpawn(player, split, ResidentCommand.getResidentOrThrow(player), Translatable.of("msg_err_cant_afford_tp").forLocale((CommandSender)player), false, false, SpawnType.RESIDENT);
                break;
            }
            default: {
                if (this.tryResidentAddonCommand((CommandSender)player, split)) {
                    return;
                }
                Resident resident = TownyUniverse.getInstance().getResidentOpt(split[0]).orElseThrow(() -> new TownyException(Translatable.of("msg_err_not_registered_1", split[0])));
                if (!resident.getName().equals(player.getName())) {
                    ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_OTHERRESIDENT.getNode());
                }
                plugin.getScheduler().runAsync(() -> TownyMessaging.sendStatusScreen((CommandSender)player, TownyFormatter.getStatus(resident, (CommandSender)player)));
            }
        }
    }

    private boolean tryResidentAddonCommand(CommandSender sender, String[] split) {
        if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.RESIDENT, split[0])) {
            TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.RESIDENT, split[0]).execute(sender, "resident", split);
            return true;
        }
        return false;
    }

    private void parseResidentTax(Player player, String[] split) throws TownyException {
        ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_TAX.getNode());
        if (!TownyEconomyHandler.isActive()) {
            throw new TownyException(Translatable.of("msg_err_no_economy"));
        }
        Resident res = split.length > 0 ? ResidentCommand.getResidentOrThrow(split[0]) : ResidentCommand.getResidentOrThrow(player);
        TownyMessaging.sendMessage((Object)player, TownyFormatter.getTaxStatus(res, Translator.locale((CommandSender)player)));
    }

    private void parseResidentPlotlist(Player player, String[] split) throws TownyException {
        ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_PLOTLIST.getNode());
        int pageLoc = 0;
        Resident res = ResidentCommand.getResidentOrThrow(player);
        if (split.length > 0 && TownyUniverse.getInstance().hasResident(split[0])) {
            res = ResidentCommand.getResidentOrThrow(split[0]);
            pageLoc = 1;
        }
        if (res.getTownBlocks().isEmpty()) {
            throw new TownyException(Translatable.of("msg_err_resident_doesnt_own_any_land"));
        }
        int page = 1;
        int total = (int)Math.ceil((double)res.getTownBlocks().size() / 10.0);
        if (split.length > pageLoc && (page = MathUtil.getPositiveIntOrThrow(split[pageLoc])) == 0) {
            throw new TownyException(Translatable.of("msg_error_must_be_int"));
        }
        if (page > total) {
            throw new TownyException(Translatable.of("LIST_ERR_NOT_ENOUGH_PAGES", total));
        }
        TownyMessaging.sendPlotList((CommandSender)player, res, page, total);
    }

    private void parseResidentOutlawlist(Player player, String[] split) throws TownyException {
        ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_OUTLAWLIST.getNode());
        Resident resident = split.length == 0 ? ResidentCommand.getResidentOrThrow(player) : ResidentCommand.getResidentOrThrow(split[0]);
        TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedTownyObjects(Translatable.of("outlawed_in").forLocale((CommandSender)player), new ArrayList<TownyObject>(resident.getTownsOutlawedIn())));
    }

    private void parseResidentJail(Player player, String[] split) throws TownyException {
        ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_JAIL.getNode());
        if (!TownySettings.isAllowingBail()) {
            throw new TownyException(Translatable.of("msg_err_bail_not_enabled"));
        }
        if (split.length == 0 || !split[0].equalsIgnoreCase("paybail")) {
            HelpMenu.RESIDENT_JAIL_HELP.send((CommandSender)player);
            return;
        }
        Resident resident = ResidentCommand.getResidentOrThrow(player);
        if (!resident.isJailed()) {
            throw new TownyException(Translatable.of("msg_err_you_aren't currently jailed"));
        }
        if (!TownyEconomyHandler.isActive()) {
            throw new TownyException(Translatable.of("msg_err_no_economy"));
        }
        Town jailTown = resident.getJailTown();
        double cost = resident.getJailBailCost();
        if (cost <= 0.0) {
            JailUtil.unJailResident(resident, UnJailReason.BAIL);
            return;
        }
        if (!resident.getAccount().canPayFromHoldings(cost)) {
            throw new TownyException(Translatable.of("msg_err_unable_to_pay_bail"));
        }
        Confirmation.runOnAccept(() -> {
            if (resident.getAccount().canPayFromHoldings(cost)) {
                resident.getAccount().payTo(cost, jailTown, "Bail paid to " + jailTown.getName());
                JailUtil.unJailResident(resident, UnJailReason.BAIL);
            } else {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_unable_to_pay_bail"));
            }
        }).setTitle(Translatable.of("msg_confirm_purchase", ResidentCommand.prettyMoney(cost))).sendTo((CommandSender)player);
    }

    private void residentToggle(Player player, String[] newSplit) throws TownyException {
        Resident resident = ResidentCommand.getResidentOrThrow(player);
        if (newSplit.length == 0) {
            HelpMenu.RESIDENT_TOGGLE.send((CommandSender)player);
            TownyMessaging.sendMsg(resident, Translatable.of("msg_modes_set").append(StringMgmt.join(resident.getModes(), ",")));
            return;
        }
        if (newSplit[0].equalsIgnoreCase("clear")) {
            ResidentCommand.checkPermOrThrow((Permissible)resident.getPlayer(), PermissionNodes.TOWNY_COMMAND_RESIDENT_SET_MODE_CLEAR.getNode());
            ResidentModeHandler.clearModes(resident, false);
            return;
        }
        if (newSplit[0].equalsIgnoreCase("reset")) {
            ResidentModeHandler.resetModes(resident, false);
            return;
        }
        TownyPermission perm = resident.getPermissions();
        Optional<Object> choice = Optional.empty();
        if (newSplit.length == 2 && residentToggleChoices.contains(newSplit[0].toLowerCase(Locale.ROOT))) {
            choice = BaseCommand.parseToggleChoice(newSplit[1]);
        }
        if (newSplit[0].equalsIgnoreCase("pvp")) {
            ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_PVP.getNode());
            Town town = resident.getTownOrNull();
            if (TownySettings.getPVPCoolDownTime() > 0 && town != null && !resident.isAdmin()) {
                if (CooldownTimerTask.hasCooldown(town.getUUID().toString(), CooldownTimerTask.CooldownType.PVP)) {
                    throw new TownyException(Translatable.of("msg_err_cannot_toggle_pvp_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(town.getUUID().toString(), CooldownTimerTask.CooldownType.PVP)));
                }
                if (CooldownTimerTask.hasCooldown(resident.getName(), CooldownTimerTask.CooldownType.PVP)) {
                    throw new TownyException(Translatable.of("msg_err_cannot_toggle_pvp_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(resident.getName(), CooldownTimerTask.CooldownType.PVP)));
                }
            }
            perm.pvp = choice.orElse(!perm.pvp);
            if (TownySettings.getPVPCoolDownTime() > 0 && !resident.isAdmin()) {
                CooldownTimerTask.addCooldownTimer(resident.getName(), CooldownTimerTask.CooldownType.PVP);
            }
        } else if (newSplit[0].equalsIgnoreCase("fire")) {
            ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_FIRE.getNode());
            perm.fire = (Boolean)choice.orElse(!perm.fire);
        } else if (newSplit[0].equalsIgnoreCase("explosion")) {
            ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_EXPLOSION.getNode());
            perm.explosion = (Boolean)choice.orElse(!perm.explosion);
        } else if (newSplit[0].equalsIgnoreCase("mobs")) {
            ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_MOBS.getNode());
            perm.mobs = (Boolean)choice.orElse(!perm.mobs);
        } else {
            if (newSplit[0].equalsIgnoreCase("bordertitles")) {
                ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE_BORDERTITLES.getNode());
                ResidentUtil.toggleResidentBorderTitles(resident, choice);
                return;
            }
            if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.RESIDENT_TOGGLE, newSplit[0])) {
                TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.RESIDENT_TOGGLE, newSplit[0]).execute((CommandSender)player, "resident", newSplit);
                return;
            }
            ResidentModeHandler.toggleMode(resident, newSplit[0].toLowerCase(Locale.ROOT), true);
            return;
        }
        this.notifyPerms(player, perm);
        resident.save();
    }

    private void notifyPerms(Player player, TownyPermission perm) {
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_set_perms"));
        TownyMessaging.sendMessage((Object)player, "\u00a72PvP: " + (perm.pvp ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72  Explosions: " + (perm.explosion ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72  Firespread: " + (perm.fire ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72  Mob Spawns: " + (perm.mobs ? "\u00a74ON" : "\u00a7aOFF"));
    }

    public void listResidents(CommandSender sender) throws TownyException {
        ResidentCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_RESIDENT_LIST.getNode());
        TownyMessaging.sendMessage((Object)sender, ChatTools.formatTitle(Translatable.of("res_list").forLocale(sender)));
        ArrayList<String> formattedList = new ArrayList<String>();
        for (Player player : BukkitTools.getVisibleOnlinePlayers(sender)) {
            Resident resident = TownyAPI.getInstance().getResident(player);
            if (resident == null) {
                formattedList.add("\u00a7f" + player.getName() + "\u00a7f");
                continue;
            }
            formattedList.add(ResidentCommand.getColour(resident) + resident.getName() + "\u00a7f");
        }
        TownyMessaging.sendMessage((Object)sender, ChatTools.list(formattedList));
    }

    public void residentSet(Player player, String[] split) throws TownyException {
        if (split.length == 0) {
            HelpMenu.RESIDENT_SET.send((CommandSender)player);
            return;
        }
        Resident resident = ResidentCommand.getResidentOrThrow(player);
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "perm": {
                ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_SET_PERM.getNode());
                TownCommand.setTownBlockPermissions((CommandSender)player, resident, resident.getPermissions(), StringMgmt.remFirstArg(split), true);
                break;
            }
            case "mode": {
                this.setMode(resident, StringMgmt.remFirstArg(split));
                break;
            }
            case "about": {
                this.setAbout(player, String.join((CharSequence)" ", StringMgmt.remFirstArg(split)), resident);
                break;
            }
            default: {
                if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.RESIDENT_SET, split[0])) {
                    TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.RESIDENT_SET, split[0]).execute((CommandSender)player, "resident", split);
                    return;
                }
                throw new TownyException(Translatable.of("msg_err_invalid_property", "resident"));
            }
        }
        resident.save();
    }

    private void setMode(Resident resident, String[] split) throws TownyException {
        if (split.length == 0) {
            HelpMenu.RESIDENT_SET_MODE.send((CommandSender)resident.getPlayer());
            return;
        }
        if (split[0].equalsIgnoreCase("clear")) {
            ResidentCommand.checkPermOrThrow((Permissible)resident.getPlayer(), PermissionNodes.TOWNY_COMMAND_RESIDENT_SET_MODE_CLEAR.getNode());
            ResidentModeHandler.clearModes(resident, true);
            return;
        }
        if (split[0].equalsIgnoreCase("reset")) {
            ResidentModeHandler.resetModes(resident, true);
            return;
        }
        ResidentModeHandler.toggleModes(resident, split, true, false);
    }

    private void setAbout(Player player, String about, Resident resident) throws TownyException {
        ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_SET_ABOUT.getNode());
        if (about.isEmpty()) {
            throw new TownyException("Eg: /res set about " + Translatable.of("res_8").forLocale((CommandSender)player));
        }
        if ("reset".equalsIgnoreCase(about)) {
            about = TownySettings.getDefaultResidentAbout();
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_resident_about_reset"));
        } else if ("none".equalsIgnoreCase(about) || "clear".equalsIgnoreCase(about)) {
            about = "";
        } else {
            if (!NameValidation.isValidBoardString(about)) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_string_about_not_set"));
                return;
            }
            if (about.length() > 159) {
                about = about.substring(0, 159);
            }
        }
        resident.setAbout(about);
        resident.save();
        if (about.isEmpty()) {
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_clear_about", resident.getName()));
        } else {
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_set_about", resident.getName(), about));
        }
    }

    public static void residentFriend(Player player, String[] split, boolean admin, Resident resident) throws TownyException {
        ResidentCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_RESIDENT_FRIEND.getNode());
        if (split.length == 0) {
            HelpMenu.RESIDENT_FRIEND.send((CommandSender)player);
            return;
        }
        if (!admin) {
            resident = ResidentCommand.getResidentOrThrow(player);
        }
        String[] args = StringMgmt.remFirstArg(split);
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "add": {
                ResidentCommand.residentFriendAdd(player, resident, ResidentCommand.filterResidentList(player, args));
                break;
            }
            case "remove": {
                ResidentCommand.residentFriendRemove(player, resident, ResidentCommand.filterResidentList(player, args));
                break;
            }
            case "list": {
                ResidentCommand.residentFriendList(player, resident, args.length > 0 && args[0].equalsIgnoreCase("online"));
                break;
            }
            case "clearlist": 
            case "clear": {
                ResidentCommand.residentFriendRemove(player, resident, resident.getFriends());
            }
        }
    }

    private static List<Resident> filterResidentList(Player player, String[] names) {
        ArrayList<Resident> residents = new ArrayList<Resident>();
        for (String name : names) {
            Resident target = TownyUniverse.getInstance().getResident(name);
            if (target == null) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_registered_1", name));
                continue;
            }
            residents.add(target);
        }
        return residents;
    }

    private static void residentFriendList(Player player, Resident resident, boolean requireOnline) {
        TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(Translatable.of("friend_list").forLocale((CommandSender)player)));
        List<String> formatedList = resident.getFriends().stream().filter(friend -> !requireOnline || friend.getPlayer() != null && player.canSee(friend.getPlayer())).map(friend -> ResidentCommand.getColour(friend) + friend.getName() + "\u00a7f").collect(Collectors.toList());
        TownyMessaging.sendMessage((Object)player, ChatTools.list(formatedList));
    }

    private static String getColour(Resident resident) {
        return resident.isMayor() ? (resident.isKing() ? "\u00a76" : "\u00a7b") : "\u00a7f";
    }

    public static void residentFriendAdd(Player player, Resident resident, List<Resident> friending) {
        List<Resident> toFriend = friending.stream().filter(friend -> !resident.hasFriend((Resident)friend) && !friend.isNPC() && !friend.getName().equalsIgnoreCase(resident.getName())).collect(Collectors.toList());
        if (toFriend.isEmpty()) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_invalid_name"));
            return;
        }
        toFriend.forEach(friend -> {
            resident.addFriend((Resident)friend);
            plugin.deleteCache((Resident)friend);
            TownyMessaging.sendMsg(friend, Translatable.of("msg_friend_add", player.getName()));
        });
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_res_friend_added_to_list", StringMgmt.join(toFriend, ", ")));
        resident.save();
    }

    public static void residentFriendRemove(Player player, Resident resident, List<Resident> unFriending) {
        List<Resident> toUnfriend = unFriending.stream().filter(resident::hasFriend).collect(Collectors.toList());
        if (toUnfriend.isEmpty()) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_invalid_name"));
            return;
        }
        toUnfriend.forEach(exFriend -> {
            resident.removeFriend((Resident)exFriend);
            plugin.deleteCache((Resident)exFriend);
            TownyMessaging.sendMsg(exFriend, Translatable.of("msg_friend_remove", player.getName()));
        });
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_res_friend_removed_from_list", StringMgmt.join(toUnfriend, ", ")));
        resident.save();
    }

    static {
        residentTabCompletes = Arrays.asList("friend", "list", "jail", "plotlist", "outlawlist", "spawn", "toggle", "set", "tax");
        residentFriendTabCompletes = Arrays.asList("add", "remove", "clear", "list");
        residentConsoleTabCompletes = Arrays.asList("?", "help", "list");
        residentSetTabCompletes = Arrays.asList("about", "perm", "mode");
        residentAboutTabCompletes = Arrays.asList("reset", "none", "clear");
        residentToggleChoices = Arrays.asList("pvp", "fire", "mobs", "explosion");
        residentToggleModeTabCompletes = ResidentModeHandler.getValidModeNames();
        residentSetModeTabCompletesWithClearAndReset = Stream.concat(Arrays.asList("reset", "clear").stream(), new ArrayList<String>(residentToggleModeTabCompletes).stream()).collect(Collectors.toList());
        residentCompleteToggleChoices = Stream.concat(new ArrayList<String>(residentToggleChoices).stream(), new ArrayList<String>(residentToggleModeTabCompletes).stream()).collect(Collectors.toList());
    }
}

