/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyCommandAddonAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.command.InviteCommand;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.confirmations.ConfirmationTransaction;
import com.palmergames.bukkit.towny.event.DeleteTownEvent;
import com.palmergames.bukkit.towny.event.NewTownEvent;
import com.palmergames.bukkit.towny.event.PreNewTownEvent;
import com.palmergames.bukkit.towny.event.TownAddResidentRankEvent;
import com.palmergames.bukkit.towny.event.TownBlockPermissionChangeEvent;
import com.palmergames.bukkit.towny.event.TownBlockSettingsChangedEvent;
import com.palmergames.bukkit.towny.event.TownInvitePlayerEvent;
import com.palmergames.bukkit.towny.event.TownPreAddResidentEvent;
import com.palmergames.bukkit.towny.event.TownPreClaimEvent;
import com.palmergames.bukkit.towny.event.TownPreRenameEvent;
import com.palmergames.bukkit.towny.event.TownRemoveResidentRankEvent;
import com.palmergames.bukkit.towny.event.nation.NationKingChangeEvent;
import com.palmergames.bukkit.towny.event.teleport.OutlawTeleportEvent;
import com.palmergames.bukkit.towny.event.town.TownCedePlotEvent;
import com.palmergames.bukkit.towny.event.town.TownKickEvent;
import com.palmergames.bukkit.towny.event.town.TownLeaveEvent;
import com.palmergames.bukkit.towny.event.town.TownMayorChangeEvent;
import com.palmergames.bukkit.towny.event.town.TownMergeEvent;
import com.palmergames.bukkit.towny.event.town.TownOutlawAddEvent;
import com.palmergames.bukkit.towny.event.town.TownOutlawRemoveEvent;
import com.palmergames.bukkit.towny.event.town.TownPreInvitePlayerEvent;
import com.palmergames.bukkit.towny.event.town.TownPreMergeEvent;
import com.palmergames.bukkit.towny.event.town.TownPreSetHomeBlockEvent;
import com.palmergames.bukkit.towny.event.town.TownPreUnclaimCmdEvent;
import com.palmergames.bukkit.towny.event.town.TownSetOutpostSpawnEvent;
import com.palmergames.bukkit.towny.event.town.TownSetSpawnEvent;
import com.palmergames.bukkit.towny.event.town.TownTrustAddEvent;
import com.palmergames.bukkit.towny.event.town.TownTrustRemoveEvent;
import com.palmergames.bukkit.towny.event.town.TownTrustTownAddEvent;
import com.palmergames.bukkit.towny.event.town.TownTrustTownRemoveEvent;
import com.palmergames.bukkit.towny.event.town.toggle.TownToggleExplosionEvent;
import com.palmergames.bukkit.towny.event.town.toggle.TownToggleFireEvent;
import com.palmergames.bukkit.towny.event.town.toggle.TownToggleMobsEvent;
import com.palmergames.bukkit.towny.event.town.toggle.TownToggleNationZoneEvent;
import com.palmergames.bukkit.towny.event.town.toggle.TownToggleNeutralEvent;
import com.palmergames.bukkit.towny.event.town.toggle.TownToggleOpenEvent;
import com.palmergames.bukkit.towny.event.town.toggle.TownTogglePVPEvent;
import com.palmergames.bukkit.towny.event.town.toggle.TownTogglePublicEvent;
import com.palmergames.bukkit.towny.event.town.toggle.TownToggleTaxPercentEvent;
import com.palmergames.bukkit.towny.event.town.toggle.TownToggleUnknownEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.CancelledEventException;
import com.palmergames.bukkit.towny.exceptions.NoPermissionException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.invites.exceptions.TooManyInvitesException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nameable;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnType;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownBlockTypeCache;
import com.palmergames.bukkit.towny.object.TownBlockTypeHandler;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyPermissionChange;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.Translator;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.comparators.ComparatorCaches;
import com.palmergames.bukkit.towny.object.comparators.ComparatorType;
import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.towny.object.economy.BankAccount;
import com.palmergames.bukkit.towny.object.inviteobjects.PlayerJoinTownInvite;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.object.jail.JailReason;
import com.palmergames.bukkit.towny.object.jail.UnJailReason;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.tasks.TownClaim;
import com.palmergames.bukkit.towny.utils.AreaSelectionUtil;
import com.palmergames.bukkit.towny.utils.BorderUtil;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.JailUtil;
import com.palmergames.bukkit.towny.utils.MoneyUtil;
import com.palmergames.bukkit.towny.utils.NameUtil;
import com.palmergames.bukkit.towny.utils.OutpostUtil;
import com.palmergames.bukkit.towny.utils.ProximityUtil;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.towny.utils.SpawnUtil;
import com.palmergames.bukkit.towny.utils.TownRuinUtil;
import com.palmergames.bukkit.towny.utils.TownUtil;
import com.palmergames.bukkit.towny.utils.TownyComponents;
import com.palmergames.bukkit.util.BookFactory;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.MathUtil;
import com.palmergames.util.Pair;
import com.palmergames.util.StringMgmt;
import com.palmergames.util.TimeMgmt;
import com.palmergames.util.TimeTools;
import java.io.InvalidObjectException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class TownCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    @VisibleForTesting
    public static final List<String> townTabCompletes;
    @VisibleForTesting
    public static final List<String> townSetTabCompletes;
    private static final List<String> townListTabCompletes;
    static final List<String> townToggleTabCompletes;
    private static final List<String> townConsoleTabCompletes;
    static final List<String> townAddRemoveTabCompletes;
    private static final List<String> townClaimTabCompletes;
    public static final List<String> townUnclaimTabCompletes;
    private static final List<String> townInviteTabCompletes;
    private static final List<String> townSetBoardTabCompletes;

    public TownCommand(Towny instance) {
        plugin = instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            if (args.length != 1) return Collections.emptyList();
            return TownCommand.filterByStartOrGetTownyStartingWith(townConsoleTabCompletes, args[0], "t");
        }
        Player player = (Player)sender;
        Town town = TownyAPI.getInstance().getTown(player);
        switch (args[0].toLowerCase(Locale.ROOT)) {
            case "online": 
            case "reslist": 
            case "outlawlist": 
            case "plots": 
            case "delete": 
            case "join": 
            case "merge": 
            case "plotgrouplist": 
            case "allylist": 
            case "enemylist": 
            case "baltop": 
            case "ranklist": {
                if (args.length != 2) return Collections.emptyList();
                return TownCommand.getTownyStartingWith(args[1], "t");
            }
            case "deposit": {
                if (args.length != 3) return Collections.emptyList();
                return TownCommand.getTownyStartingWith(args[2], "t");
            }
            case "spawn": {
                if (args.length == 2) {
                    List<String> townOrIgnore = TownCommand.getTownyStartingWith(args[1], "t");
                    townOrIgnore.add("-ignore");
                    return NameUtil.filterByStart(townOrIgnore, args[1]);
                }
                if (args.length != 3) return Collections.emptyList();
                return Collections.singletonList("-ignore");
            }
            case "leave": {
                if (args.length != 2) return Collections.emptyList();
                return Collections.singletonList("-ignore");
            }
            case "rank": {
                switch (args.length) {
                    case 2: {
                        return NameUtil.filterByStart(townAddRemoveTabCompletes, args[1]);
                    }
                    case 3: {
                        return TownCommand.getTownResidentNamesOfPlayerStartingWith(player, args[2]);
                    }
                    case 4: {
                        switch (args[1].toLowerCase(Locale.ROOT)) {
                            case "add": {
                                if (town != null) return NameUtil.filterByStart(TownyPerms.getTownRanks(town), args[3]);
                                return Collections.emptyList();
                            }
                            case "remove": {
                                Resident res = TownyUniverse.getInstance().getResident(args[2]);
                                if (res == null) return Collections.emptyList();
                                return res.getTownRanks().isEmpty() ? Collections.emptyList() : NameUtil.filterByStart(res.getTownRanks(), args[3]);
                            }
                        }
                        return Collections.emptyList();
                    }
                }
                return Collections.emptyList();
            }
            case "jail": {
                if (args.length != 2) return Collections.emptyList();
                List<String> residentOrList = TownCommand.getTownResidentNamesOfPlayerStartingWith(player, args[1]);
                residentOrList.add("list");
                return NameUtil.filterByStart(residentOrList, args[1]);
            }
            case "unjail": {
                if (args.length != 2 || town == null) return Collections.emptyList();
                List<String> jailedResidents = TownyUniverse.getInstance().getJailedResidentMap().stream().filter(jailee -> jailee.hasJailTown(town.getName())).map(jailee -> jailee.getName()).collect(Collectors.toList());
                return NameUtil.filterByStart(jailedResidents, args[1]);
            }
            case "outpost": {
                if (args.length != 2) return Collections.emptyList();
                List<Object> outpostNames = town == null ? new ArrayList() : town.getOutpostNames();
                outpostNames.add("list");
                return NameUtil.filterByStart(outpostNames, args[1]);
            }
            case "outlaw": 
            case "ban": {
                switch (args.length) {
                    case 2: {
                        return NameUtil.filterByStart(townAddRemoveTabCompletes, args[1]);
                    }
                    case 3: {
                        switch (args[1].toLowerCase(Locale.ROOT)) {
                            case "add": {
                                return TownCommand.getTownyStartingWith(args[2], "r");
                            }
                            case "remove": {
                                if (town == null) return Collections.emptyList();
                                return NameUtil.filterByStart(NameUtil.getNames(town.getOutlaws()), args[2]);
                            }
                        }
                    }
                }
                return Collections.emptyList();
            }
            case "cede": {
                if (args.length == 2) {
                    return Arrays.asList("plot");
                }
                if (args.length != 3) return Collections.emptyList();
                return TownCommand.getTownyStartingWith(args[2], "t");
            }
            case "claim": {
                switch (args.length) {
                    case 2: {
                        return NameUtil.filterByStart(townClaimTabCompletes, args[1]);
                    }
                    case 3: {
                        if (args[1].equalsIgnoreCase("outpost")) return Collections.emptyList();
                        return NameUtil.filterByStart(Collections.singletonList("auto"), args[2]);
                    }
                }
                return Collections.emptyList();
            }
            case "unclaim": {
                if (args.length != 2) return Collections.emptyList();
                return NameUtil.filterByStart(townUnclaimTabCompletes, args[1]);
            }
            case "add": {
                if (args.length != 2) return Collections.emptyList();
                return this.getVisibleResidentsForPlayerWithoutTownsStartingWith(args[1], sender);
            }
            case "kick": {
                if (args.length != 2) return Collections.emptyList();
                return TownCommand.getTownResidentNamesOfPlayerStartingWith(player, args[1]);
            }
            case "set": {
                return TownCommand.townSetTabComplete(sender, town, args);
            }
            case "invite": {
                return this.townInviteTabComplete(sender, args, player, town);
            }
            case "buy": {
                if (args.length != 2) return Collections.emptyList();
                return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.TOWN_BUY, Collections.singletonList("bonus")), args[1]);
            }
            case "toggle": {
                List<String> list;
                switch (args.length) {
                    case 2: {
                        list = NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.TOWN_TOGGLE, townToggleTabCompletes), args[1]);
                        return list;
                    }
                    case 3: {
                        list = NameUtil.filterByStart(BaseCommand.setOnOffCompletes, args[2]);
                        return list;
                    }
                    case 4: {
                        list = TownCommand.getTownResidentNamesOfPlayerStartingWith(player, args[3]);
                        return list;
                    }
                    default: {
                        list = Collections.emptyList();
                    }
                }
                return list;
            }
            case "list": {
                List<String> list;
                switch (args.length) {
                    case 2: {
                        list = Collections.singletonList("by");
                        return list;
                    }
                    case 3: {
                        list = NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.TOWN_LIST_BY, townListTabCompletes), args[2]);
                        return list;
                    }
                    default: {
                        list = Collections.emptyList();
                    }
                }
                return list;
            }
            case "trust": {
                switch (args.length) {
                    case 2: {
                        return NameUtil.filterByStart(Arrays.asList("add", "remove", "list"), args[1]);
                    }
                    case 3: {
                        if (args[1].equalsIgnoreCase("add")) {
                            List<String> resList = TownCommand.getTownyStartingWith(args[2], "r");
                            resList.removeAll(TownCommand.getTrustedResidentsFromResident(player));
                            return resList;
                        }
                        if (!args[1].equalsIgnoreCase("remove")) return Collections.emptyList();
                        return NameUtil.filterByStart(TownCommand.getTrustedResidentsFromResident(player), args[2]);
                    }
                }
                return Collections.emptyList();
            }
            case "trusttown": {
                switch (args.length) {
                    case 2: {
                        return NameUtil.filterByStart(Arrays.asList("add", "remove", "list"), args[1]);
                    }
                    case 3: {
                        if (args[1].equalsIgnoreCase("add")) {
                            List<String> townsList = TownCommand.getTownyStartingWith(args[2], "t");
                            townsList.removeAll(TownCommand.getTrustedTownsFromResident(player));
                            return townsList;
                        }
                        if (!args[1].equalsIgnoreCase("remove")) return Collections.emptyList();
                        return NameUtil.filterByStart(TownCommand.getTrustedTownsFromResident(player), args[2]);
                    }
                }
                return Collections.emptyList();
            }
            case "buytown": {
                if (args.length != 2) return Collections.emptyList();
                List<String> townsList = TownCommand.getTownyStartingWith(args[1], "t");
                townsList.removeIf(n -> !TownyAPI.getInstance().getTown((String)n).isForSale());
                return townsList;
            }
            default: {
                if (args.length == 1) {
                    return TownCommand.filterByStartOrGetTownyStartingWith(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.TOWN, townTabCompletes), args[0], "t");
                }
                if (!TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWN, args[0])) return Collections.emptyList();
                return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWN, args[0]).getTabCompletion(sender, args), args[args.length - 1]);
            }
        }
    }

    private List<String> townInviteTabComplete(CommandSender sender, String[] args, Player player, Town town) {
        if (town == null) {
            return Collections.emptyList();
        }
        switch (args.length) {
            case 2: {
                List<String> returnValue = NameUtil.filterByStart(townInviteTabCompletes, args[1]);
                if (returnValue.size() > 0) {
                    return returnValue;
                }
                if (args[1].startsWith("-")) {
                    return NameUtil.filterByStart(town.getSentInvites().stream().map(Invite::getReceiver).map(Nameable::getName).collect(Collectors.toList()), args[1].substring(1)).stream().map(e -> "-" + e).collect(Collectors.toList());
                }
                return this.getVisibleResidentsForPlayerWithoutTownsStartingWith(args[1], sender);
            }
            case 3: {
                switch (args[1].toLowerCase(Locale.ROOT)) {
                    case "accept": 
                    case "deny": {
                        return NameUtil.filterByStart(town.getReceivedInvites().stream().map(Invite::getSender).map(Nameable::getName).collect(Collectors.toList()), args[2]);
                    }
                }
                Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    static List<String> townSetTabComplete(CommandSender sender, Town town, String[] args) {
        if (town == null) {
            return Collections.emptyList();
        }
        if (args.length == 2) {
            return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.TOWN_SET, townSetTabCompletes), args[1]);
        }
        if (args.length > 2) {
            if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWN_SET, args[1])) {
                return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWN_SET, args[1]).getTabCompletion(sender, StringMgmt.remFirstArg(args)), args[args.length - 1]);
            }
            switch (args[1].toLowerCase(Locale.ROOT)) {
                case "mayor": {
                    return NameUtil.filterByStart(NameUtil.getNames(town.getResidents()), args[2]);
                }
                case "perm": {
                    return TownCommand.permTabComplete(StringMgmt.remArgs(args, 2));
                }
                case "tag": {
                    if (args.length != 3) break;
                    return NameUtil.filterByStart(Collections.singletonList("clear"), args[2]);
                }
                case "title": 
                case "surname": {
                    if (args.length != 3) break;
                    return NameUtil.filterByStart(NameUtil.getNames(town.getResidents()), args[2]);
                }
                case "board": {
                    if (args.length != 3) break;
                    return NameUtil.filterByStart(townSetBoardTabCompletes, args[2]);
                }
                case "mapcolor": {
                    if (args.length != 3) break;
                    return NameUtil.filterByStart(new ArrayList<String>(TownySettings.getTownColorsMap().keySet()), args[2]);
                }
                default: {
                    return Collections.emptyList();
                }
            }
        }
        return Collections.emptyList();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (plugin.isError()) {
                TownyMessaging.sendErrorMsg((Object)sender, "Locked in Safe mode!");
                return false;
            }
            try {
                this.parseTownCommand(player, args);
            }
            catch (TownyException te) {
                TownyMessaging.sendErrorMsg(player, te.getMessage((CommandSender)player));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(player, e.getMessage());
            }
        } else {
            try {
                this.parseTownCommandForConsole(sender, args);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
            }
        }
        return true;
    }

    private void parseTownCommandForConsole(CommandSender sender, String[] split) throws TownyException {
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.TOWN_HELP_CONSOLE.send(sender);
            return;
        }
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "list": {
                this.listTowns(sender, split);
                break;
            }
            case "reslist": {
                this.townResList(sender, split);
                break;
            }
            default: {
                if (this.tryTownAddonCommand(sender, split)) {
                    return;
                }
                if (this.tryTownStatusScreen(sender, split)) {
                    return;
                }
                throw new TownyException(Translatable.of("msg_err_invalid_sub"));
            }
        }
    }

    private void parseTownCommand(Player player, String[] split) throws TownyException {
        if (split.length == 0) {
            this.townStatusScreen((CommandSender)player, TownCommand.getTownFromPlayerOrThrow(player));
            return;
        }
        if (split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.TOWN_HELP.send((CommandSender)player);
            return;
        }
        String[] subArg = StringMgmt.remFirstArg(split);
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "add": {
                TownCommand.townAdd((CommandSender)player, null, subArg);
                break;
            }
            case "allylist": {
                this.townAllyList(player, split);
                break;
            }
            case "baltop": {
                TownCommand.parseTownBaltop(player, split.length > 1 ? TownCommand.getTownOrThrow(split[1]) : TownCommand.getTownFromPlayerOrThrow(player));
                break;
            }
            case "bankhistory": {
                this.parseTownBankHistoryCommand(player, split);
                break;
            }
            case "buy": {
                TownCommand.townBuy((CommandSender)player, subArg, null, false);
                break;
            }
            case "buytown": {
                this.parseTownBuyTownCommand((CommandSender)player, subArg);
                break;
            }
            case "cede": {
                this.parseTownCedeCommand(player, subArg);
                break;
            }
            case "claim": {
                TownCommand.parseTownClaimCommand(player, subArg);
                break;
            }
            case "delete": {
                this.townDelete(player, subArg);
                break;
            }
            case "deposit": {
                this.parseTownDepositCommand(player, split);
                break;
            }
            case "enemylist": {
                this.townEnemyList(player, split);
                break;
            }
            case "forsale": 
            case "fs": {
                this.parseTownForSaleCommand(player, subArg);
                break;
            }
            case "here": {
                this.parseTownHereCommand(player);
                break;
            }
            case "invite": 
            case "invites": {
                this.parseInviteCommand(player, subArg);
                break;
            }
            case "jail": {
                TownCommand.parseJailCommand((CommandSender)player, null, subArg, false);
                break;
            }
            case "join": {
                TownCommand.parseTownJoin(player, subArg);
                break;
            }
            case "kick": {
                TownCommand.townKick(player, subArg);
                break;
            }
            case "leave": {
                this.townLeave(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "list": {
                this.listTowns((CommandSender)player, split);
                break;
            }
            case "mayor": {
                this.parseTownyMayorCommand(player);
                break;
            }
            case "merge": {
                TownCommand.parseTownMergeCommand(player, subArg);
                break;
            }
            case "new": 
            case "create": {
                this.parseTownNewCommand(player, split);
                break;
            }
            case "notforsale": 
            case "nfs": {
                this.parseTownNotForSaleCommand(player);
                break;
            }
            case "online": {
                this.parseTownOnlineCommand(player, subArg);
                break;
            }
            case "outlaw": 
            case "ban": {
                TownCommand.parseTownOutlawCommand((CommandSender)player, subArg, false, TownCommand.getResidentOrThrow(player).getTown());
                break;
            }
            case "outlawlist": {
                this.townOutlawList((CommandSender)player, split);
                break;
            }
            case "outpost": {
                TownCommand.townOutpost(player, subArg);
                break;
            }
            case "plotgrouplist": {
                this.townPlotGroupList((CommandSender)player, split);
                break;
            }
            case "plots": {
                this.townPlots((CommandSender)player, split);
                break;
            }
            case "purge": {
                this.parseTownPurgeCommand(player, subArg);
                break;
            }
            case "rank": {
                this.townRank(player, subArg);
                break;
            }
            case "ranklist": {
                this.parseTownRanklistCommand(player, split);
                break;
            }
            case "reclaim": {
                this.parseTownReclaimCommand(player);
                break;
            }
            case "reslist": {
                this.townResList((CommandSender)player, split);
                break;
            }
            case "say": {
                this.parseTownSayCommand(player, split);
                break;
            }
            case "set": {
                TownCommand.townSet((CommandSender)player, subArg, false, null);
                break;
            }
            case "spawn": {
                TownCommand.townSpawn(player, subArg, false, split.length > 2 && split[2].equals("-ignore"));
                break;
            }
            case "takeoverclaim": {
                this.parseTownTakeoverClaimCommand(player);
                break;
            }
            case "toggle": {
                TownCommand.townToggle((CommandSender)player, subArg, false, null);
                break;
            }
            case "trust": {
                TownCommand.parseTownTrustCommand((CommandSender)player, subArg, null);
                break;
            }
            case "trusttown": {
                TownCommand.parseTownTrustTownCommand((CommandSender)player, subArg, null);
                break;
            }
            case "unclaim": {
                TownCommand.parseTownUnclaimCommand(player, subArg);
                break;
            }
            case "unjail": {
                TownCommand.parseUnJailCommand((CommandSender)player, null, subArg, false);
                break;
            }
            case "withdraw": {
                this.parseTownWithdrawCommand(player, split);
                break;
            }
            default: {
                if (this.tryTownAddonCommand((CommandSender)player, split)) {
                    return;
                }
                if (this.tryTownStatusScreen((CommandSender)player, split)) {
                    return;
                }
                throw new TownyException(Translatable.of("msg_err_invalid_sub"));
            }
        }
    }

    private boolean tryTownStatusScreen(CommandSender sender, String[] split) throws NoPermissionException {
        Town town = TownyUniverse.getInstance().getTown(split[0]);
        if (town != null) {
            Player player;
            if (sender instanceof Player && !town.hasResident((player = (Player)sender).getName())) {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_OTHERTOWN.getNode());
            }
            this.townStatusScreen(sender, town);
            return true;
        }
        return false;
    }

    private boolean tryTownAddonCommand(CommandSender sender, String[] split) {
        if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWN, split[0])) {
            TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWN, split[0]).execute(sender, "town", split);
            return true;
        }
        return false;
    }

    private static void catchRuinedTown(Player player) throws TownyException {
        if (TownRuinUtil.isPlayersTownRuined(player)) {
            throw new TownyException(Translatable.of("msg_err_cannot_use_command_because_town_ruined"));
        }
    }

    private void parseTownyMayorCommand(Player player) throws NoPermissionException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_MAYOR.getNode());
        HelpMenu.TOWN_MAYOR_HELP.send((CommandSender)player);
    }

    private void townEnemyList(Player player, String[] split) throws TownyException {
        Town town;
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_ENEMYLIST.getNode());
        Town town2 = town = split.length == 1 ? TownCommand.getTownFromPlayerOrThrow(player) : TownCommand.getTownOrThrow(split[1]);
        if (town.getEnemies().isEmpty()) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_error_town_has_no_enemies"));
        } else {
            TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(town.getName() + " " + Translatable.of("status_nation_enemies").forLocale((CommandSender)player)));
            TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedTownyObjects(Translatable.of("status_nation_enemies").forLocale((CommandSender)player), new ArrayList<TownyObject>(town.getEnemies())));
        }
    }

    private void townAllyList(Player player, String[] split) throws TownyException {
        Town town;
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_ALLYLIST.getNode());
        Town town2 = town = split.length == 1 ? TownCommand.getTownFromPlayerOrThrow(player) : TownCommand.getTownOrThrow(split[1]);
        if (town.getAllies().isEmpty()) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_error_town_has_no_allies"));
        } else {
            TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(town.getName() + " " + Translatable.of("status_nation_allies").forLocale((CommandSender)player)));
            TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedTownyObjects(Translatable.of("status_nation_allies").forLocale((CommandSender)player), new ArrayList<TownyObject>(town.getAllies())));
        }
    }

    private void parseTownPurgeCommand(Player player, String[] arg) throws TownyException {
        if (arg.length == 0) {
            HelpMenu.TOWN_PURGE.send((CommandSender)player);
            return;
        }
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_PURGE.getNode());
        TownCommand.catchRuinedTown(player);
        Town town = TownCommand.getTownFromPlayerOrThrow(player);
        int days = MathUtil.getIntOrThrow(arg[0]);
        if (days < 1) {
            throw new TownyException(Translatable.of("msg_err_days_must_be_greater_than_0"));
        }
        List<Resident> kickList = TownUtil.gatherInactiveResidents((List<Resident>)town.getResidents(), days);
        if (kickList.isEmpty()) {
            throw new TownyException(Translatable.of("msg_err_no_one_to_purge"));
        }
        Confirmation.runOnAccept(() -> {
            kickList.forEach(Resident::removeTown);
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_purge_complete_x_removed", kickList.size()));
        }).setTitle(Translatable.of("msg_purging_will_remove_the_following_residents", StringMgmt.join(kickList, ", "))).sendTo((CommandSender)player);
    }

    private void parseInviteCommand(Player player, String[] args) throws TownyException {
        TownCommand.catchRuinedTown(player);
        Resident resident = TownCommand.getResidentOrThrow(player);
        String received = Translatable.of("town_received_invites").forLocale((CommandSender)player).replace("%a", Integer.toString(resident.getTown().getReceivedInvites().size())).replace("%m", Integer.toString(InviteHandler.getReceivedInvitesMaxAmount(resident.getTown())));
        String sent = Translatable.of("town_sent_invites").forLocale((CommandSender)player).replace("%a", Integer.toString(resident.getTown().getSentInvites().size())).replace("%m", Integer.toString(InviteHandler.getSentInvitesMaxAmount(resident.getTown())));
        if (args.length == 0 || args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("?")) {
            TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_SEE_HOME.getNode());
            HelpMenu.TOWN_INVITE.send((CommandSender)player);
            TownyMessaging.sendMessage((Object)player, sent);
            TownyMessaging.sendMessage((Object)player, received);
            return;
        }
        switch (args[0].toLowerCase(Locale.ROOT)) {
            case "sent": {
                this.parseTownInviteSentCommand(player, StringMgmt.remFirstArg(args), resident, sent);
                break;
            }
            case "received": {
                this.parseTownInviteReceivedCommand(player, StringMgmt.remFirstArg(args), resident, received);
                break;
            }
            case "accept": {
                this.parseTownInviteAcceptCommand(player, StringMgmt.remFirstArg(args), resident);
                break;
            }
            case "deny": {
                this.parseTownInviteDenyCommand(player, StringMgmt.remFirstArg(args), resident);
                break;
            }
            case "add": {
                this.parseTownInviteAddCommand(player, StringMgmt.remFirstArg(args));
                break;
            }
            default: {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_ADD.getNode());
                TownCommand.townAdd((CommandSender)player, null, args);
            }
        }
    }

    private void parseTownInviteSentCommand(Player player, String[] args, Resident resident, String sent) throws TownyException {
        if (args.length == 0) {
            this.listTownSentInvites(player, args, resident, sent);
            return;
        }
        switch (args[0].toLowerCase(Locale.ROOT)) {
            case "removeall": {
                this.removeAllTownSentInvites(resident, player);
                break;
            }
            default: {
                HelpMenu.TOWN_INVITE.send((CommandSender)player);
            }
        }
    }

    private void listTownSentInvites(Player player, String[] args, Resident resident, String sent) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_LIST_SENT.getNode());
        Collection sentinvites = resident.getTown().getSentInvites();
        int page = args.length > 0 ? MathUtil.getPositiveIntOrThrow(args[0]) : 1;
        InviteCommand.sendInviteList(player, (List<Invite>)sentinvites, page, true);
        TownyMessaging.sendMessage((Object)player, sent);
    }

    private void removeAllTownSentInvites(Resident resident, Player player) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_ADD.getNode());
        for (Invite invite : new ArrayList(resident.getTown().getSentInvites())) {
            invite.decline(true);
        }
        TownyMessaging.sendMessage((CommandSender)player, Translatable.of("msg_all_of_your_towns_sent_invites_have_been_cancelled"));
    }

    private void parseTownInviteReceivedCommand(Player player, String[] args, Resident resident, String received) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_LIST_RECEIVED.getNode());
        Collection receivedinvites = resident.getTown().getReceivedInvites();
        int page = args.length > 0 ? MathUtil.getPositiveIntOrThrow(args[0]) : 1;
        InviteCommand.sendInviteList(player, (List<Invite>)receivedinvites, page, false);
        TownyMessaging.sendMessage((Object)player, received);
    }

    private void parseTownInviteAcceptCommand(Player player, String[] args, Resident resident) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_ACCEPT.getNode());
        Town town = resident.getTown();
        Collection invites = town.getReceivedInvites();
        if (invites.size() == 0) {
            throw new TownyException(Translatable.of("msg_err_town_no_invites"));
        }
        if (args.length == 0) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_town_specify_invite"));
            InviteCommand.sendInviteList(player, (List<Invite>)invites, 1, false);
            return;
        }
        Nation nation = TownCommand.getNationOrThrow(args[0]);
        Invite toAccept = null;
        for (Invite invite : InviteHandler.getActiveInvites()) {
            if (!invite.getSender().equals(nation) || !invite.getReceiver().equals(town)) continue;
            toAccept = invite;
            break;
        }
        if (toAccept != null) {
            try {
                InviteHandler.acceptInvite(toAccept);
                return;
            }
            catch (TownyException | InvalidObjectException e) {
                plugin.getLogger().log(Level.WARNING, "unknown exception occurred while accepting invite", e);
            }
        }
    }

    private void parseTownInviteDenyCommand(Player player, String[] args, Resident resident) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_DENY.getNode());
        Town town = resident.getTown();
        Collection invites = town.getReceivedInvites();
        if (invites.size() == 0) {
            throw new TownyException(Translatable.of("msg_err_town_no_invites"));
        }
        if (args.length == 0) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_town_specify_invite"));
            InviteCommand.sendInviteList(player, (List<Invite>)invites, 1, false);
            return;
        }
        Nation nation = TownCommand.getNationOrThrow(args[0]);
        Invite toDecline = null;
        for (Invite invite : InviteHandler.getActiveInvites()) {
            if (!invite.getSender().equals(nation) || !invite.getReceiver().equals(town)) continue;
            toDecline = invite;
            break;
        }
        if (toDecline != null) {
            try {
                InviteHandler.declineInvite(toDecline, false);
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("successful_deny"));
            }
            catch (InvalidObjectException e) {
                plugin.getLogger().log(Level.WARNING, "unknown exception occurred while declining invite", e);
            }
        }
    }

    private void parseTownInviteAddCommand(Player player, String[] newSplit) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_ADD.getNode());
        TownCommand.townAdd((CommandSender)player, null, newSplit);
    }

    public static void parseTownOutlawCommand(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        Resident resident;
        if (split.length == 0) {
            if (!admin) {
                HelpMenu.TOWN_OUTLAW_HELP.send(sender);
            } else {
                HelpMenu.TA_TOWN_OUTLAW.send(sender);
            }
            return;
        }
        if (split.length < 2) {
            throw new TownyException(Translatable.of("msg_usage", "/town outlaw add/remove [name]"));
        }
        if (!admin) {
            resident = TownCommand.getResidentOrThrow(sender.getName());
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_OUTLAW.getNode());
            TownCommand.catchRuinedTown((Player)sender);
        } else {
            resident = town.getMayor();
        }
        Resident target = TownCommand.getResidentOrThrow(split[1]);
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "add": {
                TownCommand.parseTownOutlawAddCommand(sender, admin, town, resident, target);
                break;
            }
            case "remove": {
                TownCommand.parseTownOutlawRemoveCommand(sender, admin, town, target);
                break;
            }
            default: {
                throw new TownyException(Translatable.of("msg_err_invalid_property", split[0]));
            }
        }
    }

    private static void parseTownOutlawAddCommand(CommandSender sender, boolean admin, Town town, Resident resident, Resident target) throws TownyException {
        if (town.getMayor().equals(target)) {
            throw new TownyException(Translatable.of("msg_err_you_cannot_outlaw_your_mayor"));
        }
        if (!resident.isMayor() && town.hasResident(target)) {
            if (TownySettings.getTownUnkickableRanks().stream().anyMatch(target::hasTownRank)) {
                throw new TownyException(Translatable.of("msg_err_you_cannot_outlaw_because_of_rank", target.getName()));
            }
        }
        if (town.hasOutlaw(target)) {
            throw new TownyException(Translatable.of("msg_err_resident_already_an_outlaw"));
        }
        BukkitTools.ifCancelledThenThrow(new TownOutlawAddEvent(sender, target, town));
        target.removeTrustInTown(town);
        if (town.hasResident(target)) {
            target.removeTown();
            Object outlawer = admin ? Translatable.of("admin_sing") : sender.getName();
            TownyMessaging.sendMsg(target, Translatable.of("msg_kicked_by", outlawer));
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_kicked", outlawer, target.getName()));
        }
        try {
            town.addOutlaw(target);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        town.save();
        if (target.isOnline()) {
            TownCommand.handleOnlineNewlyMintedOutlaw(town, target);
        }
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_you_have_declared_an_outlaw", target.getName(), town.getName()));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_you_have_declared_an_outlaw", target.getName(), town.getName()));
        }
    }

    private static void handleOnlineNewlyMintedOutlaw(Town town, Resident target) {
        TownyMessaging.sendMsg(target, Translatable.of("msg_you_have_been_declared_outlaw", town.getName()));
        Player player = target.getPlayer();
        Location loc = player.getLocation();
        if (!TownySettings.areNewOutlawsTeleportedAway() || TownyAPI.getInstance().isWilderness(loc) || !TownyAPI.getInstance().getTown(loc).equals(town) || BukkitTools.isEventCancelled(new OutlawTeleportEvent(target, town, loc))) {
            return;
        }
        int warmupTime = TownySettings.getOutlawTeleportWarmup();
        if (warmupTime > 0) {
            TownyMessaging.sendMsg(target, Translatable.of("msg_outlaw_kick_cooldown", town, TimeMgmt.formatCountdownTime(warmupTime)));
        }
        plugin.getScheduler().runLater(() -> {
            if (player.isOnline() && TownyAPI.getInstance().getTown(player.getLocation()).equals(town)) {
                SpawnUtil.outlawTeleport(town, target);
            }
        }, (long)warmupTime * 20L);
    }

    private static void parseTownOutlawRemoveCommand(CommandSender sender, boolean admin, Town town, Resident target) throws TownyException {
        if (!town.hasOutlaw(target)) {
            throw new TownyException(Translatable.of("msg_err_player_not_an_outlaw"));
        }
        BukkitTools.ifCancelledThenThrow(new TownOutlawRemoveEvent(sender, target, town));
        town.removeOutlaw(target);
        town.save();
        if (target.isOnline()) {
            TownyMessaging.sendMsg(target, Translatable.of("msg_you_have_been_undeclared_outlaw", town.getName()));
        }
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_you_have_undeclared_an_outlaw", target.getName(), town.getName()));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_you_have_undeclared_an_outlaw", target.getName(), town.getName()));
        }
    }

    private void parseTownWithdrawCommand(Player player, String[] split) throws NoPermissionException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_WITHDRAW.getNode());
        TownyEconomyHandler.economyExecutor().execute(() -> TownCommand.townTransaction(player, StringMgmt.remFirstArg(split), true));
    }

    private void parseTownDepositCommand(Player player, String[] split) throws NoPermissionException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_DEPOSIT.getNode());
        TownyEconomyHandler.economyExecutor().execute(() -> TownCommand.townTransaction(player, StringMgmt.remFirstArg(split), false));
    }

    private void townPlots(CommandSender sender, String[] args) throws TownyException {
        Town town;
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (player != null) {
            TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_PLOTS.getNode());
        }
        if (args.length == 1 && player != null) {
            TownCommand.catchRuinedTown(player);
            town = TownCommand.getTownFromPlayerOrThrow(player);
        } else {
            town = TownCommand.getTownOrThrow(args[1]);
        }
        Translator translator = Translator.locale(sender);
        ArrayList<String> out = new ArrayList<String>();
        out.add(ChatTools.formatTitle(String.valueOf(town) + translator.of("msg_town_plots_title")));
        Object townSize = translator.of("msg_town_plots_town_size", town.getTownBlocks().size(), town.getMaxTownBlocksAsAString());
        if (!town.hasUnlimitedClaims()) {
            if (TownySettings.isSellingBonusBlocks(town)) {
                townSize = (String)townSize + translator.of("msg_town_plots_town_bought", town.getPurchasedBlocks(), TownySettings.getMaxPurchasedBlocks(town));
            }
            if (town.getBonusBlocks() > 0) {
                townSize = (String)townSize + translator.of("msg_town_plots_town_bonus", town.getBonusBlocks());
            }
            if (TownySettings.getNationBonusBlocks(town) > 0) {
                townSize = (String)townSize + translator.of("msg_town_plots_town_nationbonus", TownySettings.getNationBonusBlocks(town));
            }
        }
        out.add((String)townSize);
        TownBlockTypeCache typeCache = town.getTownBlockTypeCache();
        out.add(translator.of("msg_town_plots_town_owned_land", town.getTownBlocks().size() - typeCache.getNumberOfResidentOwnedTownBlocks()));
        Object typeHeader = translator.of("msg_town_plots_type_header");
        if (TownyEconomyHandler.isActive()) {
            typeHeader = (String)typeHeader + translator.of("msg_town_plots_type_header_revenue");
        }
        out.add((String)typeHeader);
        for (TownBlockType type : TownBlockTypeHandler.getTypes().values()) {
            int residentOwned = typeCache.getNumTownBlocks(type, TownBlockTypeCache.CacheType.RESIDENTOWNED);
            Object plotTypeLine = translator.of("msg_town_plots_type_line", type.getFormattedName(), residentOwned, typeCache.getNumTownBlocks(type, TownBlockTypeCache.CacheType.FORSALE), typeCache.getNumTownBlocks(type, TownBlockTypeCache.CacheType.ALL));
            if (TownyEconomyHandler.isActive()) {
                plotTypeLine = (String)plotTypeLine + translator.of("msg_town_plots_type_line_revenue", TownCommand.prettyMoney((double)residentOwned * type.getTax(town)));
            }
            out.add((String)plotTypeLine);
        }
        out.add(Translatable.of("msg_town_plots_revenue_disclaimer").forLocale((CommandSender)player));
        TownyMessaging.sendMessage((Object)sender, out);
    }

    private void parseTownOnlineCommand(Player player, String[] split) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_ONLINE.getNode());
        TownCommand.catchRuinedTown(player);
        Translator translator = Translator.locale((CommandSender)player);
        Town town = split.length > 0 ? TownCommand.getTownOrThrow(split[0]) : TownCommand.getTownFromPlayerOrThrow(player);
        List<Resident> onlineResidents = ResidentUtil.getOnlineResidentsViewable(player, town);
        String output = onlineResidents.size() > 0 ? TownyFormatter.getFormattedOnlineResidents(translator.of("msg_town_online"), town, player) : "\u00a7f0 " + translator.of("res_list") + " " + translator.of("msg_town_online") + ": " + String.valueOf(town);
        TownyMessaging.sendMessage((Object)player, output);
    }

    private void parseTownHereCommand(Player player) throws NoPermissionException, TownyException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_HERE.getNode());
        Town town = TownyAPI.getInstance().getTown(player.getLocation());
        if (town == null) {
            throw new TownyException(Translatable.of("msg_not_claimed", Coord.parseCoord(player.getLocation())));
        }
        this.townStatusScreen((CommandSender)player, town);
    }

    public void listTowns(CommandSender sender, String[] split) throws TownyException {
        boolean console = true;
        Player player = null;
        if (split.length == 2 && split[1].equals("?")) {
            HelpMenu.TOWN_LIST.send(sender);
            return;
        }
        if (sender instanceof Player) {
            console = false;
            player = (Player)sender;
        }
        if (split.length < 2 && !console) {
            TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_LIST_RESIDENTS.getNode());
        }
        int page = 1;
        boolean pageSet = false;
        boolean comparatorSet = false;
        ComparatorType type = ComparatorType.RESIDENTS;
        for (int i = 1; i < split.length; ++i) {
            if (split[i].equalsIgnoreCase("by")) {
                if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWN_LIST_BY, split[i + 1])) {
                    TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWN_LIST_BY, split[i + 1]).execute(sender, "town", split);
                    return;
                }
                if (comparatorSet) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_error_multiple_comparators"));
                    return;
                }
                if (++i < split.length) {
                    comparatorSet = true;
                    if (split[i].equalsIgnoreCase("resident")) {
                        split[i] = "residents";
                    }
                    if (!console) {
                        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_LIST.getNode(split[i]));
                    }
                    if (!townListTabCompletes.contains(split[i].toLowerCase(Locale.ROOT))) {
                        throw new TownyException(Translatable.of("msg_error_invalid_comparator_town", townListTabCompletes.stream().filter(comp -> sender.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_LIST.getNode((String)comp))).collect(Collectors.joining(", "))));
                    }
                } else {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_error_missing_comparator"));
                    return;
                }
                type = ComparatorType.valueOf(split[i].toUpperCase(Locale.ROOT));
                comparatorSet = true;
                continue;
            }
            if (pageSet) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_error_too_many_pages"));
                return;
            }
            page = MathUtil.getPositiveIntOrThrow(split[i]);
            if (page == 0) {
                throw new TownyException(Translatable.of("msg_error_must_be_int"));
            }
            pageSet = true;
        }
        int pageNumber = page;
        ComparatorType finalType = type;
        try {
            if (!TownySettings.isTownListRandom()) {
                plugin.getScheduler().runAsync(() -> {
                    List<Pair<UUID, Component>> list = ComparatorCaches.getTownListCache(finalType);
                    int totalPages = (int)Math.ceil((double)list.size() / 10.0);
                    if (pageNumber > totalPages) {
                        TownyMessaging.sendErrorMsg(sender, Translatable.of("list_err_not_enough_pages", totalPages));
                        return;
                    }
                    TownyMessaging.sendTownList(sender, list, finalType, pageNumber, totalPages);
                });
            } else {
                ArrayList<Pair<UUID, Component>> output = new ArrayList<Pair<UUID, Component>>();
                ArrayList<Town> towns = new ArrayList<Town>(TownyUniverse.getInstance().getTowns());
                int totalPages = (int)Math.ceil((double)towns.size() / 10.0);
                if (page > totalPages) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("list_err_not_enough_pages", totalPages));
                    return;
                }
                Collections.shuffle(towns);
                boolean spawningFullyDisabled = !TownySettings.isConfigAllowingTownSpawn() && !TownySettings.isConfigAllowingPublicTownSpawnTravel() && !TownySettings.isConfigAllowingTownSpawnNationTravel() && !TownySettings.isConfigAllowingTownSpawnNationAllyTravel();
                for (Town town : towns) {
                    TextComponent townName = Component.text((String)StringMgmt.remUnderscore(town.getName()), (TextColor)NamedTextColor.AQUA);
                    townName = (TextComponent)townName.append(Component.text((String)" - ", (TextColor)NamedTextColor.DARK_GRAY).append((Component)Component.text((String)("(" + town.getResidents().size() + ")"), (TextColor)NamedTextColor.AQUA)));
                    if (town.isOpen()) {
                        townName = (TextComponent)((TextComponent)townName.append((Component)Component.space())).append(Translatable.of("status_title_open").locale(sender).component());
                    }
                    if (!spawningFullyDisabled) {
                        Translatable spawnCost = Translatable.of("msg_spawn_cost_free");
                        if (TownyEconomyHandler.isActive()) {
                            spawnCost = Translatable.of("msg_spawn_cost", TownCommand.prettyMoney(town.getSpawnCost()));
                        }
                        townName = (TextComponent)townName.clickEvent(ClickEvent.runCommand((String)("/towny:town spawn " + String.valueOf(town) + " -ignore")));
                        townName = (TextComponent)townName.hoverEvent((HoverEventSource)HoverEvent.showText((Component)Translatable.of("msg_click_spawn", town).append("\n").append(spawnCost).locale(sender).component()));
                    }
                    output.add(Pair.pair(town.getUUID(), townName));
                }
                TownyMessaging.sendTownList(sender, output, finalType, pageNumber, totalPages);
            }
        }
        catch (RuntimeException e) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_error_comparator_failed"));
        }
    }

    public static void townToggle(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        TownyPermissionSource permSource = TownyUniverse.getInstance().getPermissionSource();
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.TOWN_TOGGLE_HELP.send(sender);
            return;
        }
        if (!admin) {
            TownCommand.catchRuinedTown((Player)sender);
            Resident resident = TownCommand.getResidentOrThrow(sender.getName());
            town = resident.getTown();
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_TOGGLE.getNode(split[0].toLowerCase(Locale.ROOT)));
        }
        Optional<Boolean> choice = Optional.empty();
        if (split.length == 2) {
            choice = BaseCommand.parseToggleChoice(split[1]);
        }
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "public": {
                TownCommand.townTogglePublic(sender, admin, town, choice);
                break;
            }
            case "pvp": {
                TownCommand.townTogglePVP(sender, split, admin, town, permSource, choice);
                break;
            }
            case "explosion": {
                TownCommand.townToggleExplosion(sender, split, admin, town, choice);
                break;
            }
            case "fire": {
                TownCommand.townToggleFire(sender, split, admin, town, choice);
                break;
            }
            case "mobs": {
                TownCommand.townToggleMobs(sender, split, admin, town, choice);
                break;
            }
            case "taxpercent": {
                TownCommand.townToggleTaxPercent(sender, admin, town, choice);
                break;
            }
            case "open": {
                TownCommand.townToggleOpen(sender, admin, town, choice);
                break;
            }
            case "neutral": 
            case "peaceful": {
                TownCommand.townToggleNeutral(sender, admin, town, permSource, choice);
                break;
            }
            case "nationzone": {
                TownCommand.townToggleNationZone(sender, admin, town, choice);
                break;
            }
            default: {
                if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWN_TOGGLE, split[0])) {
                    TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWN_TOGGLE, split[0]).execute(sender, "town", split);
                    return;
                }
                BukkitTools.ifCancelledThenThrow(new TownToggleUnknownEvent(sender, town, admin, split));
            }
        }
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "pvp": 
            case "explosion": 
            case "fire": 
            case "mobs": {
                for (TownBlock townBlock : town.getTownBlocks()) {
                    if (townBlock.hasResident() || townBlock.isChanged()) continue;
                    townBlock.setType(townBlock.getType());
                    townBlock.save();
                }
                break;
            }
        }
        BukkitTools.fireEvent(new TownBlockSettingsChangedEvent(town));
        town.save();
    }

    private static void townTogglePublic(CommandSender sender, boolean admin, Town town, Optional<Boolean> choice) throws TownyException {
        TownTogglePublicEvent preEvent = new TownTogglePublicEvent(sender, town, admin, choice.orElse(!town.isPublic()));
        BukkitTools.ifCancelledThenThrow(preEvent);
        town.setPublic(preEvent.getFutureState());
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_changed_public", town.isPublic() ? Translatable.of("enabled") : Translatable.of("disabled")));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_public", town.isPublic() ? Translatable.of("enabled") : Translatable.of("disabled")));
        }
    }

    private static void townTogglePVP(CommandSender sender, String[] split, boolean admin, Town town, TownyPermissionSource permSource, Optional<Boolean> choice) throws TownyException {
        String uuid = town.getUUID().toString();
        if (!admin) {
            TownCommand.toggleTest(town, StringMgmt.join(split, " "));
            if (TownySettings.getPVPCoolDownTime() > 0 && CooldownTimerTask.hasCooldown(uuid, CooldownTimerTask.CooldownType.PVP) && !permSource.isTownyAdmin((Permissible)sender)) {
                throw new TownyException(Translatable.of("msg_err_cannot_toggle_pvp_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(uuid, CooldownTimerTask.CooldownType.PVP)));
            }
            if (TownySettings.getOutsidersPreventPVPToggle() && choice.orElse(!town.isPVP()).booleanValue()) {
                for (Player target : Bukkit.getOnlinePlayers()) {
                    if (town.hasResident(target) || !town.equals(TownyAPI.getInstance().getTown(target.getLocation()))) continue;
                    throw new TownyException(Translatable.of("msg_cant_toggle_pvp_outsider_in_town"));
                }
            }
        }
        TownTogglePVPEvent preEvent = new TownTogglePVPEvent(sender, town, admin, choice.orElse(!town.isPVP()));
        BukkitTools.ifCancelledThenThrow(preEvent);
        town.setPVP(preEvent.getFutureState());
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_changed_pvp", town.getName(), town.isPVP() ? Translatable.of("enabled") : Translatable.of("disabled")));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_pvp", town.getName(), town.isPVP() ? Translatable.of("enabled") : Translatable.of("disabled")));
        }
        if (TownySettings.getPVPCoolDownTime() > 0 && !admin && !permSource.isTownyAdmin((Permissible)sender)) {
            CooldownTimerTask.addCooldownTimer(uuid, CooldownTimerTask.CooldownType.PVP);
        }
    }

    private static void townToggleExplosion(CommandSender sender, String[] split, boolean admin, Town town, Optional<Boolean> choice) throws TownyException {
        if (!admin) {
            TownCommand.toggleTest(town, StringMgmt.join(split, " "));
        }
        TownToggleExplosionEvent preEvent = new TownToggleExplosionEvent(sender, town, admin, choice.orElse(!town.isExplosion()));
        BukkitTools.ifCancelledThenThrow(preEvent);
        town.setExplosion(preEvent.getFutureState());
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_changed_expl", town.getName(), town.isExplosion() ? Translatable.of("enabled") : Translatable.of("disabled")));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_expl", town.getName(), town.isExplosion() ? Translatable.of("enabled") : Translatable.of("disabled")));
        }
    }

    private static void townToggleFire(CommandSender sender, String[] split, boolean admin, Town town, Optional<Boolean> choice) throws TownyException {
        if (!admin) {
            TownCommand.toggleTest(town, StringMgmt.join(split, " "));
        }
        TownToggleFireEvent preEvent = new TownToggleFireEvent(sender, town, admin, choice.orElse(!town.isFire()));
        BukkitTools.ifCancelledThenThrow(preEvent);
        town.setFire(preEvent.getFutureState());
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_changed_fire", town.getName(), town.isFire() ? Translatable.of("enabled") : Translatable.of("disabled")));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_fire", town.getName(), town.isFire() ? Translatable.of("enabled") : Translatable.of("disabled")));
        }
    }

    private static void townToggleMobs(CommandSender sender, String[] split, boolean admin, Town town, Optional<Boolean> choice) throws TownyException {
        if (!admin) {
            TownCommand.toggleTest(town, StringMgmt.join(split, " "));
        }
        TownToggleMobsEvent preEvent = new TownToggleMobsEvent(sender, town, admin, choice.orElse(!town.hasMobs()));
        BukkitTools.ifCancelledThenThrow(preEvent);
        town.setHasMobs(preEvent.getFutureState());
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_changed_mobs", town.getName(), town.hasMobs() ? Translatable.of("enabled") : Translatable.of("disabled")));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_mobs", town.getName(), town.hasMobs() ? Translatable.of("enabled") : Translatable.of("disabled")));
        }
    }

    private static void townToggleTaxPercent(CommandSender sender, boolean admin, Town town, Optional<Boolean> choice) throws TownyException {
        TownToggleTaxPercentEvent preEvent = new TownToggleTaxPercentEvent(sender, town, admin, choice.orElse(!town.isTaxPercentage()));
        BukkitTools.ifCancelledThenThrow(preEvent);
        town.setTaxPercentage(preEvent.getFutureState());
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_changed_taxpercent", town.isTaxPercentage() ? Translatable.of("enabled") : Translatable.of("disabled")));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_taxpercent", town.isTaxPercentage() ? Translatable.of("enabled") : Translatable.of("disabled")));
        }
    }

    private static void townToggleOpen(CommandSender sender, boolean admin, Town town, Optional<Boolean> choice) throws TownyException {
        if (town.isBankrupt()) {
            throw new TownyException(Translatable.of("msg_err_bankrupt_town_cannot_toggle_open"));
        }
        TownToggleOpenEvent preEvent = new TownToggleOpenEvent(sender, town, admin, choice.orElse(!town.isOpen()));
        BukkitTools.ifCancelledThenThrow(preEvent);
        town.setOpen(preEvent.getFutureState());
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_changed_open", town.isOpen() ? Translatable.of("enabled") : Translatable.of("disabled")));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_open", town.isOpen() ? Translatable.of("enabled") : Translatable.of("disabled")));
        }
        if (town.isOpen()) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_toggle_open_on_warning"));
        }
    }

    private static void townToggleNeutral(CommandSender sender, boolean admin, Town town, TownyPermissionSource permSource, Optional<Boolean> choice) throws TownyException {
        String uuid = town.getUUID().toString();
        if (TownySettings.getPeacefulCoolDownTime() > 0 && !admin && !permSource.isTownyAdmin((Permissible)sender) && CooldownTimerTask.hasCooldown(uuid, CooldownTimerTask.CooldownType.NEUTRALITY)) {
            throw new TownyException(Translatable.of("msg_err_cannot_toggle_neutral_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(uuid, CooldownTimerTask.CooldownType.NEUTRALITY)));
        }
        boolean peacefulState = choice.orElse(!town.isNeutral());
        double cost = TownySettings.getTownNeutralityCost(town);
        if (TownySettings.nationCapitalsCantBeNeutral() && town.isCapital()) {
            throw new TownyException(Translatable.of("msg_err_capital_cannot_be_peaceful"));
        }
        if (town.isNeutral() && peacefulState) {
            throw new TownyException(Translatable.of("msg_town_already_peaceful"));
        }
        if (!town.isNeutral() && !peacefulState) {
            throw new TownyException(Translatable.of("msg_town_already_not_peaceful"));
        }
        if (peacefulState && TownyEconomyHandler.isActive() && !town.getAccount().canPayFromHoldings(cost)) {
            throw new TownyException(Translatable.of("msg_town_cant_peaceful", TownCommand.prettyMoney(cost)));
        }
        TownToggleNeutralEvent preEvent = new TownToggleNeutralEvent(sender, town, admin, choice.orElse(!town.isNeutral()));
        BukkitTools.ifCancelledThenThrow(preEvent);
        if (peacefulState && TownyEconomyHandler.isActive() && cost > 0.0) {
            town.getAccount().withdraw(cost, "Peaceful Town Cost");
            TownyMessaging.sendMsg(sender, Translatable.of("msg_you_paid", TownCommand.prettyMoney(cost)));
        }
        town.setNeutral(preEvent.getFutureState());
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_changed_peaceful", town.isNeutral() ? Translatable.of("enabled") : Translatable.of("disabled")));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_peaceful", town.isNeutral() ? Translatable.of("enabled") : Translatable.of("disabled")));
        }
        if (TownySettings.getPeacefulCoolDownTime() > 0 && !admin && !permSource.isTownyAdmin((Permissible)sender)) {
            CooldownTimerTask.addCooldownTimer(uuid, CooldownTimerTask.CooldownType.NEUTRALITY);
        }
        if (TownyPerms.hasPeacefulNodes()) {
            TownyPerms.updateTownPerms(town);
        }
    }

    private static void townToggleNationZone(CommandSender sender, boolean admin, Town town, Optional<Boolean> choice) throws TownyException {
        if (town.getNationZoneSize() < 1) {
            throw new TownyException(Translatable.of("msg_err_your_town_has_no_nationzone_to_toggle"));
        }
        TownToggleNationZoneEvent preEvent = new TownToggleNationZoneEvent(sender, town, admin, choice.orElse(!town.isNationZoneEnabled()));
        BukkitTools.ifCancelledThenThrow(preEvent);
        town.setNationZoneEnabled(preEvent.getFutureState());
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_changed_nationzone", town.isNationZoneEnabled() ? Translatable.of("enabled") : Translatable.of("disabled")));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_nationzone", town.isNationZoneEnabled() ? Translatable.of("enabled") : Translatable.of("disabled")));
        }
    }

    private static void parseUnJailCommand(CommandSender sender, Town town, String[] split, boolean admin) throws TownyException {
        if (!admin) {
            town = TownCommand.getTownFromPlayerOrThrow((Player)sender);
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_UNJAIL.getNode());
            TownCommand.catchRuinedTown((Player)sender);
        }
        if (split.length != 1) {
            HelpMenu.TOWN_UNJAIL.send(sender);
            return;
        }
        Resident jailedResident = TownyUniverse.getInstance().getResident(split[0]);
        if (jailedResident == null || !jailedResident.isJailed() || jailedResident.isJailed() && !jailedResident.getJail().getTown().equals(town)) {
            throw new TownyException(Translatable.of("msg_player_not_jailed_in_your_town"));
        }
        JailUtil.unJailResident(jailedResident, UnJailReason.PARDONED);
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_resident_unjailed", jailedResident));
        }
    }

    private static void parseJailCommand(CommandSender sender, Town town, String[] split, boolean admin) throws TownyException {
        boolean bailEnabled;
        if (!admin) {
            town = TownCommand.getTownFromPlayerOrThrow((Player)sender);
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_JAIL.getNode());
            TownCommand.catchRuinedTown((Player)sender);
        }
        if (!town.hasJails()) {
            throw new TownyException(Translatable.of("msg_town_has_no_jails"));
        }
        boolean bl = bailEnabled = TownySettings.isAllowingBail() && TownyEconomyHandler.isActive();
        if (split.length == 0) {
            if (bailEnabled) {
                HelpMenu.TOWN_JAILWITHBAIL.send(sender);
            } else {
                HelpMenu.TOWN_JAIL.send(sender);
            }
            return;
        }
        if (split[0].equalsIgnoreCase("list")) {
            TownCommand.parseJailListCommand(sender, town, StringMgmt.remFirstArg(split));
            return;
        }
        int hours = 2;
        int jailNum = 1;
        int cell = 1;
        Jail jail = town.getPrimaryJail();
        double bail = bailEnabled ? TownySettings.getBailAmount() : 0.0;
        double initialJailFee = TownyEconomyHandler.isActive() && TownySettings.initialJailFee() > 0.0 ? TownySettings.initialJailFee() : 0.0;
        Resident jailedResident = TownCommand.getResidentAllowedToBeJailedOrThrow(town, split);
        TownCommand.checkTeleportExploitsOrThrow(sender, admin, jailedResident);
        if (split.length > 1) {
            int offset;
            int n = offset = bailEnabled ? 1 : 0;
            if (!TownCommand.checkArgumentsPassedForJail(sender, split, offset)) {
                return;
            }
            hours = TownCommand.setJailHours(sender, split);
            if (offset == 1 && split.length >= 3) {
                bail = TownCommand.setBail(sender, split);
            }
            if (split.length >= 3 + offset && (jail = town.getJail(MathUtil.getPositiveIntOrThrow(split[2 + offset]))) == null) {
                throw new TownyException(Translatable.of("msg_err_the_town_does_not_have_that_many_jails"));
            }
            if (split.length == 4 + offset && !jail.hasJailCell(cell = MathUtil.getPositiveIntOrThrow(split[3 + offset]))) {
                throw new TownyException(Translatable.of("msg_err_that_jail_plot_does_not_have_that_many_cells"));
            }
        }
        TownCommand.testTownCanJailResidentOrThrow(town, initialJailFee, jailedResident);
        JailUtil.jailResidentWithBail(jailedResident, jail, cell, hours, bail, JailReason.MAYOR, sender);
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_player_has_been_sent_to_jail_number", jailedResident.getName(), jailNum));
        }
        if (initialJailFee > 0.0) {
            town.getAccount().withdraw(initialJailFee, "New Prisoner fee for " + jailedResident.getName());
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_x_has_been_withdrawn_for_jailing_of_prisoner_x", initialJailFee, jailedResident));
        }
    }

    private static Resident getResidentAllowedToBeJailedOrThrow(Town town, String[] split) throws TownyException {
        long time;
        Resident jailedResident = TownCommand.getResidentOrThrow(split[0]);
        if (!town.hasResident(jailedResident)) {
            throw new TownyException(Translatable.of("msg_resident_not_your_town"));
        }
        if (jailedResident.isJailed()) {
            throw new TownyException(Translatable.of("msg_err_resident_is_already_jailed", jailedResident.getName()));
        }
        if (TownySettings.newPlayerJailImmunity() > 0L && (time = jailedResident.getRegistered() + TownySettings.newPlayerJailImmunity() - System.currentTimeMillis()) > 0L) {
            throw new TownyException(Translatable.of("msg_resident_has_not_played_long_enough_to_be_jailed", jailedResident.getName(), TimeMgmt.getFormattedTimeValue(time)));
        }
        if (!jailedResident.isOnline()) {
            throw new TownyException(Translatable.of("msg_player_is_not_online", jailedResident.getName()));
        }
        return jailedResident;
    }

    private static void checkTeleportExploitsOrThrow(CommandSender sender, boolean admin, Resident jailedResident) throws TownyException {
        Player jailedPlayer = jailedResident.getPlayer();
        if (!admin && jailedPlayer.getUniqueId().equals(((Player)sender).getUniqueId())) {
            throw new TownyException(Translatable.of("msg_no_self_jailing"));
        }
        Town jaileeLocTown = TownyAPI.getInstance().getTown(jailedPlayer.getLocation());
        if (jaileeLocTown != null) {
            if (!TownySettings.canOutlawsTeleportOutOfTowns() && jaileeLocTown.hasOutlaw(jailedResident)) {
                throw new TownyException(Translatable.of("msg_err_resident_cannot_be_jailed_because_they_are_outlawed_there"));
            }
            Nation jaileeLocNation = jaileeLocTown.getNationOrNull();
            if (jaileeLocNation != null && jailedResident.hasNation() && TownySettings.getDisallowedTownSpawnZones().contains("enemy") && jaileeLocNation.hasEnemy(jailedResident.getNationOrNull())) {
                throw new TownyException(Translatable.of("msg_err_resident_cannot_be_jailed_because_they_are_enemied_there"));
            }
        }
    }

    private static boolean checkArgumentsPassedForJail(CommandSender sender, String[] split, int offset) {
        try {
            Integer.parseInt(split[1]);
            if (offset == 1 && split.length > 2) {
                Double.parseDouble(split[2]);
            }
            if (split.length > 2 + offset) {
                Integer.parseInt(split[2 + offset]);
            }
            if (split.length > 3 + offset) {
                Integer.parseInt(split[3 + offset]);
            }
        }
        catch (NumberFormatException e) {
            if (offset == 1) {
                HelpMenu.TOWN_JAILWITHBAIL.send(sender);
            } else {
                HelpMenu.TOWN_JAIL.send(sender);
            }
            return false;
        }
        return true;
    }

    private static int setJailHours(CommandSender sender, String[] split) throws TownyException {
        int hours = Math.min(2, MathUtil.getPositiveIntOrThrow(split[1]));
        if (hours > TownySettings.getJailedMaxHours()) {
            hours = TownySettings.getJailedMaxHours();
            TownyMessaging.sendMsg(sender, Translatable.of("msg_err_higher_than_max_allowed_hours_x", TownySettings.getJailedMaxHours()));
        }
        return hours;
    }

    private static double setBail(CommandSender sender, String[] split) throws TownyException {
        double bail = Math.max(1.0, MathUtil.getDoubleOrThrow(split[2]));
        if (bail > TownySettings.getBailMaxAmount()) {
            bail = TownySettings.getBailMaxAmount();
            TownyMessaging.sendMsg(sender, Translatable.of("msg_err_higher_than_max_allowed_bail_x", TownySettings.getBailMaxAmount()));
        }
        return bail;
    }

    private static void testTownCanJailResidentOrThrow(Town town, double initialJailFee, Resident jailedResident) throws TownyException {
        if (initialJailFee > 0.0 && !town.getAccount().canPayFromHoldings(initialJailFee)) {
            throw new TownyException(Translatable.of("msg_not_enough_money_in_bank_to_jail_x_fee_is_x", jailedResident, initialJailFee));
        }
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(jailedResident.getPlayer().getWorld());
        if (world != null && !world.isJailingEnabled()) {
            throw new TownyException(Translatable.of("msg_err_x_in_unjailable_world", jailedResident));
        }
        if (TownySettings.getMaxJailedPlayerCount() > 0 && town.getJailedPlayerCount() >= TownySettings.getMaxJailedPlayerCount()) {
            if (TownySettings.getMaxJailedNewJailBehavior() == 0) {
                throw new TownyException(Translatable.of("msg_town_has_no_jailslots"));
            }
            JailUtil.maxJailedUnjail(town);
        }
    }

    private static void parseJailListCommand(CommandSender sender, Town town, String[] args) {
        try {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_JAIL_LIST.getNode());
                Resident resident = TownyAPI.getInstance().getResident(player.getUniqueId());
                if (resident == null || !resident.hasTown()) {
                    throw new TownyException(Translatable.of("msg_err_must_belong_town"));
                }
            }
            int page = 1;
            int jailCount = town.getJails() == null ? 0 : town.getJails().size();
            int total = (int)Math.ceil((double)jailCount / 10.0);
            if (args.length == 1 && (page = MathUtil.getPositiveIntOrThrow(args[0])) == 0) {
                throw new TownyException(Translatable.of("msg_error_must_be_int"));
            }
            if (page > total) {
                throw new TownyException(Translatable.of("LIST_ERR_NOT_ENOUGH_PAGES", total));
            }
            TownyMessaging.sendJailList(sender, town, page, total);
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
        }
    }

    private static void toggleTest(Town town, String split) throws TownyException {
        if ((split = split.toLowerCase(Locale.ROOT)).contains("mobs")) {
            if (town.getHomeblockWorld().isForceTownMobs()) {
                throw new TownyException(Translatable.of("msg_world_mobs"));
            }
            if (town.isAdminEnabledMobs()) {
                throw new TownyException(Translatable.of("msg_town_mobs"));
            }
        }
        if (split.contains("fire") && town.getHomeblockWorld().isForceFire()) {
            throw new TownyException(Translatable.of("msg_world_fire"));
        }
        if (split.contains("explosion") && town.getHomeblockWorld().isForceExpl()) {
            throw new TownyException(Translatable.of("msg_world_expl"));
        }
        if (split.contains("pvp") && town.getHomeblockWorld().isForcePVP()) {
            throw new TownyException(Translatable.of("msg_world_pvp"));
        }
    }

    public void townRank(Player player, String[] split) throws TownyException {
        TownCommand.catchRuinedTown(player);
        if (split.length == 0) {
            HelpMenu.TOWN_RANK.send((CommandSender)player);
            return;
        }
        if (split.length < 3) {
            throw new TownyException("Eg: /town rank add/remove [resident] [rank]");
        }
        Resident target = TownCommand.getResidentOrThrow(split[1]);
        if (!TownCommand.getTownFromPlayerOrThrow(player).hasResident(target)) {
            throw new TownyException(Translatable.of("msg_resident_not_your_town"));
        }
        String rank = TownyPerms.matchTownRank(split[2]);
        if (rank == null) {
            throw new TownyException(Translatable.of("msg_unknown_rank_available_ranks", split[2], StringMgmt.join(TownyPerms.getTownRanks(), ", ")));
        }
        TownCommand.checkPermOrThrowWithMessage((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_RANK.getNode(rank.toLowerCase(Locale.ROOT)), Translatable.of("msg_no_permission_to_give_rank"));
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "add": {
                this.rankAdd(player, target, rank);
                break;
            }
            case "remove": {
                this.rankRemove(player, target, rank);
                break;
            }
            default: {
                HelpMenu.TOWN_RANK.send((CommandSender)player);
            }
        }
    }

    private void rankAdd(Player player, Resident target, String rank) throws TownyException {
        int levelNumber;
        int rankLevelReq;
        Translatable townWord = Translatable.of("town_sing");
        if (target.hasTownRank(rank)) {
            throw new TownyException(Translatable.of("msg_resident_already_has_rank", target.getName(), townWord));
        }
        if (TownyPerms.ranksWithTownLevelRequirementPresent() && (rankLevelReq = TownyPerms.getRankTownLevelReq(rank)) > (levelNumber = target.getTownOrNull().getLevelNumber())) {
            throw new TownyException(Translatable.of("msg_town_or_nation_level_not_high_enough_for_this_rank", townWord, rank, townWord, levelNumber, rankLevelReq));
        }
        BukkitTools.ifCancelledThenThrow(new TownAddResidentRankEvent(target, rank, target.getTownOrNull()));
        target.addTownRank(rank);
        target.save();
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_you_have_given_rank", townWord, rank, target.getName()));
        if (target.isOnline()) {
            TownyMessaging.sendMsg(target, Translatable.of("msg_you_have_been_given_rank", townWord, rank));
            plugin.deleteCache(TownyAPI.getInstance().getPlayer(target));
        }
    }

    private void rankRemove(Player player, Resident target, String rank) throws TownyException {
        Translatable townWord = Translatable.of("town_sing");
        if (!target.hasTownRank(rank)) {
            throw new TownyException(Translatable.of("msg_resident_doesnt_have_rank", target.getName(), townWord));
        }
        BukkitTools.ifCancelledThenThrow(new TownRemoveResidentRankEvent(target, rank, target.getTownOrNull()));
        target.removeTownRank(rank);
        target.save();
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_you_have_taken_rank_from", townWord, rank, target.getName()));
        if (target.isOnline()) {
            TownyMessaging.sendMsg(target, Translatable.of("msg_you_have_had_rank_taken", townWord, rank));
            plugin.deleteCache(TownyAPI.getInstance().getPlayer(target));
        }
    }

    private void parseTownSayCommand(Player player, String[] split) throws NoPermissionException, TownyException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_SAY.getNode());
        TownCommand.catchRuinedTown(player);
        TownyMessaging.sendPrefixedTownMessage(TownCommand.getTownFromPlayerOrThrow(player), TownyComponents.stripClickTags(StringMgmt.join(StringMgmt.remFirstArg(split))));
    }

    public static void townSet(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        String arg;
        Resident resident;
        if (split.length == 0) {
            HelpMenu.TOWN_SET.send(sender);
            return;
        }
        Player player = null;
        if (sender instanceof Player) {
            Player p = (Player)sender;
            TownCommand.catchRuinedTown(p);
            player = p;
        }
        if (!admin && player != null) {
            resident = TownCommand.getResidentOrThrow(player);
            town = resident.getTown();
        } else {
            resident = town.getMayor();
        }
        CharSequence[] subArgs = StringMgmt.remFirstArg(split);
        switch (arg = split[0].toLowerCase(Locale.ROOT)) {
            case "board": {
                TownCommand.townSetBoard(sender, String.join((CharSequence)" ", subArgs), town);
                break;
            }
            case "title": {
                TownCommand.townSetTitle(sender, (String[])subArgs, admin);
                break;
            }
            case "taxpercentcap": {
                TownCommand.townSetTaxPercent(sender, (String[])subArgs, town);
                break;
            }
            case "surname": {
                TownCommand.townSetSurname(sender, (String[])subArgs, admin);
                break;
            }
            case "mayor": {
                TownCommand.townSetMayor(sender, (String[])subArgs, admin, town, resident);
                break;
            }
            case "taxes": {
                TownCommand.townSetTaxes(sender, (String[])subArgs, admin, town);
                break;
            }
            case "plottax": {
                TownCommand.townSetPlotTax(sender, (String[])subArgs, admin, town);
                break;
            }
            case "shoptax": {
                TownCommand.townSetShopTax(sender, (String[])subArgs, admin, town);
                break;
            }
            case "embassytax": {
                TownCommand.townSetEmbassyTax(sender, (String[])subArgs, admin, town);
                break;
            }
            case "plotprice": {
                TownCommand.townSetPlotPrice(sender, (String[])subArgs, admin, town);
                break;
            }
            case "shopprice": {
                TownCommand.townSetShopPrice(sender, (String[])subArgs, admin, town);
                break;
            }
            case "embassyprice": {
                TownCommand.townSetEmbassyPrice(sender, (String[])subArgs, admin, town);
                break;
            }
            case "spawncost": {
                TownCommand.townSetSpawnCost(sender, (String[])subArgs, admin, town);
                break;
            }
            case "name": {
                TownCommand.townSetName(sender, (String[])subArgs, town);
                break;
            }
            case "tag": {
                TownCommand.townSetTag(sender, (String[])subArgs, admin, town);
                break;
            }
            case "homeblock": {
                TownCommand.townSetHomeblock(sender, town);
                break;
            }
            case "spawn": {
                TownCommand.townSetSpawn(sender, town, admin);
                break;
            }
            case "outpost": {
                TownCommand.townSetOutpost(sender, town);
                break;
            }
            case "perm": {
                TownCommand.setTownBlockOwnerPermissions(sender, town, (String[])subArgs);
                break;
            }
            case "primaryjail": {
                TownCommand.townSetPrimaryJail(sender, town);
                break;
            }
            case "mapcolor": {
                TownCommand.townSetMapColor(sender, (String[])subArgs, town);
                break;
            }
            default: {
                if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWN_SET, arg)) {
                    TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWN_SET, arg).execute(sender, "town", split);
                    return;
                }
                HelpMenu.TOWN_SET.send(sender);
            }
        }
    }

    public static void townSetBoard(CommandSender sender, String board, Town town) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_BOARD.getNode());
        if (board.isEmpty()) {
            throw new TownyException("Eg: /town set board " + Translatable.of("town_help_9").forLocale(sender));
        }
        if ("reset".equalsIgnoreCase(board)) {
            board = TownySettings.getTownDefaultBoard();
            TownyMessaging.sendMsg(sender, Translatable.of("msg_town_board_reset"));
        } else if ("none".equalsIgnoreCase(board) || "clear".equalsIgnoreCase(board)) {
            board = "";
        } else {
            if (!NameValidation.isValidBoardString(board)) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_string_board_not_set"));
                return;
            }
            if (board.length() > TownySettings.getMaxBoardLength()) {
                board = board.substring(0, TownySettings.getMaxBoardLength());
            }
        }
        town.setBoard(board);
        town.save();
        TownyMessaging.sendTownBoard(sender, town);
    }

    public static void townSetTitle(@NotNull CommandSender sender, @NotNull String[] split, boolean admin) throws TownyException {
        Player player;
        boolean sameTown;
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_TITLE.getNode());
        if (split.length == 0) {
            throw new TownyException("Eg: /town set title bilbo Jester");
        }
        Resident resident = TownCommand.getResidentOrThrow(split[0]);
        boolean bl = sameTown = sender instanceof Player && CombatUtil.isSameTown(TownCommand.getResidentOrThrow(player = (Player)sender), resident);
        if (!admin && !sameTown) {
            throw new TownyException(Translatable.of("msg_err_not_same_town", resident.getName()));
        }
        String title = NameValidation.checkAndFilterTitlesSurnameOrThrow(StringMgmt.remArgs(split, 1));
        if (TownySettings.doesSenderRequirePermissionNodeToAddColourToTitleOrSurname() && Colors.containsColourCode(title)) {
            TownCommand.checkPermOrThrowWithMessage((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_TITLE_COLOUR.getNode(), Translatable.of("msg_err_you_dont_have_permission_to_use_colours"));
        }
        resident.setTitle(title);
        resident.save();
        Translatable message = resident.hasTitle() ? Translatable.of("msg_set_title", resident.getName(), Colors.translateColorCodes(resident.getTitle())) : Translatable.of("msg_clear_title_surname", "Title", resident.getName());
        TownyMessaging.sendPrefixedTownMessage(resident, message);
        if (admin && !sameTown) {
            TownyMessaging.sendMsg(sender, message);
        }
    }

    public static void townSetSurname(CommandSender sender, String[] split, boolean admin) throws TownyException {
        Player player;
        boolean sameTown;
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_SURNAME.getNode());
        if (split.length == 0) {
            throw new TownyException("Eg: /town set surname bilbo the dwarf ");
        }
        Resident resident = TownCommand.getResidentOrThrow(split[0]);
        boolean bl = sameTown = sender instanceof Player && CombatUtil.isSameTown(TownCommand.getResidentOrThrow(player = (Player)sender), resident);
        if (!admin && !sameTown) {
            throw new TownyException(Translatable.of("msg_err_not_same_town", resident.getName()));
        }
        String surname = NameValidation.checkAndFilterTitlesSurnameOrThrow(StringMgmt.remArgs(split, 1));
        if (TownySettings.doesSenderRequirePermissionNodeToAddColourToTitleOrSurname() && Colors.containsColourCode(surname)) {
            TownCommand.checkPermOrThrowWithMessage((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_TITLE_COLOUR.getNode(), Translatable.of("msg_err_you_dont_have_permission_to_use_colours"));
        }
        resident.setSurname(surname);
        resident.save();
        Translatable message = resident.hasSurname() ? Translatable.of("msg_set_surname", resident.getName(), Colors.translateColorCodes(resident.getSurname())) : Translatable.of("msg_clear_title_surname", "Surname", resident.getName());
        TownyMessaging.sendPrefixedTownMessage(resident, message);
        if (admin && !sameTown) {
            TownyMessaging.sendMsg(sender, message);
        }
    }

    public static void townSetMayor(CommandSender sender, String[] split, boolean admin, Town town, Resident resident) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_MAYOR.getNode());
        if (split.length == 0) {
            throw new TownyException("Eg: /town set mayor Dumbo");
        }
        if (!admin && !resident.isMayor()) {
            throw new TownyException(Translatable.of("msg_not_mayor"));
        }
        Resident oldMayor = town.getMayor();
        Resident newMayor = TownCommand.getResidentOrThrow(split[0]);
        Confirmation.runOnAccept(() -> {
            try {
                NationKingChangeEvent nationKingChangeEvent;
                if (!admin && !resident.isMayor()) {
                    throw new TownyException(Translatable.of("msg_not_mayor"));
                }
                if (!town.hasResident(newMayor)) {
                    throw new TownyException(Translatable.of("msg_err_mayor_doesnt_belong_to_town"));
                }
                TownMayorChangeEvent townMayorChangeEvent = new TownMayorChangeEvent(sender, oldMayor, newMayor);
                if (BukkitTools.isEventCancelled(townMayorChangeEvent) && !admin) {
                    throw new TownyException(townMayorChangeEvent.getCancelMessage());
                }
                if (town.isCapital() && BukkitTools.isEventCancelled(nationKingChangeEvent = new NationKingChangeEvent(oldMayor, newMayor)) && !admin) {
                    throw new TownyException(nationKingChangeEvent.getCancelMessage());
                }
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
                return;
            }
            town.setMayor(newMayor);
            plugin.deleteCache(newMayor);
            if (oldMayor != null) {
                TownyPerms.assignPermissions(oldMayor, null);
                plugin.deleteCache(oldMayor);
            }
            if (admin) {
                town.setHasUpkeep(!newMayor.isNPC());
                TownyMessaging.sendMsg(sender, Translatable.of("msg_new_mayor", newMayor.getName()));
            }
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_new_mayor", newMayor.getName()));
            town.save();
        }).sendTo(sender);
    }

    public static void townSetTaxes(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        Object slug;
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_TAXES.getNode());
        if (split.length == 0) {
            throw new TownyException("Eg: /town set taxes 7");
        }
        Double amount = MathUtil.getDoubleOrThrow(split[0]);
        if (amount < 0.0 && !TownySettings.isNegativeTownTaxAllowed()) {
            throw new TownyException(Translatable.of("msg_err_negative_money"));
        }
        if (town.isTaxPercentage() && (amount > 100.0 || amount < 0.0)) {
            throw new TownyException(Translatable.of("msg_err_not_percentage"));
        }
        if (!TownySettings.isNegativeTownTaxAllowed() && TownySettings.getTownDefaultTaxMinimumTax() > amount) {
            throw new TownyException(Translatable.of("msg_err_tax_minimum_not_met", TownySettings.getTownDefaultTaxMinimumTax()));
        }
        town.setTaxes(amount);
        town.save();
        Object object = slug = town.isTaxPercentage() ? amount.toString() + "%" : TownCommand.prettyMoney(town.getTaxes());
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_town_set_tax", sender.getName(), slug));
        }
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_set_tax", sender.getName(), slug));
    }

    public static void townSetPlotTax(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_PLOTTAX.getNode());
        if (split.length == 0) {
            throw new TownyException("Eg: /town set plottax 10");
        }
        double amount = MathUtil.getDoubleOrThrow(split[0]);
        if (!TownySettings.isNegativePlotTaxAllowed() && amount < 0.0) {
            throw new TownyException(Translatable.of("msg_err_negative_money"));
        }
        town.setPlotTax(amount);
        town.save();
        String price = TownCommand.prettyMoney(town.getPlotTax());
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_town_set_plottax", sender.getName(), price));
        }
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_set_plottax", sender.getName(), price));
    }

    public static void townSetShopTax(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_SHOPTAX.getNode());
        if (split.length == 0) {
            throw new TownyException("Eg: /town set shoptax 10");
        }
        double amount = MathUtil.getDoubleOrThrow(split[0]);
        if (!TownySettings.isNegativePlotTaxAllowed() && amount < 0.0) {
            throw new TownyException(Translatable.of("msg_err_negative_money"));
        }
        town.setCommercialPlotTax(amount);
        town.save();
        String price = TownCommand.prettyMoney(town.getCommercialPlotTax());
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_town_set_alttax", sender.getName(), "shop", price));
        }
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_set_alttax", sender.getName(), "shop", price));
    }

    public static void townSetEmbassyTax(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_EMBASSYTAX.getNode());
        if (split.length == 0) {
            throw new TownyException("Eg: /town set embassytax 10");
        }
        double amount = MathUtil.getDoubleOrThrow(split[0]);
        if (!TownySettings.isNegativePlotTaxAllowed() && amount < 0.0) {
            throw new TownyException(Translatable.of("msg_err_negative_money"));
        }
        town.setEmbassyPlotTax(amount);
        town.save();
        String price = TownCommand.prettyMoney(town.getEmbassyPlotTax());
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_town_set_alttax", sender.getName(), "embassy", price));
        }
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_set_alttax", sender.getName(), "embassy", price));
    }

    public static void townSetPlotPrice(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_PLOTPRICE.getNode());
        if (split.length == 0) {
            throw new TownyException("Eg: /town set plotprice 50");
        }
        double amount = MathUtil.getDoubleOrThrow(split[0]);
        town.setPlotPrice(amount);
        town.save();
        String price = TownCommand.prettyMoney(town.getPlotPrice());
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_town_set_plotprice", sender.getName(), price));
        }
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_set_plotprice", sender.getName(), price));
    }

    public static void townSetShopPrice(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_SHOPPRICE.getNode());
        if (split.length == 0) {
            throw new TownyException("Eg: /town set shopprice 50");
        }
        double amount = MathUtil.getDoubleOrThrow(split[0]);
        town.setCommercialPlotPrice(amount);
        town.save();
        String price = TownCommand.prettyMoney(town.getCommercialPlotPrice());
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_town_set_altprice", sender.getName(), "shop", price));
        }
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_set_altprice", sender.getName(), "shop", price));
    }

    public static void townSetEmbassyPrice(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_EMBASSYPRICE.getNode());
        if (split.length == 0) {
            throw new TownyException("Eg: /town set embassyprice 50");
        }
        double amount = MathUtil.getDoubleOrThrow(split[0]);
        town.setEmbassyPlotPrice(amount);
        town.save();
        String price = TownCommand.prettyMoney(town.getEmbassyPlotPrice());
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_town_set_altprice", sender.getName(), "embassy", price));
        }
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_set_altprice", sender.getName(), "embassy", price));
    }

    public static void townSetSpawnCost(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_SPAWNCOST.getNode());
        if (split.length == 0) {
            throw new TownyException("Eg: /town set spawncost 50");
        }
        double amount = MathUtil.getDoubleOrThrow(split[0]);
        if (amount < 0.0) {
            throw new TownyException(Translatable.of("msg_err_negative_money"));
        }
        if (TownySettings.getSpawnTravelCost() < amount) {
            throw new TownyException(Translatable.of("msg_err_cannot_set_spawn_cost_more_than", TownySettings.getSpawnTravelCost()));
        }
        town.setSpawnCost(amount);
        town.save();
        String price = TownCommand.prettyMoney(amount);
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_spawn_cost_set_to", sender.getName(), Translatable.of("town_sing"), price));
        }
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_spawn_cost_set_to", sender.getName(), Translatable.of("town_sing"), price));
    }

    public static void townSetName(CommandSender sender, String[] split, Town town) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_NAME.getNode());
        if (split.length == 0) {
            throw new TownyException("Eg: /town set name BillyBobTown");
        }
        String name = String.join((CharSequence)"_", split);
        if (TownySettings.getTownAutomaticCapitalisationEnabled()) {
            name = StringMgmt.capitalizeStrings(name);
        }
        name = NameValidation.checkAndFilterGovernmentNameOrThrow(name, town);
        if (TownyUniverse.getInstance().hasTown(name)) {
            throw new TownyException(Translatable.of("msg_err_name_validation_name_already_in_use", name));
        }
        if (TownyEconomyHandler.isActive() && TownySettings.getTownRenameCost() > 0.0) {
            if (!town.getAccount().canPayFromHoldings(TownySettings.getTownRenameCost())) {
                throw new TownyException(Translatable.of("msg_err_no_money", TownCommand.prettyMoney(TownySettings.getTownRenameCost())));
            }
            Town finalTown = town;
            String finalName = name;
            Confirmation.runOnAccept(() -> TownCommand.townRename(sender, finalTown, finalName)).setTitle(Translatable.of("msg_confirm_purchase", TownCommand.prettyMoney(TownySettings.getTownRenameCost()))).sendTo(sender);
        } else {
            TownCommand.townRename(sender, town, name);
        }
    }

    public static void townSetTag(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_TAG.getNode());
        if (split.length == 0) {
            throw new TownyException("Eg: /town set tag PLTC");
        }
        if (split[0].equalsIgnoreCase("clear")) {
            town.setTag(" ");
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_reset_town_tag", sender.getName()));
            }
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_reset_town_tag", sender.getName()));
        } else {
            String tag = NameValidation.checkAndFilterTagOrThrow(split[0]);
            town.setTag(tag);
            town.save();
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_set_town_tag", sender.getName(), town.getTag()));
            }
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_set_town_tag", sender.getName(), town.getTag()));
        }
    }

    public static void townSetHomeblock(CommandSender sender, Town town) throws TownyException {
        Nation nation;
        List<Town> removedTowns;
        Player player = TownCommand.catchConsole(sender);
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_HOMEBLOCK.getNode());
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(player);
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(player.getWorld());
        if (world == null || townBlock == null || !townBlock.hasTown() || townBlock.getTownOrNull() != town) {
            throw new TownyException(Translatable.of("msg_area_not_own"));
        }
        if (TownySettings.getHomeBlockMovementCooldownHours() > 0 && town.getMovedHomeBlockAt() > 0L && TimeTools.getHours(System.currentTimeMillis() - town.getMovedHomeBlockAt()) < TownySettings.getHomeBlockMovementCooldownHours()) {
            long timeRemaining = town.getMovedHomeBlockAt() + TimeTools.getMillis(TownySettings.getHomeBlockMovementCooldownHours() + "h") - System.currentTimeMillis();
            throw new TownyException(Translatable.of("msg_err_you_have_moved_your_homeblock_too_recently_wait_x", TimeMgmt.getFormattedTimeValue(timeRemaining)));
        }
        if (town.hasHomeBlock() && town.getHomeBlock().getWorldCoord().equals(townBlock.getWorldCoord())) {
            throw new TownyException(Translatable.of("msg_err_homeblock_already_set_here"));
        }
        ProximityUtil.allowTownHomeBlockOrThrow(world, townBlock.getCoord(), town, false);
        BukkitTools.ifCancelledThenThrow(new TownPreSetHomeBlockEvent(town, townBlock, player));
        if (town.isCapital() && TownySettings.getNationProximityToCapital() > 0.0 && !(removedTowns = ProximityUtil.gatherOutOfRangeTowns(nation = town.getNationOrNull())).isEmpty()) {
            Location playerLocation = player.getLocation();
            Confirmation.runOnAccept(() -> {
                town.playerSetsHomeBlock(townBlock, playerLocation, player);
                town.save();
                ProximityUtil.removeOutOfRangeTowns(nation);
            }).setTitle(Translatable.of("msg_warn_the_following_towns_will_be_removed_from_your_nation", StringMgmt.join(removedTowns, ", "))).sendTo((CommandSender)player);
            return;
        }
        town.playerSetsHomeBlock(townBlock, player.getLocation(), player);
        town.save();
    }

    public static void townSetSpawn(CommandSender sender, Town town, boolean admin) throws TownyException {
        Player player = TownCommand.catchConsole(sender);
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_SPAWN.getNode());
        if (!town.hasHomeBlock()) {
            throw new TownyException(Translatable.of("msg_err_homeblock_has_not_been_set"));
        }
        TownSetSpawnEvent event = new TownSetSpawnEvent(town, player, player.getLocation());
        if (BukkitTools.isEventCancelled(event) && !admin && !event.getCancelMessage().isEmpty()) {
            throw new TownyException(event.getCancelMessage());
        }
        Location newSpawn = admin ? player.getLocation() : event.getNewSpawn();
        TownBlock tb = TownyAPI.getInstance().getTownBlock(newSpawn);
        if (!(tb != null && tb.hasTown() && tb.getTownOrNull().equals(town) && town.getHomeBlock().getWorldCoord().equals(tb.getWorldCoord()))) {
            throw new TownyException(Translatable.of("msg_err_spawn_not_within_homeblock"));
        }
        if (town.getSpawnOrNull() != null) {
            TownyUniverse.getInstance().removeSpawnPoint(town.getSpawnOrNull());
        }
        town.setSpawn(newSpawn);
        town.save();
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_set_town_spawn"));
    }

    public static void townSetOutpost(CommandSender sender, Town town) throws TownyException {
        Player player = TownCommand.catchConsole(sender);
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_OUTPOST.getNode());
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(player);
        if (townBlock == null || !townBlock.hasTown() || !townBlock.isOutpost()) {
            throw new TownyException(Translatable.of("msg_err_location_is_not_within_an_outpost_plot"));
        }
        if (!townBlock.getTownOrNull().equals(town)) {
            throw new TownyException(Translatable.of("msg_not_own_area"));
        }
        TownSetOutpostSpawnEvent event = new TownSetOutpostSpawnEvent(town, player, player.getLocation());
        BukkitTools.ifCancelledThenThrow(event);
        town.addOutpostSpawn(event.getNewSpawn());
        town.save();
        TownyMessaging.sendMsg(sender, Translatable.of("msg_set_outpost_spawn"));
    }

    public static void townSetPrimaryJail(CommandSender sender, Town town) throws TownyException {
        Player player = TownCommand.catchConsole(sender);
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_PRIMARYJAIL.getNode());
        TownBlock tb = TownyAPI.getInstance().getTownBlock(player);
        if (tb == null || !tb.isJail()) {
            throw new TownyException(Translatable.of("msg_err_location_is_not_within_a_jail_plot"));
        }
        Jail jail = tb.getJail();
        town.setPrimaryJail(jail);
        town.save();
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_primary_jail_set_for_town"));
    }

    public static void townSetMapColor(CommandSender sender, String[] split, Town town) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_MAPCOLOR.getNode());
        if (split.length == 0) {
            throw new TownyException("Eg: /town set mapcolor brown.");
        }
        String color = StringMgmt.join(split, " ").toLowerCase(Locale.ROOT);
        if (!TownySettings.getTownColorsMap().containsKey(color)) {
            throw new TownyException(Translatable.of("msg_err_invalid_nation_map_color", TownySettings.getTownColorsMap().keySet().toString()));
        }
        if (TownySettings.getTownSetMapColourCost() > 0.0) {
            Confirmation.runOnAccept(() -> TownCommand.setTownMapColor(town, color)).setTitle(Translatable.of("msg_confirm_purchase", TownCommand.prettyMoney(TownySettings.getTownSetMapColourCost()))).setCost(new ConfirmationTransaction(TownySettings::getTownSetMapColourCost, town, "Cost of setting town map color.")).sendTo(sender);
        } else {
            TownCommand.setTownMapColor(town, color);
        }
    }

    private static void setTownMapColor(Town town, String color) {
        town.setMapColorHexCode(TownySettings.getTownColorsMap().get(color));
        town.save();
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_map_color_changed", color));
    }

    public static void townSetTaxPercent(CommandSender sender, String[] split, Town town) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_TAXPERCENTCAP.getNode());
        if (!town.isTaxPercentage()) {
            throw new TownyException(Translatable.of("msg_max_tax_amount_only_for_percent"));
        }
        if (split.length == 0) {
            throw new TownyException("Eg. /town set taxpercentcap 10000");
        }
        town.setMaxPercentTaxAmount(MathUtil.getDoubleOrThrow(split[0]));
        town.save();
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_set_tax_max_percent_amount", sender.getName(), TownCommand.prettyMoney(town.getMaxPercentTaxAmount())));
    }

    private static void parseTownBaltop(Player player, Town town) throws TownyException {
        TownCommand.catchRuinedTown(player);
        plugin.getScheduler().runAsync(() -> {
            StringBuilder sb = new StringBuilder();
            ArrayList<Resident> residents = new ArrayList<Resident>(town.getResidents());
            residents.sort(Comparator.comparingDouble(res -> res.getAccount().getCachedBalance()).reversed());
            int i = 0;
            for (Resident res2 : residents) {
                sb.append(Translatable.of("msg_baltop_book_format", ++i, res2.getName(), TownCommand.prettyMoney(res2.getAccount().getCachedBalance())).forLocale((CommandSender)player) + "\n");
            }
            ItemStack book = BookFactory.makeBook("Town Baltop", town.getName(), sb.toString());
            plugin.getScheduler().run((Entity)player, () -> player.openBook(book));
        });
    }

    public static void townBuy(CommandSender sender, String[] split, @Nullable Town town, boolean admin) throws TownyException {
        if (!TownyEconomyHandler.isActive()) {
            throw new TownyException(Translatable.of("msg_err_no_economy"));
        }
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.TOWN_BUY.send(sender);
            return;
        }
        if (town == null && sender instanceof Player) {
            Player player = (Player)sender;
            TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_BUY.getNode());
            TownCommand.catchRuinedTown(player);
            town = TownCommand.getTownFromPlayerOrThrow(player);
        }
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "bonus": {
                TownCommand.townBuyBonus(town, split, sender);
                break;
            }
            default: {
                if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWN_BUY, split[0])) {
                    TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWN_BUY, split[0]).execute(sender, "town", split);
                    return;
                }
                HelpMenu.TOWN_BUY.send(sender);
            }
        }
    }

    public static void townBuyBonus(Town town, String[] split, CommandSender sender) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_BUY_BONUS.getNode());
        if (!TownySettings.isSellingBonusBlocks(town) && !TownySettings.isBonusBlocksPerTownLevel()) {
            throw new TownyException("Config.yml has bonus blocks disabled at max_purchased_blocks: '0' ");
        }
        if (TownySettings.isBonusBlocksPerTownLevel() && TownySettings.getMaxBonusBlocks(town) == 0) {
            throw new TownyException("Config.yml has bonus blocks disabled at town_level section: townBlockBuyBonusLimit: 0");
        }
        if (split.length < 2) {
            String line = "\u00a7e[Purchased Bonus] \u00a72Cost: \u00a7a%s\u00a78 | \u00a72Max: \u00a7a%d";
            TownyMessaging.sendMessage((Object)sender, String.format(line, TownCommand.prettyMoney(town.getBonusBlockCost()), TownySettings.getMaxPurchasedBlocks(town)));
            if (TownySettings.getPurchasedBonusBlocksIncreaseValue() != 1.0) {
                TownyMessaging.sendMessage((Object)sender, "\u00a72Cost Increase per TownBlock: \u00a7a+" + new DecimalFormat("##.##%").format(TownySettings.getPurchasedBonusBlocksIncreaseValue() - 1.0));
            }
            return;
        }
        TownCommand.townBuyBonusTownBlocks(town, MathUtil.getIntOrThrow(split[1].trim()), sender);
    }

    public static void townBuyBonusTownBlocks(Town town, int inputN, CommandSender sender) throws TownyException {
        if (inputN < 0) {
            throw new TownyException(Translatable.of("msg_err_negative"));
        }
        int current = town.getPurchasedBlocks();
        int n = current + inputN > TownySettings.getMaxPurchasedBlocks(town) ? TownySettings.getMaxPurchasedBlocks(town) - current : inputN;
        if (n == 0) {
            throw new TownyException(Translatable.of("msg_err_you_cannot_purchase_any_more_bonus_blocks"));
        }
        double cost = town.getBonusBlockCostN(n);
        if (!town.getAccount().canPayFromHoldings(cost)) {
            throw new TownyException(Translatable.of("msg_no_funds_to_buy", n, Translatable.of("bonus_townblocks"), TownCommand.prettyMoney(cost)));
        }
        Confirmation.runOnAccept(() -> {
            town.addPurchasedBlocks(n);
            TownyMessaging.sendMsg(sender, Translatable.of("msg_buy", n, Translatable.of("bonus_townblocks"), TownCommand.prettyMoney(cost)));
            town.save();
        }).setCost(new ConfirmationTransaction(() -> cost, town, String.format("Town Buy Bonus (%d)", n), Translatable.of("msg_no_funds_to_buy", n, Translatable.of("bonus_townblocks"), TownCommand.prettyMoney(cost)))).setTitle(Translatable.of("msg_confirm_purchase", TownCommand.prettyMoney(cost))).sendTo(sender);
    }

    private void parseTownNewCommand(Player player, String[] split) throws NoPermissionException, TownyException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_NEW.getNode());
        if (split.length == 1) {
            throw new TownyException(Translatable.of("msg_specify_name"));
        }
        String townName = String.join((CharSequence)"_", StringMgmt.remFirstArg(split));
        boolean noCharge = TownySettings.getNewTownPrice() == 0.0 || !TownyEconomyHandler.isActive();
        TownCommand.newTown(player, townName, TownCommand.getResidentOrThrow(player), noCharge);
    }

    public static void newTown(Player player, String name, Resident resident, boolean noCharge) throws TownyException {
        TownCommand.newTown(player, name, resident, noCharge, false);
    }

    public static void newTown(Player player, String name, Resident resident, boolean noCharge, boolean adminCreated) throws TownyException {
        if (TownySettings.hasTownLimit() && TownyUniverse.getInstance().getTowns().size() >= TownySettings.getTownLimit()) {
            throw new TownyException(Translatable.of("msg_err_universe_limit"));
        }
        if (!resident.isAdmin() && CooldownTimerTask.hasCooldown(player.getName(), CooldownTimerTask.CooldownType.TOWN_DELETE)) {
            throw new TownyException(Translatable.of("msg_err_cannot_create_new_town_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(player.getName(), CooldownTimerTask.CooldownType.TOWN_DELETE)));
        }
        if (TownySettings.getTownAutomaticCapitalisationEnabled()) {
            name = StringMgmt.capitalizeStrings(name);
        }
        name = NameValidation.checkAndFilterTownNameOrThrow(name);
        if (TownyUniverse.getInstance().hasTown(name)) {
            throw new TownyException(Translatable.of("msg_err_name_validation_name_already_in_use", name));
        }
        if (resident.hasTown()) {
            throw new TownyException(Translatable.of("msg_err_already_res", resident.getName()));
        }
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(player.getWorld());
        if (world == null || !world.isUsingTowny()) {
            throw new TownyException(Translatable.of("msg_set_use_towny_off"));
        }
        if (!world.isClaimable()) {
            throw new TownyException(Translatable.of("msg_not_claimable"));
        }
        Location spawnLocation = player.getLocation();
        Coord key = Coord.parseCoord((Entity)player);
        if (!TownyAPI.getInstance().isWilderness(spawnLocation)) {
            throw new TownyException(Translatable.of("msg_already_claimed_1", key));
        }
        if (!adminCreated) {
            if (TownySettings.isUnwantedBiomeClaimingEnabled() || TownySettings.isOceanClaimingBlocked()) {
                List<WorldCoord> selection = Arrays.asList(WorldCoord.parseWorldCoord(spawnLocation));
                selection = AreaSelectionUtil.filterOutUnwantedBiomeWorldCoords(player, selection);
                if ((selection = AreaSelectionUtil.filterOutOceanBiomeWorldCoords(player, selection)).isEmpty()) {
                    throw new TownyException(Translatable.of("msg_err_cannot_begin_town_in_this_biome"));
                }
            }
            ProximityUtil.allowTownHomeBlockOrThrow(world, key, null, true);
        }
        if (noCharge || !TownyEconomyHandler.isActive()) {
            block15: {
                BukkitTools.ifCancelledThenThrow(new PreNewTownEvent(player, name, spawnLocation, 0.0));
                try {
                    TownCommand.newTown(world, name, resident, key, spawnLocation, player);
                    TownyMessaging.sendGlobalMessage(Translatable.of("msg_new_town", player.getName(), StringMgmt.remUnderscore(name)));
                }
                catch (TownyException e) {
                    TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
                    if (e instanceof CancelledEventException) break block15;
                    plugin.getLogger().log(Level.WARNING, "An exception occurred while creating a new town", e);
                }
            }
            return;
        }
        PreNewTownEvent pnte = new PreNewTownEvent(player, name, spawnLocation, TownySettings.getNewTownPrice());
        BukkitTools.ifCancelledThenThrow(pnte);
        double cost = pnte.getPrice();
        if (!resident.getAccount().canPayFromHoldings(cost)) {
            throw new TownyException(Translatable.of("msg_no_funds_new_town2", resident.getName().equals(player.getName()) ? Translatable.of("msg_you") : resident.getName(), cost));
        }
        String finalName = name;
        Confirmation.runOnAccept(() -> {
            block2: {
                try {
                    TownCommand.newTown(world, finalName, resident, key, spawnLocation, player, cost);
                    TownyMessaging.sendGlobalMessage(Translatable.of("msg_new_town", player.getName(), StringMgmt.remUnderscore(finalName)));
                }
                catch (TownyException e) {
                    TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
                    if (e instanceof CancelledEventException) break block2;
                    plugin.getLogger().log(Level.WARNING, "An exception occurred while creating a new town", e);
                }
            }
        }).setTitle(Translatable.of("msg_confirm_purchase", TownCommand.prettyMoney(cost))).setCost(new ConfirmationTransaction(() -> cost, resident, "New Town Cost", Translatable.of("msg_no_funds_new_town2", resident.getName().equals(player.getName()) ? Translatable.of("msg_you") : resident.getName(), TownCommand.prettyMoney(cost)))).sendTo((CommandSender)player);
    }

    public static Town newTown(TownyWorld world, String name, Resident resident, Coord key, Location spawn, Player player) throws TownyException {
        return TownCommand.newTown(world, name, resident, key, spawn, player, 0.0);
    }

    public static Town newTown(TownyWorld world, String name, Resident resident, Coord key, Location spawn, Player player, double cost) throws TownyException {
        TownyUniverse.getInstance().newTown(name);
        Town town = TownyUniverse.getInstance().getTown(name);
        if (town == null) {
            throw new TownyException(String.format("Error fetching new town from name '%s'", name));
        }
        TownBlock townBlock = new TownBlock(key.getX(), key.getZ(), world);
        townBlock.setTown(town);
        TownPreClaimEvent preClaimEvent = new TownPreClaimEvent(town, townBlock, player, false, true, false);
        preClaimEvent.setCancelMessage(Translation.of("msg_claim_error", 1, 1));
        if (BukkitTools.isEventCancelled(preClaimEvent)) {
            TownyUniverse.getInstance().removeTownBlock(townBlock);
            TownyUniverse.getInstance().unregisterTown(town);
            if (TownyEconomyHandler.isActive() && cost > 0.0) {
                resident.getAccount().deposit(cost, "Cancelled town creation refund.");
            }
            throw new CancelledEventException(preClaimEvent);
        }
        town.setRegistered(System.currentTimeMillis());
        town.setMapColorHexCode(TownySettings.getDefaultTownMapColor());
        resident.setTown(town);
        town.setMayor(resident, false);
        town.setFounder(resident.getName());
        townBlock.setType(townBlock.getType());
        town.setSpawn(spawn);
        if (resident.isNPC()) {
            town.setHasUpkeep(false);
        }
        if (world.isUsingPlotManagementRevert()) {
            PlotBlockData plotChunk = TownyRegenAPI.getPlotChunk(townBlock);
            if (plotChunk != null && TownyRegenAPI.getRegenQueueList().contains(townBlock.getWorldCoord())) {
                TownyRegenAPI.removeFromActiveRegeneration(plotChunk);
                TownyRegenAPI.removeFromRegenQueueList(townBlock.getWorldCoord());
                TownyRegenAPI.addPlotChunkSnapshot(plotChunk);
            } else {
                TownyRegenAPI.handleNewSnapshot(townBlock);
            }
        }
        if (TownyEconomyHandler.isActive()) {
            TownyMessaging.sendDebugMsg("Creating new Town account: " + TownySettings.getTownAccountPrefix() + name);
            try {
                town.getAccount().setBalance(0.0, "Setting 0 balance for Town");
            }
            catch (NullPointerException e1) {
                throw new TownyException("The server economy plugin " + TownyEconomyHandler.getVersion() + " could not return the Town account!");
            }
        }
        if (TownySettings.isTownTagSetAutomatically()) {
            town.setTag(NameUtil.getTagFromName(name));
        }
        resident.save();
        townBlock.save();
        town.save();
        world.save();
        plugin.updateCache(townBlock.getWorldCoord());
        BukkitTools.fireEvent(new NewTownEvent(town));
        return town;
    }

    public static void townRename(CommandSender sender, Town town, String newName) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        String uuid = town.getUUID().toString();
        if (CooldownTimerTask.hasCooldown(uuid, CooldownTimerTask.CooldownType.TOWN_RENAME)) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_you_must_wait_x_seconds_before_renaming_your_town", CooldownTimerTask.getCooldownRemaining(uuid, CooldownTimerTask.CooldownType.TOWN_RENAME)));
            return;
        }
        TownPreRenameEvent event = new TownPreRenameEvent(town, newName);
        if (BukkitTools.isEventCancelled(event)) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_rename_cancelled"));
            return;
        }
        double renameCost = TownySettings.getTownRenameCost();
        if (TownyEconomyHandler.isActive() && renameCost > 0.0 && !town.getAccount().withdraw(renameCost, String.format("Town renamed to: %s", newName))) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_no_money", TownCommand.prettyMoney(renameCost)));
            return;
        }
        CooldownTimerTask.addCooldownTimer(uuid, CooldownTimerTask.CooldownType.TOWN_RENAME);
        try {
            townyUniverse.getDataSource().renameTown(town, newName);
            town = townyUniverse.getTown(newName);
            if (town == null) {
                throw new TownyException("Error renaming town! Cannot fetch town with new name " + newName);
            }
            town.save();
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_set_name", sender.getName(), town.getName()));
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
        }
    }

    public void townLeave(Player player, String[] args) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_LEAVE.getNode());
        Resident resident = TownCommand.getResidentOrThrow(player);
        Town town = TownCommand.getTownFromResidentOrThrow(resident);
        if (resident.isMayor()) {
            throw new TownyException(Translatable.of("msg_mayor_abandon"));
        }
        if (resident.isJailed() && TownySettings.JailDeniesTownLeave() && resident.getJailTown().getName().equals(town.getName())) {
            throw new TownyException(Translatable.of("msg_cannot_abandon_town_while_jailed"));
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("-ignore")) {
            this.townLeave(player, resident, town);
            return;
        }
        Confirmation.runOnAccept(() -> this.townLeave(player, resident, town)).setCancellableEvent(new TownLeaveEvent(resident, town)).sendTo((CommandSender)player);
    }

    private void townLeave(Player player, Resident resident, Town town) {
        if (resident.isJailed() && resident.getJailTown().getUUID().equals(town.getUUID())) {
            JailUtil.unJailResident(resident, UnJailReason.LEFT_TOWN);
        }
        if (town.hasResident(resident)) {
            resident.removeTown();
        }
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_left_town", resident.getName()));
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_left_town", resident.getName()));
        town.checkTownHasEnoughResidentsForNationRequirements();
    }

    public static void townSpawn(Player player, String[] split, Boolean outpost, boolean ignoreWarning) throws TownyException {
        String notAffordMSG;
        Town town;
        if (split.length == 1 && split[0].equals("-ignore") || split.length > 1 && split[1].equals("-ignore")) {
            ignoreWarning = true;
        }
        if (split.length == 0 || outpost.booleanValue() || split[0].equals("-ignore")) {
            town = TownCommand.getTownFromPlayerOrThrow(player);
            notAffordMSG = Translatable.of("msg_err_cant_afford_tp").forLocale((CommandSender)player);
        } else {
            town = TownCommand.getTownOrThrow(split[0]);
            notAffordMSG = Translatable.of("msg_err_cant_afford_tp_town", town.getName()).forLocale((CommandSender)player);
        }
        SpawnUtil.sendToTownySpawn(player, split, town, notAffordMSG, outpost, ignoreWarning, SpawnType.TOWN);
    }

    public void townDelete(Player player, String[] split) throws TownyException {
        Town town;
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_DELETE.getNode());
        TownCommand.catchRuinedTown(player);
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        Town town2 = town = split.length == 0 ? TownCommand.getTownFromPlayerOrThrow(player) : TownCommand.getTownOrThrow(split[0]);
        if (split.length == 0 || town.hasResident(player) && townyUniverse.getPermissionSource().testPermission((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_DELETE.getNode())) {
            if (TownySettings.getTownRuinsEnabled()) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_warning_town_ruined_if_deleted", TownySettings.getTownRuinsMaxDurationHours()));
                if (TownySettings.getTownRuinsReclaimEnabled()) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_warning_town_ruined_if_deleted2", TownySettings.getTownRuinsMinDurationHours()));
                }
            }
            Confirmation.runOnAccept(() -> {
                if (townyUniverse.getDataSource().removeTown(town, DeleteTownEvent.Cause.COMMAND, (CommandSender)player) && TownySettings.getTownUnclaimCoolDownTime() > 0) {
                    CooldownTimerTask.addCooldownTimer(player.getName(), CooldownTimerTask.CooldownType.TOWN_DELETE);
                }
            }).sendTo((CommandSender)player);
            return;
        }
        TownCommand.checkPermOrThrowWithMessage((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TOWN_DELETE.getNode(), Translatable.of("msg_err_admin_only_delete_town"));
        Confirmation.runOnAccept(() -> {
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("town_deleted_by_admin", town.getName()));
            townyUniverse.getDataSource().removeTown(town, DeleteTownEvent.Cause.ADMIN_COMMAND, (CommandSender)player);
        }).sendTo((CommandSender)player);
    }

    public static void townAddResidents(CommandSender sender, Town town, List<Resident> invited) throws TownyException {
        String string;
        List invitedResidents = invited.stream().filter(res -> !res.hasMode("ignoreinvites")).filter(res -> TownCommand.inviteResidentToTownOrThrow(sender, res, town)).map(TownyObject::getName).collect(Collectors.toList());
        if (invitedResidents.isEmpty()) {
            throw new TownyException(Translatable.of("msg_invalid_name"));
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            string = player.getName();
        } else {
            string = "Console";
        }
        String name = string;
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_invited_join_town", name, StringMgmt.join(invitedResidents, ", ")));
        town.save();
    }

    /*
     * Unable to fully structure code
     */
    private static boolean inviteResidentToTownOrThrow(CommandSender sender, Resident newMember, Town town) {
        if (!(sender instanceof Player)) ** GOTO lbl-1000
        player = (Player)sender;
        if (TownyUniverse.getInstance().getPermissionSource().isTownyAdmin((Permissible)player)) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        admin = v0;
        try {
            if (!admin) {
                BukkitTools.ifCancelledThenThrow(new TownPreAddResidentEvent(town, newMember));
            }
            if (!newMember.isOnline()) {
                throw new TownyException(Translatable.of("msg_player_is_not_online", new Object[]{newMember.getName()}));
            }
            if (!newMember.hasPermissionNode(PermissionNodes.TOWNY_TOWN_RESIDENT.getNode())) {
                throw new TownyException(Translatable.of("msg_not_allowed_join", new Object[]{newMember.getName()}));
            }
            if (!town.isAllowedThisAmountOfResidents(town.getNumResidents() + 1, town.isCapital())) {
                throw new TownyException(Translatable.of("msg_err_max_residents_per_town_reached", new Object[]{TownySettings.getMaxResidentsForTown(town)}));
            }
            if (town.hasNation() && !town.getNationOrNull().canAddResidents(1)) {
                throw new TownyException(Translatable.of("msg_err_cannot_add_nation_over_resident_limit", new Object[]{TownySettings.getMaxResidentsPerNation(), newMember.getName()}));
            }
            if (!admin && TownySettings.getTownInviteCooldown() > 0L && System.currentTimeMillis() / 1000L - newMember.getRegistered() / 1000L < TownySettings.getTownInviteCooldown()) {
                throw new TownyException(Translatable.of("msg_err_resident_doesnt_meet_invite_cooldown", new Object[]{newMember}));
            }
            town.addResidentCheck(newMember);
            TownCommand.townInviteResident(sender, town, newMember);
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
            return false;
        }
        return true;
    }

    public static void townAddResident(Town town, Resident resident) throws AlreadyRegisteredException {
        if (town.hasOutlaw(resident)) {
            town.removeOutlaw(resident);
        }
        resident.setTown(town);
        plugin.deleteCache(resident);
        resident.save();
        town.save();
    }

    private static void townInviteResident(CommandSender sender, Town town, Resident newMember) throws TownyException {
        PlayerJoinTownInvite invite = new PlayerJoinTownInvite(sender, newMember, town);
        BukkitTools.ifCancelledThenThrow(new TownPreInvitePlayerEvent(invite));
        try {
            if (!InviteHandler.inviteIsActive(invite)) {
                newMember.newReceivedInvite(invite);
                town.newSentInvite(invite);
                InviteHandler.addInvite(invite);
                Player player = TownyAPI.getInstance().getPlayer(newMember);
                if (player != null) {
                    TownyMessaging.sendRequestMessage((CommandSender)player, invite);
                }
            } else {
                throw new TownyException(Translatable.of("msg_err_player_already_invited", newMember.getName()));
            }
            BukkitTools.fireEvent(new TownInvitePlayerEvent(invite));
        }
        catch (TooManyInvitesException e) {
            newMember.deleteReceivedInvite(invite);
            town.deleteSentInvite(invite);
            throw new TownyException(e.getMessage());
        }
    }

    public static void townKick(Player player, String[] names) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_KICK.getNode());
        TownCommand.catchRuinedTown(player);
        Resident resident = TownCommand.getResidentOrThrow(player);
        Town town = resident.getTown();
        TownCommand.townKickResidents((CommandSender)player, resident, town, ResidentUtil.getValidatedResidentsOfTown((CommandSender)player, town, names));
        plugin.resetCache();
    }

    private static void townKickResidents(CommandSender sender, Resident resident, Town town, List<Resident> kicking) throws TownyException {
        List kickedResidents = kicking.stream().filter(res -> TownCommand.kickResidentFromTownOrThrow(sender, resident, res, town)).map(TownyObject::getName).collect(Collectors.toList());
        if (kickedResidents.isEmpty()) {
            throw new TownyException(Translatable.of("msg_invalid_name"));
        }
        town.checkTownHasEnoughResidentsForNationRequirements();
        town.save();
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_kicked", resident.getName(), StringMgmt.join(kickedResidents, ", ")));
    }

    private static boolean kickResidentFromTownOrThrow(CommandSender sender, Resident senderResident, Resident resToKick, Town town) {
        try {
            if (!town.hasResident(resToKick)) {
                throw new TownyException(Translatable.of("msg_resident_not_your_town"));
            }
            if (senderResident.equals(resToKick)) {
                throw new TownyException(Translatable.of("msg_you_cannot_kick_yourself"));
            }
            if (resToKick.isMayor()) {
                throw new TownyException(Translatable.of("msg_you_cannot_kick_this_resident", resToKick));
            }
            if (!senderResident.isMayor()) {
                if (TownySettings.getTownUnkickableRanks().stream().anyMatch(resToKick::hasTownRank)) {
                    throw new TownyException(Translatable.of("msg_you_cannot_kick_this_resident", resToKick));
                }
            }
            BukkitTools.ifCancelledThenThrow(new TownKickEvent(resToKick, sender));
            resToKick.removeTrustInTown(town);
            resToKick.removeTown();
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
            return false;
        }
        return true;
    }

    private void parseTownRanklistCommand(Player player, String[] split) throws NoPermissionException, TownyException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_RANKLIST.getNode());
        TownCommand.catchRuinedTown(player);
        Town town = split.length > 1 ? TownCommand.getTownOrThrow(split[1]) : TownCommand.getTownFromPlayerOrThrow(player);
        TownyMessaging.sendMessage((Object)player, TownyFormatter.getRanksForTown(town, Translator.locale((CommandSender)player)));
    }

    private void parseTownReclaimCommand(Player player) throws NoPermissionException, TownyException {
        if (!TownySettings.getTownRuinsReclaimEnabled()) {
            throw new TownyException(Translatable.of("msg_err_command_disable"));
        }
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_RECLAIM.getNode());
        TownRuinUtil.processRuinedTownReclaimRequest(player);
    }

    private static void parseTownJoin(Player player, String[] args) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_JOIN.getNode());
        Resident resident = TownCommand.getResidentOrThrow(player);
        if (resident.hasTown()) {
            throw new TownyException(Translatable.of("msg_err_already_res2", "You"));
        }
        Town town = TownCommand.getTownOrThrow(args[0]);
        if (!town.isOpen()) {
            throw new TownyException(Translatable.of("msg_err_not_open", town.getFormattedName()));
        }
        if (town.hasNation() && !town.getNationOrNull().canAddResidents(1)) {
            throw new TownyException(Translatable.of("msg_err_cannot_join_nation_over_resident_limit", TownySettings.getMaxResidentsPerNation()));
        }
        if (!town.isAllowedThisAmountOfResidents(town.getNumResidents() + 1, town.isCapital())) {
            throw new TownyException(Translatable.of("msg_err_max_residents_per_town_reached", TownySettings.getMaxResidentsForTown(town)));
        }
        if (town.hasOutlaw(resident)) {
            throw new TownyException(Translatable.of("msg_err_outlaw_in_open_town"));
        }
        BukkitTools.ifCancelledThenThrow(new TownPreAddResidentEvent(town, resident));
        TownCommand.townAddResident(town, resident);
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_join_town", resident.getName()));
    }

    public static void townAdd(CommandSender sender, Town specifiedTown, String[] names) throws TownyException {
        Town town;
        Player player = null;
        if (sender instanceof Player) {
            Player p;
            player = p = (Player)sender;
            TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_ADD.getNode());
            TownCommand.catchRuinedTown(player);
        }
        Town town2 = town = specifiedTown != null ? specifiedTown : TownCommand.getTownFromPlayerOrThrow(player);
        if (town.isBankrupt()) {
            throw new TownyException(Translatable.of("msg_err_bankrupt_town_cannot_invite"));
        }
        List<String> nameList = new ArrayList<String>(Arrays.asList(names));
        if (TownySettings.getMaxDistanceFromTownSpawnForInvite() > 0) {
            nameList = TownCommand.gatherNearbyPlayerNames(sender, nameList, town);
        }
        List<String> toInviteList = nameList.stream().filter(name -> !name.startsWith("-") && !town.hasResident((String)name)).collect(Collectors.toList());
        List toRevokeInviteList = nameList.stream().filter(name -> name.startsWith("-") || town.hasResident((String)name)).map(name -> name.startsWith("-") ? name.substring(1) : name).collect(Collectors.toList());
        if (toInviteList.size() + toRevokeInviteList.size() > 1) {
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_ADD_MULTIPLE.getNode());
        }
        if (!toInviteList.isEmpty()) {
            TownCommand.townAddResidents(sender, town, ResidentUtil.getValidatedResidents(sender, toInviteList));
        }
        if (!toRevokeInviteList.isEmpty()) {
            TownCommand.townRevokeResidentInvites(sender, town, ResidentUtil.getValidatedResidents(sender, town.getSentInvites().stream().filter(invite -> toRevokeInviteList.contains(invite.getReceiver().getName())).map(invite -> invite.getReceiver().getName()).collect(Collectors.toList())));
        }
    }

    private static List<String> gatherNearbyPlayerNames(CommandSender sender, List<String> names, Town town) throws TownyException {
        if (!town.hasSpawn()) {
            throw new TownyException(Translatable.of("msg_err_townspawn_has_not_been_set"));
        }
        Location spawnLoc = town.getSpawn();
        int maxDistance = TownySettings.getMaxDistanceFromTownSpawnForInvite();
        return names.stream().filter(name -> TownCommand.playerIsNearEnoughToTownSpawn(sender, name, spawnLoc, maxDistance)).collect(Collectors.toList());
    }

    private static boolean playerIsNearEnoughToTownSpawn(CommandSender sender, String name, Location spawnLoc, int maxDistance) {
        try {
            Player player = BukkitTools.getPlayerExact(name);
            if (player == null) {
                return false;
            }
            Location playerLoc = player.getLocation();
            if (!playerLoc.getWorld().equals((Object)spawnLoc.getWorld())) {
                throw new TownyException(Translatable.of("msg_err_player_too_far_from_town_spawn", name, maxDistance));
            }
            double distance = spawnLoc.distance(playerLoc);
            if (distance > (double)maxDistance) {
                throw new TownyException(Translatable.of("msg_err_player_too_far_from_town_spawn", name, maxDistance));
            }
            return true;
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
            return false;
        }
    }

    private static void townRevokeResidentInvites(CommandSender sender, Town town, List<Resident> residents) {
        residents.forEach(resident -> InviteHandler.getActiveInvitesFor(town, resident).forEach(invite -> {
            try {
                InviteHandler.declineInvite(invite, true);
                TownyMessaging.sendMsg(sender, Translatable.of("town_revoke_invite_successful", resident.getName()));
            }
            catch (InvalidObjectException e) {
                plugin.getLogger().log(Level.WARNING, "An exception occurred while revoking invite for resident " + resident.getName() + " from town " + town.getName(), e);
            }
        }));
    }

    public static void setTownBlockOwnerPermissions(CommandSender sender, Town town, String[] split) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_PERM.getNode());
        TownCommand.toggleTest(town, StringMgmt.join(split, " "));
        TownCommand.setTownBlockPermissions(sender, town, town.getPermissions(), split, false);
        town.save();
    }

    public static void setTownBlockPermissions(CommandSender sender, TownBlockOwner townBlockOwner, TownyPermission perm, String[] split, boolean friend) {
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split.length > 3) {
            TownCommand.displaySetPlotPermissionsHelp(sender, townBlockOwner);
            return;
        }
        if (split[0].equalsIgnoreCase("reset")) {
            TownCommand.resetTownBlockOwnersTownBlocks(sender, townBlockOwner);
            return;
        }
        if (split[0].equalsIgnoreCase("friend")) {
            split[0] = "resident";
        } else if (split[0].equalsIgnoreCase("town")) {
            split[0] = "nation";
        }
        if (split[0].equalsIgnoreCase("itemuse")) {
            split[0] = "item_use";
        }
        if (split.length > 1 && split[1].equalsIgnoreCase("itemuse")) {
            split[1] = "item_use";
        }
        TownyPermissionChange permChange = null;
        switch (split.length) {
            case 1: {
                try {
                    boolean b = StringMgmt.parseOnOff(split[0]);
                    permChange = new TownyPermissionChange(TownyPermissionChange.Action.ALL_PERMS, b, new Object[0]);
                    perm.change(permChange);
                    break;
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_input", "on/off."));
                    return;
                }
            }
            case 2: {
                boolean b;
                try {
                    b = StringMgmt.parseOnOff(split[1]);
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_input", "on/off."));
                    return;
                }
                try {
                    TownyPermission.PermLevel permLevel = TownyPermission.PermLevel.valueOf(split[0].toUpperCase(Locale.ROOT));
                    permChange = new TownyPermissionChange(TownyPermissionChange.Action.PERM_LEVEL, b, new Object[]{permLevel});
                    perm.change(permChange);
                    break;
                }
                catch (IllegalArgumentException permLevelException) {
                    try {
                        TownyPermission.ActionType actionType = TownyPermission.ActionType.valueOf(split[0].toUpperCase(Locale.ROOT));
                        permChange = new TownyPermissionChange(TownyPermissionChange.Action.ACTION_TYPE, b, new Object[]{actionType});
                        perm.change(permChange);
                        break;
                    }
                    catch (IllegalArgumentException actionTypeException) {
                        TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_town_set_perm_syntax_error"));
                        return;
                    }
                }
            }
            case 3: {
                TownyPermission.ActionType actionType;
                TownyPermission.PermLevel permLevel;
                try {
                    permLevel = TownyPermission.PermLevel.valueOf(split[0].toUpperCase(Locale.ROOT));
                    actionType = TownyPermission.ActionType.valueOf(split[1].toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException exception) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_town_set_perm_syntax_error"));
                    return;
                }
                try {
                    boolean b = StringMgmt.parseOnOff(split[2]);
                    permChange = new TownyPermissionChange(TownyPermissionChange.Action.SINGLE_PERM, b, new Object[]{permLevel, actionType});
                    perm.change(permChange);
                    break;
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_input", "on/off."));
                    return;
                }
            }
        }
        for (TownBlock townBlock : townBlockOwner.getTownBlocks()) {
            if (townBlock.isChanged()) continue;
            try {
                BukkitTools.ifCancelledThenThrow(new TownBlockPermissionChangeEvent(townBlock, permChange));
            }
            catch (CancelledEventException e) {
                TownyMessaging.sendErrorMsg((Object)sender, e.getCancelMessage());
                continue;
            }
            if (townBlockOwner instanceof Town && !townBlock.hasResident()) {
                townBlock.setType(townBlock.getType());
                townBlock.save();
                continue;
            }
            if (!(townBlockOwner instanceof Resident)) continue;
            townBlock.setType(townBlock.getType());
            townBlock.save();
        }
        Translator translator = Translator.locale(sender);
        TownyMessaging.sendMsg(sender, translator.of("msg_set_perms"));
        TownyMessaging.sendMessage((Object)sender, "\u00a72" + translator.of("status_perm") + " " + (townBlockOwner instanceof Resident ? perm.getColourString().replace("n", "t") : perm.getColourString().replace("f", "r")));
        String on = translator.of("status_on");
        String off = translator.of("status_off");
        TownyMessaging.sendMessage((Object)sender, "\u00a72" + translator.of("status_pvp") + " " + (perm.pvp ? on : off) + " \u00a72" + translator.of("explosions") + " " + (perm.explosion ? on : off) + " \u00a72" + translator.of("firespread") + " " + (perm.fire ? on : off) + " \u00a72" + translator.of("mobspawns") + " " + (perm.mobs ? on : off));
        plugin.resetCache();
    }

    private static void displaySetPlotPermissionsHelp(CommandSender sender, TownBlockOwner townBlockOwner) {
        TownyMessaging.sendMessage((Object)sender, ChatTools.formatTitle("/... set perm"));
        if (townBlockOwner instanceof Town) {
            TownyMessaging.sendMessage((Object)sender, ChatTools.formatCommand("Level", "[resident/nation/ally/outsider]", "", ""));
        }
        if (townBlockOwner instanceof Resident) {
            TownyMessaging.sendMessage((Object)sender, ChatTools.formatCommand("Level", "[friend/town/ally/outsider]", "", ""));
        }
        TownyMessaging.sendMessage((Object)sender, ChatTools.formatCommand("Type", "[build/destroy/switch/itemuse]", "", ""));
        TownyMessaging.sendMessage((Object)sender, ChatTools.formatCommand("", "set perm", "[on/off]", "Toggle all permissions"));
        TownyMessaging.sendMessage((Object)sender, ChatTools.formatCommand("", "set perm", "[level/type] [on/off]", ""));
        TownyMessaging.sendMessage((Object)sender, ChatTools.formatCommand("", "set perm", "[level] [type] [on/off]", ""));
        TownyMessaging.sendMessage((Object)sender, ChatTools.formatCommand("", "set perm", "reset", ""));
        if (townBlockOwner instanceof Town) {
            TownyMessaging.sendMessage((Object)sender, ChatTools.formatCommand("Eg", "/town set perm", "ally off", ""));
        }
        if (townBlockOwner instanceof Resident) {
            TownyMessaging.sendMessage((Object)sender, ChatTools.formatCommand("Eg", "/resident set perm", "friend build on", ""));
        }
    }

    private static void resetTownBlockOwnersTownBlocks(CommandSender sender, TownBlockOwner townBlockOwner) {
        for (TownBlock townBlock : townBlockOwner.getTownBlocks()) {
            if ((!(townBlockOwner instanceof Town) || townBlock.hasResident()) && (!(townBlockOwner instanceof Resident) || !townBlock.hasResident())) continue;
            TownyPermissionChange permChange = new TownyPermissionChange(TownyPermissionChange.Action.RESET, true, townBlock);
            try {
                BukkitTools.ifCancelledThenThrow(new TownBlockPermissionChangeEvent(townBlock, permChange));
            }
            catch (CancelledEventException e) {
                TownyMessaging.sendErrorMsg((Object)sender, e.getCancelMessage());
                return;
            }
            townBlock.setType(townBlock.getType());
            townBlock.save();
        }
        if (townBlockOwner instanceof Town) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_set_perms_reset", "Town owned"));
        } else {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_set_perms_reset", "your"));
        }
        plugin.resetCache();
    }

    private void parseTownCedeCommand(Player player, String[] args) throws TownyException {
        TownCommand.catchConsole((CommandSender)player);
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_CEDE_PLOT.getNode());
        if (args.length < 2 || !args[0].equalsIgnoreCase("plot")) {
            HelpMenu.TOWN_CEDE.send((CommandSender)player);
            return;
        }
        Town playerTown = TownCommand.getTownFromPlayerOrThrow(player);
        WorldCoord worldCoord = WorldCoord.parseWorldCoord((Entity)player);
        Town wcTown = worldCoord.getTownOrNull();
        if (wcTown == null || !wcTown.equals(playerTown)) {
            throw new TownyException(Translatable.of("msg_not_own_area"));
        }
        if (worldCoord.getTownBlock().isHomeBlock()) {
            throw new TownyException(Translatable.of("msg_err_town_cede_you_cannot_cede_your_homeblock"));
        }
        Town townGainingPlot = TownCommand.getTownOrThrow(args[1]);
        if (playerTown.equals(townGainingPlot)) {
            throw new TownyException(Translatable.of("msg_err_town_cede_you_cannot_cede_a_plot_to_your_own_town"));
        }
        ProximityUtil.allowTownClaimOrThrow(worldCoord.getTownyWorld(), worldCoord, townGainingPlot, false, true);
        if (!townGainingPlot.getMayor().isOnline()) {
            throw new TownyException(Translatable.of("msg_err_town_cede_the_mayor_is_not_online", townGainingPlot, townGainingPlot.getMayor()));
        }
        Player otherMayor = townGainingPlot.getMayor().getPlayer();
        Confirmation.runOnAccept(() -> this.offerPlotToTown(playerTown, townGainingPlot, player, otherMayor, worldCoord)).setCancellableEvent(new TownCedePlotEvent(playerTown, townGainingPlot, worldCoord.getTownBlock())).setTitle(Translatable.of("msg_town_cede_plot_confirmation_give_plot", townGainingPlot)).sendTo((CommandSender)player);
    }

    private void offerPlotToTown(Town townLosingPlot, Town townGainingPlot, Player playerGivingPlot, Player playerGainingPlot, WorldCoord worldCoord) {
        Confirmation.runOnAccept(() -> {
            try {
                ProximityUtil.allowTownClaimOrThrow(worldCoord.getTownyWorld(), worldCoord, townGainingPlot, false, true);
                TownBlock tb = worldCoord.getTownBlockOrNull();
                if (tb == null) {
                    throw new TownyException(Translatable.of("msg_not_claimed_1"));
                }
                if (!tb.getTownOrNull().equals(townLosingPlot)) {
                    throw new TownyException(Translatable.of("msg_err_town_no_longer_owns_this_plot", townLosingPlot));
                }
                if (tb.isHomeBlock()) {
                    throw new TownyException(Translatable.of("msg_err_town_cede_town_cannot_cede_their_homeblock", townLosingPlot));
                }
                tb.setTown(townGainingPlot);
                tb.save();
                TownyMessaging.sendMsg((CommandSender)playerGainingPlot, Translatable.of("msg_town_cede_plot_you_have_accepted", worldCoord.toString()));
                TownyMessaging.sendMsg((CommandSender)playerGivingPlot, Translatable.of("msg_town_cede_plot_accepted", playerGainingPlot.getName()));
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg(playerGainingPlot, e.getMessage((CommandSender)playerGainingPlot));
                TownyMessaging.sendErrorMsg((CommandSender)playerGivingPlot, Translatable.of("msg_town_cede_plot_unable_to_accept", playerGainingPlot.getName()));
            }
        }).setCancellableEvent(new TownPreClaimEvent(townGainingPlot, worldCoord.getTownBlockOrNull(), playerGainingPlot, false, false, false)).runOnCancel(() -> TownyMessaging.sendErrorMsg((CommandSender)playerGivingPlot, Translatable.of("msg_town_cede_plot_denied", playerGainingPlot.getName()))).setTitle(Translatable.of("msg_town_cede_plot_confirmation_accept_plot", playerGivingPlot.getName(), worldCoord.toString())).sendTo((CommandSender)playerGainingPlot);
    }

    public static void parseTownClaimCommand(Player player, String[] split) throws TownyException {
        if (split.length == 1 && split[0].equalsIgnoreCase("?")) {
            HelpMenu.TOWN_CLAIM.send((CommandSender)player);
            return;
        }
        TownCommand.catchRuinedTown(player);
        Town town = TownCommand.getTownFromPlayerOrThrow(player);
        TownCommand.catchBankruptTownWithLand(town);
        boolean outpost = split.length == 1 && split[0].equalsIgnoreCase("outpost");
        List<WorldCoord> selection = TownCommand.getTownClaimSelectionOrThrow(player, split, town);
        TownCommand.vetTownAllowedTheseClaims(town, outpost, selection);
        TownCommand.fireTownPreClaimEventOrThrow(player, town, outpost, selection);
        TownCommand.vetTheTownCanPayIfRequired(player, town, outpost, selection);
        plugin.getScheduler().runAsync(new TownClaim(plugin, player, town, selection, outpost, true, false));
    }

    private static void catchBankruptTownWithLand(Town town) throws TownyException {
        if (town.isBankrupt() && !town.getTownBlocks().isEmpty()) {
            throw new TownyException(Translatable.of("msg_err_bankrupt_town_cannot_claim"));
        }
    }

    private static List<WorldCoord> getTownClaimSelectionOrThrow(Player player, String[] split, Town town) throws TownyException {
        List<WorldCoord> selection;
        WorldCoord playerWorldCoord = WorldCoord.parseWorldCoord((Entity)player);
        TownyWorld world = playerWorldCoord.getTownyWorld();
        if (world == null || !world.isUsingTowny()) {
            throw new TownyException(Translatable.of("msg_set_use_towny_off"));
        }
        if (!world.isClaimable()) {
            throw new TownyException(Translatable.of("msg_not_claimable"));
        }
        if (split.length != 0 && TownyAPI.getInstance().getTownyWorld(split[0]) != null) {
            throw new TownyException(Translatable.of("tc_err_invalid_command"));
        }
        if (split.length == 1 && split[0].equalsIgnoreCase("outpost")) {
            if (!TownySettings.isAllowingOutposts()) {
                throw new TownyException(Translatable.of("msg_outpost_disable"));
            }
            TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_CLAIM_OUTPOST.getNode());
            Resident resident = TownCommand.getResidentOrThrow(player);
            OutpostUtil.OutpostTests(town, resident, world, playerWorldCoord, resident.isAdmin(), false);
            if (playerWorldCoord.hasTownBlock()) {
                throw new TownyException(Translatable.of("msg_already_claimed", playerWorldCoord.getTownOrNull()));
            }
            selection = new ArrayList<WorldCoord>();
            selection.add(playerWorldCoord);
        } else if (split.length == 1 && "fill".equalsIgnoreCase(split[0])) {
            TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_CLAIM_FILL.getNode());
            BorderUtil.FloodfillResult result = BorderUtil.getFloodFillableCoords(town, playerWorldCoord);
            if (result.type() != BorderUtil.FloodfillResult.Type.SUCCESS) {
                throw result.feedback() != null ? new TownyException(result.feedback()) : new TownyException();
            }
            if (result.feedback() != null) {
                TownyMessaging.sendMsg((CommandSender)player, result.feedback());
            }
            selection = new ArrayList<WorldCoord>(result.coords());
        } else {
            TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_CLAIM_TOWN.getNode());
            selection = AreaSelectionUtil.selectWorldCoordArea(town, playerWorldCoord, split, true);
            if (selection.size() == 1 && playerWorldCoord.hasTownBlock()) {
                throw new TownyException(Translatable.of("msg_already_claimed", playerWorldCoord.getTownOrNull()));
            }
            if (selection.size() > 1) {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_CLAIM_TOWN_MULTIPLE.getNode());
            }
        }
        if (selection.isEmpty()) {
            throw new TownyException(Translatable.of("msg_err_empty_area_selection"));
        }
        return TownCommand.vetTownClaimSelection(player, town, selection);
    }

    private static List<WorldCoord> vetTownClaimSelection(Player player, Town town, List<WorldCoord> selection) throws TownyException {
        TownyMessaging.sendDebugMsg("townClaim: Pre-Filter Selection [" + selection.size() + "] " + Arrays.toString(selection.toArray(new WorldCoord[0])));
        selection = AreaSelectionUtil.filterOutTownOwnedBlocks(selection);
        selection = AreaSelectionUtil.filterOutUnwantedBiomeWorldCoords(player, selection);
        selection = AreaSelectionUtil.filterOutOceanBiomeWorldCoords(player, selection);
        if (selection.isEmpty()) {
            throw new TownyException(Translatable.of("msg_err_empty_area_selection"));
        }
        if ((selection = AreaSelectionUtil.filterInvalidProximityToHomeblock(selection, town)).isEmpty()) {
            throw new TownyException(Translatable.of("msg_too_close2", Translatable.of("homeblock")));
        }
        if ((selection = AreaSelectionUtil.filterInvalidProximityTownBlocks(selection, town)).isEmpty()) {
            throw new TownyException(Translatable.of("msg_too_close2", Translatable.of("townblock")));
        }
        TownyMessaging.sendDebugMsg("townClaim: Post-Filter Selection [" + selection.size() + "] " + Arrays.toString(selection.toArray(new WorldCoord[0])));
        return selection;
    }

    private static void vetTownAllowedTheseClaims(Town town, boolean outpost, List<WorldCoord> selection) throws TownyException {
        if (!town.hasUnlimitedClaims() && selection.size() > town.availableTownBlocks()) {
            throw new TownyException(Translatable.of("msg_err_not_enough_blocks"));
        }
        ProximityUtil.testAdjacentClaimsRulesOrThrow(selection.get(0), town, outpost);
        if (!(outpost || TownCommand.isEdgeBlock(town, selection) || town.getTownBlocks().isEmpty())) {
            throw new TownyException(Translatable.of("msg_err_not_attached_edge"));
        }
    }

    private static void fireTownPreClaimEventOrThrow(Player player, Town town, boolean outpost, List<WorldCoord> selection) throws TownyException {
        int blockedClaims = 0;
        String cancelMessage = "";
        boolean isHomeblock = town.getTownBlocks().size() == 0;
        for (WorldCoord coord : selection) {
            TownPreClaimEvent preClaimEvent = new TownPreClaimEvent(town, new TownBlock(coord), player, outpost, isHomeblock, false);
            if (!BukkitTools.isEventCancelled(preClaimEvent)) continue;
            ++blockedClaims;
            cancelMessage = preClaimEvent.getCancelMessage();
        }
        if (blockedClaims > 0) {
            throw new TownyException(String.format(cancelMessage, blockedClaims, selection.size()));
        }
    }

    private static void vetTheTownCanPayIfRequired(Player player, Town town, boolean outpost, List<WorldCoord> selection) throws TownyException {
        if (TownyEconomyHandler.isActive()) {
            BankAccount townAccount = town.getAccount();
            if (townAccount == null) {
                throw new TownyException("The server economy plugin " + TownyEconomyHandler.getVersion() + " could not return the Town account!");
            }
            int selectionSize = selection.size();
            double blockCost = TownCommand.getSelectionCost(town, outpost, selectionSize);
            if (!((Account)townAccount).canPayFromHoldings(blockCost)) {
                double missingAmount = blockCost - townAccount.getHoldingBalance();
                throw new TownyException(Translatable.of("msg_no_funds_claim2", selectionSize, TownCommand.prettyMoney(blockCost), TownCommand.prettyMoney(missingAmount), new DecimalFormat("#").format(missingAmount)));
            }
            TownyEconomyHandler.economyExecutor().execute(() -> town.getAccount().withdraw(blockCost, String.format("Town Claim (%d) by %s", selectionSize, player.getName())));
        }
    }

    private static double getSelectionCost(Town town, boolean outpost, int selectionSize) throws TownyException {
        return outpost ? TownySettings.getOutpostCost() : (selectionSize == 1 ? town.getTownBlockCost() : town.getTownBlockCostN(selectionSize));
    }

    public static void parseTownUnclaimCommand(Player player, String[] split) throws TownyException {
        if (split.length == 1 && split[0].equalsIgnoreCase("?")) {
            HelpMenu.TOWN_UNCLAIM.send((CommandSender)player);
            return;
        }
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_UNCLAIM.getNode());
        TownCommand.catchRuinedTown(player);
        Resident resident = TownCommand.getResidentOrThrow(player);
        Town town = TownCommand.getTownFromResidentOrThrow(resident);
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(player.getWorld());
        if (split.length == 1 && split[0].equalsIgnoreCase("all")) {
            TownCommand.parseTownUnclaimAllCommand(player, town, resident, world);
            return;
        }
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_UNCLAIM.getNode());
        if (split.length == 3 && TownyAPI.getInstance().getTownyWorld(split[0]) != null) {
            throw new TownyException(Translatable.of("tc_err_invalid_command"));
        }
        List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(town, WorldCoord.parseWorldCoord((Entity)player), split);
        if ((selection = AreaSelectionUtil.filterOwnedBlocks(town, selection)).isEmpty()) {
            throw new TownyException(Translatable.of("msg_err_empty_area_selection"));
        }
        if (selection.get(0).getTownBlock().isHomeBlock()) {
            throw new TownyException(Translatable.of("msg_err_cannot_unclaim_homeblock"));
        }
        if (AreaSelectionUtil.filterHomeBlock(town, selection)) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_cannot_unclaim_homeblock"));
        }
        ProximityUtil.testAdjacentUnclaimsRulesOrThrow(selection.get(0), town);
        BukkitTools.ifCancelledThenThrow(new TownPreUnclaimCmdEvent(town, resident, world, selection));
        if (TownyEconomyHandler.isActive() && TownySettings.getClaimRefundPrice() < 0.0) {
            double cost = Math.abs(TownySettings.getClaimRefundPrice() * (double)selection.size());
            if (!town.getAccount().canPayFromHoldings(cost)) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_your_town_cannot_afford_unclaim", TownCommand.prettyMoney(cost)));
                return;
            }
            List<WorldCoord> finalSelection = selection;
            Confirmation.runOnAccept(() -> {
                if (!town.getAccount().canPayFromHoldings(cost)) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_your_town_cannot_afford_unclaim", TownCommand.prettyMoney(cost)));
                    return;
                }
                plugin.getScheduler().runAsync(new TownClaim(plugin, player, town, finalSelection, false, false, false));
            }).setTitle(Translatable.of("confirmation_unclaiming_costs", TownCommand.prettyMoney(cost))).sendTo((CommandSender)player);
            return;
        }
        plugin.getScheduler().runAsync(new TownClaim(plugin, player, town, selection, false, false, false));
    }

    private static void parseTownUnclaimAllCommand(Player player, Town town, Resident resident, TownyWorld world) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_UNCLAIM_ALL.getNode());
        ArrayList<WorldCoord> selection = new ArrayList<WorldCoord>();
        selection.addAll(town.getTownBlocks().stream().map(TownBlock::getWorldCoord).collect(Collectors.toList()));
        if (town.hasHomeBlock()) {
            selection.remove(town.getHomeBlock().getWorldCoord());
        }
        BukkitTools.ifCancelledThenThrow(new TownPreUnclaimCmdEvent(town, resident, world, selection));
        if (TownyEconomyHandler.isActive() && TownySettings.getClaimRefundPrice() < 0.0) {
            int numTownBlocks = town.getTownBlocks().size() - (town.hasHomeBlock() ? 1 : 0);
            String formattedCost = TownCommand.prettyMoney(Math.abs(TownySettings.getClaimRefundPrice() * (double)numTownBlocks));
            Confirmation.runOnAcceptAsync(new TownClaim(plugin, player, town, null, false, false, false)).setTitle(Translatable.of("confirmation_unclaiming_costs", formattedCost)).sendTo((CommandSender)player);
            return;
        }
        plugin.getScheduler().runAsync(new TownClaim(plugin, player, town, null, false, false, false));
    }

    private void parseTownTakeoverClaimCommand(Player player) throws TownyException {
        long ageNeeded;
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_TAKEOVERCLAIM.getNode());
        TownCommand.catchRuinedTown(player);
        if (!TownySettings.isOverClaimingAllowingStolenLand()) {
            throw new TownyException(Translatable.of("msg_err_taking_over_claims_is_not_enabled"));
        }
        Town town = TownCommand.getTownFromPlayerOrThrow(player);
        long ageRequirement = TownySettings.getOverclaimingTownAgeRequirement();
        if (ageRequirement > 0L && (ageNeeded = System.currentTimeMillis() - ageRequirement) < town.getRegistered()) {
            throw new TownyException(Translatable.of("msg_err_your_town_is_not_old_enough_to_overclaim", TimeMgmt.getFormattedTimeValue(town.getRegistered() - ageNeeded)));
        }
        if (town.getTownBlocks().size() == 0) {
            throw new TownyException(Translatable.of("msg_err_you_cannot_make_this_your_homeblock"));
        }
        WorldCoord wc = WorldCoord.parseWorldCoord((Entity)player);
        if (wc.isWilderness()) {
            throw new TownyException(Translatable.of("msg_not_own_place"));
        }
        Town overclaimedTown = wc.getTownOrNull();
        if (overclaimedTown.equals(town)) {
            throw new TownyException(Translatable.of("msg_already_claimed_1"));
        }
        if (!wc.canBeStolen()) {
            throw new TownyException(Translatable.of("msg_err_this_townblock_cannot_be_taken_over"));
        }
        if (TownySettings.isOverclaimingWithNationsRequiringEnemy()) {
            Nation overclaimingNation = town.getNationOrNull();
            Nation overclaimedNation = overclaimedTown.getNationOrNull();
            if (overclaimingNation != null && overclaimedNation != null && !overclaimingNation.hasEnemy(overclaimedNation)) {
                throw new TownyException(Translatable.of("msg_err_cannot_overclaim_this_town_because_they_arent_your_enemy"));
            }
        }
        if (!town.hasUnlimitedClaims() && town.availableTownBlocks() < 1) {
            throw new TownyException(Translatable.of("msg_err_not_enough_blocks"));
        }
        if (!TownCommand.isEdgeBlock(town, wc, new ArrayList<WorldCoord>())) {
            throw new TownyException(Translatable.of("msg_err_not_attached_edge"));
        }
        ProximityUtil.testAdjacentClaimsRulesOrThrow(wc, town, false);
        if (this.takeoverWouldCutATownIntoTwoSections(wc, town)) {
            throw new TownyException(Translatable.of("msg_err_you_cannot_over_claim_would_cut_into_two"));
        }
        if (TownySettings.isOverClaimingPreventedByHomeBlockRadius() && AreaSelectionUtil.isTooCloseToHomeBlock(wc, town)) {
            throw new TownyException(Translatable.of("msg_too_close2", Translatable.of("homeblock")));
        }
        if (BukkitTools.isEventCancelled(new TownPreClaimEvent(town, wc.getTownBlockOrNull(), player, false, false, true))) {
            throw new TownyException(Translatable.of("msg_err_another_plugin_cancelled_takeover"));
        }
        double cost = TownySettings.getTakeoverClaimPrice();
        String costSlug = !TownyEconomyHandler.isActive() || cost <= 0.0 ? Translatable.of("msg_spawn_cost_free").forLocale((CommandSender)player) : TownCommand.prettyMoney(cost);
        String townName = overclaimedTown.getName();
        Confirmation.runOnAcceptAsync(new TownClaim(plugin, player, town, Arrays.asList(wc), false, true, false, true)).setTitle(Translatable.of("confirmation_you_are_about_to_take_over_a_claim", townName, costSlug)).setCost(new ConfirmationTransaction(() -> cost, town, "Takeover Claim (" + wc.toString() + ") from " + townName + ".")).sendTo((CommandSender)player);
    }

    private boolean takeoverWouldCutATownIntoTwoSections(WorldCoord worldCoord, Town townOverClaiming) {
        Town overclaimed = worldCoord.getTownOrNull();
        List<WorldCoord> surroundingClaims = worldCoord.getCardinallyAdjacentWorldCoords(true);
        long townOwned = surroundingClaims.stream().filter(wc -> wc.hasTown(overclaimed)).count();
        if (townOwned < 2L) {
            return false;
        }
        long wildOr3rdPartyOwned = surroundingClaims.stream().filter(wc -> !wc.hasTown(overclaimed) && !wc.hasTown(townOverClaiming)).count();
        return wildOr3rdPartyOwned > 0L;
    }

    private void parseTownBankHistoryCommand(Player player, String[] split) throws NoPermissionException, TownyException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_BANKHISTORY.getNode());
        TownCommand.catchRuinedTown(player);
        int pages = 10;
        if (split.length > 1) {
            pages = MathUtil.getIntOrThrow(split[1]);
        }
        TownCommand.getTownFromPlayerOrThrow(player).generateBankHistoryBook(player, pages);
    }

    public static void parseTownMergeCommand(Player player, String[] args) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_MERGE.getNode());
        TownCommand.catchRuinedTown(player);
        TownCommand.parseTownMergeCommand((CommandSender)player, args, TownCommand.getTownFromPlayerOrThrow(player), false);
    }

    public static void parseTownMergeCommand(CommandSender sender, String[] args, @NotNull Town remainingTown, boolean admin) throws TownyException {
        Player player;
        if (args.length <= 0) {
            throw new TownyException(Translatable.of("msg_specify_name"));
        }
        if (!admin && sender instanceof Player && !TownCommand.getResidentOrThrow(player = (Player)sender).isMayor()) {
            throw new TownyException(Translatable.of("msg_town_merge_err_mayor_only"));
        }
        Town succumbingTown = TownCommand.getTownOrThrow(args[0]);
        TownCommand.vetTownsForMergeAndThrow(remainingTown, succumbingTown);
        double[] mergeCost = TownCommand.getMergeCosts(remainingTown, succumbingTown, admin);
        double cost = Arrays.stream(mergeCost).sum();
        if (cost > 0.0) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_town_merge_warning", succumbingTown.getName(), TownCommand.prettyMoney(cost)));
            if (mergeCost[2] > 0.0) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_town_merge_debt_warning", succumbingTown.getName()));
            }
            TownyMessaging.sendMsg(sender, Translatable.of("msg_town_merge_cost_breakdown", TownCommand.prettyMoney(mergeCost[0]), TownCommand.prettyMoney(mergeCost[1]), TownCommand.prettyMoney(mergeCost[2]), TownCommand.prettyMoney(mergeCost[3])));
            Confirmation.runOnAccept(() -> TownCommand.sendTownMergeRequest(sender, remainingTown, succumbingTown, cost)).runOnCancel(() -> TownyMessaging.sendMsg(sender, Translatable.of("msg_town_merge_cancelled"))).sendTo(sender);
        } else {
            TownCommand.sendTownMergeRequest(sender, remainingTown, succumbingTown, cost);
        }
    }

    private static void vetTownsForMergeAndThrow(Town remainingTown, Town succumbingTown) throws TownyException {
        if (succumbingTown.getName().equals(remainingTown.getName())) {
            throw new TownyException(Translatable.of("msg_err_invalid_name", succumbingTown.getName()));
        }
        if (TownySettings.getMaxDistanceForTownMerge() > 0 && TownCommand.homeBlockDistance(remainingTown, succumbingTown) > TownySettings.getMaxDistanceForTownMerge()) {
            throw new TownyException(Translatable.of("msg_town_merge_err_not_close", succumbingTown.getName(), TownySettings.getMaxDistanceForTownMerge()));
        }
        int newResidentsAmount = remainingTown.getNumResidents() + succumbingTown.getNumResidents();
        if (!remainingTown.isAllowedThisAmountOfResidents(newResidentsAmount, remainingTown.isCapital())) {
            throw new TownyException(Translatable.of("msg_town_merge_err_too_many_residents", TownySettings.getMaxResidentsForTown(remainingTown)));
        }
        if (!remainingTown.hasUnlimitedClaims()) {
            TownCommand.vetTownWouldHaveTooManyTownBlocksOrThrow(remainingTown, succumbingTown, newResidentsAmount);
        }
        if (remainingTown.getPurchasedBlocks() + succumbingTown.getPurchasedBlocks() > TownySettings.getMaxPurchasedBlocks(remainingTown, newResidentsAmount)) {
            throw new TownyException(Translatable.of("msg_town_merge_err_too_many_purchased_townblocks", TownySettings.getMaxPurchasedBlocks(remainingTown, newResidentsAmount)));
        }
        if (TownySettings.isAllowingOutposts() && TownySettings.isOutpostsLimitedByLevels()) {
            int nationTownsAmount;
            int n = nationTownsAmount = !remainingTown.hasNation() ? 0 : remainingTown.getNationOrNull().getTowns().size();
            if (remainingTown.hasNation() && remainingTown.getNationOrNull().hasTown(succumbingTown)) {
                --nationTownsAmount;
            }
            int maxOutposts = TownySettings.getMaxOutposts(remainingTown, newResidentsAmount, nationTownsAmount);
            int combinedOutposts = remainingTown.getOutpostSpawns().size() + succumbingTown.getOutpostSpawns().size();
            if (combinedOutposts > maxOutposts) {
                throw new TownyException(Translatable.of("msg_town_merge_err_too_many_outposts", maxOutposts));
            }
        }
        if (!BukkitTools.isOnline(succumbingTown.getMayor().getName()) || succumbingTown.getMayor().isNPC()) {
            throw new TownyException(Translatable.of("msg_town_merge_other_offline", succumbingTown.getName(), succumbingTown.getMayor().getName()));
        }
    }

    private static void vetTownWouldHaveTooManyTownBlocksOrThrow(Town remainingTown, Town succumbingTown, int newResidentsAmount) throws TownyException {
        int newTownBonus = TownySettings.getNewTownBonusBlocks();
        int succumbingTownTBAmount = succumbingTown.getNumTownBlocks();
        if (newTownBonus > 0 && succumbingTown.getBonusBlocks() >= newTownBonus) {
            succumbingTownTBAmount -= newTownBonus;
        }
        int succumbingBonusBlocks = succumbingTown.getBonusBlocks() + 2 * newTownBonus;
        int succumbingPurchasedBlocks = succumbingTown.getPurchasedBlocks();
        int maxAllowedTownBlocks = TownySettings.getMaxTownBlocks(remainingTown, newResidentsAmount) + succumbingBonusBlocks + succumbingPurchasedBlocks;
        if (remainingTown.getNumTownBlocks() + succumbingTownTBAmount > maxAllowedTownBlocks) {
            throw new TownyException(Translatable.of("msg_town_merge_err_too_many_townblocks", maxAllowedTownBlocks));
        }
    }

    private static double[] getMergeCosts(Town remainingTown, Town succumbingTown, boolean admin) throws TownyException {
        double[] mergeCost = new double[]{TownySettings.getBaseCostForTownMerge(), 0.0, 0.0, 0.0};
        if (admin || !TownyEconomyHandler.isActive()) {
            return mergeCost;
        }
        mergeCost[1] = remainingTown.getTownBlockCostN(succumbingTown.getNumTownBlocks()) * ((double)TownySettings.getPercentageCostPerPlot() * 0.01);
        if (succumbingTown.isBankrupt()) {
            mergeCost[2] = Math.abs(succumbingTown.getAccount().getHoldingBalance());
        }
        if (succumbingTown.getPurchasedBlocks() > 0 && TownySettings.getPurchasedBonusBlocksIncreaseValue() != 1.0) {
            int purchasedBlocks = succumbingTown.getPurchasedBlocks();
            double priceAlreadyPaid = MoneyUtil.returnPurchasedBlocksCost(0, purchasedBlocks, succumbingTown);
            mergeCost[3] = remainingTown.getBonusBlockCostN(purchasedBlocks) - priceAlreadyPaid;
        }
        double cost = Arrays.stream(mergeCost).sum();
        if (!remainingTown.getAccount().canPayFromHoldings(cost)) {
            throw new TownyException(Translatable.of("msg_town_merge_err_not_enough_money", TownCommand.prettyMoney(remainingTown.getAccount().getHoldingBalance()), TownCommand.prettyMoney(cost)));
        }
        return mergeCost;
    }

    private static void sendTownMergeRequest(CommandSender sender, Town remainingTown, Town succumbingTown, double cost) {
        TownyMessaging.sendMsg(sender, Translatable.of("msg_town_merge_request_sent", succumbingTown.getName()));
        TownyMessaging.sendMsg(succumbingTown.getMayor(), Translatable.of("msg_town_merge_request_received", remainingTown.getName(), sender.getName(), remainingTown.getName()));
        Confirmation.runOnAccept(() -> {
            try {
                TownCommand.vetTownsForMergeAndThrow(remainingTown, succumbingTown);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
                return;
            }
            TownPreMergeEvent townPreMergeEvent = new TownPreMergeEvent(remainingTown, succumbingTown);
            if (BukkitTools.isEventCancelled(townPreMergeEvent)) {
                TownyMessaging.sendErrorMsg(succumbingTown.getMayor().getPlayer(), townPreMergeEvent.getCancelMessage());
                TownyMessaging.sendErrorMsg((Object)sender, townPreMergeEvent.getCancelMessage());
                return;
            }
            if (TownyEconomyHandler.isActive() && cost > 0.0 && !remainingTown.getAccount().withdraw(cost, Translation.of("msg_town_merge_cost_withdraw"))) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_town_merge_err_not_enough_money", (int)remainingTown.getAccount().getHoldingBalance(), (int)cost));
                return;
            }
            UUID succumbingTownUUID = succumbingTown.getUUID();
            String succumbingTownName = succumbingTown.getName();
            TownyUniverse.getInstance().getDataSource().mergeTown(remainingTown, succumbingTown);
            TownyMessaging.sendGlobalMessage(Translatable.of("town1_has_merged_with_town2", succumbingTown, remainingTown));
            TownMergeEvent townMergeEvent = new TownMergeEvent(remainingTown, succumbingTownName, succumbingTownUUID);
            BukkitTools.fireEvent(townMergeEvent);
        }).runOnCancel(() -> {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_town_merge_request_denied"));
            TownyMessaging.sendMsg(succumbingTown.getMayor(), Translatable.of("msg_town_merge_cancelled"));
        }).sendTo((CommandSender)BukkitTools.getPlayerExact(succumbingTown.getMayor().getName()));
    }

    public static boolean isEdgeBlock(TownBlockOwner owner, List<WorldCoord> worldCoords) {
        ArrayList<WorldCoord> visited = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : worldCoords) {
            if (!TownCommand.isEdgeBlock(owner, worldCoord, visited)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEdgeBlock(TownBlockOwner owner, WorldCoord worldCoord, List<WorldCoord> visited) {
        for (WorldCoord wc : worldCoord.getCardinallyAdjacentWorldCoords(new boolean[0])) {
            if (visited.contains(wc)) continue;
            if (wc.isWilderness()) {
                visited.add(wc);
                continue;
            }
            if (!wc.getTownBlockOrNull().isOwner(owner)) {
                visited.add(wc);
                continue;
            }
            return true;
        }
        return false;
    }

    private static void townTransaction(Player player, String[] args, boolean withdraw) {
        try {
            int amount;
            if (args.length == 0) {
                throw new TownyException(Translatable.of("msg_must_specify_amnt", withdraw ? "/town withdraw" : "/town deposit"));
            }
            Resident resident = TownCommand.getResidentOrThrow(player);
            Town town = null;
            if (!withdraw && args.length == 2 && !(town = TownCommand.getTownOrThrow(args[1])).hasResident(player)) {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_DEPOSIT_OTHERTOWN.getNode());
            }
            if (town == null && !resident.hasTown()) {
                throw new TownyException(Translatable.of("msg_err_dont_belong_town"));
            }
            if (town == null) {
                town = resident.getTownOrNull();
            }
            if ((amount = "all".equalsIgnoreCase(args[0].trim()) ? (int)Math.floor(withdraw ? town.getAccount().getHoldingBalance() : resident.getAccount().getHoldingBalance()) : MathUtil.getIntOrThrow(args[0].trim())) == 0) {
                throw new TownyException(Translatable.of("msg_err_amount_must_be_greater_than_zero"));
            }
            if (withdraw) {
                MoneyUtil.townWithdraw(player, resident, town, amount);
            } else {
                MoneyUtil.townDeposit(player, resident, town, null, amount);
            }
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
        }
    }

    private static void townOutpost(Player player, String[] args) throws TownyException {
        TownCommand.catchRuinedTown(player);
        if (args.length >= 1) {
            if (args[0].equalsIgnoreCase("list")) {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_OUTPOST_LIST.getNode());
                Town town = TownCommand.getTownFromPlayerOrThrow(player);
                List<Location> outposts = town.getAllOutpostSpawns();
                int page = 1;
                int total = (int)Math.ceil((double)outposts.size() / 10.0);
                if (args.length == 2 && (page = MathUtil.getPositiveIntOrThrow(args[1])) == 0) {
                    throw new TownyException(Translatable.of("msg_error_must_be_int"));
                }
                if (page > total) {
                    throw new TownyException(Translatable.of("LIST_ERR_NOT_ENOUGH_PAGES", total));
                }
                TownyMessaging.sendOutpostList(player, town, page, total);
            } else {
                boolean ignoreWarning = args.length == 1 && args[0].equals("-ignore");
                TownCommand.townSpawn(player, args, true, ignoreWarning);
            }
        } else {
            TownCommand.townSpawn(player, args, true, false);
        }
    }

    private void townStatusScreen(CommandSender sender, Town town) {
        TownyEconomyHandler.economyExecutor().execute(() -> TownyMessaging.sendStatusScreen(sender, TownyFormatter.getStatus(town, sender)));
    }

    private void townResList(CommandSender sender, String[] args) throws TownyException {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (player != null) {
            TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_RESLIST.getNode());
        }
        Town town = null;
        if (args.length == 1 && player != null) {
            TownCommand.catchRuinedTown(player);
            town = TownCommand.getTownFromPlayerOrThrow(player);
        } else if (args.length == 2) {
            town = TownCommand.getTownOrThrow(args[1]);
        }
        if (town == null) {
            throw new TownyException(Translatable.of("msg_specify_name"));
        }
        TownyMessaging.sendMessage((Object)sender, ChatTools.formatTitle(town.getName() + " " + Translatable.of("res_list").forLocale(sender)));
        TownyMessaging.sendMessage((Object)sender, TownyFormatter.getFormattedTownyObjects(Translatable.of("res_list").forLocale(sender), new ArrayList<TownyObject>(town.getResidents())));
    }

    private void townPlotGroupList(CommandSender sender, String[] args) throws TownyException {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (player != null) {
            TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_PLOTGROUPLIST.getNode());
            TownCommand.catchRuinedTown(player);
        }
        Town town = null;
        if (args.length > 1) {
            town = TownCommand.getTownOrThrow(args[1]);
        }
        if (town == null && player != null) {
            town = TownCommand.getTownFromPlayerOrThrow(player);
        }
        if (!town.hasPlotGroups()) {
            throw new TownyException(Translatable.of("msg_err_this_town_has_no_plot_groups"));
        }
        int page = 1;
        int total = (int)Math.ceil((double)town.getPlotGroups().size() / 10.0);
        if (args.length > 1 && (page = MathUtil.getPositiveIntOrThrow(args[args.length - 1])) == 0) {
            throw new TownyException(Translatable.of("msg_error_must_be_int"));
        }
        if (page > total) {
            throw new TownyException(Translatable.of("LIST_ERR_NOT_ENOUGH_PAGES", total));
        }
        TownyMessaging.sendPlotGroupList(sender, town, page, total);
    }

    private void townOutlawList(CommandSender sender, String[] args) throws TownyException {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        Town town = null;
        if (args.length == 1 && player != null) {
            TownCommand.catchRuinedTown(player);
            town = TownCommand.getTownFromPlayerOrThrow(player);
        } else if (args.length == 2) {
            town = TownCommand.getTownOrThrow(args[1]);
        }
        TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedTownyObjects(Translatable.of("outlaws").forLocale(sender), new ArrayList<TownyObject>(town.getOutlaws())));
    }

    public static void parseTownTrustCommand(CommandSender sender, String[] args, @Nullable Town town) throws TownyException {
        if (args.length < 1) {
            HelpMenu.TOWN_TRUST_HELP.send(sender);
            return;
        }
        if (town == null && sender instanceof Player) {
            Player player = (Player)sender;
            town = TownCommand.getTownFromPlayerOrThrow(player);
            TownCommand.catchRuinedTown(player);
        }
        if (args[0].equalsIgnoreCase("list")) {
            TownCommand.parseTownTrustListCommand(sender, town);
            return;
        }
        if (args.length < 2) {
            HelpMenu.TOWN_TRUST_HELP.send(sender);
            return;
        }
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_TRUST.getNode());
        Resident resident = TownCommand.getResidentOrThrow(args[1]);
        TownCommand.catchNPCResident(resident);
        switch (args[0].toLowerCase(Locale.ROOT)) {
            case "add": {
                TownCommand.parseTownTrustAddCommand(sender, town, resident);
                break;
            }
            case "remove": {
                TownCommand.parseTownTrustRemoveCommand(sender, town, resident);
                break;
            }
            default: {
                HelpMenu.TOWN_TRUST_HELP.send(sender);
            }
        }
    }

    private static void parseTownTrustListCommand(CommandSender sender, Town town) {
        List<String> output = town.getTrustedResidents().isEmpty() ? Collections.singletonList(Translatable.of("status_no_town").forLocale(sender)) : town.getTrustedResidents().stream().map(TownyObject::getName).collect(Collectors.toList());
        TownyMessaging.sendMessage((Object)sender, TownyFormatter.getFormattedStrings(Translatable.of("status_trustedlist").forLocale(sender), output));
    }

    private static void parseTownTrustAddCommand(CommandSender sender, Town town, Resident resident) throws TownyException {
        if (town.hasTrustedResident(resident)) {
            throw new TownyException(Translatable.of("msg_already_trusted", resident.getName(), Translatable.of("town_sing")));
        }
        if (town.hasOutlaw(resident)) {
            throw new TownyException(Translatable.of("msg_err_you_cannot_add_trust_on_outlaw"));
        }
        if (resident.hasNation() && town.hasNation() && town.getNationOrNull().hasEnemy(resident.getNationOrNull())) {
            throw new TownyException(Translatable.of("msg_err_you_cannot_add_trust_on_enemy"));
        }
        BukkitTools.ifCancelledThenThrow(new TownTrustAddEvent(sender, resident, town));
        town.addTrustedResident(resident);
        town.save();
        plugin.deleteCache(resident);
        TownyMessaging.sendMsg(sender, Translatable.of("msg_trusted_added", resident.getName(), Translatable.of("town_sing")));
        if (resident.isOnline()) {
            String string;
            Object[] objectArray = new Object[3];
            if (sender instanceof Player) {
                Player player = (Player)sender;
                string = player.getName();
            } else {
                string = "Console";
            }
            objectArray[0] = string;
            objectArray[1] = Translatable.of("town_sing");
            objectArray[2] = town.getName();
            TownyMessaging.sendMsg(resident, Translatable.of("msg_trusted_added_2", objectArray));
        }
    }

    private static void parseTownTrustRemoveCommand(CommandSender sender, Town town, Resident resident) throws TownyException {
        if (!town.hasTrustedResident(resident)) {
            throw new TownyException(Translatable.of("msg_not_trusted", resident.getName(), Translatable.of("town_sing")));
        }
        BukkitTools.ifCancelledThenThrow(new TownTrustRemoveEvent(sender, resident, town));
        town.removeTrustedResident(resident);
        town.save();
        plugin.deleteCache(resident);
        TownyMessaging.sendMsg(sender, Translatable.of("msg_trusted_removed", resident.getName(), Translatable.of("town_sing")));
        if (resident.isOnline()) {
            String string;
            Object[] objectArray = new Object[3];
            if (sender instanceof Player) {
                Player player = (Player)sender;
                string = player.getName();
            } else {
                string = "Console";
            }
            objectArray[0] = string;
            objectArray[1] = Translatable.of("town_sing");
            objectArray[2] = town.getName();
            TownyMessaging.sendMsg(resident, Translatable.of("msg_trusted_removed_2", objectArray));
        }
    }

    public static void parseTownTrustTownCommand(CommandSender sender, String[] args, @Nullable Town town) throws TownyException {
        if (args.length < 1) {
            HelpMenu.TOWN_TRUSTTOWN_HELP.send(sender);
            return;
        }
        if (town == null && sender instanceof Player) {
            Player player = (Player)sender;
            town = TownCommand.getTownFromPlayerOrThrow(player);
            TownCommand.catchRuinedTown(player);
        }
        if ("list".equalsIgnoreCase(args[0])) {
            TownyMessaging.sendMessage((Object)sender, TownyFormatter.getFormattedTownyObjects(Translatable.of("status_trustedlist").forLocale(sender), new ArrayList<TownyObject>(town.getTrustedTowns())));
            return;
        }
        if (args.length < 2) {
            HelpMenu.TOWN_TRUSTTOWN_HELP.send(sender);
            return;
        }
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_TRUSTTOWN.getNode());
        Town trustTown = TownCommand.getTownOrThrow(args[1]);
        switch (args[0].toLowerCase(Locale.ROOT)) {
            case "add": {
                TownCommand.parseTownTrustTownAddCommand(sender, town, trustTown);
                break;
            }
            case "remove": {
                TownCommand.parseTownTrustTownRemoveCommand(sender, town, trustTown);
                break;
            }
            default: {
                HelpMenu.TOWN_TRUSTTOWN_HELP.send(sender);
            }
        }
    }

    private static void parseTownTrustTownAddCommand(CommandSender sender, Town town, Town trustTown) throws TownyException {
        if (town.hasTrustedTown(trustTown)) {
            throw new TownyException(Translatable.of("msg_already_trusted", trustTown.getName(), Translatable.of("town_sing")));
        }
        if (trustTown.getResidents().stream().filter(res -> town.hasOutlaw((Resident)res)).findAny().isPresent()) {
            throw new TownyException(Translatable.of("msg_err_you_cannot_add_towntrust_on_outlaw"));
        }
        if (trustTown.hasNation() && town.hasNation() && town.getNationOrNull().hasEnemy(trustTown.getNationOrNull())) {
            throw new TownyException(Translatable.of("msg_err_you_cannot_add_towntrust_on_enemy"));
        }
        if (town == trustTown) {
            throw new TownyException(Translatable.of("msg_cannot_trust_your_own_town"));
        }
        BukkitTools.ifCancelledThenThrow(new TownTrustTownAddEvent(sender, trustTown, town));
        Confirmation.runOnAccept(() -> {
            town.addTrustedTown(trustTown);
            town.save();
            TownyMessaging.sendMsg(sender, Translatable.of("msg_trusted_added", trustTown.getName(), Translatable.of("town_sing")));
            trustTown.getResidents().forEach(res -> plugin.deleteCache((Resident)res));
        }).setTitle(Translatable.of("confirmation_msg_trusttown_consequences")).sendTo(sender);
    }

    private static void parseTownTrustTownRemoveCommand(CommandSender sender, Town town, Town trustTown) throws TownyException {
        if (!town.hasTrustedTown(trustTown)) {
            throw new TownyException(Translatable.of("msg_not_trusted", trustTown.getName(), Translatable.of("town_sing")));
        }
        BukkitTools.ifCancelledThenThrow(new TownTrustTownRemoveEvent(sender, trustTown, town));
        town.removeTrustedTown(trustTown);
        town.save();
        trustTown.getResidents().forEach(res -> plugin.deleteCache((Resident)res));
        TownyMessaging.sendMsg(sender, Translatable.of("msg_trusted_removed", trustTown.getName(), Translatable.of("town_sing")));
    }

    public static List<String> getTrustedResidentsFromResident(Player player) {
        Resident res = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (res != null && res.hasTown()) {
            return res.getTownOrNull().getTrustedResidents().stream().map(TownyObject::getName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<String> getTrustedTownsFromResident(Player player) {
        Resident res = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (res != null && res.hasTown()) {
            return res.getTownOrNull().getTrustedTowns().stream().map(TownyObject::getName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static int homeBlockDistance(Town town1, Town town2) {
        if (!town1.hasHomeBlock() || !town2.hasHomeBlock()) {
            return Integer.MAX_VALUE;
        }
        return (int)MathUtil.distance(town1.getHomeBlockOrNull().getCoord(), town2.getHomeBlockOrNull().getCoord());
    }

    private void parseTownForSaleCommand(Player player, String[] args) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_FORSALE.getNode());
        if (args.length == 0) {
            throw new TownyException(Translatable.of("msg_error_must_be_num"));
        }
        double forSalePrice = Math.min(MathUtil.getPositiveDoubleOrThrow(args[0]), TownySettings.maxBuyTownPrice());
        Town town = TownCommand.getTownFromPlayerOrThrow(player);
        Confirmation.runOnAccept(() -> {
            TownCommand.setTownForSale(town, forSalePrice, false);
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_forsale", town.getName(), TownCommand.prettyMoney(forSalePrice)));
        }).setTitle(Translatable.of("msg_town_sell_confirmation", TownCommand.prettyMoney(forSalePrice))).sendTo((CommandSender)player);
    }

    private void parseTownNotForSaleCommand(Player player) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_NOTFORSALE.getNode());
        Town town = TownCommand.getTownFromPlayerOrThrow(player);
        if (!town.isForSale()) {
            throw new TownyException(Translatable.of("msg_town_buytown_not_forsale"));
        }
        TownCommand.setTownNotForSale(town, false);
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_notforsale", town.getName()));
    }

    public static void setTownForSale(Town town, double price, boolean admin, long time) {
        if (town != null) {
            town.setForSale(true);
            town.setForSalePrice(price);
            town.setForSaleTime(time);
            town.save();
        }
    }

    public static void setTownForSale(Town town, double price, boolean admin) {
        TownCommand.setTownForSale(town, price, admin, System.currentTimeMillis());
    }

    public static void setTownNotForSale(Town town, boolean admin) {
        if (town != null) {
            town.setForSale(false);
            town.save();
        }
    }

    private void parseTownBuyTownCommand(CommandSender sender, String[] args) throws TownyException {
        TownCommand.catchConsole(sender);
        Player player = (Player)sender;
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_BUYTOWN.getNode());
        if (args.length == 0) {
            throw new TownyException(Translatable.of("msg_specify_name"));
        }
        Town town = TownCommand.getTownOrThrow(args[0]);
        if (!town.isForSale()) {
            throw new TownyException(Translatable.of("msg_town_buytown_not_forsale"));
        }
        if (town.isRuined()) {
            throw new TownyException("msg_town_buytown_ruined");
        }
        Resident resident = TownCommand.getResidentOrThrow(player);
        if (resident.isMayor()) {
            throw new TownyException(Translatable.of("msg_mayor_abandon"));
        }
        Confirmation.runOnAccept(() -> {
            if (!town.isForSale()) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_town_buytown_not_forsale"));
                return;
            }
            Resident currentMayor = town.getMayor();
            if (resident.equals(currentMayor)) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_town_buytown_already_mayor", resident.getTownOrNull().getName()));
                return;
            }
            if (resident.isMayor()) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_mayor_abandon"));
                return;
            }
            if (!resident.getAccount().withdraw(town.getForSalePrice(), "Town purchase cost.")) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_you_need_x_to_pay", town.getForSalePrice()));
                return;
            }
            try {
                if (resident.hasTown()) {
                    resident.removeTown();
                }
                TownCommand.townAddResident(town, resident);
                town.setMayor(resident);
            }
            catch (AlreadyRegisteredException e) {
                town.setMayor(resident);
            }
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_new_mayor", resident.getName()));
            if (currentMayor != null) {
                currentMayor.getAccount().deposit(town.getForSalePrice(), "Payment for town sale");
            }
            town.setForSale(false);
            town.save();
        }).setTitle(Translatable.of("msg_town_buytown_confirmation", town.getName(), TownCommand.prettyMoney(town.getForSalePrice()))).setCancellableEvent(new TownPreAddResidentEvent(town, resident)).sendTo((CommandSender)player);
    }

    static {
        townTabCompletes = Arrays.asList("add", "allylist", "baltop", "buytown", "ban", "bankhistory", "buy", "cede", "claim", "create", "deposit", "delete", "enemylist", "forsale", "fs", "here", "invite", "jail", "join", "kick", "leave", "list", "mayor", "merge", "new", "nfs", "notforsale", "online", "outpost", "outlaw", "outlawlist", "plotgrouplist", "plots", "purge", "rank", "ranklist", "reclaim", "reslist", "say", "set", "spawn", "takeoverclaim", "toggle", "trust", "trusttown", "unclaim", "unjail", "withdraw");
        townSetTabCompletes = Arrays.asList("board", "mayor", "homeblock", "spawn", "spawncost", "mapcolor", "name", "outpost", "perm", "tag", "taxes", "plottax", "plotprice", "shopprice", "shoptax", "embassyprice", "embassytax", "title", "surname", "taxpercentcap", "primaryjail");
        townListTabCompletes = Arrays.asList("residents", "balance", "bankrupt", "forsale", "founded", "name", "online", "open", "public", "ruined", "townblocks", "upkeep");
        townToggleTabCompletes = Arrays.asList("explosion", "fire", "mobs", "nationzone", "neutral", "peaceful", "public", "pvp", "taxpercent", "open");
        townConsoleTabCompletes = Arrays.asList("?", "help", "list", "reslist");
        townAddRemoveTabCompletes = Arrays.asList("add", "remove");
        townClaimTabCompletes = Arrays.asList("outpost", "auto", "circle", "rect", "fill");
        townUnclaimTabCompletes = Arrays.asList("circle", "rect", "all");
        townInviteTabCompletes = Arrays.asList("sent", "received", "accept", "deny");
        townSetBoardTabCompletes = Arrays.asList("none", "reset");
    }
}

