/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyAsciiMap;
import com.palmergames.bukkit.towny.TownyCommandAddonAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.TownyUpdateChecker;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.hooks.PluginIntegrations;
import com.palmergames.bukkit.towny.huds.HUDManager;
import com.palmergames.bukkit.towny.object.BuildInfo;
import com.palmergames.bukkit.towny.object.Government;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownBlockTypeHandler;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.Translator;
import com.palmergames.bukkit.towny.object.comparators.GovernmentComparators;
import com.palmergames.bukkit.towny.object.gui.SelectionGUI;
import com.palmergames.bukkit.towny.object.resident.mode.ResidentModeHandler;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.utils.NameUtil;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.util.StringMgmt;
import com.palmergames.util.TimeMgmt;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class TownyCommand
extends BaseCommand
implements CommandExecutor {
    private final Towny plugin;
    private static final List<String> townyTabCompletes = Arrays.asList("map", "prices", "time", "top", "spy", "universe", "version", "v", "tree", "switches", "itemuse", "allowedblocks", "wildsblocks", "plotclearblocks");
    private static final List<String> townyTopTabCompletes = Arrays.asList("residents", "land", "balance");
    private static final List<String> townyTopTownNationCompletes = Arrays.asList("all", "town", "nation");
    private static final List<String> townyTopLandTabCompletes = Arrays.asList("all", "resident", "town");

    public TownyCommand(Towny instance) {
        this.plugin = instance;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (this.plugin.isError()) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_safe_mode"));
            return true;
        }
        this.parseTownyCommand(sender, args);
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        switch (args[0].toLowerCase(Locale.ROOT)) {
            case "top": {
                switch (args.length) {
                    case 2: {
                        return NameUtil.filterByStart(townyTopTabCompletes, args[1]);
                    }
                    case 3: {
                        switch (args[1].toLowerCase(Locale.ROOT)) {
                            case "residents": 
                            case "balance": {
                                return NameUtil.filterByStart(townyTopTownNationCompletes, args[2]);
                            }
                            case "land": {
                                return NameUtil.filterByStart(townyTopLandTabCompletes, args[2]);
                            }
                        }
                        return Collections.emptyList();
                    }
                }
                return Collections.emptyList();
            }
            case "map": {
                if (args.length != 2) break;
                return NameUtil.filterByStart(Arrays.asList("big", "hud"), args[1]);
            }
            default: {
                if (args.length == 1) {
                    return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.TOWNY, townyTabCompletes), args[0]);
                }
                if (!TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWNY, args[0])) break;
                return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWNY, args[0]).getTabCompletion(sender, args), args[args.length - 1]);
            }
        }
        return Collections.emptyList();
    }

    private void parseTownyCommand(CommandSender sender, String[] split) {
        if (split.length == 0) {
            if (TownyUniverse.getInstance().getPermissionSource().isTownyAdmin((Permissible)sender)) {
                HelpMenu.GENERAL_HELP_ADMIN.send(sender);
            } else {
                HelpMenu.GENERAL_HELP.send(sender);
            }
            return;
        }
        if (split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.HELP.send(sender);
            return;
        }
        Player player = null;
        TownyWorld world = null;
        if (sender instanceof Player) {
            player = (Player)sender;
            world = TownyAPI.getInstance().getTownyWorld(player.getWorld());
        }
        try {
            switch (split[0].toLowerCase(Locale.ROOT)) {
                case "map": {
                    TownyCommand.catchConsole(sender);
                    TownyCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNY_MAP.getNode());
                    if (split.length > 1 && split[1].equalsIgnoreCase("big")) {
                        TownyAsciiMap.generateAndSend(this.plugin, player, 18);
                        break;
                    }
                    if (split.length > 1 && split[1].equalsIgnoreCase("hud")) {
                        HUDManager.toggleMapHud(player);
                        break;
                    }
                    TownyCommand.showMap(player);
                    break;
                }
                case "prices": {
                    Object resident;
                    Town town = null;
                    if (!TownyEconomyHandler.isActive()) {
                        throw new TownyException(Translatable.of("msg_err_no_economy"));
                    }
                    if (split.length > 1) {
                        town = TownyCommand.getTownOrThrow(split[1]);
                    } else if (player != null && (resident = TownyAPI.getInstance().getResident(player)) != null) {
                        town = ((Resident)resident).getTownOrNull();
                    }
                    for (String line : this.getTownyPrices(town, Translator.locale(sender))) {
                        TownyMessaging.sendMessage((Object)sender, line);
                    }
                    break;
                }
                case "switches": {
                    TownyCommand.catchConsole(sender);
                    if (world == null || !world.isUsingTowny()) {
                        throw new TownyException(Translatable.of("msg_err_usingtowny_disabled"));
                    }
                    Resident resident = TownyCommand.getResidentOrThrow(player);
                    ResidentUtil.openSelectionGUI(resident, SelectionGUI.SelectionType.SWITCHES);
                    break;
                }
                case "itemuse": {
                    TownyCommand.catchConsole(sender);
                    if (world == null || !world.isUsingTowny()) {
                        throw new TownyException(Translatable.of("msg_err_usingtowny_disabled"));
                    }
                    Resident resident = TownyCommand.getResidentOrThrow(player);
                    ResidentUtil.openSelectionGUI(resident, SelectionGUI.SelectionType.ITEMUSE);
                    break;
                }
                case "allowedblocks": {
                    TownyCommand.catchConsole(sender);
                    if (world == null || !world.isUsingTowny()) {
                        throw new TownyException(Translatable.of("msg_err_usingtowny_disabled"));
                    }
                    Resident resident = TownyCommand.getResidentOrThrow(player);
                    ResidentUtil.openSelectionGUI(resident, SelectionGUI.SelectionType.ALLOWEDBLOCKS);
                    break;
                }
                case "wildsblocks": {
                    TownyCommand.catchConsole(sender);
                    if (world == null || !world.isUsingTowny()) {
                        throw new TownyException(Translatable.of("msg_err_usingtowny_disabled"));
                    }
                    Resident resident = TownyCommand.getResidentOrThrow(player);
                    ResidentUtil.openGUIInventory(resident, world.getUnclaimedZoneIgnoreMaterials(), Translatable.of("gui_title_towny_wildsblocks").forLocale((CommandSender)player));
                    break;
                }
                case "plotclearblocks": {
                    TownyCommand.catchConsole(sender);
                    if (world == null || !world.isUsingTowny()) {
                        throw new TownyException(Translatable.of("msg_err_usingtowny_disabled"));
                    }
                    Resident resident = TownyCommand.getResidentOrThrow(player);
                    ResidentUtil.openGUIInventory(resident, world.getPlotManagementMayorDelete(), Translatable.of("gui_title_towny_plotclear").forLocale((CommandSender)player));
                    break;
                }
                case "top": {
                    this.parseTopCommand(sender, StringMgmt.remFirstArg(split));
                    break;
                }
                case "tree": {
                    TownyCommand.catchPlayer(sender);
                    TownyCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNY_TREE.getNode());
                    for (String line : TownyUniverse.getInstance().getTreeString(0)) {
                        TownyMessaging.sendMessage((Object)sender, line);
                    }
                    break;
                }
                case "time": {
                    TownyCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNY_TIME.getNode());
                    TownyMessaging.sendMsg(sender, Translatable.of("msg_time_until_a_new_day").append(TimeMgmt.formatCountdownTime(TimeMgmt.townyTime(true))));
                    break;
                }
                case "universe": {
                    TownyCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNY_UNIVERSE.getNode());
                    for (String line : this.getUniverseStats(Translator.locale(sender))) {
                        TownyMessaging.sendMessage((Object)sender, line);
                    }
                    break;
                }
                case "version": 
                case "v": {
                    TownyCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNY_VERSION.getNode());
                    if (TownyUpdateChecker.shouldShowNotification()) {
                        TownyMessaging.sendMsg(sender, Translatable.of("msg_latest_version", this.plugin.getVersion(), TownyUpdateChecker.getNewVersion()));
                        break;
                    }
                    TownyMessaging.sendMsg(sender, Translatable.of("msg_towny_version", this.plugin.getVersion()));
                    try {
                        BuildInfo buildInfo = BuildInfo.retrieveBuildInfo(this.plugin);
                        String repositoryUrl = buildInfo.repositoryUrl();
                        if (repositoryUrl.endsWith(".git")) {
                            repositoryUrl = repositoryUrl.substring(0, repositoryUrl.length() - ".git".length());
                        }
                        String viewCommitUrl = repositoryUrl + "/commit/" + buildInfo.commit();
                        Component buildInfoMessage = Translatable.of("default_towny_prefix").append(Translatable.of("msg_version_build_info", buildInfo.commitShort(), buildInfo.branch()).component(Translation.getLocale(sender)).clickEvent(viewCommitUrl.startsWith("http") ? ClickEvent.openUrl((String)viewCommitUrl) : null).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)buildInfo.message(), (TextColor)NamedTextColor.GREEN)))).component(Translation.getLocale(sender));
                        sender.sendMessage(buildInfoMessage);
                    }
                    catch (IOException e) {
                        this.plugin.getLogger().log(Level.WARNING, "Could not retrieve build information", e);
                        TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_version_build_info_failed"));
                    }
                    if (TownyUpdateChecker.hasCheckedSuccessfully()) {
                        TownyMessaging.sendMsg(sender, Translatable.of("msg_up_to_date"));
                    }
                    break;
                }
                case "spy": {
                    TownyCommand.catchConsole(sender);
                    ResidentModeHandler.toggleMode(TownyCommand.getResidentOrThrow(player), "spy", true);
                    break;
                }
                default: {
                    if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWNY, split[0])) {
                        TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWNY, split[0]).execute(sender, "towny", split);
                        break;
                    }
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_sub"));
                }
            }
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
        }
    }

    private void parseTopCommand(CommandSender sender, String[] args) throws TownyException {
        ArrayList<String> townyTop = new ArrayList<String>();
        TownyUniverse universe = TownyUniverse.getInstance();
        if (args.length == 0 || args[0].equalsIgnoreCase("?")) {
            HelpMenu.TOWNY_TOP_HELP.send(sender);
            return;
        }
        if (args[0].equalsIgnoreCase("residents")) {
            TownyCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNY_TOP_RESIDENTS.getNode());
            if (args.length == 1 || args[1].equalsIgnoreCase("all")) {
                list = universe.getTowns().stream().filter(Town::isVisibleOnTopLists).collect(Collectors.toList());
                list.addAll(universe.getNations());
                townyTop.add(ChatTools.formatTitle("Most Residents"));
                townyTop.addAll(this.getMostResidents(list));
            } else if (args[1].equalsIgnoreCase("town")) {
                townyTop.add(ChatTools.formatTitle("Most Residents in a Town"));
                townyTop.addAll(this.getMostResidents(universe.getTowns().stream().filter(Town::isVisibleOnTopLists).collect(Collectors.toList())));
            } else if (args[1].equalsIgnoreCase("nation")) {
                townyTop.add(ChatTools.formatTitle("Most Residents in a Nation"));
                townyTop.addAll(this.getMostResidents(new ArrayList<ResidentList>(universe.getNations())));
            } else {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_sub"));
            }
        } else if (args[0].equalsIgnoreCase("land")) {
            TownyCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNY_TOP_LAND.getNode());
            if (args.length == 1 || args[1].equalsIgnoreCase("all")) {
                list = new ArrayList<Resident>(universe.getResidents());
                list.addAll(universe.getTowns().stream().filter(Town::isVisibleOnTopLists).collect(Collectors.toList()));
                townyTop.add(ChatTools.formatTitle("Most Land Owned"));
                townyTop.addAll(this.getMostLand(list));
            } else if (args[1].equalsIgnoreCase("resident")) {
                townyTop.add(ChatTools.formatTitle("Most Land Owned by Resident"));
                townyTop.addAll(this.getMostLand(new ArrayList<TownBlockOwner>(universe.getResidents())));
            } else if (args[1].equalsIgnoreCase("town")) {
                townyTop.add(ChatTools.formatTitle("Most Land Owned by Town"));
                townyTop.addAll(this.getMostLand(universe.getTowns().stream().filter(Town::isVisibleOnTopLists).collect(Collectors.toList())));
            } else {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_sub"));
            }
        } else {
            if (args[0].equalsIgnoreCase("balance")) {
                TownyCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNY_TOP_BALANCE.getNode());
                this.plugin.getScheduler().runAsync(() -> {
                    if (args.length == 1 || args[1].equalsIgnoreCase("all")) {
                        list = new ArrayList<Nation>();
                        list.addAll(universe.getTowns().stream().filter(Town::isVisibleOnTopLists).collect(Collectors.toList()));
                        list.addAll(universe.getNations());
                        townyTop.add(ChatTools.formatTitle("Top Bank Balances"));
                        townyTop.addAll(this.getTopBankBalance(list));
                    } else if (args[1].equalsIgnoreCase("town")) {
                        list = universe.getTowns().stream().filter(Town::isVisibleOnTopLists).collect(Collectors.toList());
                        townyTop.add(ChatTools.formatTitle("Top Bank Balances by Town"));
                        townyTop.addAll(this.getTopBankBalance(list));
                    } else if (args[1].equalsIgnoreCase("nation")) {
                        list = new ArrayList<Nation>(universe.getNations());
                        townyTop.add(ChatTools.formatTitle("Top Bank Balances by Nation"));
                        townyTop.addAll(this.getTopBankBalance(list));
                    } else {
                        TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_sub"));
                    }
                    for (String line : townyTop) {
                        TownyMessaging.sendMessage((Object)sender, line);
                    }
                });
                return;
            }
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_sub"));
        }
        for (String line : townyTop) {
            TownyMessaging.sendMessage((Object)sender, line);
        }
    }

    public List<String> getUniverseStats(Translator translator) {
        String heart1 = "\u00a70-\u00a74###\u00a70---\u00a74###\u00a70-   ";
        String heart2 = "\u00a74#\u00a7c###\u00a74#\u00a70-\u00a74#\u00a7c###\u00a74#\u00a70   ";
        String heart3 = "\u00a74#\u00a7c####\u00a74#\u00a7c####\u00a74#   ";
        String heart4 = "\u00a70-\u00a74#\u00a7c#######\u00a74#\u00a70-";
        String heart5 = "\u00a70--\u00a74##\u00a7c###\u00a74##\u00a70--   ";
        String heart6 = "\u00a70----\u00a74#\u00a7c#\u00a74#\u00a70----   ";
        String heart7 = "\u00a70-----\u00a74#\u00a70-----   ";
        String splitter = "\u00a78 | ";
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        ArrayList<String> output = new ArrayList<String>();
        output.add("");
        output.add(heart1 + "\u00a76[\u00a7eTowny \u00a72" + this.plugin.getVersion() + "\u00a76]");
        output.add(heart2 + "\u00a73" + translator.of("msg_universe_attribution") + "\u00a7bLlmDl, Warrior, ElgarL, Chris H (Shade)");
        output.add(heart3 + "\u00a7b" + translator.of("msg_universe_contributors") + "\u00a7c" + translator.of("msg_universe_heart"));
        output.add(heart4);
        output.add(heart5 + "\u00a73" + translator.of("res_list") + ": \u00a7b" + townyUniverse.getNumResidents() + splitter + "\u00a73" + translator.of("town_plu") + ": \u00a7b" + townyUniverse.getTowns().size() + splitter + "\u00a73" + translator.of("nation_plu") + ": \u00a7b" + townyUniverse.getNumNations());
        output.add(heart6 + "\u00a73" + translator.of("world_plu") + ": \u00a7b" + townyUniverse.getTownyWorlds().size() + splitter + "\u00a73" + translator.of("townblock_plu") + ": \u00a7b" + townyUniverse.getTownBlocks().size());
        output.add(heart7 + "\u00a7ahttps://TownyAdvanced.github.io/");
        output.add("");
        String townyPlugins = "";
        List<String> pluginList = PluginIntegrations.getInstance().getTownyPluginsForUniverseCommand();
        townyPlugins = String.join((CharSequence)" ", pluginList);
        if (pluginList.size() > 0) {
            output.add("\u00a76[" + townyPlugins + "\u00a76]");
        }
        return output;
    }

    public static void showMap(Player player) {
        TownyAsciiMap.generateAndSend(Towny.getPlugin(), player, TownySettings.asciiMapHeight());
    }

    public List<String> getTownyPrices(Town town, Translator translator) {
        ArrayList<String> output = new ArrayList<String>();
        Nation nation = null;
        if (town != null && town.hasNation()) {
            nation = town.getNationOrNull();
        }
        output.add(ChatTools.formatTitle(translator.of("towny_prices_title")));
        output.add(translator.of("towny_prices_town_nation", TownyCommand.prettyMoney(TownySettings.getNewTownPrice()), TownyCommand.prettyMoney(TownySettings.getNewNationPrice())));
        output.add(translator.of("towny_prices_reclaim", TownyCommand.prettyMoney(TownySettings.getEcoPriceReclaimTown())));
        if (town != null) {
            output.add(translator.of("towny_prices_upkeep", TownyCommand.prettyMoney(TownySettings.getTownUpkeepCost(town)), TownyCommand.prettyMoney(TownySettings.getNationUpkeepCost(nation))));
            output.add(translator.of("towny_prices_upkeep_based_on", TownySettings.isUpkeepByPlot() ? translator.of("towny_prices_upkeep_num_plots") : translator.of("towny_prices_upkeep_town_level")));
            String upkeepformula = TownySettings.isNationUpkeepPerPlot() ? translator.of("towny_prices_upkeep_num_plots") : (TownySettings.isNationUpkeepPerTown() ? translator.of("towny_prices_upkeep_num_towns") : translator.of("towny_prices_upkeep_nation_level"));
            output.add(translator.of("towny_prices_nation_upkeep_based_on", upkeepformula));
            if (town.isOverClaimed() && TownySettings.getUpkeepPenalty() > 0.0) {
                output.add(translator.of("towny_prices_overclaimed_upkeep", TownyCommand.prettyMoney(TownySettings.getTownPenaltyUpkeepCost(town))));
            }
            if (TownySettings.getUpkeepPenalty() > 0.0) {
                output.add(translator.of("towny_prices_overclaimed_based_on", TownySettings.isUpkeepPenaltyByPlot() ? translator.of("towny_prices_overclaimed_num_plots") : translator.of("towny_prices_overclaimed_flat_cost"), TownySettings.getUpkeepPenalty()));
            }
            output.add(translator.of("towny_prices_town_merge", TownyCommand.prettyMoney(TownySettings.getBaseCostForTownMerge()), TownyCommand.prettyMoney(town.getTownBlockCost() / 2.0)));
            output.add(translator.of("towny_prices_claiming_townblock", TownyCommand.prettyMoney(town.getTownBlockCost()) + (Double.valueOf(TownySettings.getClaimPriceIncreaseValue()).equals(1.0) ? "" : translator.of("towny_prices_claiming_townblock_increase", new DecimalFormat("##.##%").format(TownySettings.getClaimPriceIncreaseValue() - 1.0)))));
            output.add(translator.of("towny_prices_claiming_outposts", TownyCommand.prettyMoney(TownySettings.getOutpostCost())));
            if (TownySettings.getPerOutpostUpkeepCost() > 0.0) {
                output.add(translator.of("towny_prices_outposts_upkeept", TownyCommand.prettyMoney(TownySettings.getPerOutpostUpkeepCost())));
            }
        }
        if (town == null) {
            output.add(translator.of("towny_prices_upkeep", TownyCommand.prettyMoney(TownySettings.getTownUpkeep()), TownyCommand.prettyMoney(TownySettings.getNationUpkeep())));
        }
        if (town != null) {
            output.add(translator.of("towny_prices_townname", town.getFormattedName()));
            output.add(translator.of("towny_prices_price_plot", TownyCommand.prettyMoney(town.getPlotPrice()), TownyCommand.prettyMoney(TownySettings.getOutpostCost())));
            output.add(translator.of("towny_prices_price_shop", TownyCommand.prettyMoney(town.getCommercialPlotPrice()), TownyCommand.prettyMoney(town.getEmbassyPlotPrice())));
            output.add(translator.of("towny_prices_taxes_plot", town.isTaxPercentage() ? town.getTaxes() + "%" : TownyCommand.prettyMoney(town.getTaxes()), TownyCommand.prettyMoney(town.getPlotTax())));
            output.add(translator.of("towny_prices_taxes_shop", TownyCommand.prettyMoney(town.getCommercialPlotTax()), TownyCommand.prettyMoney(town.getEmbassyPlotTax())));
            output.add(translator.of("towny_prices_town_neutral_tax", TownyCommand.prettyMoney(TownySettings.getTownNeutralityCost(town))));
            output.add(translator.of("towny_prices_plots"));
            ArrayList<TownBlockType> townBlockTypes = new ArrayList<TownBlockType>(TownBlockTypeHandler.getTypes().values());
            for (int i = 0; i < townBlockTypes.size(); ++i) {
                if (i == townBlockTypes.size() - 1) {
                    output.add(translator.of("towny_prices_type_single", ((TownBlockType)townBlockTypes.get(i)).getFormattedName(), TownyCommand.prettyMoney(((TownBlockType)townBlockTypes.get(i)).getCost())));
                    continue;
                }
                output.add(translator.of("towny_prices_type_double", ((TownBlockType)townBlockTypes.get(i)).getFormattedName(), TownyCommand.prettyMoney(((TownBlockType)townBlockTypes.get(i)).getCost()), ((TownBlockType)townBlockTypes.get(i + 1)).getFormattedName(), TownyCommand.prettyMoney(((TownBlockType)townBlockTypes.get(i + 1)).getCost())));
                ++i;
            }
            if (nation != null) {
                output.add(translator.of("towny_prices_nationname", nation.getFormattedName()));
                output.add(translator.of("towny_prices_nation_tax", nation.isTaxPercentage() ? nation.getTaxes() + "%" : TownyCommand.prettyMoney(nation.getTaxes()), TownyCommand.prettyMoney(TownySettings.getNationNeutralityCost(nation))));
            }
        }
        return output;
    }

    public List<String> getTopBankBalance(List<Government> governments) {
        int maxListing = TownySettings.getTownyTopSize();
        ArrayList<String> output = new ArrayList<String>();
        governments.sort(GovernmentComparators.BY_BANK_BALANCE);
        int index = 0;
        for (Government gov : governments) {
            if (maxListing != -1 && ++index > maxListing) break;
            output.add(String.format("\u00a77%-20s \u00a76|\u00a73 %s", gov.getFormattedName(), TownyCommand.prettyMoney(gov.getAccount().getCachedBalance())));
        }
        return output;
    }

    public List<String> getMostResidents(List<ResidentList> list) {
        int maxListing = TownySettings.getTownyTopSize();
        ArrayList<String> output = new ArrayList<String>();
        list.sort(Comparator.comparingInt(residentList -> residentList.getResidents().size()));
        Collections.reverse(list);
        int n = 0;
        for (ResidentList residentList2 : list) {
            if (maxListing != -1 && ++n > maxListing) break;
            output.add(String.format("\u00a73%30s \u00a76|\u00a77 %10d", ((TownyObject)((Object)residentList2)).getFormattedName(), residentList2.getResidents().size()));
        }
        return output;
    }

    public List<String> getMostLand(List<TownBlockOwner> list) {
        int maxListing = TownySettings.getTownyTopSize();
        ArrayList<String> output = new ArrayList<String>();
        list.sort(Comparator.comparingInt(owner -> owner.getTownBlocks().size()));
        Collections.reverse(list);
        int n = 0;
        for (TownBlockOwner owner2 : list) {
            if (maxListing != -1 && ++n > maxListing) break;
            output.add(String.format("\u00a73%30s \u00a76|\u00a77 %10d", owner2.getFormattedName(), owner2.getTownBlocks().size()));
        }
        return output;
    }
}

