/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyCommandAddonAPI;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.event.TownBlockSettingsChangedEvent;
import com.palmergames.bukkit.towny.exceptions.NoPermissionException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.utils.NameUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class TownyWorldCommand
extends BaseCommand
implements CommandExecutor {
    private final Towny plugin;
    private static final List<String> townyWorldTabCompletes = Arrays.asList("list", "toggle", "set");
    private static final List<String> townyWorldToggleTabCompletes = Arrays.asList("claimable", "usingtowny", "pvp", "forcepvp", "explosion", "forceexplosion", "friendlyfire", "fire", "forcefire", "townmobs", "worldmobs", "wildernessmobs", "revertunclaim", "revertentityexpl", "revertblockexpl", "warallowed", "unclaimblockdelete", "unclaimentitydelete", "plotcleardelete", "wildernessuse", "jailing");
    private static final List<String> townySetTabCompletes = Arrays.asList("usedefault", "wildperm", "wildignore", "wildregen", "wildname");

    public TownyWorldCommand(Towny instance) {
        this.plugin = instance;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String commandLabel, String[] args) {
        if (this.plugin.isError() && sender instanceof Player) {
            TownyMessaging.sendErrorMsg((Object)sender, "Locked in Safe mode!");
            return true;
        }
        try {
            this.parseWorldCommand(sender, args);
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return this.tabComplete(sender, args, true);
    }

    public List<String> tabComplete(CommandSender sender, String[] args, boolean showWorlds) {
        switch (args[0].toLowerCase(Locale.ROOT)) {
            case "toggle": {
                if (args.length == 2) {
                    return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.TOWNYWORLD_TOGGLE, townyWorldToggleTabCompletes), args[1]);
                }
                if (args.length != 3) break;
                return NameUtil.filterByStart(BaseCommand.setOnOffCompletes, args[2]);
            }
            case "set": {
                if (args.length == 2) {
                    return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.TOWNYWORLD_SET, townySetTabCompletes), args[1]);
                }
                if (args.length <= 2 || !TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWNYWORLD_SET, args[1])) break;
                return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWNYWORLD_SET, args[1]).getTabCompletion(sender, StringMgmt.remFirstArg(args)), args[args.length - 1]);
            }
            default: {
                if (args.length == 1) {
                    return TownyWorldCommand.filterByStartOrGetTownyStartingWith(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.TOWNYWORLD, townyWorldTabCompletes), args[0], showWorlds ? "+w" : "");
                }
                if (args.length > 1 && TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWNYWORLD, args[0])) {
                    return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWNYWORLD, args[0]).getTabCompletion(sender, args), args[args.length - 1]);
                }
                if (!showWorlds || !BukkitTools.getWorldNames(true).contains(args[0].toLowerCase(Locale.ROOT))) break;
                return this.tabComplete(sender, StringMgmt.remFirstArg(args), false);
            }
        }
        return Collections.emptyList();
    }

    public void parseWorldCommand(CommandSender sender, String[] split) throws TownyException {
        TownyWorld world;
        if (!(sender instanceof Player)) {
            if (split.length == 0) {
                HelpMenu.TOWNYWORLD_HELP_CONSOLE.send(sender);
                return;
            }
            world = TownyAPI.getInstance().getTownyWorld(split[0]);
            if (world == null) {
                Translatable error = Translatable.of("msg_err_invalid_townyworld", split[0]);
                if (townyWorldTabCompletes.contains(split[0].toLowerCase(Locale.ROOT))) {
                    error = Translatable.of("msg_err_enter_world_name_first");
                }
                throw new TownyException(error);
            }
            split = StringMgmt.remFirstArg(split);
        } else {
            Player player = (Player)sender;
            if (split.length > 0 && !townyWorldTabCompletes.contains(split[0].toLowerCase(Locale.ROOT)) && TownyAPI.getInstance().getTownyWorld(split[0]) != null) {
                world = TownyAPI.getInstance().getTownyWorld(split[0]);
                split = StringMgmt.remFirstArg(split);
            } else {
                world = TownyAPI.getInstance().getTownyWorld(player.getWorld());
            }
            if (world == null) {
                throw new TownyException(Translatable.of("msg_area_not_recog"));
            }
        }
        if (split.length == 0) {
            TownyMessaging.sendStatusScreen(sender, TownyFormatter.getStatus(world, sender));
            return;
        }
        if (split[0].equalsIgnoreCase("?")) {
            if (sender instanceof Player) {
                HelpMenu.TOWNYWORLD_HELP.send(sender);
            } else {
                HelpMenu.TOWNYWORLD_HELP_CONSOLE.send(sender);
            }
            return;
        }
        String[] subArgs = StringMgmt.remFirstArg(split);
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "list": {
                this.listWorlds(sender);
                break;
            }
            case "set": {
                this.worldSet(sender, world, subArgs);
                break;
            }
            case "toggle": {
                this.worldToggle(sender, world, subArgs);
                break;
            }
            default: {
                if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWNYWORLD, split[0])) {
                    TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWNYWORLD, split[0]).execute(sender, "townyworld", split);
                    return;
                }
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_property", "townyworld"));
            }
        }
    }

    public void listWorlds(CommandSender sender) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_LIST.getNode());
        TownyMessaging.sendMessage((Object)sender, ChatTools.formatTitle(Translatable.of("world_plu").forLocale(sender)));
        ArrayList<String> formattedList = new ArrayList<String>();
        HashMap<String, Integer> playersPerWorld = BukkitTools.getPlayersPerWorld();
        for (TownyWorld world : TownyUniverse.getInstance().getTownyWorlds()) {
            int numPlayers = playersPerWorld.getOrDefault(world.getName(), 0);
            formattedList.add("\u00a7b" + world.getName() + "\u00a73 [" + numPlayers + "]\u00a7f");
        }
        TownyMessaging.sendMessage((Object)sender, ChatTools.list(formattedList));
    }

    public void worldToggle(CommandSender sender, TownyWorld world, String[] split) throws TownyException {
        if (split.length == 0) {
            if (sender instanceof Player) {
                HelpMenu.TOWNYWORLD_TOGGLE.send(sender);
            } else {
                HelpMenu.TOWNYWORLD_TOGGLE_CONSOLE.send(sender);
            }
            return;
        }
        if (!world.isUsingTowny() && !split[0].equalsIgnoreCase("usingtowny")) {
            throw new TownyException(Translatable.of("msg_err_usingtowny_disabled"));
        }
        Optional<Boolean> choice = Optional.empty();
        if (split.length == 2) {
            choice = TownyWorldCommand.parseToggleChoice(split[1]);
        }
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "claimable": {
                this.toggleClaimable(sender, world, choice);
                break;
            }
            case "usingtowny": {
                this.toggleUsingTowny(sender, world, choice);
                break;
            }
            case "warallowed": {
                this.toggleWarAllowed(sender, world, choice);
                break;
            }
            case "pvp": {
                this.togglePVP(sender, world, choice);
                break;
            }
            case "forcepvp": {
                this.toggleForcePVP(sender, world, choice);
                break;
            }
            case "friendlyfire": {
                this.toggleFriendlyFire(sender, world, choice);
                break;
            }
            case "explosion": {
                this.toggleExplosion(sender, world, choice);
                break;
            }
            case "forceexplosion": {
                this.toggleForceExplosion(sender, world, choice);
                break;
            }
            case "fire": {
                this.toggleFire(sender, world, choice);
                break;
            }
            case "forcefire": {
                this.toggleForceFire(sender, world, choice);
                break;
            }
            case "townmobs": {
                this.toggleTownMobs(sender, world, choice);
                break;
            }
            case "worldmobs": {
                this.toggleWorldMobs(sender, world, choice);
                break;
            }
            case "wildernessmobs": {
                this.toggleWildernessMobs(sender, world, choice);
                break;
            }
            case "revertunclaim": {
                this.toggleRevertUnclaim(sender, world, choice);
                break;
            }
            case "revertentityexpl": {
                this.toggleRevertEntityExpl(sender, world, choice);
                break;
            }
            case "revertblockexpl": {
                this.toggleRevertBlockExpl(sender, world, choice);
                break;
            }
            case "plotcleardelete": {
                this.togglePlotClearDelete(sender, world, choice);
                break;
            }
            case "unclaimblockdelete": {
                this.toggleUnclaimBlockDelete(sender, world, choice);
                break;
            }
            case "unclaimentitydelete": {
                this.toggleUnclaimEntityDelete(sender, world, choice);
                break;
            }
            case "wildernessuse": {
                this.toggleWildernessUse(sender, world, split);
                break;
            }
            case "jailing": {
                this.toggleJailing(sender, world, choice);
                break;
            }
            default: {
                if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWNYWORLD_TOGGLE, split[0])) {
                    TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWNYWORLD_TOGGLE, split[0]).execute(sender, "townyworld", split);
                    break;
                }
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_property", "'" + split[0] + "'"));
                return;
            }
        }
        world.save();
        BukkitTools.fireEvent(new TownBlockSettingsChangedEvent(world));
    }

    private void toggleClaimable(CommandSender sender, TownyWorld world, Optional<Boolean> choice) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_CLAIMABLE.getNode());
        world.setClaimable(choice.orElse(!world.isClaimable()));
        TownyMessaging.sendMsg(sender, Translatable.of("msg_set_claim", world.getName(), this.formatBool(world.isClaimable())));
    }

    private void toggleUsingTowny(CommandSender sender, TownyWorld world, Optional<Boolean> choice) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_USINGTOWNY.getNode());
        world.setUsingTowny(choice.orElse(!world.isUsingTowny()));
        this.plugin.resetCache();
        TownyMessaging.sendMsg(sender, world.isUsingTowny() ? Translatable.of("msg_set_use_towny_on") : Translatable.of("msg_set_use_towny_off"));
        if (!world.isUsingTowny() && world.isUsingPlotManagementRevert()) {
            TownyRegenAPI.turnOffRevertOnUnclaimForWorld(world);
        }
    }

    private void toggleWarAllowed(CommandSender sender, TownyWorld world, Optional<Boolean> choice) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_WARALLOWED.getNode());
        world.setWarAllowed(choice.orElse(!world.isWarAllowed()));
        this.plugin.resetCache();
        TownyMessaging.sendMsg(sender, world.isWarAllowed() ? Translatable.of("msg_set_war_allowed_on") : Translatable.of("msg_set_war_allowed_off"));
    }

    private void togglePVP(CommandSender sender, TownyWorld world, Optional<Boolean> choice) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_PVP.getNode());
        world.setPVP(choice.orElse(!world.isPVP()));
        TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Global PVP", world.getName(), this.formatBool(world.isPVP())));
    }

    private void toggleForcePVP(CommandSender sender, TownyWorld world, Optional<Boolean> choice) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_FORCEPVP.getNode());
        world.setForcePVP(choice.orElse(!world.isForcePVP()));
        TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Force town PVP", world.getName(), this.formatBool(world.isForcePVP(), "forced", "adjustable")));
    }

    private void toggleFriendlyFire(CommandSender sender, TownyWorld world, Optional<Boolean> choice) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_FRIENDLYFIRE.getNode());
        world.setFriendlyFire(choice.orElse(!world.isFriendlyFireEnabled()));
        TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Friendly Fire", world.getName(), this.formatBool(world.isFriendlyFireEnabled())));
    }

    private void toggleExplosion(CommandSender sender, TownyWorld world, Optional<Boolean> choice) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_EXPLOSION.getNode());
        world.setExpl(choice.orElse(!world.isExpl()));
        TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Explosions", world.getName(), this.formatBool(world.isExpl())));
    }

    private void toggleForceExplosion(CommandSender sender, TownyWorld world, Optional<Boolean> choice) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_FORCEEXPLOSION.getNode());
        world.setForceExpl(choice.orElse(!world.isForceExpl()));
        TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Force town Explosions", world.getName(), this.formatBool(world.isForceExpl(), "forced", "adjustable")));
    }

    private void toggleFire(CommandSender sender, TownyWorld world, Optional<Boolean> choice) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_FIRE.getNode());
        world.setFire(choice.orElse(!world.isFire()));
        TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Fire Spread", world.getName(), this.formatBool(world.isFire())));
    }

    private void toggleForceFire(CommandSender sender, TownyWorld world, Optional<Boolean> choice) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_FORCEFIRE.getNode());
        world.setForceFire(choice.orElse(!world.isForceFire()));
        TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Force town Fire Spread", world.getName(), this.formatBool(world.isForceFire(), "forced", "adjustable")));
    }

    private void toggleTownMobs(CommandSender sender, TownyWorld world, Optional<Boolean> choice) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_TOWNMOBS.getNode());
        world.setForceTownMobs(choice.orElse(!world.isForceTownMobs()));
        TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Town Mob spawns", world.getName(), this.formatBool(world.isForceTownMobs(), "forced", "adjustable")));
    }

    private void toggleWorldMobs(CommandSender sender, TownyWorld world, Optional<Boolean> choice) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_WORLDMOBS.getNode());
        world.setWorldMobs(choice.orElse(!world.hasWorldMobs()));
        TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "World Mob spawns", world.getName(), this.formatBool(world.hasWorldMobs())));
    }

    private void toggleWildernessMobs(CommandSender sender, TownyWorld world, Optional<Boolean> choice) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_WILDERNESSMOBS.getNode());
        world.setWildernessMobs(choice.orElse(!world.hasWildernessMobs()));
        TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Wilderness Mob spawns", world.getName(), this.formatBool(world.hasWildernessMobs())));
    }

    private void toggleRevertUnclaim(CommandSender sender, TownyWorld world, Optional<Boolean> choice) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_REVERTUNCLAIM.getNode());
        world.setUsingPlotManagementRevert(choice.orElse(!world.isUsingPlotManagementRevert()));
        if (!world.isUsingPlotManagementRevert()) {
            TownyRegenAPI.turnOffRevertOnUnclaimForWorld(world);
        }
        TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Unclaim Revert", world.getName(), this.formatBool(world.isUsingPlotManagementRevert())));
    }

    private void toggleRevertEntityExpl(CommandSender sender, TownyWorld world, Optional<Boolean> choice) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_REVERTENTITYEXPL.getNode());
        world.setUsingPlotManagementWildEntityRevert(choice.orElse(!world.isUsingPlotManagementWildEntityRevert()));
        TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Wilderness Entity Explosion Revert", world.getName(), this.formatBool(world.isUsingPlotManagementWildEntityRevert())));
    }

    private void toggleRevertBlockExpl(CommandSender sender, TownyWorld world, Optional<Boolean> choice) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_REVERTBLOCKEXPL.getNode());
        world.setUsingPlotManagementWildBlockRevert(choice.orElse(!world.isUsingPlotManagementWildBlockRevert()));
        TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Wilderness Block Explosion Revert", world.getName(), this.formatBool(world.isUsingPlotManagementWildBlockRevert())));
    }

    private void togglePlotClearDelete(CommandSender sender, TownyWorld world, Optional<Boolean> choice) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_PLOTCLEARDELETE.getNode());
        world.setUsingPlotManagementMayorDelete(choice.orElse(!world.isUsingPlotManagementMayorDelete()));
        TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Plot Clear Delete", world.getName(), this.formatBool(world.isUsingPlotManagementMayorDelete())));
    }

    private void toggleUnclaimBlockDelete(CommandSender sender, TownyWorld world, Optional<Boolean> choice) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_UNCLAIMBLOCKDELETE.getNode());
        world.setUsingPlotManagementDelete(choice.orElse(!world.isUsingPlotManagementDelete()));
        TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Unclaim Block Delete", world.getName(), this.formatBool(world.isUsingPlotManagementDelete())));
    }

    private void toggleUnclaimEntityDelete(CommandSender sender, TownyWorld world, Optional<Boolean> choice) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_UNCLAIMENTITYDELETE.getNode());
        world.setDeletingEntitiesOnUnclaim(choice.orElse(!world.isDeletingEntitiesOnUnclaim()));
        TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Unclaim Entity Delete", world.getName(), this.formatBool(world.isDeletingEntitiesOnUnclaim())));
    }

    private void toggleWildernessUse(CommandSender sender, TownyWorld world, String[] split) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_WILDERNESSUSE.getNode());
        String value = split.length > 1 ? split[1] : "";
        boolean toggle = TownyWorldCommand.parseToggleChoice(value).orElse(world.getUnclaimedZoneBuild() == false);
        world.setUnclaimedZoneBuild(toggle);
        world.setUnclaimedZoneDestroy(toggle);
        world.setUnclaimedZoneItemUse(toggle);
        world.setUnclaimedZoneSwitch(toggle);
        TownyMessaging.sendMsg(sender, Translatable.of("msg_wilderness_use_set_to", toggle, world.getName()));
    }

    private void toggleJailing(CommandSender sender, TownyWorld world, Optional<Boolean> choice) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE_JAILING.getNode());
        world.setJailingEnabled(choice.orElse(!world.isJailingEnabled()));
        TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_world_setting", "Jailing", world.getName(), this.formatBool(world.isJailingEnabled())));
    }

    public void worldSet(CommandSender sender, TownyWorld world, String[] split) throws NoPermissionException {
        TownyWorldCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_SET.getNode());
        if (split.length == 0) {
            HelpMenu.TOWNYWORLD_SET.send(sender);
            return;
        }
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "usedefault": {
                this.setUseDefaults(sender, world);
                break;
            }
            case "wildperm": {
                this.setWildPerm(sender, world, split);
                break;
            }
            case "wildignore": {
                this.setWildIgnore(sender, world, split);
                break;
            }
            case "wildregen": {
                this.setWildRegen(sender, world, split);
                break;
            }
            case "wildname": {
                this.setWildName(sender, world, split);
                break;
            }
            default: {
                if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWNYWORLD_SET, split[0])) {
                    try {
                        TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWNYWORLD_SET, split[0]).execute(sender, "townyworld", split);
                    }
                    catch (Exception e) {
                        TownyMessaging.sendErrorMsg((Object)sender, e.getMessage());
                    }
                    break;
                }
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_property", "world"));
                return;
            }
        }
        world.save();
    }

    private void setUseDefaults(CommandSender sender, TownyWorld world) {
        Confirmation.runOnAccept(() -> {
            world.setUsingDefault();
            world.save();
            this.plugin.resetCache();
            TownyMessaging.sendMsg(sender, Translatable.of("msg_usedefault", world.getName()));
        }).setTitle(Translatable.of("confirmation_are_you_sure_you_want_to_reset_this_worlds_settings")).sendTo(sender);
    }

    private void setWildPerm(CommandSender sender, TownyWorld world, String[] split) {
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)sender, "Eg: /townyworld set wildperm build destroy <world>");
            return;
        }
        try {
            List<String> perms = Arrays.asList(String.join((CharSequence)",", StringMgmt.remFirstArg(split)).toLowerCase(Locale.ROOT).split(","));
            world.setUnclaimedZoneBuild(perms.contains("build"));
            world.setUnclaimedZoneDestroy(perms.contains("destroy"));
            world.setUnclaimedZoneSwitch(perms.contains("switch"));
            world.setUnclaimedZoneItemUse(perms.contains("itemuse") || perms.contains("item_use"));
            this.plugin.resetCache();
            TownyMessaging.sendMsg(sender, Translatable.of("msg_set_wild_perms", world.getName(), perms.toString()));
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg((Object)sender, "Eg: /townyworld set wildperm build destroy <world>");
        }
    }

    private void setWildIgnore(CommandSender sender, TownyWorld world, String[] split) {
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_input", "/townyworld set wildignore OAK_SAPLING GOLD_ORE IRON_ORE"));
        } else {
            try {
                List<String> mats = Arrays.asList(StringMgmt.remFirstArg(split));
                world.setUnclaimedZoneIgnore(mats);
                this.plugin.resetCache();
                TownyMessaging.sendMsg(sender, Translatable.of("msg_set_wild_ignore", world.getName(), world.getUnclaimedZoneIgnoreMaterials()));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_input", "/townyworld set wildignore OAK_SAPLING GOLD_ORE IRON_ORE"));
            }
        }
    }

    private void setWildRegen(CommandSender sender, TownyWorld world, String[] split) {
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)sender, "Eg: /townyworld set wildregen Creeper,EnderCrystal,EnderDragon,Fireball,SmallFireball,LargeFireball,TNTPrimed,ExplosiveMinecart");
        } else {
            String[] entities = String.join((CharSequence)",", StringMgmt.remFirstArg(split)).split(",");
            ArrayList<String> entityList = new ArrayList<String>(Arrays.asList(entities));
            world.setPlotManagementWildRevertEntities(entityList);
            TownyMessaging.sendMsg(sender, Translatable.of("msg_set_wild_regen", world.getName(), world.getPlotManagementWildRevertEntities()));
        }
    }

    private void setWildName(CommandSender sender, TownyWorld world, String[] split) {
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)sender, "Eg: /townyworld set wildname Wildy");
        } else {
            world.setUnclaimedZoneName(split[1]);
            TownyMessaging.sendMsg(sender, Translatable.of("msg_set_wild_name", world.getName(), split[1]));
        }
    }

    private Translatable formatBool(boolean bool) {
        return bool ? Translatable.of("enabled") : Translatable.of("disabled");
    }

    private Translatable formatBool(boolean bool, String ifTrue, String ifFalse) {
        return bool ? Translatable.of(ifTrue) : Translatable.of(ifFalse);
    }
}

