/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command.commandobjects;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.confirmations.ConfirmationHandler;
import com.palmergames.bukkit.towny.object.Translatable;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ConfirmCommand
extends Command
implements PluginIdentifiableCommand {
    private final Towny plugin;

    public ConfirmCommand(Towny plugin, String name) {
        super(name);
        this.plugin = plugin;
        this.description = "Confirm command for Towny";
        this.usageMessage = "/" + name;
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) {
        if (!ConfirmationHandler.hasConfirmation(sender)) {
            TownyMessaging.sendMsg(sender, Translatable.of("no_confirmations_open"));
            return true;
        }
        ConfirmationHandler.acceptConfirmation(sender);
        return true;
    }

    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }
}

