/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.confirmations;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.confirmations.ConfirmationTransaction;
import com.palmergames.bukkit.towny.confirmations.event.ConfirmationCancelEvent;
import com.palmergames.bukkit.towny.confirmations.event.ConfirmationConfirmEvent;
import com.palmergames.bukkit.towny.confirmations.event.ConfirmationSendEvent;
import com.palmergames.bukkit.towny.exceptions.CancelledEventException;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.towny.scheduling.ScheduledTask;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ConfirmationHandler {
    private static final Towny plugin = Towny.getPlugin();
    private static final Map<CommandSender, ConfirmationContext> confirmations = new ConcurrentHashMap<CommandSender, ConfirmationContext>();

    public static void revokeConfirmation(CommandSender sender) {
        ConfirmationContext context = confirmations.get(sender);
        if (context == null) {
            return;
        }
        context.task.cancel();
        Confirmation confirmation = context.confirmation;
        confirmations.remove(sender);
        if (confirmation.getCancelHandler() != null) {
            confirmation.getCancelHandler().run();
        } else {
            TownyMessaging.sendMsg(sender, Translatable.of("successful_cancel"));
        }
        BukkitTools.fireEvent(new ConfirmationCancelEvent(confirmation, sender, false));
    }

    public static void sendConfirmation(CommandSender sender, Confirmation confirmation) {
        ConfirmationSendEvent event = new ConfirmationSendEvent(confirmation, sender);
        if (BukkitTools.isEventCancelled(event)) {
            TownyMessaging.sendErrorMsg((Object)sender, event.getCancelMessage());
            return;
        }
        if (confirmations.containsKey(sender)) {
            ConfirmationHandler.revokeConfirmation(sender);
        }
        if (event.isSendingMessage()) {
            TownyMessaging.sendConfirmationMessage(sender, confirmation);
        }
        ScheduledTask task = plugin.getScheduler().runLater(() -> {
            if (ConfirmationHandler.hasConfirmation(sender)) {
                confirmations.remove(sender);
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_confirmation_timed_out"));
                BukkitTools.fireEvent(new ConfirmationCancelEvent(confirmation, sender, true));
            }
        }, 20L * (long)confirmation.getDuration());
        confirmations.put(sender, new ConfirmationContext(confirmation, task));
    }

    public static void acceptConfirmation(CommandSender sender) {
        ConfirmationContext context = confirmations.get(sender);
        if (context == null) {
            return;
        }
        ConfirmationConfirmEvent event = new ConfirmationConfirmEvent(context.confirmation, sender);
        if (BukkitTools.isEventCancelled(event)) {
            TownyMessaging.sendErrorMsg(event.getCancelMessage());
            return;
        }
        Runnable handler = context.confirmation.getAcceptHandler();
        context.task.cancel();
        confirmations.remove(sender);
        if (context.confirmation.getEvent() != null) {
            try {
                BukkitTools.ifCancelledThenThrow(context.confirmation.getEvent());
            }
            catch (CancelledEventException e) {
                TownyMessaging.sendErrorMsg((Object)sender, e.getCancelMessage());
                return;
            }
        }
        if (TownyEconomyHandler.isActive() && context.confirmation.hasCost()) {
            ConfirmationTransaction transaction = context.confirmation.getTransaction();
            transaction.supplyCost();
            double cost = transaction.getCost();
            Account payee = transaction.getPayee();
            if (cost > 0.0 && payee != null) {
                if (!payee.canPayFromHoldings(cost)) {
                    TownyMessaging.sendErrorMsg(sender, transaction.getInsufficientFundsMessage());
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_you_need_x_to_pay", cost));
                    return;
                }
                payee.withdraw(cost, transaction.getLoggedMessage());
            }
        }
        if (context.confirmation.isAsync()) {
            plugin.getScheduler().runAsync(handler);
        } else if (sender instanceof Player) {
            Player player = (Player)sender;
            plugin.getScheduler().run((Entity)player, handler);
        } else {
            plugin.getScheduler().run(handler);
        }
    }

    public static boolean hasConfirmation(CommandSender sender) {
        return confirmations.containsKey(sender);
    }

    private record ConfirmationContext(Confirmation confirmation, ScheduledTask task) {
    }
}

