/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.conversation;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.conversation.TownyConversation;
import com.palmergames.bukkit.towny.object.Translatable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.ConversationPrefix;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetupConversation
extends TownyConversation {
    private int questionCount = 0;
    private final List<Question> setupQuestions = this.buildQuestions();

    public SetupConversation(CommandSender sender) {
        new ConversationFactory((Plugin)Towny.getPlugin()).withPrefix((ConversationPrefix)this).addConversationAbandonedListener((ConversationAbandonedListener)this).withFirstPrompt((Prompt)new SetupPrompt()).withEscapeSequence("q").withTimeout(120).withLocalEcho(true).withModality(false).buildConversation((Conversable)sender).begin();
    }

    private void findNextQuestion() {
        Question nextQuestion;
        while (this.questionCount < this.setupQuestions.size() && (nextQuestion = this.setupQuestions.get(this.questionCount)).requiresEco() && !TownyEconomyHandler.isActive()) {
            ++this.questionCount;
        }
    }

    private List<Question> buildQuestions() {
        Predicate<String> trueOrFalse = str -> switch (str.toLowerCase(Locale.ROOT)) {
            case "y", "yes", "true", "n", "no", "false" -> true;
            default -> false;
        };
        Predicate<String> isInt = str -> {
            try {
                Integer.parseInt(str);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
        return Arrays.asList(new Question(Translatable.of("msg_setup_wildernessuse"), false, trueOrFalse), new Question(Translatable.of("msg_setup_revertunclaim"), false, trueOrFalse), new Question(Translatable.of("msg_setup_town_block_ratio"), false, isInt), new Question(Translatable.of("msg_setup_town_cost"), true, isInt), new Question(Translatable.of("msg_setup_nation_cost"), true, isInt), new Question(Translatable.of("msg_setup_townblock_cost"), true, isInt));
    }

    public class SetupPrompt
    extends StringPrompt {
        @NotNull
        public String getPromptText(@NotNull ConversationContext conversationContext) {
            return SetupConversation.this.setupQuestions.get(SetupConversation.this.questionCount).message().forLocale(SetupConversation.this.getSender(conversationContext));
        }

        @Nullable
        public Prompt acceptInput(@NotNull ConversationContext context, @Nullable String string) {
            if ("back".equalsIgnoreCase(string)) {
                SetupConversation.this.questionCount = Math.max(SetupConversation.this.questionCount - 1, 0);
                return new SetupPrompt();
            }
            Question currentQuestion = SetupConversation.this.setupQuestions.get(SetupConversation.this.questionCount);
            if (!currentQuestion.isValidResponse(string)) {
                TownyMessaging.sendErrorMsg(SetupConversation.this.getSender(context), Translatable.of("msg_err_invalid_response"));
                return new SetupPrompt();
            }
            context.setSessionData((Object)SetupConversation.this.questionCount, (Object)string);
            ++SetupConversation.this.questionCount;
            SetupConversation.this.findNextQuestion();
            if (SetupConversation.this.questionCount >= SetupConversation.this.setupQuestions.size()) {
                SetupConversation.this.consumer.accept(context);
                return Prompt.END_OF_CONVERSATION;
            }
            return new SetupPrompt();
        }
    }

    private static class Question {
        private final Translatable message;
        private final boolean requiresEco;
        private final Predicate<String> predicate;

        public Question(Translatable message, boolean requiresEconomy, Predicate<String> predicate) {
            this.message = message;
            this.requiresEco = requiresEconomy;
            this.predicate = predicate;
        }

        public Translatable message() {
            return this.message;
        }

        public boolean requiresEco() {
            return this.requiresEco;
        }

        public boolean isValidResponse(String response) {
            if (response == null) {
                return false;
            }
            return this.predicate.test(response);
        }
    }
}

