/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.db.TownySQLSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SQLSchema {
    private static final String SQLDB_NAME = TownySettings.getSQLDBName();
    public static final String TABLE_PREFIX = TownySettings.getSQLTablePrefix().toUpperCase(Locale.ROOT);
    private static final int MYSQL_DUPLICATE_COLUMN_ERR = 1060;

    public static void initTables(Connection cntx) {
        Map<String, Set<String>> existingTableColumns = SQLSchema.loadExistingTables(cntx);
        SQLSchema.initTable(cntx, TownySQLSource.TownyDBTableType.WORLD, existingTableColumns);
        SQLSchema.updateTable(cntx, TownySQLSource.TownyDBTableType.WORLD, SQLSchema.getWorldColumns(), existingTableColumns);
        SQLSchema.initTable(cntx, TownySQLSource.TownyDBTableType.NATION, existingTableColumns);
        SQLSchema.updateTable(cntx, TownySQLSource.TownyDBTableType.NATION, SQLSchema.getNationColumns(), existingTableColumns);
        SQLSchema.initTable(cntx, TownySQLSource.TownyDBTableType.TOWN, existingTableColumns);
        SQLSchema.updateTable(cntx, TownySQLSource.TownyDBTableType.TOWN, SQLSchema.getTownColumns(), existingTableColumns);
        SQLSchema.initTable(cntx, TownySQLSource.TownyDBTableType.RESIDENT, existingTableColumns);
        SQLSchema.updateTable(cntx, TownySQLSource.TownyDBTableType.RESIDENT, SQLSchema.getResidentColumns(), existingTableColumns);
        SQLSchema.initTable(cntx, TownySQLSource.TownyDBTableType.TOWNBLOCK, existingTableColumns);
        SQLSchema.updateTable(cntx, TownySQLSource.TownyDBTableType.TOWNBLOCK, SQLSchema.getTownBlockColumns(), existingTableColumns);
        SQLSchema.initTable(cntx, TownySQLSource.TownyDBTableType.PLOTGROUP, existingTableColumns);
        SQLSchema.updateTable(cntx, TownySQLSource.TownyDBTableType.PLOTGROUP, SQLSchema.getPlotGroupColumns(), existingTableColumns);
        SQLSchema.initTable(cntx, TownySQLSource.TownyDBTableType.DISTRICT, existingTableColumns);
        SQLSchema.updateTable(cntx, TownySQLSource.TownyDBTableType.DISTRICT, SQLSchema.getDistrictColumns(), existingTableColumns);
        SQLSchema.initTable(cntx, TownySQLSource.TownyDBTableType.JAIL, existingTableColumns);
        SQLSchema.updateTable(cntx, TownySQLSource.TownyDBTableType.JAIL, SQLSchema.getJailsColumns(), existingTableColumns);
        SQLSchema.initTable(cntx, TownySQLSource.TownyDBTableType.HIBERNATED_RESIDENT, existingTableColumns);
        SQLSchema.updateTable(cntx, TownySQLSource.TownyDBTableType.HIBERNATED_RESIDENT, SQLSchema.getHibernatedResidentsColumns(), existingTableColumns);
        SQLSchema.initTable(cntx, TownySQLSource.TownyDBTableType.COOLDOWN, existingTableColumns);
        SQLSchema.updateTable(cntx, TownySQLSource.TownyDBTableType.COOLDOWN, SQLSchema.getCooldownColumns(), existingTableColumns);
    }

    private static void initTable(Connection cntx, TownySQLSource.TownyDBTableType tableType, Map<String, Set<String>> existingTableColumns) {
        if (existingTableColumns.containsKey((TABLE_PREFIX + tableType.tableName()).toLowerCase(Locale.ROOT))) {
            TownyMessaging.sendDebugMsg("Table " + tableType.tableName() + " already exists!");
            return;
        }
        try (Statement s = cntx.createStatement();){
            s.executeUpdate(SQLSchema.fetchTableSchema(tableType));
            TownyMessaging.sendDebugMsg("Table " + tableType.tableName() + " is ok!");
        }
        catch (SQLException ee) {
            TownyMessaging.sendErrorMsg("Error Creating table " + tableType.tableName() + " : " + ee.getMessage());
        }
    }

    private static Map<String, Set<String>> loadExistingTables(Connection connection) {
        HashMap<String, Set<String>> existingTableColumns = new HashMap<String, Set<String>>();
        try (ResultSet rs = connection.getMetaData().getColumns(SQLDB_NAME, null, null, null);){
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME").toLowerCase(Locale.ROOT);
                String columnName = rs.getString("COLUMN_NAME");
                existingTableColumns.computeIfAbsent(tableName, k -> new HashSet()).add(columnName);
            }
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("Error retrieving existing tables and columns: " + e.getMessage());
        }
        return existingTableColumns;
    }

    private static String fetchTableSchema(TownySQLSource.TownyDBTableType tableType) {
        return switch (tableType) {
            case TownySQLSource.TownyDBTableType.TOWNBLOCK -> SQLSchema.fetchCreateTownBlocksStatement();
            case TownySQLSource.TownyDBTableType.JAIL -> SQLSchema.fetchCreateUUIDStatement(tableType);
            case TownySQLSource.TownyDBTableType.PLOTGROUP -> SQLSchema.fetchCreatePlotGroupStatement(tableType);
            case TownySQLSource.TownyDBTableType.DISTRICT -> SQLSchema.fetchCreateUUIDStatement(tableType);
            case TownySQLSource.TownyDBTableType.COOLDOWN -> SQLSchema.fetchCreateCooldownsStatement(tableType);
            case TownySQLSource.TownyDBTableType.WORLD -> SQLSchema.fetchCreateWorldStatemnt(tableType);
            case TownySQLSource.TownyDBTableType.HIBERNATED_RESIDENT -> SQLSchema.fetchCreateUUIDStatement(tableType);
            default -> SQLSchema.fetchCreateNamedStatement(tableType);
        };
    }

    private static String fetchCreateNamedStatement(TownySQLSource.TownyDBTableType tableType) {
        return "CREATE TABLE IF NOT EXISTS " + TABLE_PREFIX + tableType.tableName() + " (`name` VARCHAR(32) NOT NULL COLLATE utf8mb4_bin, PRIMARY KEY (`name`))";
    }

    private static String fetchCreatePlotGroupStatement(TownySQLSource.TownyDBTableType tableType) {
        return "CREATE TABLE IF NOT EXISTS " + TABLE_PREFIX + tableType.tableName() + " (`groupID` VARCHAR(36) NOT NULL,PRIMARY KEY (`groupID`))";
    }

    private static String fetchCreateUUIDStatement(TownySQLSource.TownyDBTableType tableType) {
        return "CREATE TABLE IF NOT EXISTS " + TABLE_PREFIX + tableType.tableName() + " (`uuid` VARCHAR(36) NOT NULL,PRIMARY KEY (`uuid`))";
    }

    private static String fetchCreateTownBlocksStatement() {
        return "CREATE TABLE IF NOT EXISTS " + TABLE_PREFIX + "TOWNBLOCKS (`world` VARCHAR(36) NOT NULL,`x` mediumint NOT NULL,`z` mediumint NOT NULL,PRIMARY KEY (`world`,`x`,`z`))";
    }

    private static String fetchCreateCooldownsStatement(TownySQLSource.TownyDBTableType tableType) {
        return "CREATE TABLE IF NOT EXISTS " + TABLE_PREFIX + tableType.tableName() + " (`key` varchar(200) not null, primary key (`key`))";
    }

    private static String fetchCreateWorldStatemnt(TownySQLSource.TownyDBTableType tableType) {
        return "CREATE TABLE IF NOT EXISTS " + TABLE_PREFIX + tableType.tableName() + " (`name` VARCHAR(64) NOT NULL,PRIMARY KEY (`name`))";
    }

    private static void updateTable(Connection cntx, TownySQLSource.TownyDBTableType tableType, List<ColumnData> columns, Map<String, Set<String>> existingTableColumns) {
        String update = "ALTER TABLE `" + SQLDB_NAME + "`.`" + TABLE_PREFIX + tableType.tableName() + "` ADD COLUMN ";
        Set existingColumns = existingTableColumns.getOrDefault((TABLE_PREFIX + tableType.tableName()).toLowerCase(Locale.ROOT), Set.of());
        int addedColumns = 0;
        for (ColumnData column : columns) {
            if (existingColumns.contains(column.name)) continue;
            try {
                PreparedStatement ps = cntx.prepareStatement(update + String.valueOf(column));
                try {
                    ps.executeUpdate();
                    ++addedColumns;
                }
                finally {
                    if (ps == null) continue;
                    ps.close();
                }
            }
            catch (SQLException ee) {
                if (ee.getErrorCode() == 1060) continue;
                TownyMessaging.sendErrorMsg("Error updating table " + tableType.tableName() + ":" + ee.getMessage());
            }
        }
        TownyMessaging.sendDebugMsg("Table " + tableType.tableName() + " is updated! Created " + addedColumns + " missing column" + (addedColumns == 1 ? "" : "s") + ".");
    }

    private static List<ColumnData> getJailsColumns() {
        ArrayList<ColumnData> columns = new ArrayList<ColumnData>();
        columns.add(new ColumnData("townBlock", "mediumtext NOT NULL"));
        columns.add(new ColumnData("spawns", "mediumtext DEFAULT NULL"));
        return columns;
    }

    private static List<ColumnData> getPlotGroupColumns() {
        ArrayList<ColumnData> columns = new ArrayList<ColumnData>();
        columns.add(new ColumnData("groupName", "mediumtext NOT NULL"));
        columns.add(new ColumnData("groupPrice", "float DEFAULT NULL"));
        columns.add(new ColumnData("town", "VARCHAR(36) NOT NULL"));
        columns.add(new ColumnData("metadata", "mediumtext DEFAULT NULL"));
        return columns;
    }

    private static List<ColumnData> getDistrictColumns() {
        ArrayList<ColumnData> columns = new ArrayList<ColumnData>();
        columns.add(new ColumnData("districtName", "mediumtext NOT NULL"));
        columns.add(new ColumnData("town", "VARCHAR(36) NOT NULL"));
        columns.add(new ColumnData("metadata", "text DEFAULT NULL"));
        return columns;
    }

    private static List<ColumnData> getResidentColumns() {
        ArrayList<ColumnData> columns = new ArrayList<ColumnData>();
        columns.add(new ColumnData("town", "mediumtext"));
        columns.add(new ColumnData("town-ranks", "mediumtext"));
        columns.add(new ColumnData("nation-ranks", "mediumtext"));
        columns.add(new ColumnData("lastOnline", "BIGINT NOT NULL"));
        columns.add(new ColumnData("registered", "BIGINT NOT NULL"));
        columns.add(new ColumnData("joinedTownAt", "BIGINT NOT NULL"));
        columns.add(new ColumnData("isNPC", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("jailUUID", "VARCHAR(36) DEFAULT NULL"));
        columns.add(new ColumnData("jailCell", "mediumint"));
        columns.add(new ColumnData("jailHours", "mediumint"));
        columns.add(new ColumnData("jailBail", "float DEFAULT NULL"));
        columns.add(new ColumnData("title", "mediumtext"));
        columns.add(new ColumnData("surname", "mediumtext"));
        columns.add(new ColumnData("protectionStatus", "mediumtext"));
        columns.add(new ColumnData("friends", "mediumtext"));
        columns.add(new ColumnData("metadata", "mediumtext DEFAULT NULL"));
        columns.add(new ColumnData("uuid", "VARCHAR(36) NOT NULL"));
        columns.add(new ColumnData("about", "mediumtext DEFAULT NULL"));
        return columns;
    }

    private static List<ColumnData> getHibernatedResidentsColumns() {
        ArrayList<ColumnData> columns = new ArrayList<ColumnData>();
        columns.add(new ColumnData("registered", "BIGINT DEFAULT NULL"));
        return columns;
    }

    private static List<ColumnData> getTownColumns() {
        ArrayList<ColumnData> columns = new ArrayList<ColumnData>();
        columns.add(new ColumnData("mayor", "mediumtext"));
        columns.add(new ColumnData("nation", "mediumtext"));
        columns.add(new ColumnData("townBoard", "mediumtext DEFAULT NULL"));
        columns.add(new ColumnData("tag", "mediumtext DEFAULT NULL"));
        columns.add(new ColumnData("founder", "mediumtext DEFAULT NULL"));
        columns.add(new ColumnData("protectionStatus", "mediumtext DEFAULT NULL"));
        columns.add(new ColumnData("bonus", "int(11) DEFAULT 0"));
        columns.add(new ColumnData("purchased", "int(11)  DEFAULT 0"));
        columns.add(new ColumnData("taxpercent", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("maxPercentTaxAmount", "float DEFAULT NULL"));
        columns.add(new ColumnData("taxes", "float DEFAULT 0"));
        columns.add(new ColumnData("hasUpkeep", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("plotPrice", "float DEFAULT NULL"));
        columns.add(new ColumnData("plotTax", "float DEFAULT NULL"));
        columns.add(new ColumnData("commercialPlotPrice", "float DEFAULT NULL"));
        columns.add(new ColumnData("commercialPlotTax", "float NOT NULL"));
        columns.add(new ColumnData("embassyPlotPrice", "float NOT NULL"));
        columns.add(new ColumnData("embassyPlotTax", "float NOT NULL"));
        columns.add(new ColumnData("open", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("public", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("adminEnabledMobs", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("admindisabledpvp", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("adminenabledpvp", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("allowedToWar", "bool NOT NULL DEFAULT '1'"));
        columns.add(new ColumnData("homeblock", "mediumtext NOT NULL"));
        columns.add(new ColumnData("spawn", "mediumtext NOT NULL"));
        columns.add(new ColumnData("outpostSpawns", "mediumtext DEFAULT NULL"));
        columns.add(new ColumnData("outlaws", "mediumtext DEFAULT NULL"));
        columns.add(new ColumnData("uuid", "VARCHAR(36) DEFAULT NULL"));
        columns.add(new ColumnData("registered", "BIGINT DEFAULT NULL"));
        columns.add(new ColumnData("spawnCost", "float NOT NULL"));
        columns.add(new ColumnData("mapColorHexCode", "mediumtext DEFAULT NULL"));
        columns.add(new ColumnData("metadata", "mediumtext DEFAULT NULL"));
        columns.add(new ColumnData("conqueredDays", "mediumint"));
        columns.add(new ColumnData("conquered", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("ruined", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("ruinedTime", "BIGINT DEFAULT '0'"));
        columns.add(new ColumnData("neutral", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("debtBalance", "float NOT NULL"));
        columns.add(new ColumnData("joinedNationAt", "BIGINT NOT NULL"));
        columns.add(new ColumnData("primaryJail", "VARCHAR(36) DEFAULT NULL"));
        columns.add(new ColumnData("movedHomeBlockAt", "BIGINT NOT NULL"));
        columns.add(new ColumnData("trustedResidents", "mediumtext DEFAULT NULL"));
        columns.add(new ColumnData("trustedTowns", "mediumtext NOT NULL"));
        columns.add(new ColumnData("nationZoneOverride", "int(11) DEFAULT 0"));
        columns.add(new ColumnData("nationZoneEnabled", "bool NOT NULL DEFAULT '1'"));
        columns.add(new ColumnData("allies", "mediumtext NOT NULL"));
        columns.add(new ColumnData("enemies", "mediumtext NOT NULL"));
        columns.add(new ColumnData("hasUnlimitedClaims", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("manualTownLevel", "BIGINT DEFAULT '-1'"));
        columns.add(new ColumnData("forSale", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("forSalePrice", "float NOT NULL"));
        columns.add(new ColumnData("forSaleTime", "BIGINT DEFAULT '0'"));
        columns.add(new ColumnData("visibleOnTopLists", "bool NOT NULL DEFAULT '1'"));
        columns.add(new ColumnData("hasActiveWar", "bool NOT NULL DEFAULT '0'"));
        return columns;
    }

    private static List<ColumnData> getNationColumns() {
        ArrayList<ColumnData> columns = new ArrayList<ColumnData>();
        columns.add(new ColumnData("capital", "mediumtext NOT NULL"));
        columns.add(new ColumnData("tag", "mediumtext NOT NULL"));
        columns.add(new ColumnData("allies", "mediumtext NOT NULL"));
        columns.add(new ColumnData("enemies", "mediumtext NOT NULL"));
        columns.add(new ColumnData("taxes", "float NOT NULL"));
        columns.add(new ColumnData("taxpercent", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("maxPercentTaxAmount", "float DEFAULT NULL"));
        columns.add(new ColumnData("spawnCost", "float NOT NULL"));
        columns.add(new ColumnData("neutral", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("uuid", "VARCHAR(36) DEFAULT NULL"));
        columns.add(new ColumnData("registered", "BIGINT DEFAULT NULL"));
        columns.add(new ColumnData("nationBoard", "mediumtext DEFAULT NULL"));
        columns.add(new ColumnData("mapColorHexCode", "mediumtext DEFAULT NULL"));
        columns.add(new ColumnData("nationSpawn", "mediumtext DEFAULT NULL"));
        columns.add(new ColumnData("isPublic", "bool NOT NULL DEFAULT '1'"));
        columns.add(new ColumnData("isOpen", "bool NOT NULL DEFAULT '1'"));
        columns.add(new ColumnData("metadata", "mediumtext DEFAULT NULL"));
        columns.add(new ColumnData("conqueredTax", "float NOT NULL"));
        columns.add(new ColumnData("sanctionedTowns", "mediumtext DEFAULT NULL"));
        columns.add(new ColumnData("hasActiveWar", "bool NOT NULL DEFAULT '0'"));
        return columns;
    }

    private static List<ColumnData> getWorldColumns() {
        ArrayList<ColumnData> columns = new ArrayList<ColumnData>();
        columns.add(new ColumnData("uuid", "VARCHAR(36) DEFAULT NULL"));
        columns.add(new ColumnData("claimable", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("pvp", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("forcepvp", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("forcetownmobs", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("friendlyFire", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("worldmobs", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("wildernessmobs", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("firespread", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("forcefirespread", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("explosions", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("forceexplosions", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("endermanprotect", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("disablecreaturetrample", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("unclaimedZoneBuild", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("unclaimedZoneDestroy", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("unclaimedZoneSwitch", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("unclaimedZoneItemUse", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("unclaimedZoneName", "mediumtext NOT NULL"));
        columns.add(new ColumnData("unclaimedZoneIgnoreIds", "mediumtext NOT NULL"));
        columns.add(new ColumnData("usingPlotManagementDelete", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("plotManagementDeleteIds", "mediumtext NOT NULL"));
        columns.add(new ColumnData("isDeletingEntitiesOnUnclaim", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("unclaimDeleteEntityTypes", "mediumtext NOT NULL"));
        columns.add(new ColumnData("usingPlotManagementMayorDelete", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("plotManagementMayorDelete", "mediumtext NOT NULL"));
        columns.add(new ColumnData("usingPlotManagementRevert", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("plotManagementIgnoreIds", "mediumtext NOT NULL"));
        columns.add(new ColumnData("revertOnUnclaimWhitelistMaterials", "mediumtext NOT NULL"));
        columns.add(new ColumnData("usingPlotManagementWildRegen", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("plotManagementWildRegenEntities", "mediumtext NOT NULL"));
        columns.add(new ColumnData("plotManagementWildRegenBlockWhitelist", "mediumtext NOT NULL"));
        columns.add(new ColumnData("wildRegenBlocksToNotOverwrite", "mediumtext NOT NULL"));
        columns.add(new ColumnData("plotManagementWildRegenSpeed", "long NOT NULL"));
        columns.add(new ColumnData("usingPlotManagementWildRegenBlocks", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("plotManagementWildRegenBlocks", "mediumtext NOT NULL"));
        columns.add(new ColumnData("usingTowny", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("warAllowed", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("metadata", "mediumtext DEFAULT NULL"));
        columns.add(new ColumnData("jailing", "bool NOT NULL DEFAULT '1'"));
        return columns;
    }

    private static List<ColumnData> getTownBlockColumns() {
        ArrayList<ColumnData> columns = new ArrayList<ColumnData>();
        columns.add(new ColumnData("name", "mediumtext"));
        columns.add(new ColumnData("price", "float DEFAULT '-1'"));
        columns.add(new ColumnData("taxed", "bool NOT NULL DEFAULT '1'"));
        columns.add(new ColumnData("town", "mediumtext"));
        columns.add(new ColumnData("resident", "mediumtext"));
        columns.add(new ColumnData("type", "TINYINT NOT  NULL DEFAULT '0'"));
        columns.add(new ColumnData("typeName", "mediumtext"));
        columns.add(new ColumnData("outpost", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("permissions", "mediumtext NOT NULL"));
        columns.add(new ColumnData("locked", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("changed", "bool NOT NULL DEFAULT '0'"));
        columns.add(new ColumnData("metadata", "mediumtext DEFAULT NULL"));
        columns.add(new ColumnData("groupID", "VARCHAR(36) DEFAULT NULL"));
        columns.add(new ColumnData("districtID", "VARCHAR(36) DEFAULT NULL"));
        columns.add(new ColumnData("claimedAt", "BIGINT NOT NULL"));
        columns.add(new ColumnData("trustedResidents", "mediumtext DEFAULT NULL"));
        columns.add(new ColumnData("customPermissionData", "mediumtext DEFAULT NULL"));
        columns.add(new ColumnData("minTownMembershipDays", "SMALLINT NOT NULL DEFAULT '-1'"));
        columns.add(new ColumnData("maxTownMembershipDays", "SMALLINT NOT NULL DEFAULT '-1'"));
        return columns;
    }

    private static List<ColumnData> getCooldownColumns() {
        ArrayList<ColumnData> columns = new ArrayList<ColumnData>();
        columns.add(new ColumnData("key", "varchar(200) NOT NULL"));
        columns.add(new ColumnData("expiry", "BIGINT NOT NULL"));
        return columns;
    }

    private record ColumnData(String name, String dataType) {
        @Override
        @NotNull
        public String toString() {
            return "`" + this.name + "` " + this.dataType;
        }
    }
}

