/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.DeleteNationEvent;
import com.palmergames.bukkit.towny.event.DeleteTownEvent;
import com.palmergames.bukkit.towny.event.town.TownPreUnclaimEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.District;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TownyDataSource {
    final Lock lock = new ReentrantLock();
    protected final Towny plugin;
    protected final TownyUniverse universe;

    TownyDataSource(Towny plugin, TownyUniverse universe) {
        this.plugin = plugin;
        this.universe = universe;
    }

    public abstract boolean backup() throws IOException;

    public boolean loadAll() {
        return this.loadWorldList() && this.loadNationList() && this.loadTownList() && this.loadPlotGroupList() && this.loadDistrictList() && this.loadJailList() && this.loadResidentList() && this.loadTownBlockList() && this.loadWorlds() && this.loadResidents() && this.loadTowns() && this.loadNations() && this.loadTownBlocks() && this.loadPlotGroups() && this.loadDistricts() && this.loadJails() && this.loadRegenList() && this.loadCooldowns();
    }

    public boolean saveAll() {
        return this.saveWorlds() && this.saveNations() && this.saveTowns() && this.saveResidents() && this.savePlotGroups() && this.saveDistricts() && this.saveTownBlocks() && this.saveJails() && this.saveRegenList() && this.saveCooldowns();
    }

    public boolean saveAllWorlds() {
        return this.saveWorlds();
    }

    public boolean saveQueues() {
        return this.saveRegenList();
    }

    public abstract void finishTasks();

    public abstract boolean loadTownBlockList();

    public abstract boolean loadResidentList();

    public abstract boolean loadTownList();

    public abstract boolean loadNationList();

    public abstract boolean loadWorldList();

    public abstract boolean loadRegenList();

    public abstract boolean loadTownBlocks();

    public abstract boolean loadJailList();

    public abstract boolean loadResident(Resident var1);

    public abstract boolean loadTown(Town var1);

    public abstract boolean loadNation(Nation var1);

    public abstract boolean loadWorld(TownyWorld var1);

    public abstract boolean loadJail(Jail var1);

    public abstract boolean loadPlotGroupList();

    public abstract boolean loadPlotGroup(PlotGroup var1);

    public abstract boolean loadDistrictList();

    public abstract boolean loadDistrict(District var1);

    public abstract boolean saveRegenList();

    public abstract boolean saveResident(Resident var1);

    public abstract boolean saveHibernatedResident(UUID var1, long var2);

    public abstract boolean saveTown(Town var1);

    public abstract boolean savePlotGroup(PlotGroup var1);

    public abstract boolean saveDistrict(District var1);

    public abstract boolean saveJail(Jail var1);

    public abstract boolean saveNation(Nation var1);

    public abstract boolean saveWorld(TownyWorld var1);

    public abstract boolean saveTownBlock(TownBlock var1);

    public abstract boolean savePlotData(PlotBlockData var1);

    public abstract PlotBlockData loadPlotData(String var1, int var2, int var3);

    public abstract PlotBlockData loadPlotData(TownBlock var1);

    public abstract boolean hasPlotData(TownBlock var1);

    public abstract void deletePlotData(PlotBlockData var1);

    public abstract void deleteResident(Resident var1);

    public abstract void deleteHibernatedResident(UUID var1);

    public abstract void deleteTown(Town var1);

    public abstract void deleteNation(Nation var1);

    public abstract void deleteWorld(TownyWorld var1);

    public abstract void deleteTownBlock(TownBlock var1);

    public abstract void deleteFile(String var1);

    public abstract void deletePlotGroup(PlotGroup var1);

    public abstract void deleteDistrict(District var1);

    public abstract void deleteJail(Jail var1);

    public abstract CompletableFuture<Optional<Long>> getHibernatedResidentRegistered(UUID var1);

    public boolean cleanup() {
        return true;
    }

    public boolean loadResidents() {
        TownyMessaging.sendDebugMsg("Loading Residents");
        for (Resident resident : this.universe.getResidents()) {
            if (this.loadResident(resident)) continue;
            this.plugin.getLogger().severe("Loading Error: Could not read resident data '" + resident.getName() + "'.");
            return false;
        }
        return true;
    }

    public boolean loadTowns() {
        TownyMessaging.sendDebugMsg("Loading Towns");
        for (Town town : this.universe.getTowns()) {
            if (this.loadTown(town)) continue;
            this.plugin.getLogger().severe("Loading Error: Could not read town data '" + town.getName() + "'.");
            return false;
        }
        return true;
    }

    public boolean loadNations() {
        TownyMessaging.sendDebugMsg("Loading Nations");
        for (Nation nation : this.universe.getNations()) {
            if (this.loadNation(nation)) continue;
            this.plugin.getLogger().severe("Loading Error: Could not read nation data '" + nation.getName() + "'.");
            return false;
        }
        return true;
    }

    public boolean loadWorlds() {
        TownyMessaging.sendDebugMsg("Loading Worlds");
        for (TownyWorld world : this.universe.getTownyWorlds()) {
            if (this.loadWorld(world)) continue;
            this.plugin.getLogger().severe("Loading Error: Could not read world data '" + world.getName() + "'.");
            return false;
        }
        return true;
    }

    public boolean loadJails() {
        TownyMessaging.sendDebugMsg("Loading Jails");
        for (Jail jail : this.universe.getJails()) {
            if (this.loadJail(jail)) continue;
            this.plugin.getLogger().severe("Loading Error: Could not read jail data '" + String.valueOf(jail.getUUID()) + "'.");
            return false;
        }
        return true;
    }

    public boolean loadPlotGroups() {
        TownyMessaging.sendDebugMsg("Loading PlotGroups");
        for (PlotGroup group : this.universe.getGroups()) {
            if (this.loadPlotGroup(group)) continue;
            this.plugin.getLogger().severe("Loading Error: Could not read PlotGroup data: '" + String.valueOf(group.getUUID()) + "'.");
            return false;
        }
        return true;
    }

    public boolean loadDistricts() {
        TownyMessaging.sendDebugMsg("Loading Districts");
        for (District district : this.universe.getDistricts()) {
            if (this.loadDistrict(district)) continue;
            this.plugin.getLogger().severe("Loading Error: Could not read District data: '" + String.valueOf(district.getUUID()) + "'.");
            return false;
        }
        return true;
    }

    public abstract boolean loadCooldowns();

    public boolean saveResidents() {
        TownyMessaging.sendDebugMsg("Saving Residents");
        for (Resident resident : this.universe.getResidents()) {
            this.saveResident(resident);
        }
        return true;
    }

    public boolean savePlotGroups() {
        TownyMessaging.sendDebugMsg("Saving PlotGroups");
        for (PlotGroup plotGroup : this.universe.getGroups()) {
            if (plotGroup.hasTownBlocks()) {
                this.savePlotGroup(plotGroup);
                continue;
            }
            this.deletePlotGroup(plotGroup);
        }
        return true;
    }

    public boolean saveDistricts() {
        TownyMessaging.sendDebugMsg("Saving Districts");
        for (District district : this.universe.getDistricts()) {
            if (district.hasTownBlocks()) {
                this.saveDistrict(district);
                continue;
            }
            this.deleteDistrict(district);
        }
        return true;
    }

    public boolean saveJails() {
        TownyMessaging.sendDebugMsg("Saving Jails");
        for (Jail jail : this.universe.getJails()) {
            this.saveJail(jail);
        }
        return true;
    }

    public boolean saveTowns() {
        TownyMessaging.sendDebugMsg("Saving Towns");
        for (Town town : this.universe.getTowns()) {
            this.saveTown(town);
        }
        return true;
    }

    public boolean saveNations() {
        TownyMessaging.sendDebugMsg("Saving Nations");
        for (Nation nation : this.universe.getNations()) {
            this.saveNation(nation);
        }
        return true;
    }

    public boolean saveWorlds() {
        TownyMessaging.sendDebugMsg("Saving Worlds");
        for (TownyWorld world : this.universe.getTownyWorlds()) {
            this.saveWorld(world);
        }
        return true;
    }

    public boolean saveTownBlocks() {
        TownyMessaging.sendDebugMsg("Saving Townblocks");
        for (Town town : this.universe.getTowns()) {
            for (TownBlock townBlock : town.getTownBlocks()) {
                this.saveTownBlock(townBlock);
            }
        }
        return true;
    }

    public abstract boolean saveCooldowns();

    public abstract void removeResident(Resident var1);

    public abstract void removeTownBlock(TownBlock var1) throws TownyException;

    public abstract void removeTownBlock(TownBlock var1, TownPreUnclaimEvent.Cause var2) throws TownyException;

    public abstract void removeTownBlocks(Town var1);

    public boolean removeNation(@NotNull Nation nation, @NotNull DeleteNationEvent.Cause cause) {
        return this.removeNation(nation, cause, null);
    }

    public abstract boolean removeNation(@NotNull Nation var1, @NotNull DeleteNationEvent.Cause var2, @Nullable CommandSender var3);

    @NotNull
    public abstract Resident newResident(String var1) throws AlreadyRegisteredException, NotRegisteredException;

    @NotNull
    public abstract Resident newResident(String var1, UUID var2) throws AlreadyRegisteredException, NotRegisteredException;

    public abstract void newNation(String var1) throws AlreadyRegisteredException, NotRegisteredException;

    public abstract void newNation(String var1, UUID var2) throws AlreadyRegisteredException, NotRegisteredException;

    public abstract void newWorld(String var1) throws AlreadyRegisteredException;

    public boolean removeTown(Town town, @NotNull DeleteTownEvent.Cause cause) {
        return this.removeTown(town, cause, null);
    }

    public boolean removeTown(@NotNull Town town, @NotNull DeleteTownEvent.Cause cause, @Nullable CommandSender sender) {
        return this.removeTown(town, cause, sender, TownySettings.getTownRuinsEnabled() && !town.isRuined());
    }

    public abstract boolean removeTown(@NotNull Town var1, @NotNull DeleteTownEvent.Cause var2, @Nullable CommandSender var3, boolean var4);

    public abstract void removeWorld(TownyWorld var1) throws UnsupportedOperationException;

    public abstract void removeJail(Jail var1);

    public abstract void removePlotGroup(PlotGroup var1);

    public abstract void removeDistrict(District var1);

    public abstract void renameTown(Town var1, String var2) throws AlreadyRegisteredException, NotRegisteredException;

    public abstract void renameNation(Nation var1, String var2) throws AlreadyRegisteredException, NotRegisteredException;

    public abstract void mergeNation(Nation var1, Nation var2);

    public abstract void mergeTown(Town var1, Town var2);

    public abstract void renamePlayer(Resident var1, String var2) throws AlreadyRegisteredException, NotRegisteredException;

    public abstract void renameGroup(PlotGroup var1, String var2) throws AlreadyRegisteredException;

    public abstract void renameDistrict(District var1, String var2) throws AlreadyRegisteredException;

    @Deprecated
    public void removeTown(Town town) {
        this.removeTown(town, DeleteTownEvent.Cause.UNKNOWN);
    }

    @Deprecated
    public void removeNation(Nation nation) {
        this.removeNation(nation, DeleteNationEvent.Cause.UNKNOWN, null);
    }
}

