/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.db.TownyDataSource;
import com.palmergames.bukkit.towny.db.TownyFlatFileSource;
import com.palmergames.bukkit.towny.event.DeleteNationEvent;
import com.palmergames.bukkit.towny.event.DeletePlayerEvent;
import com.palmergames.bukkit.towny.event.DeleteTownEvent;
import com.palmergames.bukkit.towny.event.NationRemoveTownEvent;
import com.palmergames.bukkit.towny.event.PreDeleteNationEvent;
import com.palmergames.bukkit.towny.event.PreDeleteTownEvent;
import com.palmergames.bukkit.towny.event.RenameNationEvent;
import com.palmergames.bukkit.towny.event.RenameResidentEvent;
import com.palmergames.bukkit.towny.event.RenameTownEvent;
import com.palmergames.bukkit.towny.event.town.TownPreRuinedEvent;
import com.palmergames.bukkit.towny.event.town.TownPreUnclaimEvent;
import com.palmergames.bukkit.towny.event.town.TownUnclaimEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.InvalidNameException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.object.District;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.object.jail.UnJailReason;
import com.palmergames.bukkit.towny.object.metadata.DataFieldIO;
import com.palmergames.bukkit.towny.object.resident.mode.ResidentModeHandler;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.regen.WorldCoordEntityRemover;
import com.palmergames.bukkit.towny.regen.WorldCoordMaterialRemover;
import com.palmergames.bukkit.towny.scheduling.ScheduledTask;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.tasks.DeleteFileTask;
import com.palmergames.bukkit.towny.utils.JailUtil;
import com.palmergames.bukkit.towny.utils.TownRuinUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.FileMgmt;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TownyDatabaseHandler
extends TownyDataSource {
    public static final SimpleDateFormat BACKUP_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH_mm_ssZ");
    final String rootFolderPath;
    final String dataFolderPath;
    final String settingsFolderPath;
    final String logFolderPath;
    final String backupFolderPath;
    protected final Queue<Runnable> queryQueue = new ConcurrentLinkedQueue<Runnable>();
    private final ScheduledTask task;

    protected TownyDatabaseHandler(Towny plugin, TownyUniverse universe) {
        super(plugin, universe);
        this.rootFolderPath = universe.getRootFolder();
        this.dataFolderPath = this.rootFolderPath + File.separator + "data";
        this.settingsFolderPath = this.rootFolderPath + File.separator + "settings";
        this.logFolderPath = this.rootFolderPath + File.separator + "logs";
        this.backupFolderPath = this.rootFolderPath + File.separator + "backup";
        if (!FileMgmt.checkOrCreateFolders(this.rootFolderPath, this.rootFolderPath + File.separator + "logs", this.dataFolderPath, this.dataFolderPath + File.separator + "plot-block-data") || !FileMgmt.checkOrCreateFiles(this.dataFolderPath + File.separator + "regen.txt", this.dataFolderPath + File.separator + "snapshot_queue.txt")) {
            TownyMessaging.sendErrorMsg("Could not create flatfile default files and folders.");
        }
        this.task = plugin.getScheduler().runAsyncRepeating(() -> {
            Queue<Runnable> queue = this.queryQueue;
            synchronized (queue) {
                while (!this.queryQueue.isEmpty()) {
                    Runnable operation = this.queryQueue.poll();
                    operation.run();
                }
            }
        }, 5L, 5L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishTasks() {
        Queue<Runnable> queue = this.queryQueue;
        synchronized (queue) {
            if (this.task != null) {
                this.task.cancel();
            }
            while (!this.queryQueue.isEmpty()) {
                Runnable operation = this.queryQueue.poll();
                operation.run();
            }
        }
    }

    @Override
    public boolean backup() throws IOException {
        if (!TownySettings.getSaveDatabase().equalsIgnoreCase("flatfile") && !TownySettings.disableMySQLBackupWarning()) {
            this.plugin.getLogger().info("***** Warning *****");
            this.plugin.getLogger().info("***** Only Snapshots & Regen files in plugins/Towny/data/ will be backed up!");
            this.plugin.getLogger().info("***** This does not include your residents/towns/nations.");
            this.plugin.getLogger().info("***** Make sure you have scheduled a backup in MySQL too!!!");
            this.plugin.getLogger().info("***** If you already have backups or accept the risk, this message can be disabled in the database config.");
        }
        String backupType = TownySettings.getFlatFileBackupType();
        String newBackupFolder = this.backupFolderPath + File.separator + BACKUP_DATE_FORMAT.format(System.currentTimeMillis());
        FileMgmt.checkOrCreateFolders(this.rootFolderPath, this.rootFolderPath + File.separator + "backup");
        return switch (backupType.toLowerCase(Locale.ROOT)) {
            case "folder" -> {
                FileMgmt.checkOrCreateFolder(newBackupFolder);
                FileMgmt.copyDirectory(new File(this.dataFolderPath), new File(newBackupFolder));
                FileMgmt.copyDirectory(new File(this.logFolderPath), new File(newBackupFolder));
                FileMgmt.copyDirectory(new File(this.settingsFolderPath), new File(newBackupFolder));
                yield true;
            }
            case "zip" -> {
                FileMgmt.zipDirectories(new File(newBackupFolder + ".zip"), new File(this.dataFolderPath), new File(this.logFolderPath), new File(this.settingsFolderPath));
                yield true;
            }
            case "tar.gz", "tar" -> {
                FileMgmt.tar(new File(newBackupFolder.concat(".tar.gz")), new File(this.dataFolderPath), new File(this.logFolderPath), new File(this.settingsFolderPath));
                yield true;
            }
            default -> false;
        };
    }

    @Override
    @NotNull
    public Resident newResident(String name) throws AlreadyRegisteredException, NotRegisteredException {
        return this.newResident(name, null);
    }

    @Override
    @NotNull
    public Resident newResident(String name, UUID uuid) throws AlreadyRegisteredException, NotRegisteredException {
        String filteredName;
        try {
            filteredName = NameValidation.checkAndFilterPlayerName(name);
        }
        catch (InvalidNameException e) {
            throw new NotRegisteredException(e.getMessage());
        }
        if (this.universe.hasResident(name)) {
            throw new AlreadyRegisteredException("A resident with the name " + filteredName + " is already in use.");
        }
        Resident resident = new Resident(filteredName);
        if (uuid != null) {
            resident.setUUID(uuid);
        }
        this.universe.registerResident(resident);
        return resident;
    }

    @Override
    public void newNation(String name) throws AlreadyRegisteredException, NotRegisteredException {
        this.newNation(name, null);
    }

    @Override
    public void newNation(String name, @Nullable UUID uuid) throws AlreadyRegisteredException, NotRegisteredException {
        String filteredName;
        try {
            filteredName = NameValidation.checkAndFilterNationNameOrThrow(name);
        }
        catch (InvalidNameException e) {
            throw new NotRegisteredException(e.getMessage());
        }
        if (this.universe.hasNation(filteredName)) {
            throw new AlreadyRegisteredException("The nation " + filteredName + " is already in use.");
        }
        Nation nation = new Nation(filteredName);
        if (uuid != null) {
            nation.setUUID(uuid);
        }
        this.universe.registerNation(nation);
    }

    @Override
    public void newWorld(String name) throws AlreadyRegisteredException {
        if (this.universe.getWorldMap().containsKey(name.toLowerCase(Locale.ROOT))) {
            throw new AlreadyRegisteredException("The world " + name + " is already in use.");
        }
        this.universe.getWorldMap().put(name.toLowerCase(Locale.ROOT), new TownyWorld(name));
    }

    @Override
    public void removeResident(Resident resident) {
        for (Town town : this.universe.getTowns()) {
            if (!town.exists()) continue;
            boolean save = false;
            if (town.hasOutlaw(resident)) {
                town.removeOutlaw(resident);
                save = true;
            }
            if (town.hasTrustedResident(resident)) {
                town.removeTrustedResident(resident);
                save = true;
            }
            if (!save) continue;
            town.save();
        }
        for (PlotGroup plotGroup : this.universe.getGroups()) {
            if (!plotGroup.hasTrustedResident(resident)) continue;
            plotGroup.removeTrustedResident(resident);
            plotGroup.save();
        }
        for (TownBlock townBlock : this.universe.getTownBlocks().values()) {
            if (!townBlock.hasTrustedResident(resident)) continue;
            townBlock.removeTrustedResident(resident);
            townBlock.save();
        }
        for (TownBlock townBlock : new ArrayList<TownBlock>(resident.getTownBlocks())) {
            townBlock.setResident(null, false);
            resident.removeTownBlock(townBlock);
            if (townBlock.getType() != TownBlockType.EMBASSY) {
                townBlock.setPlotPrice(townBlock.getTownOrNull().getPlotPrice());
            }
            townBlock.setType(townBlock.getType());
            townBlock.save();
        }
        ArrayList<Resident> toSave = new ArrayList<Resident>();
        for (Resident toCheck : this.universe.getResidents()) {
            TownyMessaging.sendDebugMsg("Checking friends of: " + toCheck.getName());
            if (!toCheck.hasFriend(resident)) continue;
            TownyMessaging.sendDebugMsg("       - Removing Friend: " + resident.getName());
            toCheck.removeFriend(resident);
            toSave.add(toCheck);
        }
        for (Resident toCheck : toSave) {
            this.saveResident(toCheck);
        }
        if (resident.hasTown() && resident.getTownOrNull() != null) {
            resident.removeTown();
        }
        if (resident.hasUUID() && !resident.isNPC()) {
            this.saveHibernatedResident(resident.getUUID(), resident.getRegistered());
        }
        this.deleteResident(resident);
        try {
            this.universe.unregisterResident(resident);
        }
        catch (NotRegisteredException notRegisteredException) {
            this.plugin.getLogger().log(Level.WARNING, "An exception occurred while unregistering resident " + resident.getName(), notRegisteredException);
        }
        if (TownySettings.isDeleteEcoAccount() && TownyEconomyHandler.isActive()) {
            resident.getAccount().removeAccount();
        }
        this.plugin.deleteCache(resident);
        BukkitTools.fireEvent(new DeletePlayerEvent(resident));
    }

    @Override
    public void removeTownBlock(TownBlock townBlock) throws TownyException {
        this.removeTownBlock(townBlock, TownPreUnclaimEvent.Cause.UNKNOWN);
    }

    @Override
    public void removeTownBlock(TownBlock townBlock, TownPreUnclaimEvent.Cause cause) throws TownyException {
        Town town = townBlock.getTownOrNull();
        if (town == null) {
            this.plugin.getLogger().severe(String.format("The TownBlock at (%s, %d, %d) is not registered to a town.", townBlock.getWorld().getName(), townBlock.getX(), townBlock.getZ()));
        }
        if (!cause.ignoresPreEvent()) {
            BukkitTools.ifCancelledThenThrow(new TownPreUnclaimEvent(town, townBlock, cause));
        }
        if (townBlock.isJail() && townBlock.getJail() != null) {
            this.removeJail(townBlock.getJail());
        }
        if (TownySettings.getTownUnclaimCoolDownTime() > 0) {
            CooldownTimerTask.addCooldownTimer(townBlock.getWorldCoord().toString(), CooldownTimerTask.CooldownType.TOWNBLOCK_UNCLAIM);
        }
        this.universe.removeTownBlock(townBlock);
        this.deleteTownBlock(townBlock);
        if (townBlock.getWorld().isDeletingEntitiesOnUnclaim()) {
            WorldCoordEntityRemover.addToQueue(townBlock.getWorldCoord());
        }
        if (townBlock.getWorld().isUsingPlotManagementDelete()) {
            WorldCoordMaterialRemover.addToQueue(townBlock.getWorldCoord());
        }
        if (townBlock.getWorld().isUsingPlotManagementRevert()) {
            TownyRegenAPI.addToRegenQueueList(townBlock.getWorldCoord(), true);
        }
        BukkitTools.fireEvent(new TownUnclaimEvent(town, townBlock.getWorldCoord(), false));
    }

    @Override
    public void removeTownBlocks(Town town) {
        for (TownBlock townBlock : new ArrayList<TownBlock>(town.getTownBlocks())) {
            try {
                this.removeTownBlock(townBlock, TownPreUnclaimEvent.Cause.DELETE);
            }
            catch (TownyException townyException) {}
        }
    }

    @Override
    public boolean removeTown(@NotNull Town town, @NotNull DeleteTownEvent.Cause cause, @Nullable CommandSender sender, boolean delayFullRemoval) {
        if (delayFullRemoval) {
            TownPreRuinedEvent tpre = new TownPreRuinedEvent(town, cause, sender);
            if (!BukkitTools.isEventCancelled(tpre)) {
                TownRuinUtil.putTownIntoRuinedState(town);
                return false;
            }
            if (sender != null && !tpre.getCancelMessage().isEmpty()) {
                TownyMessaging.sendErrorMsg(tpre.getCancelMessage());
            }
        }
        PreDeleteTownEvent preEvent = new PreDeleteTownEvent(town, cause, sender);
        if (!cause.ignoresPreEvent() && BukkitTools.isEventCancelled(preEvent)) {
            if (sender != null && !preEvent.getCancelMessage().isEmpty()) {
                TownyMessaging.sendErrorMsg((Object)sender, preEvent.getCancelMessage());
            }
            return false;
        }
        Resident mayor = town.getMayor();
        TownyWorld townyWorld = town.getHomeblockWorld();
        if (town.hasSpawn()) {
            try {
                this.universe.removeSpawnPoint(town.getSpawn());
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
        this.removeTownBlocks(town);
        ArrayList toSave = new ArrayList(town.getResidents());
        if (town.hasNation()) {
            town.removeNation();
        }
        if (TownyEconomyHandler.isActive()) {
            town.getAccount().removeAccount();
        }
        for (Resident resident2 : toSave) {
            ResidentModeHandler.resetModes(resident2, false);
            resident2.removeTown(true);
        }
        new ArrayList<Resident>(this.universe.getJailedResidentMap()).stream().filter(resident -> resident.hasJailTown(town.getName())).forEach(resident -> JailUtil.unJailResident(resident, UnJailReason.JAIL_DELETED));
        if (townyWorld != null) {
            try {
                townyWorld.removeTown(town);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            this.saveWorld(townyWorld);
        }
        try {
            this.universe.unregisterTown(town);
        }
        catch (NotRegisteredException e) {
            TownyMessaging.sendErrorMsg(e.getMessage());
        }
        this.plugin.resetCache();
        this.deleteTown(town);
        BukkitTools.fireEvent(new DeleteTownEvent(town, mayor, cause, sender));
        TownyMessaging.sendGlobalMessage(Translatable.of("msg_del_town2", town.getName()));
        return true;
    }

    @Override
    public boolean removeNation(@NotNull Nation nation, @NotNull DeleteNationEvent.Cause cause, @Nullable CommandSender sender) {
        PreDeleteNationEvent preEvent = new PreDeleteNationEvent(nation, cause, sender);
        if (sender != null) {
            preEvent.setCancelMessage(Translatable.of("msg_err_you_cannot_delete_this_nation").forLocale(sender));
        }
        if (!cause.ignoresPreEvent() && BukkitTools.isEventCancelled(preEvent)) {
            if (sender != null && !preEvent.getCancelMessage().isEmpty()) {
                TownyMessaging.sendErrorMsg(preEvent.getCancelMessage());
            }
            return false;
        }
        Resident king = null;
        if (nation.hasKing()) {
            king = nation.getKing();
        }
        if (nation.hasSpawn()) {
            try {
                this.universe.removeSpawnPoint(nation.getSpawn());
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
        ArrayList<Nation> toSaveNation = new ArrayList<Nation>();
        for (Nation toCheck : new ArrayList<Nation>(this.universe.getNations())) {
            if (!toCheck.hasAlly(nation) && !toCheck.hasEnemy(nation)) continue;
            if (toCheck.hasAlly(nation)) {
                toCheck.removeAlly(nation);
            } else {
                toCheck.removeEnemy(nation);
            }
            toSaveNation.add(toCheck);
        }
        for (Nation toCheck : toSaveNation) {
            this.saveNation(toCheck);
        }
        for (Nation toCheck : new ArrayList<Nation>(this.universe.getNations())) {
            for (Invite invite : new ArrayList<Invite>(toCheck.getSentAllyInvites())) {
                if (!invite.getReceiver().getName().equalsIgnoreCase(nation.getName())) continue;
                toCheck.deleteSentAllyInvite(invite);
                InviteHandler.removeInvite(invite);
            }
        }
        for (Invite invite : new ArrayList<Invite>(nation.getSentAllyInvites())) {
            nation.deleteSentAllyInvite(invite);
            invite.getReceiver().deleteReceivedInvite(invite);
            InviteHandler.removeInvite(invite);
        }
        if (TownyEconomyHandler.isActive()) {
            nation.getAccount().removeAccount();
        }
        this.deleteNation(nation);
        ArrayList<Town> toSave = new ArrayList<Town>(nation.getTowns());
        nation.clear();
        try {
            this.universe.unregisterNation(nation);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        for (Town town : toSave) {
            if (!town.exists()) continue;
            for (Resident res : town.getResidents()) {
                res.updatePermsForNationRemoval();
                res.save();
            }
            try {
                town.setNation(null);
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                // empty catch block
            }
            town.save();
            BukkitTools.fireEvent(new NationRemoveTownEvent(town, nation));
        }
        this.plugin.resetCache();
        BukkitTools.fireEvent(new DeleteNationEvent(nation, king, cause, sender));
        return true;
    }

    @Override
    public void removeWorld(TownyWorld world) throws UnsupportedOperationException {
        this.deleteWorld(world);
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeJail(Jail jail) {
        new ArrayList<Resident>(this.universe.getJailedResidentMap()).stream().filter(resident -> resident.getJail().getUUID().equals(jail.getUUID())).forEach(resident -> JailUtil.unJailResident(resident, UnJailReason.JAIL_DELETED));
        if (jail.hasCells()) {
            jail.removeAllCells();
        }
        if (jail.getTown() != null) {
            jail.getTown().removeJail(jail);
        }
        this.universe.unregisterJail(jail);
        this.deleteJail(jail);
    }

    @Override
    public void removePlotGroup(PlotGroup group) {
        this.universe.unregisterGroup(group.getUUID());
        this.deletePlotGroup(group);
    }

    @Override
    public void removeDistrict(District district) {
        this.universe.unregisterDistrict(district.getUUID());
        this.deleteDistrict(district);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameTown(Town town, String newName) throws AlreadyRegisteredException, NotRegisteredException {
        String oldName;
        this.lock.lock();
        try {
            TownyWorld world;
            String filteredName;
            try {
                filteredName = NameValidation.checkAndFilterTownNameOrThrow(newName);
            }
            catch (InvalidNameException e) {
                throw new NotRegisteredException(e.getMessage());
            }
            if (this.universe.hasTown(filteredName)) {
                throw new AlreadyRegisteredException("The town " + filteredName + " is already in use.");
            }
            ArrayList toSave = new ArrayList(town.getResidents());
            boolean isCapital = false;
            Nation nation = null;
            double townBalance = 0.0;
            oldName = town.getName();
            if (TownyEconomyHandler.isActive()) {
                if (TownyEconomyHandler.canRenameAccounts()) {
                    TownyEconomyHandler.rename(town, TownySettings.getTownAccountPrefix() + filteredName);
                } else {
                    try {
                        townBalance = town.getAccount().getHoldingBalance();
                        town.getAccount().withdraw(townBalance, "Rename Town - Transfer from old account");
                    }
                    catch (Exception ignored) {
                        TownyMessaging.sendErrorMsg("The bank balance for the town " + oldName + " could not be received from the economy plugin and will not be able to be converted.");
                    }
                }
            }
            UUID oldUUID = town.getUUID();
            long oldregistration = town.getRegistered();
            if (town.hasNation()) {
                nation = town.getNationOrNull();
                isCapital = town.isCapital();
            }
            if ((world = town.getHomeblockWorld()).hasTown(town)) {
                world.removeTown(town);
            }
            this.deleteTown(town);
            this.universe.unregisterTown(town);
            town.setName(filteredName);
            this.universe.registerTown(town);
            world.addTown(town);
            if (isCapital) {
                nation.setCapital(town);
            }
            town.setUUID(oldUUID);
            town.setRegistered(oldregistration);
            if (TownyEconomyHandler.isActive()) {
                town.getAccount().setName(TownySettings.getTownAccountPrefix() + town.getName());
                if (!TownyEconomyHandler.canRenameAccounts()) {
                    town.getAccount().setBalance(townBalance, "Rename Town - Transfer to new account");
                }
            }
            for (Resident resident : toSave) {
                this.saveResident(resident);
            }
            town.saveTownBlocks();
            if (town.hasPlotGroups()) {
                for (PlotGroup pg : town.getPlotGroups()) {
                    pg.setTown(town);
                    this.savePlotGroup(pg);
                }
            }
            this.saveTown(town);
            this.saveWorld(town.getHomeblockWorld());
            if (nation != null) {
                this.saveNation(nation);
            }
        }
        finally {
            this.lock.unlock();
        }
        BukkitTools.fireEvent(new RenameTownEvent(oldName, town));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameNation(Nation nation, String newName) throws AlreadyRegisteredException, NotRegisteredException {
        String oldName;
        this.lock.lock();
        try {
            String filteredName;
            try {
                filteredName = NameValidation.checkAndFilterNationNameOrThrow(newName);
            }
            catch (InvalidNameException e) {
                throw new NotRegisteredException(e.getMessage());
            }
            if (this.universe.hasNation(filteredName)) {
                throw new AlreadyRegisteredException("The nation " + filteredName + " is already in use.");
            }
            ArrayList<Town> toSave = new ArrayList<Town>(nation.getTowns());
            double nationBalance = 0.0;
            if (TownyEconomyHandler.isActive()) {
                if (TownyEconomyHandler.canRenameAccounts()) {
                    TownyEconomyHandler.rename(nation, TownySettings.getNationAccountPrefix() + filteredName);
                } else {
                    try {
                        nationBalance = nation.getAccount().getHoldingBalance();
                        nation.getAccount().setBalance(0.0, "Rename Nation - Transfer from old account");
                    }
                    catch (Exception ignored) {
                        TownyMessaging.sendErrorMsg("The bank balance for the nation " + nation.getName() + ", could not be received from the economy plugin and will not be able to be converted.");
                    }
                }
            }
            this.deleteNation(nation);
            oldName = nation.getName();
            this.universe.unregisterNation(nation);
            nation.setName(filteredName);
            this.universe.registerNation(nation);
            if (TownyEconomyHandler.isActive()) {
                nation.getAccount().setName(TownySettings.getNationAccountPrefix() + nation.getName());
                if (!TownyEconomyHandler.canRenameAccounts()) {
                    nation.getAccount().setBalance(nationBalance, "Rename Nation - Transfer to new account");
                }
            }
            for (Town town : toSave) {
                this.saveTown(town);
            }
            this.saveNation(nation);
            Nation oldNation = new Nation(oldName);
            ArrayList toSaveNations = new ArrayList();
            this.universe.getNations().stream().filter(n -> n.hasAlly(oldNation) || n.hasEnemy(oldNation)).forEach(n -> {
                if (n.hasAlly(oldNation)) {
                    n.removeAlly(oldNation);
                    n.addAlly(nation);
                } else {
                    n.removeEnemy(oldNation);
                    n.addEnemy(nation);
                }
                toSaveNations.add(n);
            });
            toSaveNations.forEach(Nation::save);
        }
        finally {
            this.lock.unlock();
        }
        BukkitTools.fireEvent(new RenameNationEvent(oldName, nation));
    }

    @Override
    public void renameGroup(PlotGroup group, String newName) throws AlreadyRegisteredException {
        group.setName(newName);
        this.savePlotGroup(group);
    }

    @Override
    public void renameDistrict(District district, String newName) throws AlreadyRegisteredException {
        district.setName(newName);
        this.saveDistrict(district);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renamePlayer(Resident resident, String newName) throws AlreadyRegisteredException, NotRegisteredException {
        this.lock.lock();
        String oldName = resident.getName();
        try {
            double balance = 0.0;
            if (TownyEconomyHandler.isActive() && TownyEconomyHandler.getVersion().startsWith("iConomy 5")) {
                balance = resident.getAccount().getHoldingBalance();
                resident.getAccount().removeAccount();
            }
            if (TownyEconomyHandler.isActive() && resident.getAccountOrNull() != null) {
                resident.getAccount().setName(newName);
            }
            this.universe.unregisterResident(resident);
            resident.setName(newName);
            this.universe.registerResident(resident);
            if (TownyEconomyHandler.isActive() && TownyEconomyHandler.getVersion().startsWith("iConomy 5")) {
                resident.getAccount().setName(resident.getName());
                resident.getAccount().setBalance(balance, "Rename Player - Transfer to new account");
            }
            this.saveResident(resident);
            for (TownBlock tb2 : resident.getTownBlocks()) {
                this.saveTownBlock(tb2);
            }
            if (resident.isMayor()) {
                this.saveTown(resident.getTown());
            }
            Resident oldResident = new Resident(oldName);
            oldResident.setUUID(resident.getUUID());
            HashSet<Resident> residentsToSave = new HashSet<Resident>();
            for (Resident toCheck : new ArrayList<Resident>(this.universe.getResidents())) {
                if (!toCheck.hasFriend(oldResident)) continue;
                toCheck.removeFriend(oldResident);
                toCheck.addFriend(resident);
                residentsToSave.add(toCheck);
            }
            residentsToSave.forEach(Resident::save);
            HashSet<Town> townsToSave = new HashSet<Town>();
            for (Town toCheckTown : new ArrayList<Town>(this.universe.getTowns())) {
                if (toCheckTown.hasOutlaw(oldResident)) {
                    toCheckTown.removeOutlaw(oldResident);
                    toCheckTown.addOutlaw(resident);
                    townsToSave.add(toCheckTown);
                }
                if (!toCheckTown.hasTrustedResident(oldResident)) continue;
                toCheckTown.removeTrustedResident(oldResident);
                toCheckTown.addTrustedResident(resident);
                townsToSave.add(toCheckTown);
            }
            townsToSave.forEach(Town::save);
            new ArrayList<TownBlock>(this.universe.getTownBlocks().values()).stream().filter(tb -> tb.hasTrustedResident(oldResident)).forEach(tb -> {
                tb.removeTrustedResident(oldResident);
                tb.addTrustedResident(resident);
            });
            this.deleteResident(oldResident);
        }
        finally {
            this.lock.unlock();
        }
        BukkitTools.fireEvent(new RenameResidentEvent(oldName, resident));
    }

    @Override
    public boolean savePlotData(PlotBlockData plotChunk) {
        String path = this.getPlotFilename(plotChunk);
        this.queryQueue.add(() -> {
            File file = new File(this.dataFolderPath + File.separator + "plot-block-data" + File.separator + plotChunk.getWorldName());
            FileMgmt.savePlotData(plotChunk, file, path);
        });
        return true;
    }

    @Override
    public PlotBlockData loadPlotData(String worldName, int x, int z) {
        TownyWorld world = this.universe.getWorld(worldName);
        if (world == null) {
            return null;
        }
        return this.loadPlotData(new TownBlock(x, z, world));
    }

    @Override
    public PlotBlockData loadPlotData(TownBlock townBlock) {
        PlotBlockData plotBlockData = null;
        try {
            plotBlockData = new PlotBlockData(townBlock);
        }
        catch (NullPointerException e1) {
            TownyMessaging.sendErrorMsg("Unable to load plotblockdata for townblock: " + townBlock.getWorldCoord().toString() + ". Skipping regeneration for this townBlock.");
            return null;
        }
        String fileName = this.getPlotFilename(townBlock);
        if (this.isFile(fileName)) {
            PlotBlockData plotBlockData2;
            ZipFile zipFile = new ZipFile(fileName);
            try {
                InputStream stream = zipFile.getInputStream(zipFile.entries().nextElement());
                plotBlockData2 = this.loadDataStream(plotBlockData, stream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        zipFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.plugin.getLogger().log(Level.WARNING, "An exception occurred while loading plot block data from file " + fileName, e);
                    return null;
                }
            }
            zipFile.close();
            return plotBlockData2;
        }
        if (this.isFile(this.getLegacyPlotFilename(townBlock))) {
            try {
                return this.loadDataStream(plotBlockData, new FileInputStream(this.getLegacyPlotFilename(townBlock)));
            }
            catch (FileNotFoundException e) {
                this.plugin.getLogger().log(Level.WARNING, "Could not find file for legacy plot block data file for townblock " + String.valueOf(townBlock), e);
                return null;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PlotBlockData loadDataStream(PlotBlockData plotBlockData, InputStream stream) {
        int version = 0;
        ArrayList<String> blockArr = new ArrayList<String>();
        try (DataInputStream fin2 = new DataInputStream(stream);){
            String value;
            fin2.mark(3);
            byte[] key = new byte[3];
            fin2.read(key, 0, 3);
            String test = new String(key);
            if (TownyFlatFileSource.elements.fromString(test) != TownyFlatFileSource.elements.VER) {
                PlotBlockData plotBlockData2 = null;
                return plotBlockData2;
            }
            version = fin2.read();
            if (version < 4) {
                PlotBlockData plotBlockData3 = null;
                return plotBlockData3;
            }
            plotBlockData.setVersion(version);
            plotBlockData.setHeight(fin2.readInt());
            plotBlockData.setMinHeight(version == 4 ? 0 : fin2.readInt());
            while ((value = fin2.readUTF()) != null) {
                blockArr.add(value);
            }
        }
        catch (EOFException fin2) {
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "An exception occurred while loading plot block data stream", e);
        }
        plotBlockData.setBlockList(blockArr);
        plotBlockData.resetBlockListRestored();
        return plotBlockData;
    }

    @Override
    public void deletePlotData(PlotBlockData plotChunk) {
        File file = new File(this.getPlotFilename(plotChunk));
        this.queryQueue.add(new DeleteFileTask(file, true));
    }

    @Override
    public boolean hasPlotData(TownBlock townBlock) {
        return this.isFile(this.getPlotFilename(townBlock));
    }

    private String getPlotFilename(PlotBlockData plotChunk) {
        return this.dataFolderPath + File.separator + "plot-block-data" + File.separator + plotChunk.getWorldName() + File.separator + plotChunk.getX() + "_" + plotChunk.getZ() + "_" + plotChunk.getSize() + ".zip";
    }

    private String getPlotFilename(TownBlock townBlock) {
        return this.dataFolderPath + File.separator + "plot-block-data" + File.separator + townBlock.getWorld().getName() + File.separator + townBlock.getX() + "_" + townBlock.getZ() + "_" + TownySettings.getTownBlockSize() + ".zip";
    }

    public String getLegacyPlotFilename(TownBlock townBlock) {
        return this.dataFolderPath + File.separator + "plot-block-data" + File.separator + townBlock.getWorld().getName() + File.separator + townBlock.getX() + "_" + townBlock.getZ() + "_" + TownySettings.getTownBlockSize() + ".data";
    }

    private boolean isFile(String fileName) {
        File file = new File(fileName);
        return file.exists() && file.isFile();
    }

    @Override
    public boolean loadRegenList() {
        boolean bl;
        TownyMessaging.sendDebugMsg("Loading Regen List");
        String line = null;
        BufferedReader fin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.dataFolderPath + File.separator + "regen.txt"), StandardCharsets.UTF_8));
        try {
            while ((line = fin.readLine()) != null) {
                if (line.equals("")) continue;
                String[] split = line.split(",");
                WorldCoord wc = new WorldCoord(split[0], Integer.parseInt(split[1]), Integer.parseInt(split[2]));
                TownyRegenAPI.addToRegenQueueList(wc, false);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Error Loading Regen List at " + line + ", in towny\\data\\regen.txt", e);
                return false;
            }
        }
        fin.close();
        return bl;
    }

    protected final String serializeMetadata(TownyObject obj) {
        return DataFieldIO.serializeCDFs(obj.getMetadata());
    }

    @Override
    public boolean saveRegenList() {
        this.queryQueue.add(() -> {
            File file = new File(this.dataFolderPath + File.separator + "regen.txt");
            Collection lines = TownyRegenAPI.getRegenQueueList().stream().map(wc -> wc.getWorldName() + "," + wc.getX() + "," + wc.getZ()).collect(Collectors.toList());
            FileMgmt.listToFile(lines, file.getPath());
        });
        return true;
    }

    @Override
    public void deleteFile(String fileName) {
        File file = new File(fileName);
        this.queryQueue.add(new DeleteFileTask(file, true));
    }

    @Override
    public void mergeNation(Nation succumbingNation, Nation prevailingNation) {
        if (TownyEconomyHandler.isActive()) {
            succumbingNation.getAccount().payTo(succumbingNation.getAccount().getHoldingBalance(), prevailingNation, "Nation merge bank accounts.");
        }
        this.lock.lock();
        ArrayList<Town> towns = new ArrayList<Town>(succumbingNation.getTowns());
        for (Town town : towns) {
            town.removeNation();
            try {
                town.setNation(prevailingNation);
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                // empty catch block
            }
            this.saveTown(town);
        }
        this.lock.unlock();
    }

    @Override
    public void mergeTown(Town mergeInto, Town mergeFrom) {
        if (TownyEconomyHandler.isActive() && mergeFrom.getAccount().getHoldingBalance() > 0.0) {
            mergeFrom.getAccount().payTo(mergeFrom.getAccount().getHoldingBalance(), mergeInto, Translation.of("msg_town_merge_transaction_reason"));
        }
        this.lock.lock();
        boolean isSameNation = mergeInto.hasNation() && mergeInto.getNationOrNull().hasTown(mergeFrom);
        String mayorName = mergeFrom.getMayor().getName();
        List jails = this.universe.getJailUUIDMap().values().stream().filter(jail -> jail.getTown().equals(mergeFrom)).collect(Collectors.toList());
        ArrayList<Location> outposts = new ArrayList<Location>(mergeFrom.getAllOutpostSpawns());
        mergeInto.addPurchasedBlocks(mergeFrom.getPurchasedBlocks());
        int mergeFromBonus = mergeFrom.getBonusBlocks();
        int newTownBonus = TownySettings.getNewTownBonusBlocks();
        if (newTownBonus > 0 && mergeFromBonus >= newTownBonus) {
            mergeFromBonus -= newTownBonus;
        }
        mergeInto.addBonusBlocks(mergeFromBonus);
        for (TownBlock tb : mergeFrom.getTownBlocks()) {
            tb.setTown(mergeInto);
            tb.save();
        }
        ArrayList residents = new ArrayList(mergeFrom.getResidents());
        for (Resident resident : residents) {
            try {
                if (mergeInto.hasOutlaw(resident)) {
                    resident.removeTown();
                    continue;
                }
                ArrayList<String> nationRanks = new ArrayList<String>(resident.getNationRanks());
                resident.removeTown();
                resident.setTown(mergeInto);
                if (isSameNation) {
                    for (String rank : nationRanks) {
                        resident.addNationRank(rank);
                    }
                }
                resident.save();
            }
            catch (TownyException nationRanks) {}
        }
        for (Resident outlaw : mergeFrom.getOutlaws()) {
            if (mergeInto.hasOutlaw(outlaw) || mergeInto.hasResident(outlaw)) continue;
            try {
                mergeInto.addOutlaw(outlaw);
            }
            catch (AlreadyRegisteredException nationRanks) {}
        }
        for (Jail jail2 : jails) {
            TownBlock jailPlot = jail2.getTownBlock();
            if (jailPlot.getType() != TownBlockType.JAIL) {
                jailPlot.setType(TownBlockType.JAIL);
            }
            jail2.setTown(mergeInto);
        }
        for (Location outpost : outposts) {
            mergeInto.addOutpostSpawn(outpost);
        }
        this.lock.unlock();
        this.removeTown(mergeFrom, DeleteTownEvent.Cause.MERGED, null, false);
        mergeInto.save();
        TownyMessaging.sendGlobalMessage(Translatable.of("msg_town_merge_success", mergeFrom.getName(), mayorName, mergeInto.getName()));
    }

    public List<UUID> toUUIDList(Collection<Resident> residents) {
        return residents.stream().filter(Resident::hasUUID).map(Resident::getUUID).collect(Collectors.toList());
    }

    public UUID[] toUUIDArray(String[] uuidArray) {
        UUID[] uuids = new UUID[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            try {
                uuids[i] = UUID.fromString(uuidArray[i]);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return uuids;
    }

    public String generateReplacementName(boolean town) {
        Random r = new Random();
        Object replacementName = "replacementname" + r.nextInt(99) + "1";
        try {
            replacementName = this.getNextName(town);
        }
        catch (TownyException townyException) {
            // empty catch block
        }
        return replacementName;
    }

    private String getNextName(boolean town) throws TownyException {
        String name = town ? "Town" : "Nation";
        int i = 0;
        do {
            String newName = name + ++i;
            if (!(town ? !this.universe.hasTown(newName) : !this.universe.hasNation(newName))) continue;
            return newName;
        } while (i <= 100000);
        throw new TownyException("Too many replacement names.");
    }
}

