/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.db.SQLSchema;
import com.palmergames.bukkit.towny.db.SQLTask;
import com.palmergames.bukkit.towny.db.TownyDatabaseHandler;
import com.palmergames.bukkit.towny.event.DeleteNationEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.exceptions.initialization.TownyInitException;
import com.palmergames.bukkit.towny.object.District;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PermissionData;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Position;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockTypeHandler;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.object.metadata.MetadataLoader;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.utils.MapUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.hikaricp.HikariConfig;
import com.palmergames.hikaricp.HikariDataSource;
import com.palmergames.hikaricp.pool.HikariPool;
import com.palmergames.util.FileMgmt;
import com.palmergames.util.StringMgmt;
import java.io.File;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.jetbrains.annotations.ApiStatus;

public final class TownySQLSource
extends TownyDatabaseHandler {
    private final String tb_prefix;
    private final HikariDataSource hikariDataSource;

    public TownySQLSource(Towny plugin, TownyUniverse universe) {
        super(plugin, universe);
        if (!FileMgmt.checkOrCreateFolders(this.rootFolderPath, this.dataFolderPath, this.dataFolderPath + File.separator + "plot-block-data") || !FileMgmt.checkOrCreateFiles(this.dataFolderPath + File.separator + "regen.txt", this.dataFolderPath + File.separator + "snapshot_queue.txt")) {
            TownyMessaging.sendErrorMsg("Could not create flatfile default files and folders.");
        }
        this.tb_prefix = TownySettings.getSQLTablePrefix().toUpperCase();
        String dsn = "jdbc:mysql://" + TownySettings.getSQLHostName() + ":" + TownySettings.getSQLPort() + "/" + TownySettings.getSQLDBName() + TownySettings.getSQLFlags();
        HikariConfig config = new HikariConfig();
        config.setPoolName("Towny MySQL");
        config.setJdbcUrl(dsn);
        config.setUsername(TownySettings.getSQLUsername());
        config.setPassword(TownySettings.getSQLPassword());
        config.addDataSourceProperty("cachePrepStmts", "true");
        config.addDataSourceProperty("prepStmtCacheSize", "250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        config.addDataSourceProperty("useServerPrepStmts", "true");
        config.addDataSourceProperty("useLocalSessionState", "true");
        config.addDataSourceProperty("rewriteBatchedStatements", "true");
        config.addDataSourceProperty("cacheResultSetMetadata", "true");
        config.addDataSourceProperty("cacheServerConfiguration", "true");
        config.addDataSourceProperty("elideSetAutoCommits", "true");
        config.addDataSourceProperty("maintainTimeStats", "false");
        config.addDataSourceProperty("cacheCallableStmts", "true");
        config.setMaximumPoolSize(TownySettings.getMaxPoolSize());
        config.setMaxLifetime(TownySettings.getMaxLifetime());
        config.setConnectionTimeout(TownySettings.getConnectionTimeout());
        try {
            Driver driver;
            try {
                driver = (Driver)Class.forName("com.mysql.cj.jdbc.Driver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                driver = (Driver)Class.forName("com.mysql.jdbc.Driver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            DriverManager.registerDriver(driver);
        }
        catch (Exception e) {
            plugin.getLogger().severe("Driver error: " + String.valueOf(e));
        }
        try {
            this.hikariDataSource = new HikariDataSource(config);
            try (Connection connection = this.getConnection();){
                TownyMessaging.sendDebugMsg("Connected to the database");
                SQLSchema.initTables(connection);
            }
        }
        catch (HikariPool.PoolInitializationException | SQLException e) {
            throw new TownyInitException("Failed to connect to the database", TownyInitException.TownyError.DATABASE, e);
        }
    }

    @Override
    public void finishTasks() {
        super.finishTasks();
        if (this.hikariDataSource != null) {
            this.hikariDataSource.close();
        }
    }

    public boolean isReady() {
        return this.hikariDataSource != null && this.hikariDataSource.isRunning();
    }

    public Connection getConnection() throws SQLException {
        return this.hikariDataSource.getConnection();
    }

    public boolean updateDB(String tb_name, Map<String, ?> args, List<String> keys) {
        this.queryQueue.add(new SQLTask(this, tb_name, args, keys));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public boolean queueUpdateDB(String tb_name, Map<String, ?> args, List<String> keys) {
        Statement stmt = null;
        ArrayList parameters = new ArrayList();
        int rs = 0;
        try (Connection connection = this.getConnection();){
            StringBuilder code;
            if (keys == null) {
                parameters.addAll(args.values());
                aKeys = args.keySet().toArray(new String[0]);
                code = new StringBuilder("REPLACE INTO " + this.tb_prefix + tb_name.toUpperCase() + " ");
                StringBuilder keycode = new StringBuilder("(");
                StringBuilder valuecode = new StringBuilder(" VALUES (");
                for (int count = 0; count < args.size(); ++count) {
                    keycode.append("`").append(aKeys[count]).append("`");
                    valuecode.append("?");
                    if (count < args.size() - 1) {
                        keycode.append(", ");
                        valuecode.append(",");
                        continue;
                    }
                    keycode.append(")");
                    valuecode.append(")");
                }
                code.append((CharSequence)keycode);
                code.append((CharSequence)valuecode);
            } else {
                int count;
                aKeys = args.keySet().toArray(new String[0]);
                code = new StringBuilder("UPDATE " + this.tb_prefix + tb_name.toUpperCase() + " SET ");
                for (count = 0; count < args.size(); ++count) {
                    code.append("`").append(aKeys[count]).append("` = ?");
                    parameters.add(args.get(aKeys[count]));
                    if (count >= args.size() - 1) continue;
                    code.append(",");
                }
                code.append(" WHERE ");
                for (count = 0; count < keys.size(); ++count) {
                    code.append("`").append(keys.get(count)).append("` = ?");
                    parameters.add(args.get(keys.get(count)));
                    if (count >= keys.size() - 1) continue;
                    code.append(" AND ");
                }
            }
            stmt = connection.prepareStatement(code.toString());
            for (int count = 0; count < parameters.size(); ++count) {
                Object element = parameters.get(count);
                if (element instanceof String) {
                    stmt.setString(count + 1, (String)element);
                    continue;
                }
                if (element instanceof Boolean) {
                    stmt.setString(count + 1, (Boolean)element != false ? "1" : "0");
                    continue;
                }
                stmt.setObject(count + 1, element.toString());
            }
            rs = stmt.executeUpdate();
        }
        catch (SQLException e) {
            Towny.getPlugin().getLogger().warning("SQL: " + e.getMessage() + " --> " + stmt.toString());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (rs == 0) {
                    return this.updateDB(tb_name, args, null);
                }
            }
            catch (SQLException e) {
                Towny.getPlugin().getLogger().warning("SQL closing: " + e.getMessage() + " --> " + stmt.toString());
            }
        }
        return rs != 0;
    }

    @ApiStatus.Internal
    public boolean DeleteDB(String tb_name, HashMap<String, Object> args) {
        this.queryQueue.add(new SQLTask(this, tb_name, args));
        return true;
    }

    @ApiStatus.Internal
    public boolean queueDeleteDB(String tb_name, Map<String, ?> args) {
        try {
            int rs;
            StringBuilder wherecode = new StringBuilder("DELETE FROM " + this.tb_prefix + tb_name.toUpperCase() + " WHERE ");
            Iterator<Map.Entry<String, ?>> i = args.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, ?> me = i.next();
                wherecode.append("`").append(me.getKey()).append("` = ?");
                wherecode.append(i.hasNext() ? " AND " : "");
            }
            try (Connection connection = this.getConnection();
                 PreparedStatement statement = connection.prepareStatement(wherecode.toString());){
                Object[] values = args.values().stream().toArray();
                for (int count = 0; count < values.length; ++count) {
                    Object object = values[count];
                    if (object instanceof String) {
                        String str = (String)object;
                        statement.setString(count + 1, str);
                        continue;
                    }
                    if (object instanceof Boolean) {
                        Boolean b = (Boolean)object;
                        statement.setBoolean(count + 1, b);
                        continue;
                    }
                    if (object instanceof UUID) {
                        UUID uuid = (UUID)object;
                        statement.setObject(count + 1, uuid.toString());
                        continue;
                    }
                    statement.setObject(count + 1, object);
                }
                rs = statement.executeUpdate();
            }
            if (rs == 0) {
                TownyMessaging.sendDebugMsg("SQL: delete returned 0: " + String.valueOf(wherecode));
            }
        }
        catch (SQLException e) {
            Towny.getPlugin().getLogger().warning("SQL: Error delete : " + e.getMessage());
        }
        return false;
    }

    @Override
    public boolean cleanup() {
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean loadTownBlockList() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean loadResidentList() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean loadTownList() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean loadNationList() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean loadWorldList() {
        block29: {
            TownyMessaging.sendDebugMsg("Loading World List");
            for (World world : Bukkit.getServer().getWorlds()) {
                this.universe.registerTownyWorld(new TownyWorld(world.getName(), world.getUID()));
            }
            try (Connection connection = this.getConnection();
                 Statement s = connection.createStatement();){
                ResultSet rs = s.executeQuery("SELECT name, uuid FROM " + this.tb_prefix + "WORLDS");
                block23: while (true) {
                    while (rs.next()) {
                        String name = rs.getString("name");
                        if (this.universe.getWorld(name) != null) continue;
                        UUID uuid = null;
                        try {
                            uuid = UUID.fromString(rs.getString("uuid"));
                        }
                        catch (IllegalArgumentException | NullPointerException | SQLException exception) {
                            // empty catch block
                        }
                        if (uuid != null) {
                            this.universe.registerTownyWorld(new TownyWorld(rs.getString("name"), uuid));
                            continue;
                        }
                        try {
                            this.newWorld(rs.getString("name"));
                            continue block23;
                        }
                        catch (AlreadyRegisteredException alreadyRegisteredException) {
                        }
                    }
                    break block29;
                    {
                        continue block23;
                        break;
                    }
                    break;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (SQLException e) {
                TownyMessaging.sendErrorMsg("SQL: world list sql error : " + e.getMessage());
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "SQL: world list unknown error", e);
            }
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean loadPlotGroupList() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean loadDistrictList() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean loadJailList() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadResidents() {
        TownyMessaging.sendDebugMsg("Loading Residents");
        try (Connection connection = this.getConnection();
             Statement s = connection.createStatement();
             ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "RESIDENTS");){
            Resident resident;
            block28: {
                while (rs.next()) {
                    String residentName;
                    try {
                        residentName = rs.getString("name");
                    }
                    catch (SQLException ex) {
                        this.plugin.getLogger().log(Level.SEVERE, "Loading Error: Error fetching a resident name from SQL Database. Skipping loading resident..", ex);
                        continue;
                    }
                    resident = this.universe.getResident(residentName);
                    if (resident == null) {
                        this.plugin.getLogger().severe(String.format("Loading Error: Could not fetch resident '%s' from Towny universe while loading from SQL DB.", residentName));
                        continue;
                    }
                    if (this.loadResident(resident, rs)) {
                        continue;
                    }
                    break block28;
                }
                return true;
            }
            this.plugin.getLogger().severe("Loading Error: Could not read resident data '" + resident.getName() + "'.");
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load resident sql error : " + e.getMessage());
        }
        return true;
    }

    @Override
    public boolean loadResident(Resident resident) {
        return true;
    }

    private boolean loadResident(Resident resident, ResultSet rs) {
        try {
            String search;
            String line;
            UUID uuid;
            block59: {
                try {
                    if (rs.getString("uuid") == null || rs.getString("uuid").isEmpty()) break block59;
                    uuid = UUID.fromString(rs.getString("uuid"));
                    if (this.universe.hasResident(uuid)) {
                        Resident olderRes = this.universe.getResident(uuid);
                        if (resident.getLastOnline() > olderRes.getLastOnline()) {
                            TownyMessaging.sendDebugMsg("Deleting : " + olderRes.getName() + " which is a dupe of " + resident.getName());
                            try {
                                this.universe.unregisterResident(olderRes);
                            }
                            catch (NotRegisteredException notRegisteredException) {
                                // empty catch block
                            }
                            if (olderRes.hasTown()) {
                                try {
                                    olderRes.getTown().removeResident(olderRes);
                                }
                                catch (NotRegisteredException notRegisteredException) {
                                    // empty catch block
                                }
                            }
                            this.deleteResident(olderRes);
                        } else {
                            TownyMessaging.sendDebugMsg("Deleting resident : " + resident.getName() + " which is a dupe of " + olderRes.getName());
                            try {
                                this.universe.unregisterResident(resident);
                            }
                            catch (NotRegisteredException notRegisteredException) {
                                // empty catch block
                            }
                            this.deleteResident(resident);
                            return true;
                        }
                    }
                    resident.setUUID(uuid);
                    this.universe.registerResidentUUID(resident);
                }
                catch (SQLException e) {
                    this.plugin.getLogger().log(Level.WARNING, "Could not get uuid column on the residents table", e);
                }
            }
            try {
                resident.setLastOnline(rs.getLong("lastOnline"));
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.WARNING, "Could not get lastOnline column on the residents table", e);
            }
            try {
                resident.setRegistered(rs.getLong("registered"));
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.WARNING, "Could not get registered column on the residents table", e);
            }
            try {
                resident.setJoinedTownAt(rs.getLong("joinedTownAt"));
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.WARNING, "Could not get joinedTownAt column on the residents table", e);
            }
            try {
                resident.setNPC(rs.getBoolean("isNPC"));
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.WARNING, "Could not get isNPC column on the residents table", e);
            }
            if (rs.getString("jailUUID") != null && !rs.getString("jailUUID").isEmpty() && this.universe.hasJail(uuid = UUID.fromString(rs.getString("jailUUID")))) {
                resident.setJail(this.universe.getJail(uuid));
            }
            if (resident.isJailed()) {
                try {
                    if (rs.getString("jailCell") != null && !rs.getString("jailCell").isEmpty()) {
                        resident.setJailCell(rs.getInt("jailCell"));
                    }
                }
                catch (SQLException e) {
                    this.plugin.getLogger().log(Level.WARNING, "Could not get jailCell column on the residents table", e);
                }
                try {
                    if (rs.getString("jailHours") != null && !rs.getString("jailHours").isEmpty()) {
                        resident.setJailHours(rs.getInt("jailHours"));
                    }
                }
                catch (SQLException e) {
                    this.plugin.getLogger().log(Level.WARNING, "Could not get jailHours column on the residents table", e);
                }
                try {
                    if (rs.getString("jailBail") != null && !rs.getString("jailBail").isEmpty()) {
                        resident.setJailBailCost(rs.getDouble("jailBail"));
                    }
                }
                catch (SQLException e) {
                    this.plugin.getLogger().log(Level.WARNING, "Could not get jailBail column on the residents table", e);
                }
            }
            try {
                line = rs.getString("about");
                if (line != null) {
                    resident.setAbout(line);
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.WARNING, "Could not get about column on the residents table", e);
            }
            try {
                line = rs.getString("friends");
                if (line != null) {
                    search = line.contains("#") ? "#" : ",";
                    List<Resident> friends = TownyAPI.getInstance().getResidents(line.split(search));
                    for (Resident friend : friends) {
                        resident.addFriend(friend);
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.WARNING, "Could not get friends column on the residents table", e);
            }
            try {
                resident.setPermissions(rs.getString("protectionStatus").replaceAll("#", ","));
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.WARNING, "Could not get protectionStatus column on the residents table", e);
            }
            try {
                line = rs.getString("metadata");
                if (line != null && !line.isEmpty()) {
                    MetadataLoader.getInstance().deserializeMetadata(resident, line);
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            line = rs.getString("town");
            if (line != null && !line.isEmpty()) {
                Town town = this.universe.getTown(line);
                if (town == null) {
                    TownyMessaging.sendErrorMsg("Loading Error: " + resident.getName() + " tried to load the town " + line + " which is invalid, removing town from the resident.");
                    resident.setTown(null, false);
                } else {
                    resident.setTown(town, false);
                    try {
                        resident.setTitle(rs.getString("title"));
                    }
                    catch (SQLException e) {
                        this.plugin.getLogger().log(Level.WARNING, "Could not get title column on the residents table", e);
                    }
                    try {
                        resident.setSurname(rs.getString("surname"));
                    }
                    catch (SQLException e) {
                        this.plugin.getLogger().log(Level.WARNING, "Could not get surname column on the residents table", e);
                    }
                    try {
                        line = rs.getString("town-ranks");
                        if (line != null && !line.isEmpty()) {
                            search = line.contains("#") ? "#" : ",";
                            resident.setTownRanks(Arrays.asList(line.split(search)));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        line = rs.getString("nation-ranks");
                        if (line != null && !line.isEmpty()) {
                            search = line.contains("#") ? "#" : ",";
                            resident.setNationRanks(Arrays.asList(line.split(search)));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load resident sql error : " + e.getMessage());
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "SQL: Load resident unknown error", e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadTowns() {
        TownyMessaging.sendDebugMsg("Loading Towns");
        try (Connection connection = this.getConnection();
             Statement s = connection.createStatement();
             ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "TOWNS ");){
            block28: {
                while (rs.next()) {
                    String townName;
                    try {
                        townName = rs.getString("name");
                    }
                    catch (SQLException ex) {
                        this.plugin.getLogger().log(Level.SEVERE, "Loading Error: Error fetching a town name from SQL Database. Skipping loading town..", ex);
                        continue;
                    }
                    Town town = this.universe.getTown(townName);
                    if (town == null) {
                        this.plugin.getLogger().severe(String.format("Loading Error: Could not fetch town '%s' from Towny universe while loading from SQL DB.", townName));
                        continue;
                    }
                    if (this.loadTown(rs)) {
                        continue;
                    }
                    break block28;
                }
                return true;
            }
            this.plugin.getLogger().warning("Loading Error: Could not read town data properly.");
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load Town sql Error - " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean loadTown(Town town) {
        return true;
    }

    private boolean loadTown(ResultSet rs) {
        String name = null;
        try {
            UUID uuid2;
            String spawn;
            int z;
            String search;
            String[] tokens;
            Town town = this.universe.getTown(rs.getString("name"));
            if (town == null) {
                TownyMessaging.sendErrorMsg("SQL: Load Town " + rs.getString("name") + ". Town was not registered properly on load!");
                return false;
            }
            name = town.getName();
            TownyMessaging.sendDebugMsg("Loading town " + name);
            try {
                Resident res = this.universe.getResident(rs.getString("mayor"));
                if (res == null) {
                    throw new TownyException();
                }
                town.forceSetMayor(res);
            }
            catch (TownyException e1) {
                e1.getMessage();
                if (town.getResidents().size() == 0) {
                    this.deleteTown(town);
                    return true;
                }
                town.findNewMayor();
            }
            town.setBoard(rs.getString("townBoard"));
            String line = rs.getString("tag");
            if (line != null) {
                town.setTag(line);
            }
            if ((line = rs.getString("founder")) != null) {
                town.setFounder(line);
            }
            town.setPermissions(rs.getString("protectionStatus").replaceAll("#", ","));
            town.setBonusBlocks(rs.getInt("bonus"));
            town.setManualTownLevel(rs.getInt("manualTownLevel"));
            town.setTaxPercentage(rs.getBoolean("taxpercent"));
            town.setTaxes(rs.getFloat("taxes"));
            town.setMaxPercentTaxAmount(rs.getFloat("maxPercentTaxAmount"));
            town.setHasUpkeep(rs.getBoolean("hasUpkeep"));
            town.setHasUnlimitedClaims(rs.getBoolean("hasUnlimitedClaims"));
            town.setVisibleOnTopLists(rs.getBoolean("visibleOnTopLists"));
            town.setPlotPrice(rs.getFloat("plotPrice"));
            town.setPlotTax(rs.getFloat("plotTax"));
            town.setEmbassyPlotPrice(rs.getFloat("embassyPlotPrice"));
            town.setEmbassyPlotTax(rs.getFloat("embassyPlotTax"));
            town.setCommercialPlotPrice(rs.getFloat("commercialPlotPrice"));
            town.setCommercialPlotTax(rs.getFloat("commercialPlotTax"));
            town.setSpawnCost(rs.getFloat("spawnCost"));
            town.setOpen(rs.getBoolean("open"));
            town.setPublic(rs.getBoolean("public"));
            town.setConquered(rs.getBoolean("conquered"), false);
            town.setAdminDisabledPVP(rs.getBoolean("admindisabledpvp"));
            town.setAdminEnabledPVP(rs.getBoolean("adminenabledpvp"));
            town.setAdminEnabledMobs(rs.getBoolean("adminEnabledMobs"));
            town.setAllowedToWar(rs.getBoolean("allowedToWar"));
            town.setJoinedNationAt(rs.getLong("joinedNationAt"));
            town.setMovedHomeBlockAt(rs.getLong("movedHomeBlockAt"));
            line = rs.getString("forSale");
            if (line != null) {
                town.setForSale(Boolean.getBoolean(line));
            }
            if ((line = rs.getString("forSalePrice")) != null) {
                town.setForSalePrice(Double.parseDouble(line));
            }
            if ((line = rs.getString("forSaleTime")) != null) {
                town.setForSaleTime(Long.parseLong(line));
            }
            town.setPurchasedBlocks(rs.getInt("purchased"));
            town.setNationZoneOverride(rs.getInt("nationZoneOverride"));
            town.setNationZoneEnabled(rs.getBoolean("nationZoneEnabled"));
            line = rs.getString("maxPercentTaxAmount");
            if (line != null) {
                town.setMaxPercentTaxAmount(Double.parseDouble(line));
            } else {
                town.setMaxPercentTaxAmount(TownySettings.getMaxTownTaxPercentAmount());
            }
            line = rs.getString("homeBlock");
            if (line != null && (tokens = line.split(search = line.contains("#") ? "#" : ",")).length == 3) {
                TownyWorld world = this.universe.getWorld(tokens[0]);
                if (world == null) {
                    TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid world.");
                } else {
                    try {
                        int x = Integer.parseInt(tokens[1]);
                        z = Integer.parseInt(tokens[2]);
                        TownBlock homeBlock = this.universe.getTownBlock(new WorldCoord(world.getName(), x, z));
                        town.forceSetHomeBlock(homeBlock);
                    }
                    catch (NumberFormatException e) {
                        TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid location.");
                    }
                    catch (NotRegisteredException e) {
                        TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid TownBlock.");
                    }
                    catch (TownyException e) {
                        TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " does not have a home block.");
                    }
                }
            }
            if ((line = rs.getString("spawn")) != null && (tokens = line.split(search = line.contains("#") ? "#" : ",")).length >= 4) {
                try {
                    town.spawnPosition(Position.deserialize(tokens));
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Failed to load spawn location for town " + town.getName() + ": " + e.getMessage());
                }
            }
            if ((line = rs.getString("outpostSpawns")) != null) {
                String[] outposts;
                String[] e = outposts = line.split(";");
                z = e.length;
                for (int homeBlock = 0; homeBlock < z; ++homeBlock) {
                    spawn = e[homeBlock];
                    search = line.contains("#") ? "#" : ",";
                    tokens = spawn.split(search);
                    if (tokens.length < 4) continue;
                    try {
                        town.forceAddOutpostSpawn(Position.deserialize(tokens));
                        continue;
                    }
                    catch (IllegalArgumentException e2) {
                        this.plugin.getLogger().warning("Failed to load an outpost spawn location for town " + town.getName() + ": " + e2.getMessage());
                    }
                }
            }
            try {
                line = rs.getString("jailSpawns");
            }
            catch (SQLException e) {
                line = null;
            }
            if (line != null) {
                String[] jails;
                String[] e = jails = line.split(";");
                z = e.length;
                for (int homeBlock = 0; homeBlock < z; ++homeBlock) {
                    spawn = e[homeBlock];
                    search = line.contains("#") ? "#" : ",";
                    tokens = spawn.split(search);
                    if (tokens.length < 4) continue;
                    try {
                        Position pos = Position.deserialize(tokens);
                        TownBlock tb = this.universe.getTownBlock(pos.worldCoord());
                        if (tb == null) continue;
                        Jail jail = new Jail(UUID.randomUUID(), town, tb, Collections.singleton(pos));
                        this.universe.registerJail(jail);
                        town.addJail(jail);
                        tb.setJail(jail);
                        jail.save();
                        continue;
                    }
                    catch (IllegalArgumentException e3) {
                        this.plugin.getLogger().warning("Failed to load a legacy jail spawn location for town " + town.getName() + ": " + e3.getMessage());
                    }
                }
            }
            if ((line = rs.getString("outlaws")) != null) {
                search = line.contains("#") ? "#" : ",";
                tokens = line.split(search);
                for (String token : tokens) {
                    if (token.isEmpty()) continue;
                    Resident resident = this.universe.getResident(token);
                    if (resident != null) {
                        town.addOutlaw(resident);
                        continue;
                    }
                    this.plugin.getLogger().warning(String.format("Loading Error: Cannot load outlaw with name '%s' for town '%s'! Skipping adding outlaw to town...", token, town.getName()));
                }
            }
            try {
                town.setUUID(UUID.fromString(rs.getString("uuid")));
            }
            catch (IllegalArgumentException | NullPointerException ee) {
                town.setUUID(UUID.randomUUID());
            }
            this.universe.registerTownUUID(town);
            int conqueredDays = rs.getInt("conqueredDays");
            town.setConqueredDays(conqueredDays);
            try {
                long registered = rs.getLong("registered");
                town.setRegistered(registered);
            }
            catch (Exception ignored) {
                town.setRegistered(0L);
            }
            try {
                line = rs.getString("metadata");
                if (line != null && !line.isEmpty()) {
                    MetadataLoader.getInstance().deserializeMetadata(town, line);
                }
            }
            catch (SQLException ignored) {
                // empty catch block
            }
            try {
                Nation nation;
                line = rs.getString("nation");
                if (line != null && !line.isEmpty() && (nation = this.universe.getNation(line)) != null) {
                    town.setNation(nation, false);
                }
            }
            catch (SQLException nation) {
                // empty catch block
            }
            town.setRuined(rs.getBoolean("ruined"));
            town.setRuinedTime(rs.getLong("ruinedTime"));
            town.setNeutral(rs.getBoolean("neutral"));
            town.setDebtBalance(rs.getFloat("debtBalance"));
            line = rs.getString("primaryJail");
            if (line != null && !line.isEmpty() && this.universe.hasJail(uuid2 = UUID.fromString(line))) {
                town.setPrimaryJail(this.universe.getJail(uuid2));
            }
            if ((line = rs.getString("trustedResidents")) != null && !line.isEmpty()) {
                search = line.contains("#") ? "#" : ",";
                for (Resident resident : TownyAPI.getInstance().getResidents(this.toUUIDArray(line.split(search)))) {
                    town.addTrustedResident(resident);
                }
            }
            if ((line = rs.getString("trustedTowns")) != null && !line.isEmpty()) {
                search = line.contains("#") ? "#" : ",";
                List<UUID> uuids = Arrays.stream(line.split(search)).map(UUID::fromString).collect(Collectors.toList());
                town.loadTrustedTowns(TownyAPI.getInstance().getTowns(uuids));
            }
            if ((line = rs.getString("mapColorHexCode")) != null) {
                town.setMapColorHexCode(line);
            } else {
                town.setMapColorHexCode(MapUtil.generateRandomTownColourAsHexCode());
            }
            line = rs.getString("allies");
            if (line != null && !line.isEmpty()) {
                search = line.contains("#") ? "#" : ",";
                List<UUID> uuids = Arrays.stream(line.split(search)).map(uuid -> UUID.fromString(uuid)).collect(Collectors.toList());
                town.loadAllies(TownyAPI.getInstance().getTowns(uuids));
            }
            if ((line = rs.getString("enemies")) != null && !line.isEmpty()) {
                search = line.contains("#") ? "#" : ",";
                List<UUID> uuids = Arrays.stream(line.split(search)).map(uuid -> UUID.fromString(uuid)).collect(Collectors.toList());
                town.loadEnemies(TownyAPI.getInstance().getTowns(uuids));
            }
            if ((line = rs.getString("visibleOnTopLists")) != null && !line.isEmpty()) {
                town.setVisibleOnTopLists(rs.getBoolean("visibleOnTopLists"));
            }
            if ((line = rs.getString("hasActiveWar")) != null && !line.isEmpty()) {
                town.setActiveWar(rs.getBoolean("hasActiveWar"));
            }
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load Town " + name + " sql Error - " + e.getMessage());
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "SQL: Load Town " + name + " unknown Error - ", e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadNations() {
        try (Connection connection = this.getConnection();
             Statement s = connection.createStatement();
             ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "NATIONS");){
            block28: {
                while (rs.next()) {
                    String nationName;
                    try {
                        nationName = rs.getString("name");
                    }
                    catch (SQLException ex) {
                        this.plugin.getLogger().log(Level.SEVERE, "Loading Error: Error fetching a nation name from SQL Database. Skipping loading nation..", ex);
                        continue;
                    }
                    Nation nation = this.universe.getNation(nationName);
                    if (nation == null) {
                        this.plugin.getLogger().severe(String.format("Loading Error: Could not fetch nation '%s' from Towny universe while loading from SQL DB.", nationName));
                        continue;
                    }
                    if (this.loadNation(rs)) {
                        continue;
                    }
                    break block28;
                }
                return true;
            }
            this.plugin.getLogger().warning("Loading Error: Could not properly read nation data.");
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load Nation sql error " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean loadNation(Nation nation) {
        return true;
    }

    private boolean loadNation(ResultSet rs) {
        String name = null;
        try {
            String[] tokens;
            String search;
            Nation nation = this.universe.getNation(rs.getString("name"));
            if (nation == null) {
                this.plugin.getLogger().warning(String.format("Error: The nation with the name '%s' was not registered and cannot be loaded!", rs.getString("name")));
                return false;
            }
            name = nation.getName();
            TownyMessaging.sendDebugMsg("Loading nation " + nation.getName());
            Town town = this.universe.getTown(rs.getString("capital"));
            if (town != null) {
                try {
                    nation.forceSetCapital(town);
                }
                catch (EmptyNationException e1) {
                    this.plugin.getLogger().warning("The nation " + nation.getName() + " could not load a capital city and is being disbanded.");
                    this.removeNation(nation, DeleteNationEvent.Cause.LOAD);
                    return true;
                }
            } else {
                TownyMessaging.sendDebugMsg("Nation " + name + " could not set capital to " + rs.getString("capital") + ", selecting a new capital...");
                if (!nation.findNewCapital()) {
                    this.plugin.getLogger().warning("The nation " + nation.getName() + " could not load a capital city and is being disbanded.");
                    this.removeNation(nation, DeleteNationEvent.Cause.LOAD);
                    return true;
                }
            }
            String line = rs.getString("nationBoard");
            if (line != null) {
                nation.setBoard(rs.getString("nationBoard"));
            } else {
                nation.setBoard("");
            }
            line = rs.getString("mapColorHexCode");
            if (line != null) {
                nation.setMapColorHexCode(line);
            } else {
                nation.setMapColorHexCode(MapUtil.generateRandomNationColourAsHexCode());
            }
            nation.setTag(rs.getString("tag"));
            line = rs.getString("allies");
            if (line != null) {
                search = line.contains("#") ? "#" : ",";
                List<Nation> allies = TownyAPI.getInstance().getNations(line.split(search));
                for (Nation ally : allies) {
                    nation.addAlly(ally);
                }
            }
            if ((line = rs.getString("enemies")) != null) {
                search = line.contains("#") ? "#" : ",";
                List<Nation> enemies = TownyAPI.getInstance().getNations(line.split(search));
                for (Nation enemy : enemies) {
                    nation.addEnemy(enemy);
                }
            }
            nation.setSpawnCost(rs.getFloat("spawnCost"));
            nation.setNeutral(rs.getBoolean("neutral"));
            try {
                nation.setUUID(UUID.fromString(rs.getString("uuid")));
            }
            catch (IllegalArgumentException | NullPointerException ee) {
                nation.setUUID(UUID.randomUUID());
            }
            this.universe.registerNationUUID(nation);
            line = rs.getString("nationSpawn");
            if (line != null && (tokens = line.split(search = line.contains("#") ? "#" : ",")).length >= 4) {
                try {
                    nation.spawnPosition(Position.deserialize(tokens));
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Failed to load nation spawn location for nation " + nation.getName() + ": " + e.getMessage());
                }
            }
            nation.setPublic(rs.getBoolean("isPublic"));
            nation.setOpen(rs.getBoolean("isOpen"));
            nation.setTaxPercentage(rs.getBoolean("taxpercent"));
            nation.setTaxes(rs.getDouble("taxes"));
            line = rs.getString("maxPercentTaxAmount");
            if (line != null) {
                nation.setMaxPercentTaxAmount(Double.parseDouble(line));
            } else {
                nation.setMaxPercentTaxAmount(TownySettings.getMaxNationTaxPercentAmount());
            }
            try {
                line = rs.getString("registered");
                if (line != null) {
                    nation.setRegistered(Long.parseLong(line));
                } else {
                    nation.setRegistered(0L);
                }
            }
            catch (SQLException e) {
            }
            catch (NullPointerException | NumberFormatException e) {
                nation.setRegistered(0L);
            }
            try {
                line = rs.getString("metadata");
                if (line != null && !line.isEmpty()) {
                    MetadataLoader.getInstance().deserializeMetadata(nation, line);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                line = rs.getString("conqueredTax");
                if (line != null && !line.isEmpty()) {
                    nation.setConqueredTax(Double.parseDouble(line));
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            line = rs.getString("sanctionedTowns");
            if (line != null) {
                nation.loadSanctionedTowns(line.split("#"));
            }
            if ((line = rs.getString("hasActiveWar")) != null && !line.isEmpty()) {
                nation.setActiveWar(rs.getBoolean("hasActiveWar"));
            }
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load Nation " + name + " SQL Error - " + e.getMessage());
        }
        catch (TownyException ex) {
            this.plugin.getLogger().log(Level.WARNING, "SQL: Load Nation " + name + " unknown Error - ", ex);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadWorlds() {
        try (Connection connection = this.getConnection();
             Statement s = connection.createStatement();
             ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "WORLDS");){
            block28: {
                while (rs.next()) {
                    String worldName;
                    try {
                        worldName = rs.getString("name");
                    }
                    catch (SQLException ex) {
                        this.plugin.getLogger().log(Level.SEVERE, "Loading Error: Error fetching a world name from SQL Database. Skipping loading world..", ex);
                        continue;
                    }
                    TownyWorld world = this.universe.getWorld(worldName);
                    if (world == null) {
                        this.plugin.getLogger().severe(String.format("Loading Error: Could not fetch world '%s' from Towny universe while loading from SQL DB.", worldName));
                        continue;
                    }
                    if (this.loadWorld(rs)) {
                        continue;
                    }
                    break block28;
                }
                return true;
            }
            this.plugin.getLogger().warning("Loading Error: Could not read properly world data.");
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Error reading worlds from SQL database!");
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadWorld(TownyWorld world) {
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement("SELECT * FROM " + this.tb_prefix + "WORLDS WHERE name=?");){
            ps.setString(1, world.getName());
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return false;
                boolean bl = this.loadWorld(rs);
                return bl;
            }
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load world sql error (" + world.getName() + ")" + e.getMessage());
        }
        return false;
    }

    private boolean loadWorld(ResultSet rs) {
        String worldName = null;
        try {
            ArrayList<String> materials2;
            String search;
            ArrayList<String> mats2;
            worldName = rs.getString("name");
            TownyWorld world = this.universe.getWorld(worldName);
            if (world == null) {
                throw new Exception("World " + worldName + " not registered!");
            }
            TownyMessaging.sendDebugMsg("Loading world " + world.getName());
            String line = rs.getString("uuid");
            if (line != null && !line.isEmpty()) {
                try {
                    world.setUUID(UUID.fromString(line));
                }
                catch (IllegalArgumentException ignored) {
                    UUID uuid = BukkitTools.getWorldUUID(worldName);
                    if (uuid != null) {
                        world.setUUID(uuid);
                    }
                }
            } else {
                UUID uuid = BukkitTools.getWorldUUID(worldName);
                if (uuid != null) {
                    world.setUUID(uuid);
                }
            }
            boolean result = rs.getBoolean("claimable");
            try {
                world.setClaimable(result);
            }
            catch (Exception uuid) {
                // empty catch block
            }
            result = rs.getBoolean("pvp");
            try {
                world.setPVP(result);
            }
            catch (Exception uuid) {
                // empty catch block
            }
            result = rs.getBoolean("forcepvp");
            try {
                world.setForcePVP(result);
            }
            catch (Exception uuid) {
                // empty catch block
            }
            result = rs.getBoolean("friendlyFire");
            try {
                world.setFriendlyFire(result);
            }
            catch (Exception uuid) {
                // empty catch block
            }
            result = rs.getBoolean("forcetownmobs");
            try {
                world.setForceTownMobs(result);
            }
            catch (Exception uuid) {
                // empty catch block
            }
            result = rs.getBoolean("wildernessmobs");
            try {
                world.setWildernessMobs(result);
            }
            catch (Exception uuid) {
                // empty catch block
            }
            result = rs.getBoolean("worldmobs");
            try {
                world.setWorldMobs(result);
            }
            catch (Exception uuid) {
                // empty catch block
            }
            result = rs.getBoolean("firespread");
            try {
                world.setFire(result);
            }
            catch (Exception uuid) {
                // empty catch block
            }
            result = rs.getBoolean("forcefirespread");
            try {
                world.setForceFire(result);
            }
            catch (Exception uuid) {
                // empty catch block
            }
            result = rs.getBoolean("explosions");
            try {
                world.setExpl(result);
            }
            catch (Exception uuid) {
                // empty catch block
            }
            result = rs.getBoolean("forceexplosions");
            try {
                world.setForceExpl(result);
            }
            catch (Exception uuid) {
                // empty catch block
            }
            result = rs.getBoolean("endermanprotect");
            try {
                world.setEndermanProtect(result);
            }
            catch (Exception uuid) {
                // empty catch block
            }
            result = rs.getBoolean("disablecreaturetrample");
            try {
                world.setDisableCreatureTrample(result);
            }
            catch (Exception uuid) {
                // empty catch block
            }
            result = rs.getBoolean("unclaimedZoneBuild");
            try {
                world.setUnclaimedZoneBuild(result);
            }
            catch (Exception uuid) {
                // empty catch block
            }
            result = rs.getBoolean("unclaimedZoneDestroy");
            try {
                world.setUnclaimedZoneDestroy(result);
            }
            catch (Exception uuid) {
                // empty catch block
            }
            result = rs.getBoolean("unclaimedZoneSwitch");
            try {
                world.setUnclaimedZoneSwitch(result);
            }
            catch (Exception uuid) {
                // empty catch block
            }
            result = rs.getBoolean("unclaimedZoneItemUse");
            try {
                world.setUnclaimedZoneItemUse(result);
            }
            catch (Exception uuid) {
                // empty catch block
            }
            line = rs.getString("unclaimedZoneName");
            try {
                world.setUnclaimedZoneName(line);
            }
            catch (Exception uuid) {
                // empty catch block
            }
            line = rs.getString("unclaimedZoneIgnoreIds");
            if (line != null) {
                try {
                    mats2 = new ArrayList<String>();
                    search = line.contains("#") ? "#" : ",";
                    for (String split : line.split(search)) {
                        if (split.isEmpty()) continue;
                        mats2.add(split);
                    }
                    world.setUnclaimedZoneIgnore(mats2);
                }
                catch (Exception mats2) {
                    // empty catch block
                }
            }
            result = rs.getBoolean("isDeletingEntitiesOnUnclaim");
            try {
                world.setDeletingEntitiesOnUnclaim(result);
            }
            catch (Exception mats2) {
                // empty catch block
            }
            line = rs.getString("unclaimDeleteEntityTypes");
            if (line != null) {
                try {
                    ArrayList<String> entityTypes = new ArrayList<String>();
                    search = line.contains("#") ? "#" : ",";
                    for (String split : line.split(search)) {
                        if (split.isEmpty()) continue;
                        entityTypes.add(split);
                    }
                    world.setUnclaimDeleteEntityTypes(entityTypes);
                }
                catch (Exception entityTypes) {
                    // empty catch block
                }
            }
            result = rs.getBoolean("usingPlotManagementDelete");
            try {
                world.setUsingPlotManagementDelete(result);
            }
            catch (Exception entityTypes) {
                // empty catch block
            }
            line = rs.getString("plotManagementDeleteIds");
            if (line != null) {
                try {
                    mats2 = new ArrayList();
                    search = line.contains("#") ? "#" : ",";
                    for (String split : line.split(search)) {
                        if (split.isEmpty()) continue;
                        mats2.add(split);
                    }
                    world.setPlotManagementDeleteIds(mats2);
                }
                catch (Exception mats3) {
                    // empty catch block
                }
            }
            result = rs.getBoolean("usingPlotManagementMayorDelete");
            try {
                world.setUsingPlotManagementMayorDelete(result);
            }
            catch (Exception mats3) {
                // empty catch block
            }
            line = rs.getString("plotManagementMayorDelete");
            if (line != null) {
                try {
                    materials2 = new ArrayList<String>();
                    search = line.contains("#") ? "#" : ",";
                    for (String split : line.split(search)) {
                        if (split.isEmpty()) continue;
                        try {
                            materials2.add(split.toUpperCase().trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    world.setPlotManagementMayorDelete(materials2);
                }
                catch (Exception materials2) {
                    // empty catch block
                }
            }
            result = rs.getBoolean("usingPlotManagementRevert");
            try {
                world.setUsingPlotManagementRevert(result);
            }
            catch (Exception materials2) {
                // empty catch block
            }
            line = rs.getString("plotManagementIgnoreIds");
            if (line != null) {
                try {
                    mats2 = new ArrayList();
                    search = line.contains("#") ? "#" : ",";
                    for (String split : line.split(search)) {
                        if (split.isEmpty()) continue;
                        mats2.add(split);
                    }
                    world.setPlotManagementIgnoreIds(mats2);
                }
                catch (Exception mats4) {
                    // empty catch block
                }
            }
            result = rs.getBoolean("usingPlotManagementWildRegen");
            try {
                world.setUsingPlotManagementWildEntityRevert(result);
            }
            catch (Exception mats4) {
                // empty catch block
            }
            line = rs.getString("revertOnUnclaimWhitelistMaterials");
            if (line != null) {
                try {
                    materials2 = new ArrayList();
                    for (String split : line.split("#")) {
                        if (split.isEmpty()) continue;
                        try {
                            materials2.add(split.trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    world.setRevertOnUnclaimWhitelistMaterials(materials2);
                }
                catch (Exception materials3) {
                    // empty catch block
                }
            }
            if ((line = rs.getString("plotManagementWildRegenEntities")) != null) {
                try {
                    ArrayList<String> entities = new ArrayList<String>();
                    search = line.contains("#") ? "#" : ",";
                    for (String split : line.split(search)) {
                        if (split.isEmpty()) continue;
                        try {
                            entities.add(split.trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    world.setPlotManagementWildRevertEntities(entities);
                }
                catch (Exception entities) {
                    // empty catch block
                }
            }
            if ((line = rs.getString("plotManagementWildRegenBlockWhitelist")) != null) {
                try {
                    materials2 = new ArrayList();
                    search = line.contains("#") ? "#" : ",";
                    for (String split : line.split(search)) {
                        if (split.isEmpty()) continue;
                        try {
                            materials2.add(split.trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    world.setPlotManagementWildRevertBlockWhitelist(materials2);
                }
                catch (Exception materials4) {
                    // empty catch block
                }
            }
            if ((line = rs.getString("wildRegenBlocksToNotOverwrite")) != null) {
                try {
                    materials2 = new ArrayList();
                    search = line.contains("#") ? "#" : ",";
                    for (String split : line.split(search)) {
                        if (split.isEmpty()) continue;
                        try {
                            materials2.add(split.trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    world.setWildRevertMaterialsToNotOverwrite(materials2);
                }
                catch (Exception materials5) {
                    // empty catch block
                }
            }
            long resultLong = rs.getLong("plotManagementWildRegenSpeed");
            try {
                world.setPlotManagementWildRevertDelay(resultLong);
            }
            catch (Exception materials5) {
                // empty catch block
            }
            result = rs.getBoolean("usingPlotManagementWildRegenBlocks");
            try {
                world.setUsingPlotManagementWildBlockRevert(result);
            }
            catch (Exception materials5) {
                // empty catch block
            }
            line = rs.getString("plotManagementWildRegenBlocks");
            if (line != null) {
                try {
                    materials2 = new ArrayList();
                    search = line.contains("#") ? "#" : ",";
                    for (String split : line.split(search)) {
                        if (split.isEmpty()) continue;
                        try {
                            materials2.add(split.trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    world.setPlotManagementWildRevertMaterials(materials2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            result = rs.getBoolean("usingTowny");
            try {
                world.setUsingTowny(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = rs.getBoolean("warAllowed");
            try {
                world.setWarAllowed(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = rs.getBoolean("jailing");
            try {
                world.setJailingEnabled(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                line = rs.getString("metadata");
                if (line != null && !line.isEmpty()) {
                    MetadataLoader.getInstance().deserializeMetadata(world, line);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load world sql error (" + (worldName != null ? worldName : "NULL") + ")" + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg(e.getMessage());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadTownBlocks() {
        String line = "";
        TownyMessaging.sendDebugMsg("Loading Town Blocks.");
        Object townBlock = null;
        try {
            Connection connection = this.getConnection();
            try {
                Statement s = connection.createStatement();
                try (ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "TOWNBLOCKS");){
                    while (rs.next()) {
                        block77: {
                            block76: {
                                String worldName = rs.getString("world");
                                int x = rs.getInt("x");
                                int z = rs.getInt("z");
                                if (!this.universe.hasTownyWorld(worldName)) continue;
                                try {
                                    townBlock = this.universe.getTownBlock(new WorldCoord(worldName, x, z));
                                }
                                catch (NotRegisteredException ex) {
                                    TownyMessaging.sendErrorMsg("Loading Error: Exception while fetching townblock: " + worldName + " " + x + " " + z + " from memory!");
                                    boolean bl = false;
                                    if (rs != null) {
                                        rs.close();
                                    }
                                    if (s != null) {
                                        s.close();
                                    }
                                    if (connection == null) return bl;
                                    connection.close();
                                    return bl;
                                }
                                line = rs.getString("name");
                                if (line != null) {
                                    try {
                                        ((TownBlock)townBlock).setName(line.trim());
                                    }
                                    catch (Exception ex) {
                                        // empty catch block
                                    }
                                }
                                if ((line = rs.getString("town")) != null) {
                                    Town town = this.universe.getTown(line.trim());
                                    if (town == null) {
                                        TownyMessaging.sendErrorMsg("TownBlock file contains unregistered Town: " + line + ", deleting " + ((TownBlock)townBlock).getWorld().getName() + "," + ((TownBlock)townBlock).getX() + "," + ((TownBlock)townBlock).getZ());
                                        this.universe.removeTownBlock((TownBlock)townBlock);
                                        this.deleteTownBlock((TownBlock)townBlock);
                                        continue;
                                    }
                                    ((TownBlock)townBlock).setTown(town, false);
                                    try {
                                        town.addTownBlock((TownBlock)townBlock);
                                        TownyWorld townyWorld = ((TownBlock)townBlock).getWorld();
                                        if (townyWorld != null && !townyWorld.hasTown(town)) {
                                            townyWorld.addTown(town);
                                        }
                                    }
                                    catch (AlreadyRegisteredException townyWorld) {
                                        // empty catch block
                                    }
                                }
                                if ((line = rs.getString("resident")) != null && !line.isEmpty()) {
                                    Resident res = this.universe.getResident(line.trim());
                                    if (res != null) {
                                        ((TownBlock)townBlock).setResident(res, false);
                                    } else {
                                        TownyMessaging.sendErrorMsg(String.format("Error fetching resident '%s' for townblock '%s'!", line.trim(), ((TownBlock)townBlock).toString()));
                                    }
                                }
                                if ((line = rs.getString("type")) != null) {
                                    ((TownBlock)townBlock).setType(TownBlockTypeHandler.getTypeInternal(line));
                                }
                                if ((line = rs.getString("price")) != null) {
                                    try {
                                        ((TownBlock)townBlock).setPlotPrice(Float.parseFloat(line.trim()));
                                    }
                                    catch (Exception res) {
                                        // empty catch block
                                    }
                                }
                                boolean taxed = rs.getBoolean("taxed");
                                try {
                                    ((TownBlock)townBlock).setTaxed(taxed);
                                }
                                catch (Exception townyWorld) {
                                    // empty catch block
                                }
                                line = rs.getString("typeName");
                                if (line != null) {
                                    ((TownBlock)townBlock).setType(TownBlockTypeHandler.getTypeInternal(line));
                                }
                                boolean outpost = rs.getBoolean("outpost");
                                try {
                                    ((TownBlock)townBlock).setOutpost(outpost);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                line = rs.getString("permissions");
                                if (line != null && !line.isEmpty()) {
                                    try {
                                        ((TownBlock)townBlock).setPermissions(line.trim().replaceAll("#", ","));
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                boolean result = rs.getBoolean("changed");
                                try {
                                    ((TownBlock)townBlock).setChanged(result);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                ((TownBlock)townBlock).setClaimedAt(rs.getLong("claimedAt"));
                                line = rs.getString("minTownMembershipDays");
                                if (line != null && !line.isEmpty()) {
                                    ((TownBlock)townBlock).setMinTownMembershipDays(Integer.valueOf(line));
                                }
                                if ((line = rs.getString("maxTownMembershipDays")) != null && !line.isEmpty()) {
                                    ((TownBlock)townBlock).setMaxTownMembershipDays(Integer.valueOf(line));
                                }
                                try {
                                    line = rs.getString("metadata");
                                    if (line != null && !line.isEmpty()) {
                                        MetadataLoader.getInstance().deserializeMetadata((TownyObject)townBlock, line);
                                    }
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                                try {
                                    line = rs.getString("groupID");
                                    if (line == null || line.isEmpty()) break block76;
                                    try {
                                        UUID groupID = UUID.fromString(line.trim());
                                        PlotGroup group = this.universe.getGroup(groupID);
                                        if (group != null) {
                                            ((TownBlock)townBlock).setPlotObjectGroup(group);
                                            if (group.getPermissions() == null && ((TownBlock)townBlock).getPermissions() != null) {
                                                group.setPermissions(((TownBlock)townBlock).getPermissions());
                                            }
                                            if (((TownBlock)townBlock).hasResident()) {
                                                group.setResident(((TownBlock)townBlock).getResidentOrNull());
                                            }
                                        }
                                    }
                                    catch (Exception groupID) {}
                                }
                                catch (SQLException groupID) {
                                    // empty catch block
                                }
                            }
                            try {
                                line = rs.getString("districtID");
                                if (line == null || line.isEmpty()) break block77;
                                try {
                                    UUID districtID = UUID.fromString(line.trim());
                                    District district = this.universe.getDistrict(districtID);
                                    if (district != null) {
                                        ((TownBlock)townBlock).setDistrict(district);
                                    }
                                }
                                catch (Exception districtID) {}
                            }
                            catch (SQLException districtID) {
                                // empty catch block
                            }
                        }
                        if ((line = rs.getString("trustedResidents")) != null && !line.isEmpty() && ((TownBlock)townBlock).getTrustedResidents().isEmpty()) {
                            String search = line.contains("#") ? "#" : ",";
                            for (Resident resident : TownyAPI.getInstance().getResidents(this.toUUIDArray(line.split(search)))) {
                                ((TownBlock)townBlock).addTrustedResident(resident);
                            }
                            if (((TownBlock)townBlock).hasPlotObjectGroup() && ((TownBlock)townBlock).getPlotObjectGroup().getTrustedResidents().isEmpty() && ((TownBlock)townBlock).getTrustedResidents().size() > 0) {
                                ((TownBlock)townBlock).getPlotObjectGroup().setTrustedResidents(((TownBlock)townBlock).getTrustedResidents());
                            }
                        }
                        if ((line = rs.getString("customPermissionData")) == null || line.isEmpty() || !((TownBlock)townBlock).getPermissionOverrides().isEmpty()) continue;
                        Map map = (Map)new Gson().fromJson(line, new TypeToken<Map<String, String>>(){}.getType());
                        for (Map.Entry entry : map.entrySet()) {
                            Resident resident;
                            try {
                                resident = TownyAPI.getInstance().getResident(UUID.fromString((String)entry.getKey()));
                            }
                            catch (IllegalArgumentException e) {
                                continue;
                            }
                            if (resident == null) continue;
                            ((TownBlock)townBlock).getPermissionOverrides().put(resident, new PermissionData((String)entry.getValue()));
                        }
                        if (!((TownBlock)townBlock).hasPlotObjectGroup() || !((TownBlock)townBlock).getPlotObjectGroup().getPermissionOverrides().isEmpty() || ((TownBlock)townBlock).getPermissionOverrides().size() <= 0) continue;
                        ((TownBlock)townBlock).getPlotObjectGroup().setPermissionOverrides(((TownBlock)townBlock).getPermissionOverrides());
                    }
                    return true;
                }
                finally {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable3;
                        throwable3.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.WARNING, "Loading Error: Exception while reading TownBlock: " + String.valueOf(townBlock != null ? townBlock : "NULL") + " at line: " + line + " in the sql database", ex);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadPlotGroups() {
        TownyMessaging.sendDebugMsg("Loading plot groups.");
        try (Connection connection = this.getConnection();
             Statement s = connection.createStatement();
             ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "PLOTGROUPS ");){
            do {
                if (!rs.next()) return true;
            } while (this.loadPlotGroup(rs));
            this.plugin.getLogger().warning("Loading Error: Could not read plotgroup data properly.");
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load PlotGroup sql Error - " + e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadDistricts() {
        TownyMessaging.sendDebugMsg("Loading districts.");
        try (Connection connection = this.getConnection();
             Statement s = connection.createStatement();
             ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "DISTRICTS ");){
            do {
                if (!rs.next()) return true;
            } while (this.loadDistrict(rs));
            this.plugin.getLogger().warning("Loading Error: Could not read district data properly.");
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load District sql Error - " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean loadCooldowns() {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + this.tb_prefix + TownyDBTableType.COOLDOWN.tableName());
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                CooldownTimerTask.getCooldowns().put(resultSet.getString("key"), resultSet.getLong("expiry"));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "An exception occurred when loading cooldowns", e);
            return false;
        }
        return true;
    }

    @Override
    public boolean saveCooldowns() {
        for (Map.Entry<String, Long> entry : CooldownTimerTask.getCooldowns().entrySet()) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("key", entry.getKey());
            data.put("expiry", entry.getValue());
            this.queueUpdateDB(TownyDBTableType.COOLDOWN.tableName(), data, Collections.singletonList("key"));
        }
        return true;
    }

    private boolean loadPlotGroup(ResultSet rs) {
        String line = null;
        String uuid = null;
        try {
            PlotGroup group = this.universe.getGroup(UUID.fromString(rs.getString("groupID")));
            if (group == null) {
                TownyMessaging.sendErrorMsg("SQL: A plot group was not registered properly on load!");
                return true;
            }
            uuid = group.getUUID().toString();
            line = rs.getString("groupName");
            if (line != null) {
                try {
                    group.setName(line.trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((line = rs.getString("town")) != null) {
                Town town = this.universe.getTown(line.trim());
                if (town != null) {
                    group.setTown(town);
                } else {
                    this.deletePlotGroup(group);
                    return true;
                }
            }
            if ((line = rs.getString("groupPrice")) != null) {
                try {
                    group.setPrice(Float.parseFloat(line.trim()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((line = rs.getString("metadata")) != null) {
                MetadataLoader.getInstance().deserializeMetadata(group, line);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "Loading Error: Exception while reading plot group: " + uuid + " at line: " + line + " in the sql database", e);
            return false;
        }
        return true;
    }

    @Override
    public boolean loadPlotGroup(PlotGroup group) {
        return true;
    }

    private boolean loadDistrict(ResultSet rs) {
        String line = null;
        String uuidString = null;
        try {
            District district = this.universe.getDistrict(UUID.fromString(rs.getString("uuid")));
            if (district == null) {
                TownyMessaging.sendErrorMsg("SQL: A district was not registered properly on load!");
                return true;
            }
            uuidString = district.getUUID().toString();
            line = rs.getString("districtName");
            if (line != null) {
                try {
                    district.setName(line.trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((line = rs.getString("town")) != null) {
                UUID uuid = UUID.fromString(line.trim());
                if (uuid == null) {
                    this.deleteDistrict(district);
                    return true;
                }
                Town town = this.universe.getTown(uuid);
                if (town != null) {
                    district.setTown(town);
                } else {
                    this.deleteDistrict(district);
                    return true;
                }
            }
            if ((line = rs.getString("metadata")) != null) {
                MetadataLoader.getInstance().deserializeMetadata(district, line);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "Loading Error: Exception while reading district: " + uuidString + " at line: " + line + " in the sql database", e);
            return false;
        }
        return true;
    }

    @Override
    public boolean loadDistrict(District district) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadJails() {
        TownyMessaging.sendDebugMsg("Loading Jails");
        try (Connection connection = this.getConnection();
             Statement s = connection.createStatement();
             ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "JAILS ");){
            do {
                if (!rs.next()) return true;
            } while (this.loadJail(rs));
            this.plugin.getLogger().warning("Loading Error: Could not read jail data properly.");
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load Jail sql Error - " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean loadJail(Jail jail) {
        return true;
    }

    private boolean loadJail(ResultSet rs) {
        String uuid = null;
        try {
            String[] tokens;
            Jail jail = this.universe.getJail(UUID.fromString(rs.getString("uuid")));
            if (jail == null) {
                TownyMessaging.sendErrorMsg("SQL: A jail was not registered properly on load!");
                return true;
            }
            uuid = jail.getUUID().toString();
            String line = rs.getString("townBlock");
            if (line != null) {
                tokens = line.split("#");
                WorldCoord wc = null;
                try {
                    wc = new WorldCoord(tokens[0], Integer.parseInt(tokens[1].trim()), Integer.parseInt(tokens[2].trim()));
                    if (wc.isWilderness() || wc.getTownOrNull() == null) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    TownyMessaging.sendErrorMsg("Jail " + String.valueOf(jail.getUUID()) + " tried to load invalid townblock " + line + " deleting jail.");
                    this.removeJail(jail);
                    this.deleteJail(jail);
                    return true;
                }
                TownBlock tb = wc.getTownBlockOrNull();
                Town town = tb.getTownOrNull();
                jail.setTownBlock(tb);
                jail.setTown(town);
                tb.setJail(jail);
                town.addJail(jail);
            }
            if ((line = rs.getString("spawns")) != null) {
                String[] jails;
                for (String spawn : jails = line.split(";")) {
                    tokens = spawn.split("#");
                    if (tokens.length < 4) continue;
                    try {
                        jail.addJailCell(Position.deserialize(tokens));
                    }
                    catch (IllegalArgumentException e) {
                        TownyMessaging.sendErrorMsg("Jail " + String.valueOf(jail.getUUID()) + " tried to load invalid spawn " + line + " skipping: " + e.getMessage());
                    }
                }
                if (jail.getJailCellLocations().size() < 1) {
                    TownyMessaging.sendErrorMsg("Jail " + String.valueOf(jail.getUUID()) + " loaded with zero spawns " + line + " deleting jail.");
                    this.removeJail(jail);
                    this.deleteJail(jail);
                    return true;
                }
            }
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load Jail " + uuid + " sql Error - " + e.getMessage());
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "SQL: Load Jail " + uuid + " unknown Error - ", e);
        }
        return false;
    }

    @Override
    public synchronized boolean saveResident(Resident resident) {
        TownyMessaging.sendDebugMsg("Saving Resident " + resident.getName());
        try {
            HashMap<String, Object> res_hm = new HashMap<String, Object>();
            res_hm.put("name", resident.getName());
            res_hm.put("uuid", resident.hasUUID() ? resident.getUUID().toString() : "");
            res_hm.put("lastOnline", resident.getLastOnline());
            res_hm.put("registered", resident.getRegistered());
            res_hm.put("joinedTownAt", resident.getJoinedTownAt());
            res_hm.put("isNPC", resident.isNPC());
            res_hm.put("jailUUID", resident.isJailed() ? resident.getJail().getUUID() : "");
            res_hm.put("jailCell", resident.getJailCell());
            res_hm.put("jailHours", resident.getJailHours());
            res_hm.put("jailBail", resident.getJailBailCost());
            res_hm.put("title", resident.getTitle());
            res_hm.put("surname", resident.getSurname());
            if (!TownySettings.getDefaultResidentAbout().equals(resident.getAbout())) {
                res_hm.put("about", resident.getAbout());
            }
            res_hm.put("town", resident.hasTown() ? resident.getTown().getName() : "");
            res_hm.put("town-ranks", resident.hasTown() ? StringMgmt.join(resident.getTownRanksForSaving(), "#") : "");
            res_hm.put("nation-ranks", resident.hasTown() ? StringMgmt.join(resident.getNationRanksForSaving(), "#") : "");
            res_hm.put("friends", StringMgmt.join(resident.getFriends(), "#"));
            res_hm.put("protectionStatus", resident.getPermissions().toString().replaceAll(",", "#"));
            if (resident.hasMeta()) {
                res_hm.put("metadata", this.serializeMetadata(resident));
            } else {
                res_hm.put("metadata", "");
            }
            this.updateDB("RESIDENTS", res_hm, Collections.singletonList("name"));
            return true;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Save Resident unknown error " + e.getMessage());
            return false;
        }
    }

    @Override
    public synchronized boolean saveHibernatedResident(UUID uuid, long registered) {
        TownyMessaging.sendDebugMsg("Saving Hibernated Resident " + String.valueOf(uuid));
        try {
            HashMap<String, Comparable<UUID>> res_hm = new HashMap<String, Comparable<UUID>>();
            res_hm.put("uuid", uuid);
            res_hm.put("registered", Long.valueOf(registered));
            this.updateDB("HIBERNATEDRESIDENTS", res_hm, Collections.singletonList("uuid"));
            return true;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Save Hibernated Resident unknown error " + e.getMessage());
            return false;
        }
    }

    @Override
    public synchronized boolean saveTown(Town town) {
        TownyMessaging.sendDebugMsg("Saving town " + town.getName());
        try {
            HashMap<String, Object> twn_hm = new HashMap<String, Object>();
            twn_hm.put("name", town.getName());
            twn_hm.put("outlaws", StringMgmt.join(town.getOutlaws(), "#"));
            twn_hm.put("mayor", town.hasMayor() ? town.getMayor().getName() : "");
            twn_hm.put("nation", town.hasNation() ? town.getNationOrNull().getName() : "");
            twn_hm.put("townBoard", town.getBoard());
            twn_hm.put("tag", town.getTag());
            twn_hm.put("founder", town.getFounder());
            twn_hm.put("protectionStatus", town.getPermissions().toString().replaceAll(",", "#"));
            twn_hm.put("bonus", town.getBonusBlocks());
            twn_hm.put("manualTownLevel", town.getManualTownLevel());
            twn_hm.put("purchased", town.getPurchasedBlocks());
            twn_hm.put("nationZoneOverride", town.getNationZoneOverride());
            twn_hm.put("nationZoneEnabled", town.isNationZoneEnabled());
            twn_hm.put("commercialPlotPrice", town.getCommercialPlotPrice());
            twn_hm.put("commercialPlotTax", town.getCommercialPlotTax());
            twn_hm.put("embassyPlotPrice", town.getEmbassyPlotPrice());
            twn_hm.put("embassyPlotTax", town.getEmbassyPlotTax());
            twn_hm.put("spawnCost", town.getSpawnCost());
            twn_hm.put("plotPrice", town.getPlotPrice());
            twn_hm.put("plotTax", town.getPlotTax());
            twn_hm.put("taxes", town.getTaxes());
            twn_hm.put("hasUpkeep", town.hasUpkeep());
            twn_hm.put("hasUnlimitedClaims", town.hasUnlimitedClaims());
            twn_hm.put("visibleOnTopLists", town.isVisibleOnTopLists());
            twn_hm.put("taxpercent", town.isTaxPercentage());
            twn_hm.put("maxPercentTaxAmount", town.getMaxPercentTaxAmount());
            twn_hm.put("open", town.isOpen());
            twn_hm.put("public", town.isPublic());
            twn_hm.put("conquered", town.isConquered());
            twn_hm.put("conqueredDays", town.getConqueredDays());
            twn_hm.put("admindisabledpvp", town.isAdminDisabledPVP());
            twn_hm.put("adminenabledpvp", town.isAdminEnabledPVP());
            twn_hm.put("adminEnabledMobs", town.isAdminEnabledMobs());
            twn_hm.put("allowedToWar", town.isAllowedToWar());
            twn_hm.put("joinedNationAt", town.getJoinedNationAt());
            twn_hm.put("mapColorHexCode", town.getMapColorHexCode());
            twn_hm.put("movedHomeBlockAt", town.getMovedHomeBlockAt());
            twn_hm.put("forSale", town.isForSale());
            twn_hm.put("forSalePrice", town.getForSalePrice());
            twn_hm.put("forSaleTime", town.getForSaleTime());
            if (town.hasMeta()) {
                twn_hm.put("metadata", this.serializeMetadata(town));
            } else {
                twn_hm.put("metadata", "");
            }
            twn_hm.put("homeblock", town.hasHomeBlock() ? town.getHomeBlock().getWorld().getName() + "#" + town.getHomeBlock().getX() + "#" + town.getHomeBlock().getZ() : "");
            Position spawnPos = town.spawnPosition();
            twn_hm.put("spawn", spawnPos != null ? String.join((CharSequence)"#", spawnPos.serialize()) : "");
            StringBuilder outpostArray = new StringBuilder();
            if (town.hasOutpostSpawn()) {
                for (Position spawn : town.getOutpostSpawns()) {
                    outpostArray.append(String.join((CharSequence)"#", spawn.serialize())).append(";");
                }
            }
            twn_hm.put("outpostSpawns", outpostArray.toString());
            if (town.hasValidUUID()) {
                twn_hm.put("uuid", town.getUUID());
            } else {
                twn_hm.put("uuid", UUID.randomUUID());
            }
            twn_hm.put("registered", town.getRegistered());
            twn_hm.put("ruined", town.isRuined());
            twn_hm.put("ruinedTime", town.getRuinedTime());
            twn_hm.put("neutral", town.isNeutral());
            twn_hm.put("debtBalance", town.getDebtBalance());
            if (town.getPrimaryJail() != null) {
                twn_hm.put("primaryJail", town.getPrimaryJail().getUUID());
            }
            twn_hm.put("trustedResidents", StringMgmt.join(this.toUUIDList(town.getTrustedResidents()), "#"));
            twn_hm.put("trustedTowns", StringMgmt.join(town.getTrustedTownsUUIDS(), "#"));
            twn_hm.put("allies", StringMgmt.join(town.getAlliesUUIDs(), "#"));
            twn_hm.put("enemies", StringMgmt.join(town.getEnemiesUUIDs(), "#"));
            twn_hm.put("hasActiveWar", town.hasActiveWar());
            this.updateDB("TOWNS", twn_hm, Collections.singletonList("name"));
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "SQL: Save Town unknown error", e);
            return false;
        }
    }

    @Override
    public synchronized boolean savePlotGroup(PlotGroup group) {
        TownyMessaging.sendDebugMsg("Saving group " + group.getName());
        try {
            HashMap<String, Object> pltgrp_hm = new HashMap<String, Object>();
            pltgrp_hm.put("groupID", group.getUUID().toString());
            pltgrp_hm.put("groupName", group.getName());
            pltgrp_hm.put("groupPrice", group.getPrice());
            pltgrp_hm.put("town", group.getTown().getName());
            pltgrp_hm.put("metadata", this.serializeMetadata(group));
            this.updateDB("PLOTGROUPS", pltgrp_hm, Collections.singletonList("groupID"));
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "SQL: Save Plot groups unknown error", e);
        }
        return false;
    }

    @Override
    public boolean saveDistrict(District district) {
        TownyMessaging.sendDebugMsg("Saving district " + district.getName());
        try {
            HashMap<String, String> pltgrp_hm = new HashMap<String, String>();
            pltgrp_hm.put("uuid", district.getUUID().toString());
            pltgrp_hm.put("districtName", district.getName());
            pltgrp_hm.put("town", district.getTown().getUUID().toString());
            pltgrp_hm.put("metadata", this.serializeMetadata(district));
            this.updateDB("DISTRICTS", pltgrp_hm, Collections.singletonList("uuid"));
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "SQL: Save Districts unknown error", e);
        }
        return false;
    }

    @Override
    public synchronized boolean saveNation(Nation nation) {
        TownyMessaging.sendDebugMsg("Saving nation " + nation.getName());
        try {
            HashMap<String, Object> nat_hm = new HashMap<String, Object>();
            nat_hm.put("name", nation.getName());
            nat_hm.put("capital", nation.hasCapital() ? nation.getCapital().getName() : "");
            nat_hm.put("nationBoard", nation.getBoard());
            nat_hm.put("mapColorHexCode", nation.getMapColorHexCode());
            nat_hm.put("tag", nation.hasTag() ? nation.getTag() : "");
            nat_hm.put("allies", StringMgmt.join(nation.getAllies(), "#"));
            nat_hm.put("enemies", StringMgmt.join(nation.getEnemies(), "#"));
            nat_hm.put("taxes", nation.getTaxes());
            nat_hm.put("taxpercent", nation.isTaxPercentage());
            nat_hm.put("maxPercentTaxAmount", nation.getMaxPercentTaxAmount());
            nat_hm.put("spawnCost", nation.getSpawnCost());
            nat_hm.put("neutral", nation.isNeutral());
            Position spawnPos = nation.spawnPosition();
            nat_hm.put("nationSpawn", spawnPos != null ? String.join((CharSequence)"#", spawnPos.serialize()) : "");
            if (nation.hasValidUUID()) {
                nat_hm.put("uuid", nation.getUUID());
            } else {
                nat_hm.put("uuid", UUID.randomUUID());
            }
            nat_hm.put("registered", nation.getRegistered());
            nat_hm.put("isPublic", nation.isPublic());
            nat_hm.put("isOpen", nation.isOpen());
            if (nation.hasMeta()) {
                nat_hm.put("metadata", this.serializeMetadata(nation));
            } else {
                nat_hm.put("metadata", "");
            }
            nat_hm.put("conqueredTax", nation.getConqueredTax());
            nat_hm.put("sanctionedTowns", StringMgmt.join(nation.getSanctionedTownsForSaving(), "#"));
            nat_hm.put("hasActiveWar", nation.hasActiveWar());
            this.updateDB("NATIONS", nat_hm, Collections.singletonList("name"));
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "SQL: Save Nation unknown error", e);
        }
        return false;
    }

    @Override
    public synchronized boolean saveWorld(TownyWorld world) {
        TownyMessaging.sendDebugMsg("Saving world " + world.getName());
        try {
            HashMap<String, Object> nat_hm = new HashMap<String, Object>();
            nat_hm.put("name", world.getName());
            nat_hm.put("uuid", world.getUUID());
            nat_hm.put("pvp", world.isPVP());
            nat_hm.put("forcepvp", world.isForcePVP());
            nat_hm.put("friendlyFire", world.isFriendlyFireEnabled());
            nat_hm.put("claimable", world.isClaimable());
            nat_hm.put("worldmobs", world.hasWorldMobs());
            nat_hm.put("wildernessmobs", world.hasWildernessMobs());
            nat_hm.put("forcetownmobs", world.isForceTownMobs());
            nat_hm.put("firespread", world.isFire());
            nat_hm.put("forcefirespread", world.isForceFire());
            nat_hm.put("explosions", world.isExpl());
            nat_hm.put("forceexplosions", world.isForceExpl());
            nat_hm.put("endermanprotect", world.isEndermanProtect());
            nat_hm.put("disablecreaturetrample", world.isDisableCreatureTrample());
            nat_hm.put("unclaimedZoneBuild", world.getUnclaimedZoneBuild());
            nat_hm.put("unclaimedZoneDestroy", world.getUnclaimedZoneDestroy());
            nat_hm.put("unclaimedZoneSwitch", world.getUnclaimedZoneSwitch());
            nat_hm.put("unclaimedZoneItemUse", world.getUnclaimedZoneItemUse());
            if (world.getUnclaimedZoneName() != null) {
                nat_hm.put("unclaimedZoneName", world.getUnclaimedZoneName());
            }
            if (world.getUnclaimedZoneIgnoreMaterials() != null) {
                nat_hm.put("unclaimedZoneIgnoreIds", StringMgmt.join(world.getUnclaimedZoneIgnoreMaterials(), "#"));
            }
            nat_hm.put("isDeletingEntitiesOnUnclaim", world.isDeletingEntitiesOnUnclaim());
            if (world.getUnclaimDeleteEntityTypes() != null) {
                nat_hm.put("unclaimDeleteEntityTypes", StringMgmt.join(BukkitTools.convertKeyedToString(world.getUnclaimDeleteEntityTypes()), "#"));
            }
            nat_hm.put("usingPlotManagementDelete", world.isUsingPlotManagementDelete());
            if (world.getPlotManagementDeleteIds() != null) {
                nat_hm.put("plotManagementDeleteIds", StringMgmt.join(world.getPlotManagementDeleteIds(), "#"));
            }
            nat_hm.put("usingPlotManagementMayorDelete", world.isUsingPlotManagementMayorDelete());
            if (world.getPlotManagementMayorDelete() != null) {
                nat_hm.put("plotManagementMayorDelete", StringMgmt.join(world.getPlotManagementMayorDelete(), "#"));
            }
            nat_hm.put("usingPlotManagementRevert", world.isUsingPlotManagementRevert());
            if (world.getPlotManagementIgnoreIds() != null) {
                nat_hm.put("plotManagementIgnoreIds", StringMgmt.join(world.getPlotManagementIgnoreIds(), "#"));
            }
            if (world.getRevertOnUnclaimWhitelistMaterials() != null) {
                nat_hm.put("revertOnUnclaimWhitelistMaterials", StringMgmt.join(world.getRevertOnUnclaimWhitelistMaterials(), "#"));
            }
            nat_hm.put("usingPlotManagementWildRegen", world.isUsingPlotManagementWildEntityRevert());
            if (world.getPlotManagementWildRevertEntities() != null) {
                nat_hm.put("PlotManagementWildRegenEntities", StringMgmt.join(BukkitTools.convertKeyedToString(world.getPlotManagementWildRevertEntities()), "#"));
            }
            if (world.getPlotManagementWildRevertBlockWhitelist() != null) {
                nat_hm.put("PlotManagementWildRegenBlockWhitelist", StringMgmt.join(world.getPlotManagementWildRevertBlockWhitelist(), "#"));
            }
            if (world.getWildRevertMaterialsToNotOverwrite() != null) {
                nat_hm.put("wildRegenBlocksToNotOverwrite", StringMgmt.join(world.getWildRevertMaterialsToNotOverwrite(), "#"));
            }
            nat_hm.put("plotManagementWildRegenSpeed", world.getPlotManagementWildRevertDelay());
            nat_hm.put("usingPlotManagementWildRegenBlocks", world.isUsingPlotManagementWildBlockRevert());
            if (world.getPlotManagementWildRevertBlocks() != null) {
                nat_hm.put("PlotManagementWildRegenBlocks", StringMgmt.join(world.getPlotManagementWildRevertBlocks(), "#"));
            }
            nat_hm.put("usingTowny", world.isUsingTowny());
            nat_hm.put("warAllowed", world.isWarAllowed());
            nat_hm.put("jailing", world.isJailingEnabled());
            if (world.hasMeta()) {
                nat_hm.put("metadata", this.serializeMetadata(world));
            } else {
                nat_hm.put("metadata", "");
            }
            this.updateDB("WORLDS", nat_hm, Collections.singletonList("name"));
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "SQL: Save world unknown error (" + world.getName() + ")", e);
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean saveTownBlock(TownBlock townBlock) {
        TownyMessaging.sendDebugMsg("Saving town block " + townBlock.getWorld().getName() + ":" + townBlock.getX() + "x" + townBlock.getZ());
        try {
            HashMap<String, Object> tb_hm = new HashMap<String, Object>();
            tb_hm.put("world", townBlock.getWorld().getName());
            tb_hm.put("x", townBlock.getX());
            tb_hm.put("z", townBlock.getZ());
            tb_hm.put("name", townBlock.getName());
            tb_hm.put("price", townBlock.getPlotPrice());
            tb_hm.put("taxed", townBlock.isTaxed());
            tb_hm.put("town", townBlock.getTown().getName());
            tb_hm.put("resident", townBlock.hasResident() ? townBlock.getResidentOrNull().getName() : "");
            tb_hm.put("typeName", townBlock.getTypeName());
            tb_hm.put("outpost", townBlock.isOutpost());
            tb_hm.put("permissions", townBlock.isChanged() ? townBlock.getPermissions().toString().replaceAll(",", "#") : "");
            tb_hm.put("changed", townBlock.isChanged());
            tb_hm.put("claimedAt", townBlock.getClaimedAt());
            tb_hm.put("minTownMembershipDays", townBlock.getMinTownMembershipDays());
            tb_hm.put("maxTownMembershipDays", townBlock.getMaxTownMembershipDays());
            if (townBlock.hasPlotObjectGroup()) {
                tb_hm.put("groupID", townBlock.getPlotObjectGroup().getUUID().toString());
            } else {
                tb_hm.put("groupID", "");
            }
            if (townBlock.hasDistrict()) {
                tb_hm.put("districtID", townBlock.getDistrict().getUUID().toString());
            } else {
                tb_hm.put("districtID", "");
            }
            if (townBlock.hasMeta()) {
                tb_hm.put("metadata", this.serializeMetadata(townBlock));
            } else {
                tb_hm.put("metadata", "");
            }
            tb_hm.put("trustedResidents", StringMgmt.join(this.toUUIDList(townBlock.getTrustedResidents()), "#"));
            HashMap<String, String> stringMap = new HashMap<String, String>();
            for (Map.Entry<Resident, PermissionData> entry : townBlock.getPermissionOverrides().entrySet()) {
                stringMap.put(entry.getKey().getUUID().toString(), entry.getValue().toString());
            }
            tb_hm.put("customPermissionData", new Gson().toJson(stringMap));
            this.updateDB("TOWNBLOCKS", tb_hm, Arrays.asList("world", "x", "z"));
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "SQL: Save TownBlock unknown error", e);
        }
        return true;
    }

    @Override
    public synchronized boolean saveJail(Jail jail) {
        TownyMessaging.sendDebugMsg("Saving jail " + String.valueOf(jail.getUUID()));
        try {
            HashMap<String, Object> jail_hm = new HashMap<String, Object>();
            jail_hm.put("uuid", jail.getUUID());
            jail_hm.put("townBlock", jail.getTownBlock().getWorld().getName() + "#" + jail.getTownBlock().getX() + "#" + jail.getTownBlock().getZ());
            StringBuilder jailCellArray = new StringBuilder();
            if (jail.hasCells()) {
                for (Position cell : jail.getJailCellPositions()) {
                    jailCellArray.append(String.join((CharSequence)"#", cell.serialize())).append(";");
                }
            }
            jail_hm.put("spawns", jailCellArray);
            this.updateDB("JAILS", jail_hm, Collections.singletonList("uuid"));
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "SQL: Save jail unknown error", e);
            return true;
        }
    }

    @Override
    public void deleteResident(Resident resident) {
        HashMap<String, Object> res_hm = new HashMap<String, Object>();
        res_hm.put("name", resident.getName());
        this.DeleteDB("RESIDENTS", res_hm);
    }

    @Override
    public void deleteHibernatedResident(UUID uuid) {
        HashMap<String, Object> res_hm = new HashMap<String, Object>();
        res_hm.put("uuid", uuid);
        this.DeleteDB("HIBERNATEDRESIDENTS", res_hm);
    }

    @Override
    public void deleteTown(Town town) {
        HashMap<String, Object> twn_hm = new HashMap<String, Object>();
        twn_hm.put("name", town.getName());
        this.DeleteDB("TOWNS", twn_hm);
    }

    @Override
    public void deleteNation(Nation nation) {
        HashMap<String, Object> nat_hm = new HashMap<String, Object>();
        nat_hm.put("name", nation.getName());
        this.DeleteDB("NATIONS", nat_hm);
    }

    @Override
    public void deleteWorld(TownyWorld world) {
    }

    @Override
    public void deleteTownBlock(TownBlock townBlock) {
        HashMap<String, Object> twn_hm = new HashMap<String, Object>();
        twn_hm.put("world", townBlock.getWorld().getName());
        twn_hm.put("x", townBlock.getX());
        twn_hm.put("z", townBlock.getZ());
        this.DeleteDB("TOWNBLOCKS", twn_hm);
    }

    @Override
    public void deletePlotGroup(PlotGroup group) {
        HashMap<String, Object> pltgrp_hm = new HashMap<String, Object>();
        pltgrp_hm.put("groupID", group.getUUID());
        this.DeleteDB("PLOTGROUPS", pltgrp_hm);
    }

    @Override
    public void deleteDistrict(District district) {
        HashMap<String, Object> district_hm = new HashMap<String, Object>();
        district_hm.put("uuid", district.getUUID());
        this.DeleteDB("DISTRICTS", district_hm);
    }

    @Override
    public void deleteJail(Jail jail) {
        HashMap<String, Object> jail_hm = new HashMap<String, Object>();
        jail_hm.put("uuid", jail.getUUID());
        this.DeleteDB("JAILS", jail_hm);
    }

    @Override
    public CompletableFuture<Optional<Long>> getHibernatedResidentRegistered(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection connection = this.getConnection();){
                Optional optional;
                block18: {
                    PreparedStatement preparedStatement;
                    block16: {
                        Optional<Long> optional2;
                        block17: {
                            preparedStatement = connection.prepareStatement("SELECT * FROM " + this.tb_prefix + "HIBERNATEDRESIDENTS WHERE uuid = ? LIMIT 1");
                            try {
                                String registered;
                                preparedStatement.setString(1, uuid.toString());
                                ResultSet resultSet = preparedStatement.executeQuery();
                                if (!resultSet.next() || (registered = resultSet.getString("registered")) == null || registered.isEmpty()) break block16;
                                optional2 = Optional.of(Long.parseLong(registered));
                                if (preparedStatement == null) break block17;
                            }
                            catch (Throwable throwable) {
                                if (preparedStatement != null) {
                                    try {
                                        preparedStatement.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            preparedStatement.close();
                        }
                        return optional2;
                    }
                    optional = Optional.empty();
                    if (preparedStatement == null) break block18;
                    preparedStatement.close();
                }
                return optional;
            }
            catch (Exception e) {
                return Optional.empty();
            }
        });
    }

    public HikariDataSource getHikariDataSource() {
        return this.hikariDataSource;
    }

    public static enum TownyDBTableType {
        JAIL("JAILS", "SELECT uuid FROM ", "uuid"),
        PLOTGROUP("PLOTGROUPS", "SELECT groupID FROM ", "groupID"),
        DISTRICT("DISTRICTS", "SELECT uuid FROM ", "uuid"),
        RESIDENT("RESIDENTS", "SELECT name FROM ", "name"),
        HIBERNATED_RESIDENT("HIBERNATEDRESIDENTS", "", "uuid"),
        TOWN("TOWNS", "SELECT name FROM ", "name"),
        NATION("NATIONS", "SELECT name FROM ", "name"),
        WORLD("WORLDS", "SELECT name FROM ", "name"),
        TOWNBLOCK("TOWNBLOCKS", "SELECT world,x,z FROM ", "name"),
        COOLDOWN("COOLDOWNS", "SELECT * FROM ", "key");

        private final String tableName;
        private String queryString;
        private String primaryKey;

        private TownyDBTableType(String tableName, String queryString, String primaryKey) {
            this.tableName = tableName;
            this.queryString = queryString;
            this.primaryKey = primaryKey;
        }

        public String tableName() {
            return this.tableName;
        }

        public String primaryKey() {
            return this.primaryKey;
        }

        private String getSingular() {
            return this.tableName.substring(0, this.tableName.length() - 1).toLowerCase(Locale.ROOT);
        }

        public String getSaveLocation(String rowKeyName) {
            return TownySettings.getSQLTablePrefix() + this.tableName + File.separator + rowKeyName;
        }

        public String getLoadErrorMsg(UUID uuid) {
            return "Loading Error: Could not read the " + this.getSingular() + " with UUID '" + String.valueOf(uuid) + "' from the " + this.tableName + " table.";
        }
    }
}

