/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.event.TownyObjDeleteEvent;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteNationEvent
extends TownyObjDeleteEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Resident king;
    private final Cause cause;
    private final CommandSender sender;

    public DeleteNationEvent(Nation nation, Resident king, Cause cause, CommandSender sender) {
        super(nation.getName(), nation.getUUID(), nation.getRegistered());
        this.king = king;
        this.cause = cause;
        this.sender = sender;
    }

    public String getNationName() {
        return this.name;
    }

    public UUID getNationUUID() {
        return this.uuid;
    }

    public long getNationCreated() {
        return this.registered;
    }

    @Nullable
    public UUID getLeaderUUID() {
        return this.king != null ? this.king.getUUID() : null;
    }

    @Nullable
    public Resident getLeader() {
        return this.king;
    }

    public Cause getCause() {
        return this.cause;
    }

    @Nullable
    public CommandSender getSender() {
        return this.sender;
    }

    @Nullable
    public Resident getSenderResident() {
        Resident resident;
        CommandSender commandSender = this.sender;
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            resident = TownyAPI.getInstance().getResident(player);
        } else {
            resident = null;
        }
        return resident;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public static enum Cause {
        UNKNOWN,
        LOAD,
        COMMAND,
        ADMIN_COMMAND,
        NO_TOWNS,
        NOT_ENOUGH_RESIDENTS,
        UPKEEP;


        public boolean isCommand() {
            return this == COMMAND || this == ADMIN_COMMAND;
        }

        @ApiStatus.Internal
        public boolean ignoresPreEvent() {
            return this == LOAD || this == ADMIN_COMMAND || this == NO_TOWNS;
        }
    }
}

