/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.event.TownyObjDeleteEvent;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteTownEvent
extends TownyObjDeleteEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Resident mayor;
    private final Cause cause;
    private final CommandSender sender;

    public DeleteTownEvent(@NotNull Town town, @Nullable Resident mayor, @NotNull Cause cause, @Nullable CommandSender sender) {
        super(town.getName(), town.getUUID(), town.getRegistered());
        this.mayor = mayor;
        this.cause = cause;
        this.sender = sender;
    }

    public String getTownName() {
        return this.name;
    }

    public UUID getTownUUID() {
        return this.uuid;
    }

    public long getTownCreated() {
        return this.registered;
    }

    @Nullable
    public UUID getMayorUUID() {
        return this.mayor != null ? this.mayor.getUUID() : null;
    }

    @Nullable
    public Resident getMayor() {
        return this.mayor;
    }

    @NotNull
    public Cause getCause() {
        return this.cause;
    }

    @Nullable
    public CommandSender getSender() {
        return this.sender;
    }

    @Nullable
    public Resident getSenderResident() {
        Resident resident;
        CommandSender commandSender = this.sender;
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            resident = TownyAPI.getInstance().getResident(player);
        } else {
            resident = null;
        }
        return resident;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public static enum Cause {
        UNKNOWN,
        LOAD,
        COMMAND,
        ADMIN_COMMAND,
        NO_RESIDENTS,
        NO_TOWNBLOCKS,
        MERGED,
        RUINED,
        UPKEEP,
        BANKRUPTCY;


        public boolean isCommand() {
            return this == COMMAND || this == ADMIN_COMMAND;
        }

        public boolean isUpkeep() {
            return this == UPKEEP || this == BANKRUPTCY;
        }

        @ApiStatus.Internal
        public boolean ignoresPreEvent() {
            return this == LOAD || this == ADMIN_COMMAND || this == MERGED || this == NO_RESIDENTS;
        }
    }
}

