/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.permissions.Permissible;

public class PlayerChangePlotEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private final Player player;
    private final WorldCoord from;
    private final WorldCoord to;
    private final PlayerMoveEvent moveEvent;
    private boolean showPlotNotifications;

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public PlayerChangePlotEvent(Player player, WorldCoord from, WorldCoord to, PlayerMoveEvent moveEvent) {
        super(!Bukkit.getServer().isPrimaryThread());
        this.player = player;
        this.from = from;
        this.to = to;
        this.moveEvent = moveEvent;
        this.showPlotNotifications = TownySettings.getShowTownNotifications() && TownyUniverse.getInstance().getPermissionSource().testPermission((Permissible)player, PermissionNodes.TOWNY_RECEIVES_PLOT_NOTIFICATIONS.getNode());
    }

    public WorldCoord getFrom() {
        return this.from;
    }

    public PlayerMoveEvent getMoveEvent() {
        return this.moveEvent;
    }

    public WorldCoord getTo() {
        return this.to;
    }

    public Player getPlayer() {
        return this.player;
    }

    public TownyWorld getTownyWorldFrom() {
        return this.from.getTownyWorld();
    }

    public TownyWorld getTownyWorldTo() {
        return this.to.getTownyWorld();
    }

    public boolean isShowingPlotNotifications() {
        return this.showPlotNotifications;
    }

    public void setShowingPlotNotifications(boolean showPlotNotifications) {
        this.showPlotNotifications = showPlotNotifications;
    }
}

