/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event.damage;

import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.jetbrains.annotations.Nullable;

public abstract class TownyDamageEvent
extends Event
implements Cancellable {
    protected final Entity entity;
    protected final Location loc;
    protected final EntityDamageEvent.DamageCause cause;
    protected final TownBlock townblock;
    protected boolean cancelled;
    protected String message;

    public TownyDamageEvent(Location loc, Entity entity, EntityDamageEvent.DamageCause cause, TownBlock townblock, boolean cancelled) {
        this.entity = entity;
        this.loc = loc;
        this.cause = cause;
        this.townblock = townblock;
        this.setCancelled(cancelled);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Nullable
    public Town getTown() {
        return this.townblock == null ? null : this.townblock.getTownOrNull();
    }

    public Location getLocation() {
        return this.loc;
    }

    public Entity getEntity() {
        return this.entity;
    }

    @Nullable
    public TownBlock getTownBlock() {
        return this.townblock;
    }

    public boolean isInWilderness() {
        return this.townblock == null;
    }

    public boolean hasTownBlock() {
        return this.townblock != null;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public EntityDamageEvent.DamageCause getCause() {
        return this.cause;
    }
}

