/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event.economy;

import com.palmergames.bukkit.towny.event.CancellableTownyEvent;
import com.palmergames.bukkit.towny.object.economy.transaction.Transaction;
import com.palmergames.bukkit.towny.object.economy.transaction.TransactionType;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class TownyPreTransactionEvent
extends CancellableTownyEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Transaction transaction;

    public TownyPreTransactionEvent(Transaction transaction) {
        this.transaction = transaction;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public double getNewBalance() {
        return switch (this.transaction.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case TransactionType.ADD, TransactionType.DEPOSIT -> this.transaction.getReceivingAccount().getHoldingBalance() + this.transaction.getAmount();
            case TransactionType.SUBTRACT, TransactionType.WITHDRAW -> this.transaction.getReceivingAccount().getHoldingBalance() - this.transaction.getAmount();
        };
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }
}

