/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event.executors;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.actions.TownyActionEvent;
import com.palmergames.bukkit.towny.event.actions.TownyBuildEvent;
import com.palmergames.bukkit.towny.event.actions.TownyBurnEvent;
import com.palmergames.bukkit.towny.event.actions.TownyDestroyEvent;
import com.palmergames.bukkit.towny.event.actions.TownyExplodingBlocksEvent;
import com.palmergames.bukkit.towny.event.actions.TownyItemuseEvent;
import com.palmergames.bukkit.towny.event.actions.TownySwitchEvent;
import com.palmergames.bukkit.towny.event.damage.TownBlockExplosionTestEvent;
import com.palmergames.bukkit.towny.event.damage.TownyExplosionDamagesEntityEvent;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ItemLists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;

public class TownyActionEventExecutor {
    private static boolean isAllowedAction(Player player, Location loc, Material mat, TownyPermission.ActionType action, TownyActionEvent event) {
        return TownyActionEventExecutor.isAllowedAction(player, loc, mat, action, event, false);
    }

    private static boolean isAllowedAction(Player player, Location loc, Material mat, TownyPermission.ActionType action, TownyActionEvent event, boolean silent) {
        if (!PlayerCacheUtil.getCachePermission(player, loc, mat, action)) {
            event.setCancelled(true);
            PlayerCache cache = PlayerCacheUtil.getCache(player);
            if (cache.hasBlockErrMsg()) {
                event.setCancelMessage(cache.getBlockErrMsg());
            } else {
                event.suppressMessage();
            }
        }
        BukkitTools.fireEvent(event);
        if (event.isCancelled() && !event.isMessageSuppressed() && !silent) {
            TownyMessaging.sendErrorMsg(player, event.getCancelMessage());
        }
        return !event.isCancelled();
    }

    private static boolean isAllowedExplosion(Location loc) {
        boolean canExplode = false;
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(loc.getWorld());
        if (world != null) {
            if (TownyAPI.getInstance().isWilderness(loc)) {
                if (world.isForceExpl() || world.isExpl()) {
                    canExplode = true;
                } else if (!world.isExpl()) {
                    canExplode = false;
                }
            } else {
                TownBlock townBlock = TownyAPI.getInstance().getTownBlock(loc);
                canExplode = world.isForceExpl() || townBlock.getPermissions().explosion;
                TownBlockExplosionTestEvent event = new TownBlockExplosionTestEvent(townBlock, townBlock.getTownOrNull(), canExplode);
                BukkitTools.fireEvent(event);
                canExplode = event.isExplosion();
            }
        }
        return canExplode;
    }

    private static List<Block> filterExplodingBlockList(List<Block> blocks) {
        ArrayList<Block> approvedBlocks = new ArrayList<Block>();
        for (Block block : blocks) {
            if (!TownyActionEventExecutor.isAllowedExplosion(block.getLocation())) continue;
            approvedBlocks.add(block);
        }
        return approvedBlocks;
    }

    private static Block getBlock(Location loc) {
        return Bukkit.getWorld((String)loc.getWorld().getName()).getBlockAt(loc);
    }

    private static boolean isAllowedBurn(Block block) {
        TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(block.getWorld());
        return !(TownyAPI.getInstance().isWilderness(block) ? TownyActionEventExecutor.isNotPortal(block) && TownyActionEventExecutor.isNotCandle(block) && TownyActionEventExecutor.isNotCampfire(block) && !townyWorld.isForceFire() && !townyWorld.isFire() : TownyActionEventExecutor.isNotPortal(block) && TownyActionEventExecutor.isNotCandle(block) && TownyActionEventExecutor.isNotCampfire(block) && TownyActionEventExecutor.isNotFireSpreadBypassMat(block) && !townyWorld.isForceFire() && !TownyAPI.getInstance().getTownBlock((Location)block.getLocation()).getPermissions().fire);
    }

    private static boolean isNotCampfire(Block block) {
        return !ItemLists.CAMPFIRES.contains(block.getType());
    }

    private static boolean isNotPortal(Block block) {
        return block.getRelative(BlockFace.DOWN).getType() != Material.OBSIDIAN;
    }

    private static boolean isNotCandle(Block block) {
        return !ItemLists.CANDLES.contains(block.getType());
    }

    private static boolean isNotFireSpreadBypassMat(Block block) {
        if (TownyActionEventExecutor.isNotCampfire(block)) {
            block = block.getRelative(BlockFace.DOWN);
        }
        return !TownySettings.isFireSpreadBypassMaterial(block.getType().getKey().getKey().toUpperCase(Locale.ROOT));
    }

    public static boolean canBuild(Player player, Location loc, Material mat) {
        TownyBuildEvent event = new TownyBuildEvent(player, loc, mat, TownyActionEventExecutor.getBlock(loc), TownyAPI.getInstance().getTownBlock(loc), false);
        return TownyActionEventExecutor.isAllowedAction(player, loc, mat, TownyPermission.ActionType.BUILD, event);
    }

    public static boolean canBuild(Player player, Block block) {
        return TownyActionEventExecutor.canBuild(player, block.getLocation(), block.getType());
    }

    public static boolean canDestroy(Player player, Location loc, Material mat) {
        TownyDestroyEvent event = new TownyDestroyEvent(player, loc, mat, TownyActionEventExecutor.getBlock(loc), TownyAPI.getInstance().getTownBlock(loc), false);
        return TownyActionEventExecutor.isAllowedAction(player, loc, mat, TownyPermission.ActionType.DESTROY, event);
    }

    public static boolean canDestroy(Player player, Block block) {
        return TownyActionEventExecutor.canDestroy(player, block.getLocation(), block.getType());
    }

    public static boolean canSwitch(Player player, Location loc, Material mat) {
        return TownyActionEventExecutor.canSwitch(player, loc, mat, false);
    }

    public static boolean canSwitch(Player player, Location loc, Material mat, boolean silent) {
        TownySwitchEvent event = new TownySwitchEvent(player, loc, mat, TownyActionEventExecutor.getBlock(loc), TownyAPI.getInstance().getTownBlock(loc), false);
        return TownyActionEventExecutor.isAllowedAction(player, loc, mat, TownyPermission.ActionType.SWITCH, event, silent);
    }

    public static boolean canItemuse(Player player, Location loc, Material mat) {
        TownyItemuseEvent event = new TownyItemuseEvent(player, loc, mat, TownyAPI.getInstance().getTownBlock(loc), false);
        return TownyActionEventExecutor.isAllowedAction(player, loc, mat, TownyPermission.ActionType.ITEM_USE, event);
    }

    public static List<Block> filterExplodableBlocks(List<Block> blockList, Material mat, Entity entity, Event bukkitExplodeEvent) {
        blockList.sort(Comparator.comparingInt(Block::getY));
        List<Block> filteredBlocks = TownyActionEventExecutor.filterExplodingBlockList(blockList);
        TownyExplodingBlocksEvent event = new TownyExplodingBlocksEvent(blockList, filteredBlocks, mat, entity, bukkitExplodeEvent);
        BukkitTools.fireEvent(event);
        if (event.isChanged()) {
            filteredBlocks = event.getBlockList();
        }
        return filteredBlocks;
    }

    public static boolean canExplosionDamageEntities(Location loc, Entity harmedEntity, EntityDamageEvent.DamageCause cause) {
        boolean cancelled = !TownyActionEventExecutor.isAllowedExplosion(loc);
        return !BukkitTools.isEventCancelled(new TownyExplosionDamagesEntityEvent(loc, harmedEntity, cause, TownyAPI.getInstance().getTownBlock(loc), cancelled));
    }

    public static boolean canBurn(Block block) {
        boolean cancelled = !TownyActionEventExecutor.isAllowedBurn(block);
        return !BukkitTools.isEventCancelled(new TownyBurnEvent(block, block.getLocation(), TownyAPI.getInstance().getTownBlock(block.getLocation()), cancelled));
    }
}

