/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event.nation;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.event.CancellableTownyEvent;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Translation;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class NationKingChangeEvent
extends CancellableTownyEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Resident oldKing;
    private final Resident newKing;

    public NationKingChangeEvent(Resident oldKing, Resident newKing) {
        this.oldKing = oldKing;
        this.newKing = newKing;
        this.setCancelMessage(Translation.of("msg_err_command_disable"));
    }

    public Resident getOldKing() {
        return this.oldKing;
    }

    public Resident getNewKing() {
        return this.newKing;
    }

    public Nation getNation() {
        return this.newKing.getNationOrNull();
    }

    public boolean isCapitalChange() {
        return !TownyAPI.getInstance().getResidentTownOrNull(this.oldKing).hasResident(this.newKing);
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }
}

