/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event.plot;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class PlayerChangePlotTypeEvent
extends Event {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final TownBlockType newType;
    private final TownBlockType oldType;
    private final TownBlock townBlock;
    private final Player player;

    public PlayerChangePlotTypeEvent(TownBlockType newType, TownBlockType oldType, TownBlock townBlock, Player player) {
        super(!Bukkit.getServer().isPrimaryThread());
        this.newType = newType;
        this.oldType = oldType;
        this.townBlock = townBlock;
        this.player = player;
    }

    public TownBlockType getNewType() {
        return this.newType;
    }

    public TownBlockType getOldType() {
        return this.oldType;
    }

    public TownBlock getTownBlock() {
        return this.townBlock;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Resident getResident() {
        return TownyAPI.getInstance().getResident(this.player);
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }
}

