/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event.statusscreen;

import com.palmergames.bukkit.towny.object.statusscreens.StatusScreen;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class StatusScreenEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private final StatusScreen screen;
    private int addedLineCount = 0;

    public StatusScreenEvent(StatusScreen screen) {
        super(!Bukkit.getServer().isPrimaryThread());
        this.screen = screen;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public StatusScreen getStatusScreen() {
        return this.screen;
    }

    public CommandSender getCommandSender() {
        return this.screen.getCommandSender();
    }

    public void addLines(List<String> lines) {
        for (String line : lines) {
            this.addLine(line);
        }
    }

    public void addLine(String line) {
        this.addLine(this.getNextKey(), line);
    }

    public void addLine(String key, String line) {
        this.screen.addComponentOf(key, "\n" + line);
    }

    public void addLines(Collection<Component> lines) {
        for (Component line : lines) {
            this.addLine(line);
        }
    }

    public void addLine(Component line) {
        this.addLine(this.getNextKey(), line);
    }

    public void addLine(String key, Component line) {
        this.screen.addComponentOf(key, Component.newline().append(line));
    }

    private String getNextKey() {
        return String.format("eventAddedLine-%d", ++this.addedLineCount);
    }
}

