/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event.town;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.event.CancellableTownyEvent;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translation;
import org.bukkit.command.CommandSender;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class TownMayorChangeEvent
extends CancellableTownyEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final CommandSender sender;
    private final Resident oldMayor;
    private final Resident newMayor;

    public TownMayorChangeEvent(CommandSender sender, Resident oldMayor, Resident newMayor) {
        this.sender = sender;
        this.oldMayor = oldMayor;
        this.newMayor = newMayor;
        this.setCancelMessage(Translation.of("msg_err_command_disable"));
    }

    public Resident getOldMayor() {
        return this.oldMayor;
    }

    public Resident getNewMayor() {
        return this.newMayor;
    }

    public Town getTown() {
        return TownyAPI.getInstance().getResidentTownOrNull(this.newMayor);
    }

    public boolean isNationCapital() {
        return this.getTown().isCapital();
    }

    public boolean isKingChange() {
        return this.oldMayor.isKing();
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public CommandSender getCommandSender() {
        return this.sender;
    }
}

