/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.hooks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.util.Version;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class LeakChecker {
    static final List<Version> EWVersions = Arrays.asList(Version.fromString("0.0.104"), Version.fromString("0.0.105"), Version.fromString("0.0.121"));
    static final List<Version> TCVersions = Arrays.asList(Version.fromString("0.0.46"));
    static final List<Version> TRTPVersions = Arrays.asList(Version.fromString("0.0.9"));
    static final List<Version> ToBVersions = Arrays.asList(Version.fromString("0.2.0"));
    static final List<Version> THVersions = Arrays.asList(Version.fromString("0.0.30"));

    public static void checkForLeaks() {
        ArrayList<String> leaks = new ArrayList<String>();
        LeakChecker.checkPlugin(leaks, EWVersions, "EventWar");
        LeakChecker.checkPlugin(leaks, TCVersions, "TownyCamps");
        LeakChecker.checkPlugin(leaks, TRTPVersions, "TownyRTP");
        LeakChecker.checkPlugin(leaks, ToBVersions, "TowerOfBabel");
        LeakChecker.checkPlugin(leaks, THVersions, "TownyHistories");
        if (leaks.isEmpty()) {
            return;
        }
        Towny.getPlugin().getLogger().warning("Detected memory leaks coming from " + StringMgmt.join(leaks, ",") + "!");
    }

    private static void checkPlugin(List<String> leaks, List<Version> versionList, String name) {
        PluginManager pm = Bukkit.getPluginManager();
        Plugin plugin = pm.getPlugin(name);
        if (plugin == null || !versionList.contains(Version.fromString(plugin.getDescription().getVersion()))) {
            return;
        }
        Towny.getPlugin().getScheduler().runLater(() -> pm.disablePlugin(plugin), 10L);
        leaks.add(name);
    }
}

