/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.huds;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyAsciiMap;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.asciimap.WildernessMapEvent;
import com.palmergames.bukkit.towny.huds.HUDManager;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.map.TownyMapData;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.Colors;
import io.papermc.paper.scoreboard.numbers.NumberFormat;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class MapHUD {
    private static final ChatColor WHITE = ChatColor.WHITE;
    private static final ChatColor GOLD = ChatColor.GOLD;
    private static final ChatColor YELLOW = ChatColor.YELLOW;
    private static final ChatColor LIGHT_PURPLE = ChatColor.LIGHT_PURPLE;
    private static final ChatColor RED = ChatColor.RED;
    private static final ChatColor GREEN = ChatColor.GREEN;
    private static final ChatColor DARK_GREEN = ChatColor.DARK_GREEN;
    private static final String HUD_OBJECTIVE = "MAP_HUD_OBJ";
    private static final String TEAM_MAP_PREFIX = "mapTeam";
    private static final String TEAM_TOWN = "townTeam";
    private static final String TEAM_OWNER = "ownerTeam";
    private static final String TEAM_DISTRICT = "districtTeam";
    private static final String TEAM_PLOTNAME = "plotnameTeam";
    private static final int mapLineWidth = 19;
    private static final int mapLineHeight = 10;
    private static final int halfMapLineWidth = 9;
    private static final int halfMapLineHeight = 5;
    private static final int MAX_NON_MAP_LINES = 5;

    public static String mapHudTestKey() {
        return "mapTeam1";
    }

    public static void toggleOn(Player player) {
        Scoreboard board = Bukkit.getScoreboardManager().getNewScoreboard();
        Objective objective = BukkitTools.objective(board, HUD_OBJECTIVE, "maphud");
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        try {
            objective.numberFormat(NumberFormat.blank());
        }
        catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
            // empty catch block
        }
        int nonMapLines = Math.max(4, 5);
        int score = 10 + nonMapLines;
        ChatColor[] colors = ChatColor.values();
        for (int i = 0; i < 10; ++i) {
            board.registerNewTeam(TEAM_MAP_PREFIX + i).addEntry(colors[i].toString());
            objective.getScore(colors[i].toString()).setScore(score);
            --score;
        }
        String townEntry = String.valueOf(DARK_GREEN) + Translatable.of("town_sing").forLocale((CommandSender)player) + ": ";
        String ownerEntry = YELLOW.toString();
        String districtEntry = LIGHT_PURPLE.toString();
        String plotnameEntry = RED.toString();
        score = nonMapLines;
        board.registerNewTeam(TEAM_TOWN).addEntry(townEntry);
        objective.getScore(townEntry).setScore(score--);
        board.registerNewTeam(TEAM_OWNER).addEntry(ownerEntry);
        objective.getScore(ownerEntry).setScore(score--);
        board.registerNewTeam(TEAM_DISTRICT).addEntry(districtEntry);
        objective.getScore(districtEntry).setScore(score--);
        board.registerNewTeam(TEAM_PLOTNAME).addEntry(plotnameEntry);
        objective.getScore(plotnameEntry).setScore(score--);
        player.setScoreboard(board);
        MapHUD.updateMap(player);
    }

    public static void updateMap(Player player) {
        MapHUD.updateMap(player, WorldCoord.parseWorldCoord((Entity)player));
    }

    public static void updateMap(Player player, WorldCoord wc) {
        Scoreboard board = player.getScoreboard();
        if (board == null) {
            MapHUD.toggleOn(player);
            return;
        }
        if (board.getObjective(HUD_OBJECTIVE) == null || wc.getTownyWorld() == null || !wc.getTownyWorld().isUsingTowny()) {
            HUDManager.toggleOff(player);
            return;
        }
        int wcX = wc.getX();
        int wcZ = wc.getZ();
        String boardTitle = String.format("%sTowny Map %s(%s, %s)", GOLD, WHITE, wcX, wcZ);
        board.getObjective(HUD_OBJECTIVE).setDisplayName(boardTitle);
        String[][] map = new String[19][10];
        MapHUD.fillMapArray(wcX, wcZ, TownyAPI.getInstance().getResident(player.getName()), player.getWorld(), map);
        MapHUD.writeMapToBoard(board, map);
        TownBlock tb = wc.getTownBlockOrNull();
        board.getTeam(TEAM_TOWN).setSuffix(String.valueOf(GREEN) + (tb != null && tb.hasTown() ? tb.getTownOrNull().getName() : Translatable.of("status_no_town").forLocale((CommandSender)player)));
        board.getTeam(TEAM_OWNER).setSuffix(MapHUD.getOwnerName(tb, player));
        board.getTeam(TEAM_DISTRICT).setSuffix(MapHUD.getDistrictName(tb, player));
        board.getTeam(TEAM_PLOTNAME).setSuffix(MapHUD.getPlotName(tb, player));
    }

    private static String getOwnerName(TownBlock tb, Player player) {
        String name = "";
        if (tb == null) {
            return name;
        }
        name = !tb.hasResident() ? "" : tb.getResidentOrNull().getName();
        String prefix = Translatable.of("owner_status").forLocale((CommandSender)player);
        return HUDManager.check(String.valueOf(DARK_GREEN) + prefix + ": " + String.valueOf(GREEN) + name);
    }

    private static String getDistrictName(TownBlock tb, Player player) {
        String name = "";
        if (tb == null) {
            return name;
        }
        name = !tb.hasDistrict() ? "" : tb.getDistrict().getFormattedName();
        String prefix = Translatable.of("msg_map_hud_district").forLocale((CommandSender)player);
        return HUDManager.check(String.valueOf(DARK_GREEN) + prefix + String.valueOf(GREEN) + name);
    }

    private static String getPlotName(TownBlock tb, Player player) {
        String name = "";
        if (tb == null) {
            return name;
        }
        if (tb.hasPlotObjectGroup() && !tb.getPlotObjectGroup().getName().isEmpty()) {
            name = tb.getPlotObjectGroup().getFormattedName();
        }
        if (!tb.hasPlotObjectGroup() && !tb.getName().isEmpty()) {
            name = tb.getFormattedName();
        }
        String slug = tb.hasPlotObjectGroup() ? "msg_perm_hud_plotgroup_name" : "msg_perm_hud_plot_name";
        String prefix = Translatable.of(slug).forLocale((CommandSender)player);
        return HUDManager.check(String.valueOf(DARK_GREEN) + prefix + String.valueOf(GREEN) + name);
    }

    private static void fillMapArray(int wcX, int wcZ, Resident resident, World bukkitWorld, String[][] map) {
        int y = 0;
        for (int tby = wcX + 9; tby >= wcX - 9; --tby) {
            int x = 0;
            for (int tbx = wcZ - 5; tbx <= wcZ + 4; ++tbx) {
                WorldCoord worldCoord = new WorldCoord(bukkitWorld, tby, tbx);
                if (worldCoord.hasTownBlock()) {
                    MapHUD.mapTownBlock(resident, map, x, y, worldCoord.getTownBlockOrNull());
                } else {
                    MapHUD.mapWilderness(map, x, y, worldCoord);
                }
                ++x;
            }
            ++y;
        }
    }

    private static void mapTownBlock(Resident resident, String[][] map, int x, int y, TownBlock townBlock) {
        map[y][x] = MapHUD.getTownBlockColour(resident, x, y, townBlock);
        if (MapHUD.isForSale(townBlock)) {
            String[] stringArray = map[y];
            int n = x;
            stringArray[n] = stringArray[n] + TownyAsciiMap.forSaleSymbol;
        } else if (townBlock.isHomeBlock()) {
            String[] stringArray = map[y];
            int n = x;
            stringArray[n] = stringArray[n] + TownyAsciiMap.homeSymbol;
        } else if (townBlock.isOutpost()) {
            String[] stringArray = map[y];
            int n = x;
            stringArray[n] = stringArray[n] + TownyAsciiMap.outpostSymbol;
        } else {
            String[] stringArray = map[y];
            int n = x;
            stringArray[n] = stringArray[n] + townBlock.getType().getAsciiMapKey();
        }
    }

    private static String getTownBlockColour(Resident resident, int x, int y, TownBlock townBlock) {
        if (MapHUD.playerLocatedAtThisCoord(x, y)) {
            return "\u00a76";
        }
        if (townBlock.hasResident(resident)) {
            return "\u00a7e";
        }
        if (townBlock.getData().hasColour()) {
            return Colors.getLegacyFromNamedTextColor(townBlock.getData().getColour());
        }
        if (resident.hasTown()) {
            return MapHUD.getTownBlockColour(resident, townBlock.getTownOrNull());
        }
        return "\u00a7f";
    }

    private static String getTownBlockColour(Resident resident, Town townAtTownBlock) {
        if (townAtTownBlock.hasResident(resident)) {
            return "\u00a7a";
        }
        if (!resident.hasNation()) {
            return "\u00a7f";
        }
        Nation resNation = resident.getNationOrNull();
        if (resNation.hasTown(townAtTownBlock)) {
            return "\u00a72";
        }
        if (!townAtTownBlock.hasNation()) {
            return "\u00a7f";
        }
        Nation townBlockNation = townAtTownBlock.getNationOrNull();
        if (resNation.hasAlly(townBlockNation)) {
            return "\u00a72";
        }
        if (resNation.hasEnemy(townBlockNation)) {
            return "\u00a74";
        }
        return "\u00a7f";
    }

    private static boolean playerLocatedAtThisCoord(int x, int y) {
        return x == 5 && y == 9;
    }

    private static boolean isForSale(TownBlock townBlock) {
        return townBlock.getPlotPrice() != -1.0 || townBlock.hasPlotObjectGroup() && townBlock.getPlotObjectGroup().getPrice() != -1.0;
    }

    private static void mapWilderness(String[][] map, int x, int y, WorldCoord worldCoord) {
        String symbol;
        map[y][x] = MapHUD.playerLocatedAtThisCoord(x, y) ? "\u00a76" : "\u00a78";
        TownyMapData data = MapHUD.getWildernessMapDataMap().get(worldCoord);
        if (data != null && !data.isOld()) {
            TownyMapData mapData = MapHUD.getWildernessMapDataMap().get(worldCoord);
            symbol = mapData.getSymbol();
        } else {
            WildernessMapEvent wildMapEvent = new WildernessMapEvent(worldCoord);
            BukkitTools.fireEvent(wildMapEvent);
            symbol = wildMapEvent.getMapSymbol();
            MapHUD.getWildernessMapDataMap().put(worldCoord, new TownyMapData(worldCoord, symbol, wildMapEvent.getHoverText(), wildMapEvent.getClickCommand()));
            Towny.getPlugin().getScheduler().runAsyncLater(() -> MapHUD.getWildernessMapDataMap().computeIfPresent(worldCoord, (key, cachedData) -> cachedData.isOld() ? null : cachedData), 700L);
        }
        String[] stringArray = map[y];
        int n = x;
        stringArray[n] = stringArray[n] + symbol;
    }

    private static Map<WorldCoord, TownyMapData> getWildernessMapDataMap() {
        return TownyUniverse.getInstance().getWildernessMapDataMap();
    }

    private static void writeMapToBoard(Scoreboard board, String[][] map) {
        for (int my = 0; my < 10; ++my) {
            Object line = "";
            for (int mx = 18; mx >= 0; --mx) {
                line = (String)line + map[mx][my];
            }
            board.getTeam(TEAM_MAP_PREFIX + my).setSuffix((String)line);
        }
    }
}

