/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.huds;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.huds.HUDManager;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translator;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.util.BukkitTools;
import io.papermc.paper.scoreboard.numbers.NumberFormat;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class PermHUD {
    private static final ChatColor DARK_RED = ChatColor.DARK_RED;
    private static final ChatColor WHITE = ChatColor.WHITE;
    private static final ChatColor GRAY = ChatColor.GRAY;
    private static final ChatColor YELLOW = ChatColor.YELLOW;
    private static final ChatColor DARK_GREEN = ChatColor.DARK_GREEN;
    private static final ChatColor GOLD = ChatColor.GOLD;
    private static final ChatColor BOLD = ChatColor.BOLD;
    private static final ChatColor UNDERLINE = ChatColor.UNDERLINE;
    private static final String HUD_OBJECTIVE = "PERM_HUD_OBJ";
    private static final String TEAM_PERMS_TITLE = "permsTitle";
    private static final String TEAM_PLOT_COST = "plot_cost";
    private static final String TEAM_BUILD = "build";
    private static final String TEAM_DESTROY = "destroy";
    private static final String TEAM_SWITCH = "switching";
    private static final String TEAM_ITEMUSE = "item";
    private static final String TEAM_PLOT_TYPE = "plotType";
    private static final String TEAM_PVP = "pvp";
    private static final String TEAM_EXPLOSIONS = "explosions";
    private static final String TEAM_FIRESPREAD = "firespread";
    private static final String TEAM_MOBSPAWNING = "mobspawn";
    private static final String TEAM_TITLE = "keyTitle";
    private static final String TEAM_RESIDENT = "keyResident";
    private static final String TEAM_FRIEND = "keyFriend";
    private static final String TEAM_ALLY = "keyAlly";

    public static void updatePerms(Player p) {
        PermHUD.updatePerms(p, WorldCoord.parseWorldCoord((Entity)p));
    }

    public static String permHudTestKey() {
        return TEAM_BUILD;
    }

    public static void updatePerms(Player p, WorldCoord worldCoord) {
        Translator translator = Translator.locale((CommandSender)p);
        Scoreboard board = p.getScoreboard();
        if (board == null) {
            PermHUD.toggleOn(p);
            return;
        }
        if (board.getObjective(HUD_OBJECTIVE) == null) {
            HUDManager.toggleOff(p);
            return;
        }
        if (worldCoord.isWilderness()) {
            PermHUD.clearPerms(p);
            return;
        }
        TownBlock townBlock = worldCoord.getTownBlockOrNull();
        TownBlockOwner owner = townBlock.getTownBlockOwner();
        boolean plotGroup = townBlock.hasPlotObjectGroup();
        TextComponent title = Component.text((String)(owner.getName() + (String)(townBlock.hasResident() ? " (" + townBlock.getTownOrNull().getName() + ")" : "")), (TextColor)NamedTextColor.GOLD);
        String type = townBlock.getType().equals(TownBlockType.RESIDENTIAL) ? " " : townBlock.getType().getName();
        String forSale = PermHUD.getPlotPrice(translator, townBlock, plotGroup);
        TownyPermission tp = townBlock.getPermissions();
        boolean residentOwned = owner instanceof Resident;
        String build = PermHUD.getPermLine(tp, TownyPermission.ActionType.BUILD, residentOwned);
        String destroy = PermHUD.getPermLine(tp, TownyPermission.ActionType.DESTROY, residentOwned);
        String switching = PermHUD.getPermLine(tp, TownyPermission.ActionType.SWITCH, residentOwned);
        String item = PermHUD.getPermLine(tp, TownyPermission.ActionType.ITEM_USE, residentOwned);
        TownyWorld world = townBlock.getWorld();
        String pvp = PermHUD.getTranslatedOnOrOff(!CombatUtil.preventPvP(world, townBlock), translator);
        String explosions = PermHUD.getTranslatedOnOrOff(world.isForceExpl() || tp.explosion, translator);
        String firespread = PermHUD.getTranslatedOnOrOff(world.isForceFire() || tp.fire, translator);
        String mobspawn = PermHUD.getTranslatedOnOrOff(world.isForceTownMobs() || tp.mobs || townBlock.getTownOrNull().isAdminEnabledMobs(), translator);
        board.getObjective(HUD_OBJECTIVE).displayName((Component)title);
        board.getTeam(TEAM_PLOT_TYPE).setSuffix(type);
        board.getTeam(TEAM_PLOT_COST).setSuffix(forSale);
        board.getTeam(TEAM_BUILD).setSuffix(build);
        board.getTeam(TEAM_DESTROY).setSuffix(destroy);
        board.getTeam(TEAM_SWITCH).setSuffix(switching);
        board.getTeam(TEAM_ITEMUSE).setSuffix(item);
        board.getTeam(TEAM_PVP).setSuffix(pvp);
        board.getTeam(TEAM_EXPLOSIONS).setSuffix(explosions);
        board.getTeam(TEAM_FIRESPREAD).setSuffix(firespread);
        board.getTeam(TEAM_MOBSPAWNING).setSuffix(mobspawn);
    }

    private static String getPlotPrice(Translator translator, TownBlock townBlock, boolean plotGroup) {
        String forSale = translator.of("msg_perm_hud_no");
        forSale = TownyEconomyHandler.isActive() ? (plotGroup && townBlock.getPlotObjectGroup().getPrice() > -1.0 ? PermHUD.prettyMoney(townBlock.getPlotObjectGroup().getPrice()) : (townBlock.isForSale() ? PermHUD.prettyMoney(townBlock.getPlotPrice()) : forSale)) : (plotGroup && townBlock.getPlotObjectGroup().getPrice() > -1.0 || !plotGroup && townBlock.isForSale() ? translator.of("msg_perm_hud_yes") : forSale);
        return forSale;
    }

    private static String getPermLine(TownyPermission tp, TownyPermission.ActionType actionType, boolean residentOwned) {
        String v = residentOwned ? "f" : "r";
        String u = residentOwned ? "t" : "n";
        return (tp.getResidentPerm(actionType) ? v : "-") + (tp.getNationPerm(actionType) ? u : "-") + (tp.getAllyPerm(actionType) ? "a" : "-") + (tp.getOutsiderPerm(actionType) ? "o" : "-");
    }

    private static String getTranslatedOnOrOff(boolean test, Translator translator) {
        return test ? translator.of("status_on") : translator.of("status_off");
    }

    private static void clearPerms(Player p) {
        Scoreboard board = p.getScoreboard();
        try {
            board.getObjective(HUD_OBJECTIVE).setDisplayName(HUDManager.check(PermHUD.getFormattedWildernessName(p.getWorld())));
            board.getTeam(TEAM_PLOT_TYPE).setSuffix(" ");
            board.getTeam(TEAM_PLOT_COST).setSuffix(" ");
            board.getTeam(TEAM_BUILD).setSuffix(" ");
            board.getTeam(TEAM_DESTROY).setSuffix(" ");
            board.getTeam(TEAM_SWITCH).setSuffix(" ");
            board.getTeam(TEAM_ITEMUSE).setSuffix(" ");
            board.getTeam(TEAM_PVP).setSuffix(" ");
            board.getTeam(TEAM_EXPLOSIONS).setSuffix(" ");
            board.getTeam(TEAM_FIRESPREAD).setSuffix(" ");
            board.getTeam(TEAM_MOBSPAWNING).setSuffix(" ");
        }
        catch (NullPointerException e) {
            PermHUD.toggleOn(p);
        }
    }

    private static String getFormattedWildernessName(World w) {
        StringBuilder wildernessName = new StringBuilder().append(DARK_RED).append(BOLD);
        if (TownyAPI.getInstance().isTownyWorld(w)) {
            wildernessName.append(TownyAPI.getInstance().getTownyWorld(w).getFormattedUnclaimedZoneName());
        } else {
            wildernessName.append("Unknown");
        }
        return wildernessName.toString();
    }

    public static void toggleOn(Player p) {
        Scoreboard board = Bukkit.getScoreboardManager().getNewScoreboard();
        PermHUD.initializeScoreboard(Translator.locale((CommandSender)p), board);
        p.setScoreboard(board);
        PermHUD.updatePerms(p);
    }

    private static void initializeScoreboard(Translator translator, Scoreboard board) {
        String keyPlotType_entry = String.valueOf(DARK_GREEN) + translator.of("msg_perm_hud_plot_type");
        String forSale_entry = String.valueOf(DARK_GREEN) + translator.of("msg_perm_hud_plot_for_sale") + String.valueOf(GRAY);
        String permsTitle_entry = String.valueOf(YELLOW) + String.valueOf(UNDERLINE) + translator.of("msg_perm_hud_title");
        String build_entry = String.valueOf(DARK_GREEN) + translator.of("msg_perm_hud_build") + String.valueOf(GRAY);
        String destroy_entry = String.valueOf(DARK_GREEN) + translator.of("msg_perm_hud_destroy") + String.valueOf(GRAY);
        String switching_entry = String.valueOf(DARK_GREEN) + translator.of("msg_perm_hud_switch") + String.valueOf(GRAY);
        String item_entry = String.valueOf(DARK_GREEN) + translator.of("msg_perm_hud_item_use") + String.valueOf(GRAY);
        String pvp_entry = String.valueOf(DARK_GREEN) + translator.of("msg_perm_hud_pvp") + " ";
        String explosions_entry = String.valueOf(DARK_GREEN) + translator.of("msg_perm_hud_explosions") + " ";
        String firespread_entry = String.valueOf(DARK_GREEN) + translator.of("msg_perm_hud_firespread") + " ";
        String mobspawn_entry = String.valueOf(DARK_GREEN) + translator.of("msg_perm_hud_mobspawns") + " ";
        String keyTitle_entry = String.valueOf(YELLOW) + String.valueOf(UNDERLINE) + translator.of("msg_perm_hud_key");
        String keyResident_entry = String.valueOf(DARK_GREEN) + String.valueOf(BOLD) + "f" + String.valueOf(WHITE) + " - " + String.valueOf(GRAY) + translator.of("msg_perm_hud_friend") + String.valueOf(DARK_GREEN) + " " + String.valueOf(BOLD) + "r" + String.valueOf(WHITE) + " - " + String.valueOf(GRAY) + translator.of("msg_perm_hud_resident");
        String keyNation_entry = String.valueOf(DARK_GREEN) + String.valueOf(BOLD) + "t" + String.valueOf(WHITE) + " - " + String.valueOf(GRAY) + translator.of("msg_perm_hud_town") + String.valueOf(DARK_GREEN) + " " + String.valueOf(BOLD) + "n" + String.valueOf(WHITE) + " - " + String.valueOf(GRAY) + translator.of("msg_perm_hud_nation");
        String keyAlly_entry = String.valueOf(DARK_GREEN) + String.valueOf(BOLD) + "a" + String.valueOf(WHITE) + " - " + String.valueOf(GRAY) + translator.of("msg_perm_hud_ally") + String.valueOf(DARK_GREEN) + " " + String.valueOf(BOLD) + "o" + String.valueOf(WHITE) + " - " + String.valueOf(GRAY) + translator.of("msg_perm_hud_outsider");
        Objective obj = BukkitTools.objective(board, HUD_OBJECTIVE, "");
        obj.setDisplaySlot(DisplaySlot.SIDEBAR);
        try {
            obj.numberFormat(NumberFormat.blank());
        }
        catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
            // empty catch block
        }
        Team keyPlotType = board.registerNewTeam(TEAM_PLOT_TYPE);
        Team forSaleTitle = board.registerNewTeam(TEAM_PLOT_COST);
        Team permsTitle = board.registerNewTeam(TEAM_PERMS_TITLE);
        Team build = board.registerNewTeam(TEAM_BUILD);
        Team destroy = board.registerNewTeam(TEAM_DESTROY);
        Team switching = board.registerNewTeam(TEAM_SWITCH);
        Team item = board.registerNewTeam(TEAM_ITEMUSE);
        Team pvp = board.registerNewTeam(TEAM_PVP);
        Team explosions = board.registerNewTeam(TEAM_EXPLOSIONS);
        Team firespread = board.registerNewTeam(TEAM_FIRESPREAD);
        Team mobspawn = board.registerNewTeam(TEAM_MOBSPAWNING);
        Team keyTitle = board.registerNewTeam(TEAM_TITLE);
        Team keyResident = board.registerNewTeam(TEAM_RESIDENT);
        Team keyFriend = board.registerNewTeam(TEAM_FRIEND);
        Team keyAlly = board.registerNewTeam(TEAM_ALLY);
        keyPlotType.addEntry(keyPlotType_entry);
        forSaleTitle.addEntry(forSale_entry);
        permsTitle.addEntry(permsTitle_entry);
        build.addEntry(build_entry);
        destroy.addEntry(destroy_entry);
        switching.addEntry(switching_entry);
        item.addEntry(item_entry);
        pvp.addEntry(pvp_entry);
        explosions.addEntry(explosions_entry);
        firespread.addEntry(firespread_entry);
        mobspawn.addEntry(mobspawn_entry);
        keyTitle.addEntry(keyTitle_entry);
        keyResident.addEntry(keyResident_entry);
        keyFriend.addEntry(keyNation_entry);
        keyAlly.addEntry(keyAlly_entry);
        int score = 15;
        obj.getScore(keyPlotType_entry).setScore(score--);
        obj.getScore(forSale_entry).setScore(score--);
        obj.getScore(permsTitle_entry).setScore(score--);
        obj.getScore(build_entry).setScore(score--);
        obj.getScore(destroy_entry).setScore(score--);
        obj.getScore(switching_entry).setScore(score--);
        obj.getScore(item_entry).setScore(score--);
        obj.getScore(pvp_entry).setScore(score--);
        obj.getScore(explosions_entry).setScore(score--);
        obj.getScore(firespread_entry).setScore(score--);
        obj.getScore(mobspawn_entry).setScore(score--);
        obj.getScore(keyTitle_entry).setScore(score--);
        obj.getScore(keyResident_entry).setScore(score--);
        obj.getScore(keyNation_entry).setScore(score--);
        obj.getScore(keyAlly_entry).setScore(score--);
    }

    private static String prettyMoney(double price) {
        return TownyEconomyHandler.getFormattedBalance(price);
    }
}

