/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.invites;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteReceiver;
import com.palmergames.bukkit.towny.invites.InviteSender;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class InviteHandler {
    private static Towny plugin;
    private static final Map<Invite, Long> ACTIVE_INVITES;

    public static void initialize(Towny plugin) {
        InviteHandler.plugin = plugin;
    }

    public static void acceptInvite(Invite invite) throws InvalidObjectException, TownyException {
        Optional<Invite> matchingInvite = ACTIVE_INVITES.keySet().stream().filter(inv -> inv.equals(invite)).findFirst();
        if (!matchingInvite.isPresent()) {
            throw new InvalidObjectException("Invite not valid!");
        }
        invite.accept();
        InviteHandler.removeInvite(matchingInvite.get());
    }

    public static void declineInvite(Invite invite, boolean fromSender) throws InvalidObjectException {
        Optional<Invite> matchingInvite = ACTIVE_INVITES.keySet().stream().filter(inv -> inv.equals(invite)).findFirst();
        if (!matchingInvite.isPresent()) {
            throw new InvalidObjectException("Invite not valid!");
        }
        invite.decline(fromSender);
        InviteHandler.removeInvite(matchingInvite.get());
    }

    public static void addInvite(Invite invite) {
        ACTIVE_INVITES.put(invite, System.currentTimeMillis());
    }

    public static void removeInvite(Invite invite) {
        ACTIVE_INVITES.remove(invite);
    }

    private static long getInviteTime(Invite invite) {
        return ACTIVE_INVITES.getOrDefault(invite, 0L);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void searchForExpiredInvites() {
        time = TownySettings.getInviteExpirationTime() * 1000L;
        for (Invite activeInvite : new ArrayList<Invite>(InviteHandler.getActiveInvites())) {
            if (InviteHandler.getInviteTime(activeInvite) + time >= System.currentTimeMillis()) continue;
            var6_5 /* !! */  = activeInvite.getReceiver();
            if (!(var6_5 /* !! */  instanceof Nation)) ** GOTO lbl-1000
            receiver = (Nation)var6_5 /* !! */ ;
            var6_5 /* !! */  = activeInvite.getSender();
            if (var6_5 /* !! */  instanceof Nation) {
                sender = (Nation)var6_5 /* !! */ ;
                receiver.deleteReceivedInvite(activeInvite);
                sender.deleteSentAllyInvite(activeInvite);
            } else lbl-1000:
            // 2 sources

            {
                activeInvite.getReceiver().deleteReceivedInvite(activeInvite);
                activeInvite.getSender().deleteSentInvite(activeInvite);
            }
            InviteHandler.removeInvite(activeInvite);
        }
    }

    public static Collection<Invite> getActiveInvites() {
        return Collections.unmodifiableSet(ACTIVE_INVITES.keySet());
    }

    public static boolean inviteIsActive(Invite invite) {
        for (Invite activeInvite : ACTIVE_INVITES.keySet()) {
            if (!activeInvite.getReceiver().equals(invite.getReceiver()) || !activeInvite.getSender().equals(invite.getSender())) continue;
            return true;
        }
        return false;
    }

    public static boolean inviteIsActive(InviteSender sender, InviteReceiver receiver) {
        for (Invite activeInvite : ACTIVE_INVITES.keySet()) {
            if (!activeInvite.getReceiver().equals(receiver) || !activeInvite.getSender().equals(sender)) continue;
            return true;
        }
        return false;
    }

    public static List<Invite> getActiveInvitesFor(InviteSender sender, InviteReceiver receiver) {
        return ACTIVE_INVITES.keySet().stream().filter(activeInvite -> activeInvite.getReceiver().equals(receiver) && activeInvite.getSender().equals(sender)).collect(Collectors.toList());
    }

    public static int getSentAllyRequestsMaxAmount(Nation sender) {
        int amount = 0;
        if (sender != null) {
            amount = TownySettings.getMaximumRequestsSentNation() == 0 ? 100 : TownySettings.getMaximumRequestsSentNation();
        }
        return amount;
    }

    public static int getReceivedInvitesMaxAmount(InviteReceiver receiver) {
        int amount = 0;
        if (receiver instanceof Resident) {
            amount = TownySettings.getMaximumInvitesReceivedResident() == 0 ? 100 : TownySettings.getMaximumInvitesReceivedResident();
        }
        if (receiver instanceof Town) {
            amount = TownySettings.getMaximumInvitesReceivedTown() == 0 ? 100 : TownySettings.getMaximumInvitesReceivedTown();
        }
        if (receiver instanceof Nation) {
            amount = TownySettings.getMaximumRequestsReceivedNation() == 0 ? 100 : TownySettings.getMaximumRequestsReceivedNation();
        }
        return amount;
    }

    public static int getSentInvitesMaxAmount(InviteSender sender) {
        int amount = 0;
        if (sender instanceof Town) {
            amount = TownySettings.getMaximumInvitesSentTown() == 0 ? 100 : TownySettings.getMaximumInvitesSentTown();
        }
        if (sender instanceof Nation) {
            amount = TownySettings.getMaximumInvitesSentNation() == 0 ? 100 : TownySettings.getMaximumInvitesSentNation();
        }
        return amount;
    }

    static {
        ACTIVE_INVITES = new ConcurrentHashMap<Invite, Long>();
    }
}

