/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.libs.pixelwidth;

import com.palmergames.bukkit.towny.libs.pixelwidth.ContextualPixelWidthSource;
import com.palmergames.bukkit.towny.libs.pixelwidth.DefaultCharacterWidthFunction;
import com.palmergames.bukkit.towny.libs.pixelwidth.PixelWidthSource;
import com.palmergames.bukkit.towny.libs.pixelwidth.function.CharacterWidthFunction;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.flattener.FlattenerListener;
import net.kyori.adventure.text.format.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PixelWidthSourceImpl<CX>
implements ContextualPixelWidthSource<CX> {
    static final PixelWidthSource INSTANCE = new PixelWidthSourceImpl<Object>(ComponentFlattener.basic(), cx -> DefaultCharacterWidthFunction.INSTANCE);
    private final ComponentFlattener flattener;
    private final Function<CX, CharacterWidthFunction> characterWidthFunction;

    PixelWidthSourceImpl(@NotNull ComponentFlattener flattener, @NotNull Function<@Nullable CX, CharacterWidthFunction> characterWidthFunction) {
        this.flattener = flattener;
        this.characterWidthFunction = characterWidthFunction;
    }

    @Override
    public float width(@NotNull Component component, final @Nullable CX context) {
        final float[] length = new float[]{0.0f};
        this.flattener.flatten(component, new FlattenerListener(){
            final List<Style> styles = new LinkedList<Style>();
            Style currentStyle = Style.empty();

            public void pushStyle(@NotNull Style style) {
                this.styles.add(style);
                this.calculateStyle();
            }

            public void component(@NotNull String text) {
                length[0] = length[0] + PixelWidthSourceImpl.this.width(text, this.currentStyle, context);
            }

            public void popStyle(@NotNull Style style) {
                this.styles.remove(this.styles.size() - 1);
                this.calculateStyle();
            }

            private void calculateStyle() {
                Style.Builder newStyle = Style.style();
                for (Style style : this.styles) {
                    newStyle.merge(style);
                }
                this.currentStyle = newStyle.build();
            }
        });
        return length[0];
    }

    @Override
    public float width(@NotNull String string, @NotNull Style style, @Nullable CX context) {
        return (float)string.codePoints().mapToDouble(codepoint -> this.characterWidthFunction.apply(context).widthOf(codepoint, style)).sum();
    }

    @Override
    public float width(char c, @NotNull Style style, @Nullable CX context) {
        return this.characterWidthFunction.apply(context).widthOf(c, style);
    }

    @Override
    public float width(int codepoint, @NotNull Style style, @Nullable CX context) {
        return this.characterWidthFunction.apply(context).widthOf(codepoint, style);
    }
}

