/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.command.TownyCommand;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.event.BedExplodeEvent;
import com.palmergames.bukkit.towny.event.ChunkNotificationEvent;
import com.palmergames.bukkit.towny.event.NationAddEnemyEvent;
import com.palmergames.bukkit.towny.event.NewTownEvent;
import com.palmergames.bukkit.towny.event.PlayerChangePlotEvent;
import com.palmergames.bukkit.towny.event.SpawnEvent;
import com.palmergames.bukkit.towny.event.TownAddResidentEvent;
import com.palmergames.bukkit.towny.event.TownBlockPermissionChangeEvent;
import com.palmergames.bukkit.towny.event.TownClaimEvent;
import com.palmergames.bukkit.towny.event.TownPreAddResidentEvent;
import com.palmergames.bukkit.towny.event.TownRemoveResidentEvent;
import com.palmergames.bukkit.towny.event.damage.TownyPlayerDamagePlayerEvent;
import com.palmergames.bukkit.towny.event.nation.NationLevelDecreaseEvent;
import com.palmergames.bukkit.towny.event.nation.NationLevelIncreaseEvent;
import com.palmergames.bukkit.towny.event.nation.NationPreTownLeaveEvent;
import com.palmergames.bukkit.towny.event.town.TownLevelDecreaseEvent;
import com.palmergames.bukkit.towny.event.town.TownLevelIncreaseEvent;
import com.palmergames.bukkit.towny.event.town.TownOutlawAddEvent;
import com.palmergames.bukkit.towny.event.town.TownPreUnclaimCmdEvent;
import com.palmergames.bukkit.towny.event.town.TownPreUnclaimEvent;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.CellSurface;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnType;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.utils.BorderUtil;
import com.palmergames.bukkit.towny.utils.ChunkNotificationUtil;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.palmergames.bukkit.towny.utils.ProximityUtil;
import com.palmergames.bukkit.towny.utils.SpawnUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.DrawSmokeTaskFactory;
import com.palmergames.util.TimeMgmt;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permissible;

public class TownyCustomListener
implements Listener {
    private final Towny plugin;

    public TownyCustomListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerChangePlotEvent(PlayerChangePlotEvent event) {
        Player player = event.getPlayer();
        WorldCoord from = event.getFrom();
        WorldCoord to = event.getTo();
        if (!TownyAPI.getInstance().isTownyWorld(to.getBukkitWorld())) {
            return;
        }
        Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (resident == null) {
            return;
        }
        this.plugin.getScheduler().runLater((Entity)player, () -> {
            try {
                if (resident.hasMode("townclaim")) {
                    TownCommand.parseTownClaimCommand(player, new String[0]);
                }
                if (resident.hasMode("townunclaim")) {
                    TownCommand.parseTownUnclaimCommand(player, new String[0]);
                }
                if (resident.hasMode("plotgroup") && resident.hasPlotGroupName()) {
                    Towny.getPlugin().getScheduler().runLater((Entity)player, () -> Bukkit.dispatchCommand((CommandSender)player, (String)("plot group add " + resident.getPlotGroupName())), 1L);
                }
                if (resident.hasMode("district") && resident.hasDistrictName()) {
                    Towny.getPlugin().getScheduler().runLater((Entity)player, () -> Bukkit.dispatchCommand((CommandSender)player, (String)("plot district add " + resident.getDistrictName())), 1L);
                }
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
            }
            if (resident.hasMode("map")) {
                TownyCommand.showMap(player);
            }
            if (resident.hasMode("plotborder") || resident.hasMode("constantplotborder")) {
                BorderUtil.getPlotBorder(to).runBorderedOnSurface(1, 2, DrawSmokeTaskFactory.showToPlayer(player, to));
            }
        }, 1L);
        if (event.isShowingPlotNotifications()) {
            this.plugin.getScheduler().runLater(() -> ChunkNotificationUtil.showChunkNotification(player, resident, to, from), 2L);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerCreateTown(NewTownEvent event) {
        Town town = event.getTown();
        Resident mayor = town.getMayor();
        if (mayor.isOnline() && town.hasHomeBlock() && TownySettings.isShowingClaimParticleEffect()) {
            this.plugin.getScheduler().runAsync(() -> CellSurface.getCellSurface(town.getHomeBlockOrNull().getWorldCoord()).runClaimingParticleOverSurfaceAtPlayer(mayor.getPlayer()));
        }
        this.plugin.getScheduler().runLater(() -> {
            double upkeep = TownySettings.getTownUpkeepCost(town);
            if (TownyEconomyHandler.isActive() && TownySettings.isTaxingDaily() && upkeep > 0.0) {
                String cost = TownyEconomyHandler.getFormattedBalance(upkeep);
                String time = TimeMgmt.formatCountdownTime(TimeMgmt.townyTime(true));
                TownyMessaging.sendTownMessagePrefixed(town, Translatable.of("msg_new_town_advice", cost, time));
            }
        }, 200L);
        int bonus = TownySettings.getNewTownBonusBlocks();
        if (bonus > 0) {
            town.setBonusBlocks(town.getBonusBlocks() + bonus);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onBedExplodeEvent(BedExplodeEvent event) {
        TownyWorld world = Optional.ofNullable(event.getLocation().getWorld()).map(w -> TownyAPI.getInstance().getTownyWorld((World)w)).orElse(null);
        if (world == null) {
            return;
        }
        world.addBedExplosionAtBlock(event.getLocation(), event.getMaterial());
        if (event.getLocation2() != null) {
            world.addBedExplosionAtBlock(event.getLocation2(), event.getMaterial());
        }
        this.plugin.getScheduler().runLater(event.getLocation(), () -> {
            world.removeBedExplosionAtBlock(event.getLocation());
            world.removeBedExplosionAtBlock(event.getLocation2());
        }, 20L);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onTownLeaveNation(NationPreTownLeaveEvent event) {
        if (event.getTown().isConquered()) {
            event.setCancelMessage(Translation.of("msg_err_your_conquered_town_cannot_leave_the_nation_yet"));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerDamagePlayerEvent(TownyPlayerDamagePlayerEvent event) {
        Resident victim = event.getVictimResident();
        Resident attacker = event.getAttackingResident();
        if (victim != null && victim.hasRespawnProtection()) {
            event.setCancelled(true);
            event.setMessage(Translatable.of("msg_err_player_cannot_be_harmed", victim.getName()).forLocale(attacker));
        }
        if (attacker != null && attacker.hasRespawnProtection()) {
            event.setCancelled(true);
            attacker.removeRespawnProtection();
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerSpawnsWithTown(SpawnEvent event) {
        if (TownyUniverse.getInstance().getPermissionSource().isTownyAdmin((Permissible)event.getPlayer())) {
            return;
        }
        Town town = TownyAPI.getInstance().getTown(event.getTo());
        if (town == null || !town.hasOutlaw(event.getPlayer().getName())) {
            return;
        }
        event.setCancelled(true);
        event.setCancelMessage(Translatable.of("msg_error_cannot_town_spawn_youre_an_outlaw_in_town", town.getName()).forLocale((CommandSender)event.getPlayer()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onTownUnclaim(TownPreUnclaimCmdEvent event) {
        Player player = event.getResident().getPlayer();
        if (!TownySettings.getOutsidersUnclaimingTownBlocks() || player == null) {
            return;
        }
        List<WorldCoord> unclaimSelection = event.getUnclaimSelection();
        Town town = event.getTown();
        for (Player target : Bukkit.getOnlinePlayers()) {
            if (town.hasResident(target) || TownyAPI.getInstance().isWilderness(target.getLocation()) || !unclaimSelection.contains(WorldCoord.parseWorldCoord((Entity)target))) continue;
            event.setCancelled(true);
            event.setCancelMessage(Translatable.of("msg_cant_unclaim_outsider_in_town").forLocale(event.getResident()));
            break;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onTownUnclaimDistrict(TownPreUnclaimEvent event) {
        TownBlock townBlock = event.getTownBlock();
        if (!townBlock.hasDistrict()) {
            return;
        }
        try {
            ProximityUtil.testAdjacentRemoveDistrictRulesOrThrow(townBlock.getWorldCoord(), event.getTown(), townBlock.getDistrict(), 1);
        }
        catch (TownyException e) {
            event.setCancelled(true);
            event.setCancelMessage(e.getMessage());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTownClaim(TownClaimEvent event) {
        if (TownySettings.isShowingClaimParticleEffect() && event.getTownBlock().getWorldCoord().isFullyLoaded()) {
            Towny.getPlugin().getScheduler().runAsync(() -> CellSurface.getCellSurface(event.getTownBlock().getWorldCoord()).runClaimingParticleOverSurfaceAtPlayer(event.getResident().getPlayer()));
        }
        if (!TownySettings.isOverClaimingAllowingStolenLand()) {
            return;
        }
        if (event.getTown().availableTownBlocks() <= TownySettings.getTownBlockRatio()) {
            TownyMessaging.sendMsg(event.getResident(), Translatable.literal("\u00a74").append(Translatable.of("msg_warning_you_are_almost_out_of_townblocks")));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTownLosesResident(TownRemoveResidentEvent event) {
        Nation nation;
        Town town = event.getTown();
        if (town.getLevelNumber() < TownySettings.getTownLevelFromGivenInt(town.getNumResidents() + 1, town)) {
            BukkitTools.fireEvent(new TownLevelDecreaseEvent(town));
        }
        if (town.hasNation() && (nation = town.getNationOrNull()).getLevelNumber() < TownySettings.getNationLevelFromGivenInt(nation.getNumResidents() + 1)) {
            BukkitTools.fireEvent(new NationLevelDecreaseEvent(nation));
        }
        if (!TownySettings.isOverClaimingAllowingStolenLand()) {
            return;
        }
        if (town.isOverClaimed()) {
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.literal("\u00a74").append(Translatable.of("msg_warning_your_town_is_overclaimed")));
        }
    }

    @EventHandler
    public void onChunkNotification(ChunkNotificationEvent event) {
        if (!TownySettings.isOverClaimingAllowingStolenLand() || event.getToCoord().isWilderness() || event.getFromCoord().isWilderness()) {
            return;
        }
        Town town = TownyAPI.getInstance().getTown(event.getPlayer());
        if (town == null) {
            return;
        }
        if (town.availableTownBlocks() < 1 || !town.equals(event.getFromCoord().getTownOrNull())) {
            return;
        }
        if (!event.getToCoord().canBeStolen()) {
            return;
        }
        String message = event.getMessage() + Translatable.of("chunk_notification_takeover_available").forLocale((CommandSender)event.getPlayer());
        event.setMessage(message);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onResidentPreJoinTown(TownPreAddResidentEvent event) {
        Resident resident = event.getResident();
        long minTime = TownySettings.getResidentMinTimeToJoinTown();
        if (minTime <= 0L) {
            return;
        }
        long timePlayed = System.currentTimeMillis() - resident.getRegistered();
        if (timePlayed >= minTime) {
            return;
        }
        String timeRemaining = TimeMgmt.getFormattedTimeValue(minTime - timePlayed);
        event.setCancelled(true);
        event.setCancelMessage(Translatable.of("msg_err_you_cannot_join_town_you_have_not_played_long_enough", timeRemaining).forLocale(resident));
    }

    @EventHandler(ignoreCancelled=true)
    public void onResidentJoinTown(TownAddResidentEvent event) {
        Nation nation;
        Town town = event.getTown();
        if (town.getLevelNumber() > TownySettings.getTownLevelFromGivenInt(town.getNumResidents() - 1, town)) {
            BukkitTools.fireEvent(new TownLevelIncreaseEvent(town));
        }
        if (town.hasNation() && (nation = town.getNationOrNull()).getLevelNumber() > TownySettings.getNationLevelFromGivenInt(nation.getNumResidents() - 1)) {
            BukkitTools.fireEvent(new NationLevelIncreaseEvent(nation));
        }
        if (!TownySettings.isPromptingNewResidentsToTownSpawn() || !TownySettings.isConfigAllowingTownSpawn()) {
            return;
        }
        Player player = event.getResident().getPlayer();
        Town playerLocationTown = Optional.ofNullable(player).map(p -> TownyAPI.getInstance().getTown(p.getLocation())).orElse(null);
        if (player == null || playerLocationTown != null && playerLocationTown.equals(town)) {
            return;
        }
        String notAffordMsg = Translatable.of("msg_err_cant_afford_tp").forLocale((CommandSender)player);
        double cost = town.getSpawnCost();
        if (cost > 0.0) {
            try {
                SpawnUtil.sendToTownySpawn(player, new String[0], town, notAffordMsg, false, false, SpawnType.TOWN);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
            }
        } else {
            Confirmation.runOnAccept(() -> {
                try {
                    SpawnUtil.sendToTownySpawn(player, new String[0], town, notAffordMsg, false, false, SpawnType.TOWN);
                }
                catch (TownyException e) {
                    TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
                }
            }).setTitle(Translatable.of("msg_new_resident_spawn_to_town_prompt")).sendTo((CommandSender)player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTownBlockPermissionChange(TownBlockPermissionChangeEvent event) {
        WorldCoord wc = event.getTownBlock().getWorldCoord();
        for (Player player : Bukkit.getOnlinePlayers()) {
            Towny.getPlugin().getScheduler().runAsync(() -> this.attemptPlayerCacheReset(player, wc));
        }
    }

    private void attemptPlayerCacheReset(Player player, WorldCoord worldCoord) {
        if (!worldCoord.getWorldName().equalsIgnoreCase(player.getWorld().getName())) {
            return;
        }
        PlayerCache cache = Towny.getPlugin().getCache(player);
        if (cache == null || !cache.getLastTownBlock().equals(worldCoord) || PlayerCacheUtil.isOwnerCache(cache)) {
            return;
        }
        Towny.getPlugin().resetCache(player);
    }

    @EventHandler
    public void onTownLevelIncrease(TownLevelIncreaseEvent event) {
        if (!TownyPerms.ranksWithTownLevelRequirementPresent()) {
            return;
        }
        event.getTown().getResidents().stream().filter(Resident::isOnline).forEach(r -> TownyPerms.assignPermissions(r, r.getPlayer()));
    }

    @EventHandler
    public void onTownLevelDecrease(TownLevelDecreaseEvent event) {
        if (!TownyPerms.ranksWithTownLevelRequirementPresent()) {
            return;
        }
        event.getTown().getResidents().stream().filter(Resident::isOnline).forEach(r -> TownyPerms.assignPermissions(r, r.getPlayer()));
    }

    @EventHandler
    public void onNationLevelIncrease(NationLevelIncreaseEvent event) {
        if (!TownyPerms.ranksWithNationLevelRequirementPresent()) {
            return;
        }
        event.getNation().getResidents().stream().filter(Resident::isOnline).forEach(r -> TownyPerms.assignPermissions(r, r.getPlayer()));
    }

    @EventHandler
    public void onNationLevelDecrease(NationLevelDecreaseEvent event) {
        if (!TownyPerms.ranksWithNationLevelRequirementPresent()) {
            return;
        }
        event.getNation().getResidents().stream().filter(Resident::isOnline).forEach(r -> TownyPerms.assignPermissions(r, r.getPlayer()));
    }

    @EventHandler
    public void onNationAddEnemy(NationAddEnemyEvent event) {
        Nation targetNation = event.getEnemy();
        Nation targettingNation = event.getNation();
        for (Town nationTown : targettingNation.getTowns()) {
            boolean save = false;
            for (Town town : new ArrayList<Town>(nationTown.getTrustedTowns())) {
                save = false;
                if (town.hasNation() && town.getNationOrNull().equals(targetNation)) {
                    nationTown.removeTrustedTown(town);
                    save = true;
                }
                if (!save) continue;
                town.save();
            }
            for (Resident resident : new ArrayList<Resident>(nationTown.getTrustedResidents())) {
                save = false;
                if (resident.hasNation() && resident.getNationOrNull().equals(targetNation)) {
                    nationTown.removeTrustedResident(resident);
                    save = true;
                }
                if (!save) continue;
                resident.save();
            }
            for (TownBlock tb : nationTown.getTownBlocks()) {
                if (tb.getTrustedResidents().isEmpty()) continue;
                save = false;
                for (Resident resident : new ArrayList<Resident>(tb.getTrustedResidents())) {
                    if (!resident.hasNation() || !resident.getNationOrNull().equals(targetNation)) continue;
                    tb.removeTrustedResident(resident);
                    save = true;
                }
                if (!save) continue;
                tb.save();
            }
        }
    }

    @EventHandler
    public void onTownAddOutlaw(TownOutlawAddEvent event) {
        Resident outlaw = event.getOutlawedResident();
        Town town = event.getTown();
        for (Town trustedTown : new ArrayList<Town>(town.getTrustedTowns())) {
            if (!trustedTown.hasResident(outlaw)) continue;
            town.removeTrustedTown(trustedTown);
            town.save();
        }
        if (town.hasTrustedResident(outlaw)) {
            town.removeTrustedResident(outlaw);
            town.save();
        }
        for (TownBlock tb : town.getTownBlocks()) {
            if (!tb.hasTrustedResident(outlaw)) continue;
            tb.removeTrustedResident(outlaw);
            tb.save();
        }
    }
}

