/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.executors.TownyActionEventExecutor;
import com.palmergames.bukkit.towny.event.mobs.MobSpawnRemovalEvent;
import com.palmergames.bukkit.towny.hooks.PluginIntegrations;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.regen.block.BlockLocation;
import com.palmergames.bukkit.towny.tasks.MobRemovalTimerTask;
import com.palmergames.bukkit.towny.utils.BorderUtil;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.EntityTypeUtil;
import com.palmergames.bukkit.towny.utils.MinecraftVersion;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.EntityLists;
import com.palmergames.bukkit.util.ItemLists;
import com.palmergames.util.JavaUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Trident;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WindCharge;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.PigZapEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.Nullable;

public class TownyEntityListener
implements Listener {
    private final Towny plugin;
    private static final Map<String, String> POTION_LEGACY_NAMES = JavaUtil.make(new HashMap(), map -> {
        map.put("slowness", "slow");
        map.put("haste", "fast_digging");
        map.put("mining_fatigue", "slow_digging");
        map.put("strength", "increase_damage");
        map.put("instant_health", "heal");
        map.put("instant_damage", "harm");
        map.put("jump_boost", "jump");
        map.put("nausea", "confusion");
        map.put("resistance", "damage_resistance");
    });

    public TownyEntityListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        Entity attacker = event.getDamager();
        Entity defender = event.getEntity();
        if (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION && !(attacker instanceof Projectile)) {
            boolean cancelExplosiveDamage = false;
            if (EntityTypeUtil.isInstanceOfAny(TownySettings.getProtectedEntityTypes(), defender) && TownySettings.areProtectedEntitiesProtectedAgainstMobs() && this.entityProtectedFromExplosiveDamageHere(defender, event.getCause())) {
                cancelExplosiveDamage = true;
            }
            if (defender instanceof Player && EntityTypeUtil.isPVPExplosive(attacker.getType())) {
                cancelExplosiveDamage = CombatUtil.preventPvP(TownyAPI.getInstance().getTownyWorld(defender.getWorld()), TownyAPI.getInstance().getTownBlock(defender.getLocation()));
            }
            if (cancelExplosiveDamage) {
                event.setDamage(0.0);
                event.setCancelled(true);
                return;
            }
        }
        if (CombatUtil.preventDamageCall(attacker, defender, event.getCause())) {
            if (attacker instanceof Projectile && !attacker.getType().equals((Object)EntityType.TRIDENT)) {
                attacker.remove();
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onAxolotlTarget(EntityTargetLivingEntityEvent event) {
        Mob defender;
        Mob attacker;
        Entity entity = event.getEntity();
        if (entity instanceof Mob && (attacker = (Mob)entity).getType() == EntityType.AXOLOTL && (entity = event.getTarget()) instanceof Mob && CombatUtil.preventDamageCall((Entity)attacker, (Entity)(defender = (Mob)entity), EntityDamageEvent.DamageCause.ENTITY_ATTACK)) {
            attacker.setMemory(MemoryKey.HAS_HUNTING_COOLDOWN, (Object)true);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        if (this.plugin.isError()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!TownyAPI.getInstance().isTownyWorld(entity.getWorld())) {
            return;
        }
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(entity.getLocation());
        if (townBlock == null) {
            return;
        }
        if (entity instanceof Monster && townBlock.getType() == TownBlockType.ARENA) {
            event.getDrops().clear();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityTakesExplosionDamage(EntityDamageEvent event) {
        EntityDamageByEntityEvent eevent;
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        if (event instanceof EntityDamageByEntityEvent && (eevent = (EntityDamageByEntityEvent)event).getDamager() instanceof Creeper) {
            return;
        }
        if (event.getCause() != null && this.causeIsExplosive(event.getCause()) && this.entityProtectedFromExplosiveDamageHere(event.getEntity(), event.getCause())) {
            event.setDamage(0.0);
            event.setCancelled(true);
        }
    }

    private boolean causeIsExplosive(EntityDamageEvent.DamageCause cause) {
        return switch (cause) {
            case EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, EntityDamageEvent.DamageCause.LIGHTNING -> true;
            default -> false;
        };
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onLingeringPotionApplyEvent(AreaEffectCloudApplyEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        AreaEffectCloud effectCloud = event.getEntity();
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        if (MinecraftVersion.CURRENT_VERSION.isNewerThanOrEquals(MinecraftVersion.MINECRAFT_1_20_2)) {
            if (effectCloud.getBasePotionType() != null) {
                effects.addAll(effectCloud.getBasePotionType().getPotionEffects());
            }
        } else if (effectCloud.getBasePotionData() != null) {
            effects.addAll(effectCloud.getBasePotionData().getType().getPotionEffects());
        }
        if (effectCloud.hasCustomEffects()) {
            effects.addAll(effectCloud.getCustomEffects());
        }
        if (!this.hasDetrimentalEffects(effects)) {
            return;
        }
        if (effectCloud.getSource() == null && effectCloud.getOwnerUniqueId() != null && TownyUniverse.getInstance().hasResident(effectCloud.getOwnerUniqueId())) {
            event.setCancelled(true);
            return;
        }
        event.getAffectedEntities().removeIf(defender -> CombatUtil.preventDamageCall((Entity)effectCloud, (Entity)defender, EntityDamageEvent.DamageCause.MAGIC));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPotionSplashEvent(PotionSplashEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        ThrownPotion potion = event.getPotion();
        if (!this.hasDetrimentalEffects(potion.getEffects())) {
            return;
        }
        for (LivingEntity defender : event.getAffectedEntities()) {
            if (!CombatUtil.preventDamageCall((Entity)potion, (Entity)defender, EntityDamageEvent.DamageCause.MAGIC)) continue;
            event.setIntensity(defender, -1.0);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(event.getEntity().getWorld());
        if (townyWorld == null || !townyWorld.isUsingTowny()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (this.entityIsExempt(livingEntity, event.getSpawnReason())) {
            return;
        }
        if (this.disallowedWorldMob(townyWorld.hasWorldMobs(), livingEntity)) {
            if (this.weAreAllowedToRemoveThis(livingEntity)) {
                event.setCancelled(true);
            }
        } else if (this.disallowedWildernessMob(townyWorld.hasWildernessMobs(), livingEntity)) {
            if (this.weAreAllowedToRemoveThis(livingEntity)) {
                event.setCancelled(true);
            }
        } else if (this.disallowedTownMob(livingEntity) && this.weAreAllowedToRemoveThis(livingEntity)) {
            event.setCancelled(true);
        }
    }

    private boolean entityIsExempt(LivingEntity livingEntity, CreatureSpawnEvent.SpawnReason spawnReason) {
        return PluginIntegrations.getInstance().isNPC((Entity)livingEntity) || this.entityIsExemptByName(livingEntity) || MobRemovalTimerTask.isSpawnReasonIgnored((Entity)livingEntity, spawnReason);
    }

    private boolean entityIsExemptByName(LivingEntity livingEntity) {
        return TownySettings.isSkippingRemovalOfNamedMobs() && livingEntity.getCustomName() != null && !PluginIntegrations.getInstance().checkHostileEliteMobs((Entity)livingEntity);
    }

    private boolean disallowedWorldMob(boolean worldAllowsMobs, LivingEntity livingEntity) {
        return !worldAllowsMobs && MobRemovalTimerTask.isRemovingWorldEntity(livingEntity) || this.disallowedWorldVillagerBaby(livingEntity);
    }

    private boolean disallowedWorldVillagerBaby(LivingEntity livingEntity) {
        Villager villager;
        return TownySettings.isRemovingVillagerBabiesWorld() && livingEntity instanceof Villager && !(villager = (Villager)livingEntity).isAdult();
    }

    private boolean disallowedWildernessMob(boolean wildernessAllowsMobs, LivingEntity livingEntity) {
        return TownyAPI.getInstance().isWilderness(livingEntity.getLocation()) && !wildernessAllowsMobs && MobRemovalTimerTask.isRemovingWildernessEntity(livingEntity);
    }

    private boolean disallowedTownMob(LivingEntity livingEntity) {
        return !TownyAPI.getInstance().isWilderness(livingEntity.getLocation()) && (this.disallowedByTown(livingEntity) || this.disallowedTownVillagerBaby(livingEntity));
    }

    private boolean disallowedByTown(LivingEntity livingEntity) {
        return !TownyAPI.getInstance().areMobsEnabled(livingEntity.getLocation()) && MobRemovalTimerTask.isRemovingTownEntity(livingEntity);
    }

    private boolean disallowedTownVillagerBaby(LivingEntity livingEntity) {
        Villager villager;
        return TownySettings.isRemovingVillagerBabiesTown() && livingEntity instanceof Villager && !(villager = (Villager)livingEntity).isAdult();
    }

    private boolean weAreAllowedToRemoveThis(LivingEntity livingEntity) {
        return !BukkitTools.isEventCancelled(new MobSpawnRemovalEvent((Entity)livingEntity));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityInteract(EntityInteractEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getBlock().getWorld())) {
            return;
        }
        Block block = event.getBlock();
        Entity entity = event.getEntity();
        List passengers = entity.getPassengers();
        for (Entity passenger : passengers) {
            if (!(passenger instanceof Player)) continue;
            Player player = (Player)passenger;
            if (!TownySettings.isSwitchMaterial(block.getType(), block.getLocation())) continue;
            event.setCancelled(!TownyActionEventExecutor.canSwitch(player, block.getLocation(), block.getType()));
            return;
        }
        if (!(entity instanceof Creature)) {
            return;
        }
        if (entity instanceof Villager && ItemLists.WOOD_DOORS.contains(block.getType())) {
            return;
        }
        if (block.getType() == Material.STONE_PRESSURE_PLATE) {
            if (TownySettings.isCreatureTriggeringPressurePlateDisabled()) {
                event.setCancelled(true);
            }
            return;
        }
        if (TownyAPI.getInstance().isWilderness(block)) {
            return;
        }
        if (TownySettings.isSwitchMaterial(block.getType(), block.getLocation())) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityChangeBlockEvent(EntityChangeBlockEvent event) {
        ThrownPotion potion;
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Block block = event.getBlock();
        TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(block.getWorld());
        if (townyWorld == null || !townyWorld.isUsingTowny()) {
            return;
        }
        Material blockMat = block.getType();
        Entity entity = event.getEntity();
        EntityType entityType = event.getEntityType();
        if (blockMat.equals((Object)Material.FARMLAND)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                event.setCancelled(TownySettings.isPlayerCropTramplePrevented() || !TownyActionEventExecutor.canDestroy(player, block));
            } else {
                event.setCancelled(townyWorld.isDisableCreatureTrample());
            }
            return;
        }
        if (entity instanceof FallingBlock && TownyRegenAPI.hasActiveRegeneration(WorldCoord.parseWorldCoord(event.getBlock()))) {
            event.setCancelled(true);
            return;
        }
        if (entityType == EntityType.ENDERMAN) {
            event.setCancelled(townyWorld.isEndermanProtect());
        } else if (entityType == EntityType.RAVAGER) {
            event.setCancelled(townyWorld.isDisableCreatureTrample());
        } else if (entityType == EntityType.WITHER) {
            List<Block> allowed = TownyActionEventExecutor.filterExplodableBlocks(Collections.singletonList(block), blockMat, entity, (Event)event);
            event.setCancelled(allowed.isEmpty());
        } else if (EntityLists.BOATS.contains(entityType) && blockMat.equals((Object)Material.LILY_PAD)) {
            Object e;
            List passengers = entity.getPassengers();
            if (!passengers.isEmpty() && (e = passengers.get(0)) instanceof Player) {
                Player player = (Player)e;
                event.setCancelled(!TownyActionEventExecutor.canDestroy(player, block));
            } else {
                event.setCancelled(!TownyAPI.getInstance().isWilderness(block));
            }
        } else if (entity instanceof ThrownPotion && (potion = (ThrownPotion)entity).getEffects().isEmpty() && ItemLists.CAMPFIRES.contains(blockMat)) {
            ProjectileSource projectileSource = potion.getShooter();
            if (projectileSource instanceof BlockProjectileSource) {
                BlockProjectileSource bps = (BlockProjectileSource)projectileSource;
                event.setCancelled(!BorderUtil.allowedMove(bps.getBlock(), block));
            } else {
                projectileSource = potion.getShooter();
                if (projectileSource instanceof Player) {
                    Player player = (Player)projectileSource;
                    event.setCancelled(!TownyActionEventExecutor.canDestroy(player, block));
                }
            }
        } else if (entityType == EntityType.SILVERFISH && ItemLists.INFESTED_BLOCKS.contains(event.getTo()) && !TownyAPI.getInstance().isWilderness(event.getBlock().getLocation())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(event.getEntity().getWorld());
        if (townyWorld == null || !townyWorld.isUsingTowny()) {
            return;
        }
        if (this.isWindCharge(event)) {
            return;
        }
        List<Block> blocks = TownyActionEventExecutor.filterExplodableBlocks(event.blockList(), null, event.getEntity(), (Event)event);
        event.blockList().clear();
        event.blockList().addAll(blocks);
        if (event.blockList().isEmpty()) {
            return;
        }
        Entity entity = event.getEntity();
        if (townyWorld.isUsingPlotManagementWildEntityRevert() && townyWorld.isProtectingExplosionEntity(entity)) {
            int count = 0;
            for (Block block : event.blockList()) {
                if (!TownyAPI.getInstance().isWilderness(block) || !townyWorld.isExplodedBlockAllowedToRevert(block.getType()) || TownyRegenAPI.hasProtectionRegenTask(new BlockLocation(block.getLocation()))) continue;
                TownyRegenAPI.beginProtectionRegenTask(block, ++count, townyWorld, (Event)event);
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onWindChargeExplode(EntityExplodeEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(event.getEntity().getWorld());
        if (townyWorld == null || !townyWorld.isUsingTowny()) {
            return;
        }
        if (!this.isWindCharge(event)) {
            return;
        }
        Player player = this.getWindChargePlayerOrNull(event);
        if (player == null) {
            return;
        }
        ArrayList<Block> deniedBlocks = new ArrayList<Block>();
        for (Block block : event.blockList()) {
            if (!TownySettings.isSwitchMaterial(block.getType(), block.getLocation()) || TownyActionEventExecutor.canSwitch(player, block.getLocation(), block.getType(), true)) continue;
            deniedBlocks.add(block);
        }
        if (deniedBlocks.isEmpty()) {
            return;
        }
        event.blockList().removeAll(deniedBlocks);
        TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_allowed_to_switch"));
    }

    private boolean isWindCharge(EntityExplodeEvent event) {
        boolean bl;
        Entity entity;
        if (MinecraftVersion.CURRENT_VERSION.isNewerThanOrEquals(MinecraftVersion.MINECRAFT_1_21) && (entity = event.getEntity()) instanceof WindCharge) {
            WindCharge charge = (WindCharge)entity;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    private Player getWindChargePlayerOrNull(EntityExplodeEvent event) {
        WindCharge charge;
        Entity entity = event.getEntity();
        if (entity instanceof WindCharge && (entity = (charge = (WindCharge)entity).getShooter()) instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityCombustByEntityEvent(EntityCombustByEntityEvent event) {
        Player player;
        LightningStrike lightning;
        Entity entity;
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        Entity combuster = event.getCombuster();
        Entity defender = event.getEntity();
        LivingEntity attacker = null;
        if (combuster instanceof Projectile) {
            Projectile projectile = (Projectile)combuster;
            ProjectileSource source = projectile.getShooter();
            if (source instanceof BlockProjectileSource) {
                BlockProjectileSource blockSource = (BlockProjectileSource)source;
                if (CombatUtil.preventDispenserDamage(blockSource.getBlock(), defender, EntityDamageEvent.DamageCause.PROJECTILE)) {
                    combuster.remove();
                    event.setCancelled(true);
                    return;
                }
            } else {
                attacker = (LivingEntity)source;
            }
            if (attacker != null && CombatUtil.preventDamageCall((Entity)attacker, defender, EntityDamageEvent.DamageCause.PROJECTILE)) {
                combuster.remove();
                event.setCancelled(true);
            }
        } else if (combuster instanceof LightningStrike && (entity = (lightning = (LightningStrike)combuster).getCausingEntity()) instanceof Player && CombatUtil.preventDamageCall((Entity)(player = (Player)entity), defender, EntityDamageEvent.DamageCause.LIGHTNING)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        Hanging hanging = event.getEntity();
        HangingBreakEvent.RemoveCause removeCause = event.getCause();
        if (removeCause.equals((Object)HangingBreakEvent.RemoveCause.PHYSICS)) {
            if (this.attachedToRegeneratingBlock((Entity)hanging) || this.itemFrameBrokenByBoatExploit((Entity)hanging)) {
                event.setCancelled(true);
            }
            return;
        }
        if (event instanceof HangingBreakByEntityEvent) {
            HangingBreakByEntityEvent evt = (HangingBreakByEntityEvent)event;
            if (this.preventHangingBrokenByEntity((Entity)hanging, removeCause, evt.getRemover())) {
                event.setCancelled(true);
            }
            return;
        }
        if (removeCause.equals((Object)HangingBreakEvent.RemoveCause.EXPLOSION)) {
            if (this.entityProtectedFromExplosiveDamageHere((Entity)hanging, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) || this.weAreRevertingBlockExplosionsInWild(hanging.getLocation())) {
                event.setCancelled(true);
            }
            return;
        }
    }

    private boolean attachedToRegeneratingBlock(Entity hanging) {
        return EntityLists.HANGING.contains(hanging) && TownyRegenAPI.hasProtectionRegenTask(new BlockLocation(hanging.getLocation().add(hanging.getFacing().getOppositeFace().getDirection())));
    }

    private boolean itemFrameBrokenByBoatExploit(Entity hanging) {
        if (EntityLists.ITEM_FRAMES.contains(hanging)) {
            Block block = hanging.getLocation().add(hanging.getFacing().getOppositeFace().getDirection()).getBlock();
            if (block.isLiquid() || block.isEmpty()) {
                return false;
            }
            for (Entity entity : hanging.getNearbyEntities(0.5, 0.5, 0.5)) {
                if (!(entity instanceof Vehicle)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean preventHangingBrokenByEntity(Entity hanging, HangingBreakEvent.RemoveCause removeCause, Object remover) {
        if (removeCause.equals((Object)HangingBreakEvent.RemoveCause.EXPLOSION) && (this.entityProtectedFromExplosiveDamageHere(hanging, EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) || this.weAreRevertingThisRemoversExplosionsInWild(hanging.getLocation(), remover))) {
            return true;
        }
        if (remover instanceof Projectile) {
            Projectile projectile = (Projectile)remover;
            remover = projectile.getShooter();
        }
        if (remover instanceof Player) {
            Player player = (Player)remover;
            return !this.allowedToBreak(player, hanging);
        }
        if (remover instanceof Entity) {
            return !TownyAPI.getInstance().isWilderness(hanging.getLocation());
        }
        return false;
    }

    private boolean allowedToBreak(Player player, Entity hanging) {
        return TownyActionEventExecutor.canDestroy(player, hanging.getLocation(), EntityTypeUtil.parseEntityToMaterial(hanging.getType(), Material.GRASS_BLOCK));
    }

    private boolean weAreRevertingThisRemoversExplosionsInWild(Location loc, Object remover) {
        TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(loc.getWorld());
        return remover != null && TownyAPI.getInstance().isWilderness(loc) && townyWorld.isUsingPlotManagementWildEntityRevert() && townyWorld.isProtectingExplosionEntity((Entity)remover);
    }

    private boolean weAreRevertingBlockExplosionsInWild(Location loc) {
        return TownyAPI.getInstance().isWilderness(loc) && TownyAPI.getInstance().getTownyWorld(loc.getWorld()).isUsingPlotManagementWildBlockRevert();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        Material mat = EntityTypeUtil.parseEntityToMaterial(event.getEntity().getType(), Material.GRASS_BLOCK);
        event.setCancelled(!TownyActionEventExecutor.canBuild(event.getPlayer(), event.getEntity().getLocation(), mat));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPigHitByLightning(PigZapEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        if (this.entityProtectedFromExplosiveDamageHere((Entity)event.getEntity(), EntityDamageEvent.DamageCause.LIGHTNING)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onProjectileHitEventButtonOrPlate(ProjectileHitEvent event) {
        ProjectileSource projectileSource;
        if (this.plugin.isError() || !TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld()) || event.getHitBlock() == null || !((projectileSource = event.getEntity().getShooter()) instanceof Player)) {
            return;
        }
        Player player = (Player)projectileSource;
        Block block = event.getHitBlock().getRelative(event.getHitBlockFace());
        Material material = block.getType();
        if (ItemLists.PROJECTILE_TRIGGERED_REDSTONE.contains(material) && TownySettings.isSwitchMaterial(material, block.getLocation()) && !TownyActionEventExecutor.canSwitch(player, block.getLocation(), material)) {
            BlockData data = block.getBlockData();
            block.setType(Material.AIR);
            this.plugin.getScheduler().run(block.getLocation(), () -> block.setBlockData(data));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onProjectileHitBlockEvent(ProjectileHitEvent event) {
        Block hitBlock = event.getHitBlock();
        if (this.plugin.isError() || !TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld()) || hitBlock == null || this.projectileIsIrrelevantToBlock(hitBlock)) {
            return;
        }
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (!(projectileSource instanceof Player)) {
            if (!TownyAPI.getInstance().isWilderness(hitBlock)) {
                event.setCancelled(true);
            }
            return;
        }
        Player player = (Player)projectileSource;
        if (this.disallowedTargetSwitch(hitBlock, player) || this.disallowedProjectileBlockBreak(hitBlock, event.getEntity(), player) || this.disallowedCampfireLighting(hitBlock, event.getEntity(), player)) {
            event.setCancelled(true);
        }
    }

    private boolean projectileIsIrrelevantToBlock(Block hitBlock) {
        return hitBlock.getType() != Material.TARGET && !ItemLists.PROJECTILE_BREAKABLE_BLOCKS.contains(hitBlock.getType()) && !ItemLists.CAMPFIRES.contains(hitBlock.getType());
    }

    private boolean disallowedTargetSwitch(Block hitBlock, Player player) {
        return hitBlock.getType() == Material.TARGET && TownySettings.isSwitchMaterial(Material.TARGET, hitBlock.getLocation()) && !TownyActionEventExecutor.canSwitch(player, hitBlock.getLocation(), hitBlock.getType());
    }

    private boolean disallowedProjectileBlockBreak(Block hitBlock, Projectile projectile, Player player) {
        if (hitBlock.getType() == Material.POINTED_DRIPSTONE && !(projectile instanceof Trident)) {
            return false;
        }
        if (hitBlock.getType().getKey().equals((Object)NamespacedKey.minecraft((String)"decorated_pot")) && (projectile instanceof ShulkerBullet || projectile instanceof EnderPearl || projectile instanceof LlamaSpit)) {
            return false;
        }
        return ItemLists.PROJECTILE_BREAKABLE_BLOCKS.contains(hitBlock.getType()) && !TownyActionEventExecutor.canDestroy(player, hitBlock.getLocation(), hitBlock.getType());
    }

    private boolean disallowedCampfireLighting(Block hitBlock, Projectile projectile, Player player) {
        return ItemLists.CAMPFIRES.contains(hitBlock.getType()) && this.isFireArrow(projectile) && !TownyActionEventExecutor.canDestroy(player, hitBlock);
    }

    private boolean isFireArrow(Projectile projectile) {
        Arrow arrow;
        return projectile instanceof Arrow && (arrow = (Arrow)projectile).getFireTicks() > 0;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onDoorBreak(EntityBreakDoorEvent event) {
        if (TownyAPI.getInstance().isTownyWorld(event.getBlock().getWorld()) && !TownyAPI.getInstance().isWilderness(event.getBlock().getLocation())) {
            event.setCancelled(true);
        }
    }

    private boolean entityProtectedFromExplosiveDamageHere(Entity entity, EntityDamageEvent.DamageCause cause) {
        return !TownyActionEventExecutor.canExplosionDamageEntities(entity.getLocation(), entity, cause);
    }

    private boolean hasDetrimentalEffects(Collection<PotionEffect> effects) {
        if (effects.isEmpty()) {
            return false;
        }
        List<String> detrimentalPotions = TownySettings.getPotionTypes().stream().map(type -> type.toLowerCase(Locale.ROOT)).toList();
        return effects.stream().map(effect -> BukkitTools.potionEffectName(effect.getType())).anyMatch(name -> {
            if (detrimentalPotions.contains(name)) {
                return true;
            }
            String legacyName = POTION_LEGACY_NAMES.get(name);
            return legacyName != null && detrimentalPotions.contains(legacyName);
        });
    }
}

