/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownBlockTypeHandler;
import com.palmergames.bukkit.towny.object.TownyInventory;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.gui.EditGUI;
import com.palmergames.bukkit.towny.object.gui.PermissionGUI;
import com.palmergames.bukkit.towny.object.gui.SelectionGUI;
import com.palmergames.bukkit.towny.utils.PermissionGUIUtil;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.towny.utils.TownyComponents;
import java.util.Set;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public class TownyInventoryListener
implements Listener {
    private final Towny plugin;
    private final Sound clickSound = Sound.sound((Key)Key.key((String)"minecraft", (String)"block.stone_button.click_on"), (Sound.Source)Sound.Source.PLAYER, (float)1.0f, (float)1.0f);

    public TownyInventoryListener(Towny plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onClick(InventoryClickEvent event) {
        TownyInventory townyInventory;
        block47: {
            block46: {
                InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
                if (!(inventoryHolder instanceof TownyInventory)) break block46;
                townyInventory = (TownyInventory)inventoryHolder;
                if (event.getCurrentItem() != null || event.getHotbarButton() != -1) break block47;
            }
            return;
        }
        event.setCancelled(true);
        if (event.getHotbarButton() > -1) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (resident == null || event.getClickedInventory() != null && !(event.getClickedInventory().getHolder(false) instanceof TownyInventory)) {
            return;
        }
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (inventoryHolder instanceof EditGUI) {
            EditGUI editGUI = (EditGUI)inventoryHolder;
            meta = event.getCurrentItem().getItemMeta();
            if (meta == null) {
                return;
            }
            Component customName = meta.displayName();
            String plainCustomName = customName != null ? TownyComponents.plain(customName) : event.getCurrentItem().getType().getKey().asMinimalString();
            Material type = event.getCurrentItem().getType();
            if (type == Material.LIME_WOOL) {
                if (meta.getPersistentDataContainer().has(PermissionGUIUtil.EDIT_GUI_SAVE_KEY)) {
                    editGUI.saveChanges();
                } else {
                    ItemStack newItem = new ItemStack(Material.RED_WOOL);
                    newItem.editMeta(newMeta -> newMeta.displayName(Component.text((String)plainCustomName, (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).decoration(TextDecoration.ITALIC, false)));
                    event.setCurrentItem(newItem);
                }
            } else if (type == Material.RED_WOOL) {
                if (meta.getPersistentDataContainer().has(PermissionGUIUtil.EDIT_GUI_BACK_KEY)) {
                    editGUI.exitScreen();
                } else if (meta.getPersistentDataContainer().has(PermissionGUIUtil.EDIT_GUI_DELETE_KEY)) {
                    editGUI.deleteResident();
                } else {
                    ItemStack newItem = new ItemStack(Material.GRAY_WOOL);
                    newItem.editMeta(newMeta -> newMeta.displayName(Component.text((String)plainCustomName, (TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).decoration(TextDecoration.ITALIC, false)));
                    event.setCurrentItem(newItem);
                }
            } else if (type == Material.GRAY_WOOL) {
                ItemStack newItem = new ItemStack(Material.LIME_WOOL);
                newItem.editMeta(newMeta -> newMeta.displayName(Component.text((String)plainCustomName, (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).decoration(TextDecoration.ITALIC, false)));
                event.setCurrentItem(newItem);
            } else {
                return;
            }
            editGUI.playClickSound(player);
        } else {
            meta = event.getInventory().getHolder();
            if (meta instanceof PermissionGUI) {
                PermissionGUI permissionGUI = (PermissionGUI)meta;
                if (event.getCurrentItem().getType() == Material.PLAYER_HEAD && permissionGUI.canEdit()) {
                    PermissionGUIUtil.openPermissionEditorGUI(resident, permissionGUI.getTownBlock(), event.getCurrentItem());
                    player.playSound(this.clickSound);
                } else if (event.getCurrentItem().getType() == Material.WRITTEN_BOOK) {
                    player.openBook(PermissionGUIUtil.createTutorialBook());
                } else if (event.getCurrentItem().getType() == Material.NAME_TAG) {
                    if (this.plugin.isFolia()) {
                        TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_perm_gui_folia"));
                        return;
                    }
                    PermissionGUIUtil.handleConversation(player);
                    event.getWhoClicked().closeInventory();
                } else {
                    permissionGUI.tryPaginate(event.getCurrentItem(), player, resident, event.getView());
                }
            } else {
                meta = event.getInventory().getHolder();
                if (meta instanceof SelectionGUI) {
                    String string;
                    Set<Material> materialSet;
                    SelectionGUI selectionGUI = (SelectionGUI)meta;
                    meta = event.getCurrentItem().getItemMeta();
                    if (meta == null) {
                        return;
                    }
                    String townBlockTypeName = (String)meta.getPersistentDataContainer().get(ResidentUtil.SELECTION_GUI_TOWNBLOCK_TYPE_KEY, PersistentDataType.STRING);
                    if (townBlockTypeName == null) {
                        return;
                    }
                    TownBlockType type = TownBlockTypeHandler.getType(townBlockTypeName);
                    if (type == null) {
                        selectionGUI.playClickSound(player);
                        return;
                    }
                    switch (selectionGUI.getType()) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case ITEMUSE: {
                            Set<Material> set = type.getData().getItemUseIds();
                            break;
                        }
                        case ALLOWEDBLOCKS: {
                            Set<Material> set = type.getData().getAllowedBlocks();
                            break;
                        }
                        case SWITCHES: {
                            Set<Material> set = materialSet = type.getData().getSwitchIds();
                        }
                    }
                    if (materialSet.isEmpty()) {
                        string = Translatable.of("gui_title_no_restrictions").forLocale(resident);
                    } else {
                        switch (selectionGUI.getType()) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case ALLOWEDBLOCKS: {
                                string = Translatable.of("gui_title_towny_allowedblocks", type.getName()).forLocale(resident);
                                break;
                            }
                            case SWITCHES: {
                                string = Translatable.of("gui_title_towny_switch").forLocale(resident);
                                break;
                            }
                            case ITEMUSE: {
                                string = Translatable.of("gui_title_towny_itemuse").forLocale(resident);
                            }
                        }
                    }
                    String title = string;
                    resident.setGUISelectionType(selectionGUI.getType());
                    selectionGUI.playClickSound(player);
                    ResidentUtil.openGUIInventory(resident, materialSet, title);
                } else {
                    townyInventory.tryPaginate(event.getCurrentItem(), player, resident, event.getView());
                }
            }
        }
    }
}

