/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.destroystokyo.paper.event.block.BeaconEffectEvent;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.executors.TownyActionEventExecutor;
import com.palmergames.bukkit.towny.hooks.PluginIntegrations;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.tasks.MobRemovalTimerTask;
import com.palmergames.bukkit.towny.utils.BorderUtil;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.util.JavaUtil;
import com.palmergames.util.TimeTools;
import java.lang.invoke.MethodHandle;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class TownyPaperEvents
implements Listener {
    private final Towny plugin;
    private static final String SIGN_OPEN_EVENT = "io.papermc.paper.event.player.PlayerOpenSignEvent";
    private static final String SPIGOT_SIGN_OPEN_EVENT = "org.bukkit.event.player.PlayerSignOpenEvent";
    private static final String USED_SIGN_OPEN_EVENT = JavaUtil.classExists("io.papermc.paper.event.player.PlayerOpenSignEvent") ? "io.papermc.paper.event.player.PlayerOpenSignEvent" : "org.bukkit.event.player.PlayerSignOpenEvent";
    private static final String PLAYER_ELYTRA_BOOST_EVENT = "com.destroystokyo.paper.event.player.PlayerElytraBoostEvent";
    private static final String DRAGON_FIREBALL_HIT_EVENT = "com.destroystokyo.paper.event.entity.EnderDragonFireballHitEvent";
    private static final String BEACON_EFFECT_EVENT = "com.destroystokyo.paper.event.block.BeaconEffectEvent";
    public static final MethodHandle SIGN_OPEN_GET_CAUSE = JavaUtil.getMethodHandle(USED_SIGN_OPEN_EVENT, "getCause");
    private static final MethodHandle SIGN_OPEN_GET_SIGN = JavaUtil.getMethodHandle(USED_SIGN_OPEN_EVENT, "getSign");
    public static final String ADD_TO_WORLD_EVENT = "com.destroystokyo.paper.event.entity.EntityAddToWorldEvent";

    public TownyPaperEvents(Towny plugin) {
        this.plugin = plugin;
    }

    public void register() {
        this.registerEvent(TNTPrimeEvent.class, this.tntPrimeEvent(), EventPriority.LOW, true);
        this.registerEvent(EntityChangeBlockEvent.class, this.fallingBlockListener(), EventPriority.LOW, true);
        if (SIGN_OPEN_GET_CAUSE != null) {
            this.registerEvent(JavaUtil.classExists(SIGN_OPEN_EVENT) ? SIGN_OPEN_EVENT : SPIGOT_SIGN_OPEN_EVENT, this::openSignListener, EventPriority.LOW, true);
            TownyMessaging.sendDebugMsg("PlayerOpenSignEvent#getCause found, using PlayerOpenSignEvent listener.");
        }
        if (JavaUtil.classExists(BEACON_EFFECT_EVENT)) {
            this.registerEvent(BEACON_EFFECT_EVENT, this::beaconEffectEventListener, EventPriority.LOW, true);
            TownyMessaging.sendDebugMsg("Using com.destroystokyo.paper.event.block.BeaconEffectEvent listener.");
        }
        this.registerEvent(PLAYER_ELYTRA_BOOST_EVENT, this::playerElytraBoostListener, EventPriority.LOW, true);
        if (this.plugin.isFolia()) {
            this.registerEvent(ADD_TO_WORLD_EVENT, this::entityAddToWorldListener, EventPriority.MONITOR, false);
        }
    }

    private <T extends Event> void registerEvent(String className, Supplier<Consumer<T>> executor, EventPriority eventPriority, boolean ignoreCancelled) {
        try {
            Class<Event> eventClass = Class.forName(className).asSubclass(Event.class);
            this.registerEvent(eventClass, executor.get(), eventPriority, ignoreCancelled);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private <T extends Event> void registerEvent(Class<T> eventClass, Consumer<T> consumer, EventPriority eventPriority, boolean ignoreCancelled) {
        Bukkit.getPluginManager().registerEvent(eventClass, (Listener)this, eventPriority, (listener, event) -> consumer.accept(event), (Plugin)this.plugin, ignoreCancelled);
    }

    private Consumer<PlayerEvent> playerElytraBoostListener() {
        return event -> {
            Player player = event.getPlayer();
            if (!TownySettings.isItemUseMaterial(Material.FIREWORK_ROCKET, player.getLocation())) {
                return;
            }
            ((Cancellable)event).setCancelled(!TownyActionEventExecutor.canItemuse(player, player.getLocation(), Material.FIREWORK_ROCKET));
        };
    }

    private Consumer<TNTPrimeEvent> tntPrimeEvent() {
        return event -> {
            Entity primerEntity = event.getPrimingEntity();
            if (primerEntity instanceof Projectile) {
                Projectile projectile = (Projectile)primerEntity;
                Block block = event.getBlock();
                ProjectileSource patt0$temp = projectile.getShooter();
                if (patt0$temp instanceof Player) {
                    Player player = (Player)patt0$temp;
                    event.setCancelled(!TownyActionEventExecutor.canDestroy(player, block));
                } else {
                    BlockProjectileSource bps;
                    ProjectileSource patt1$temp = projectile.getShooter();
                    if (patt1$temp instanceof BlockProjectileSource && !BorderUtil.allowedMove((bps = (BlockProjectileSource)patt1$temp).getBlock(), block)) {
                        event.setCancelled(true);
                    }
                }
            }
        };
    }

    private Consumer<EntityChangeBlockEvent> fallingBlockListener() {
        return event -> {
            if (event.getEntityType() != EntityType.FALLING_BLOCK || !TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
                return;
            }
            Location origin = event.getEntity().getOrigin();
            if (origin == null) {
                return;
            }
            if (origin.getBlockZ() == event.getBlock().getZ() && origin.getBlockX() == event.getBlock().getX()) {
                return;
            }
            if (!BorderUtil.allowedMove(origin.getBlock(), event.getBlock())) {
                event.setCancelled(true);
            }
        };
    }

    private Consumer<Event> openSignListener() {
        return event -> {
            Sign sign;
            Enum cause;
            if (SIGN_OPEN_GET_CAUSE == null || SIGN_OPEN_GET_SIGN == null) {
                return;
            }
            try {
                cause = SIGN_OPEN_GET_CAUSE.invoke((Event)event);
                sign = SIGN_OPEN_GET_SIGN.invoke((Event)event);
            }
            catch (Throwable e) {
                this.plugin.getLogger().log(Level.WARNING, "An exception occurred while invoking " + USED_SIGN_OPEN_EVENT + "#getCause/#getSign reflectively", e);
                return;
            }
            if (!cause.name().equals("INTERACT") || !sign.isPlaced()) {
                return;
            }
            if (!TownyActionEventExecutor.canDestroy(((PlayerEvent)event).getPlayer(), sign.getBlock())) {
                ((Cancellable)event).setCancelled(true);
            }
        };
    }

    private Consumer<BeaconEffectEvent> beaconEffectEventListener() {
        return event -> {
            if (!TownySettings.beaconsForTownMembersOnly()) {
                return;
            }
            Player player = event.getPlayer();
            Block block = event.getBlock();
            Town blockTown = TownyAPI.getInstance().getTown(block.getLocation());
            Town playerTown = TownyAPI.getInstance().getTown(player);
            if (blockTown == null) {
                return;
            }
            if (!(playerTown == null || !CombatUtil.isAlly(playerTown, blockTown) || playerTown.isConquered() && blockTown.hasNation() && blockTown.getNationOrNull().hasTown(playerTown) && TownySettings.beaconsExcludeConqueredTowns())) {
                return;
            }
            event.setCancelled(true);
        };
    }

    private Consumer<EntityEvent> entityAddToWorldListener() {
        return event -> {
            Entity patt0$temp = event.getEntity();
            if (!(patt0$temp instanceof LivingEntity)) {
                return;
            }
            LivingEntity entity = (LivingEntity)patt0$temp;
            if (entity instanceof Player || PluginIntegrations.getInstance().isNPC((Entity)entity)) {
                return;
            }
            TownyWorld world = TownyAPI.getInstance().getTownyWorld(entity.getWorld());
            this.plugin.getScheduler().runRepeating((Entity)entity, task -> {
                if (!entity.isValid()) {
                    task.cancel();
                    return;
                }
                if (MobRemovalTimerTask.isRemovingEntities(world)) {
                    MobRemovalTimerTask.checkEntity(this.plugin, world, (Entity)entity);
                }
            }, 1L, TimeTools.convertToTicks(TownySettings.getMobRemovalSpeed()));
        };
    }
}

