/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.BedExplodeEvent;
import com.palmergames.bukkit.towny.event.PlayerChangePlotEvent;
import com.palmergames.bukkit.towny.event.TitleNotificationEvent;
import com.palmergames.bukkit.towny.event.executors.TownyActionEventExecutor;
import com.palmergames.bukkit.towny.event.player.PlayerDeniedBedUseEvent;
import com.palmergames.bukkit.towny.event.player.PlayerEntersIntoDistrictEvent;
import com.palmergames.bukkit.towny.event.player.PlayerEntersIntoTownBorderEvent;
import com.palmergames.bukkit.towny.event.player.PlayerExitsFromDistrictEvent;
import com.palmergames.bukkit.towny.event.player.PlayerExitsFromTownBorderEvent;
import com.palmergames.bukkit.towny.event.player.PlayerKeepsExperienceEvent;
import com.palmergames.bukkit.towny.event.player.PlayerKeepsInventoryEvent;
import com.palmergames.bukkit.towny.event.teleport.CancelledTownyTeleportEvent;
import com.palmergames.bukkit.towny.hooks.PluginIntegrations;
import com.palmergames.bukkit.towny.listeners.TownyPaperEvents;
import com.palmergames.bukkit.towny.object.CommandList;
import com.palmergames.bukkit.towny.object.District;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.jail.UnJailReason;
import com.palmergames.bukkit.towny.object.notification.TitleNotification;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.tasks.OnPlayerLogin;
import com.palmergames.bukkit.towny.tasks.TeleportWarmupTimerTask;
import com.palmergames.bukkit.towny.utils.ChunkNotificationUtil;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.EntityTypeUtil;
import com.palmergames.bukkit.towny.utils.JailUtil;
import com.palmergames.bukkit.towny.utils.MinecraftVersion;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.EntityLists;
import com.palmergames.bukkit.util.ItemLists;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.RespawnAnchor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTakeLecternBookEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class TownyPlayerListener
implements Listener {
    private final Towny plugin;
    private CommandList blockedJailCommands;
    private CommandList blockedTownCommands;
    private CommandList blockedTouristCommands;
    private CommandList blockedOutlawCommands;
    private CommandList blockedWarCommands;
    private CommandList ownPlotLimitedCommands;
    private int teleportWarmupTime = TownySettings.getTeleportWarmupTime();
    private boolean isMovementCancellingWarmup = TownySettings.isMovementCancellingSpawnWarmup();
    private boolean isPreventingSaturationLoss = TownySettings.preventSaturationLoss();

    public TownyPlayerListener(Towny plugin) {
        this.plugin = plugin;
        this.loadBlockedCommandLists();
        TownySettings.addReloadListener(NamespacedKey.fromString((String)"blocked-commands", (Plugin)plugin), config -> this.loadBlockedCommandLists());
        TownySettings.addReloadListener(NamespacedKey.fromString((String)"teleport-warmups", (Plugin)plugin), () -> {
            this.teleportWarmupTime = TownySettings.getTeleportWarmupTime();
            this.isMovementCancellingWarmup = TownySettings.isMovementCancellingSpawnWarmup();
        });
        TownySettings.addReloadListener(NamespacedKey.fromString((String)"saturation", (Plugin)plugin), () -> {
            this.isPreventingSaturationLoss = TownySettings.preventSaturationLoss();
        });
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.isOnline()) {
            return;
        }
        if (player.getName().contains(" ")) {
            player.kickPlayer("Invalid name!");
            return;
        }
        if (this.plugin.isError()) {
            this.sendSafeModeMessage(player);
            return;
        }
        this.plugin.getScheduler().run(new OnPlayerLogin(Towny.getPlugin(), player));
    }

    private void sendSafeModeMessage(Player player) {
        try {
            Translatable tipMsg = player.isOp() || player.hasPermission("towny.admin") ? Translatable.of("msg_safe_mode_admin") : Translatable.of("msg_safe_mode_player");
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_safe_mode_base"), tipMsg);
        }
        catch (Exception e) {
            String msg = player.isOp() || player.hasPermission("towny.admin") ? "Check the server's console for more information." : "Tell an admin to check the server's console.";
            player.sendMessage(String.valueOf(ChatColor.RED) + "[Towny] [Error] Towny is locked in Safe Mode due to an error! " + msg);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.plugin.deleteCache(event.getPlayer());
        TownyPerms.removeAttachment(event.getPlayer().getName());
        if (this.plugin.isError()) {
            return;
        }
        Resident resident = TownyUniverse.getInstance().getResident(event.getPlayer().getUniqueId());
        if (resident != null) {
            if (!BukkitTools.hasVanishedMeta(event.getPlayer())) {
                resident.setLastOnline(System.currentTimeMillis());
            }
            resident.setGUIPageNum(0);
            resident.setGUIPages(null);
            resident.clearModes(false);
            resident.save();
            if (TownyTimerHandler.isTeleportWarmupRunning()) {
                TownyAPI.getInstance().abortTeleportRequest(resident);
            }
            if (JailUtil.isQueuedToBeJailed(resident)) {
                event.getPlayer().setHealth(0.0);
            }
        }
        ChunkNotificationUtil.cancelPlayerTasks(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Location bed;
        if (this.plugin.isError() || event.getRespawnReason() == PlayerRespawnEvent.RespawnReason.END_PORTAL || !TownySettings.isTownRespawning()) {
            return;
        }
        if (event.isAnchorSpawn() && TownySettings.isRespawnAnchorHigherPrecedence()) {
            return;
        }
        Player player = event.getPlayer();
        Location respawn = TownyAPI.getInstance().getTownSpawnLocation(player);
        Resident resident = TownyAPI.getInstance().getResident(player);
        if ((TownySettings.getBedUse() || resident != null && resident.hasMode("bedspawn")) && (bed = BukkitTools.getBedOrRespawnLocation(player)) != null) {
            respawn = bed;
        }
        if (respawn == null) {
            return;
        }
        if (TownySettings.isTownRespawningInOtherWorlds() && !player.getWorld().equals((Object)respawn.getWorld())) {
            return;
        }
        event.setRespawnLocation(respawn);
        long protectionTime = TownySettings.getSpawnProtectionDuration();
        if (protectionTime > 0L && resident != null) {
            resident.addRespawnProtection(protectionTime);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJailRespawn(PlayerRespawnEvent event) {
        if (this.plugin.isError()) {
            return;
        }
        Resident resident = TownyUniverse.getInstance().getResident(event.getPlayer().getUniqueId());
        if (resident != null && resident.isJailed() && resident.getJailSpawn().isWorldLoaded()) {
            event.setRespawnLocation(resident.getJailSpawn());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        event.setCancelled(!TownyActionEventExecutor.canBuild(event.getPlayer(), event.getBlock().getLocation(), event.getBucket()));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getItemStack().getType().equals((Object)Material.MILK_BUCKET) || event.getBlockClicked().getType().equals((Object)Material.AIR)) {
            return;
        }
        event.setCancelled(!TownyActionEventExecutor.canDestroy(event.getPlayer(), event.getBlockClicked().getLocation(), event.getBlockClicked().getType()));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        Action action = event.getAction();
        if (this.actionIsNotRightClickOrPhysical(action) && this.actionIsNotLeftClickThatCountsAsSwitch(event, action)) {
            return;
        }
        Player player = event.getPlayer();
        Block clickedBlock = event.getClickedBlock();
        if (event.hasItem()) {
            Material item = event.getItem().getType();
            Location loc = null;
            loc = clickedBlock != null ? clickedBlock.getLocation() : player.getLocation();
            if (TownySettings.isItemUseMaterial(item, loc) && !TownyActionEventExecutor.canItemuse(player, loc, item)) {
                event.setCancelled(true);
                return;
            }
            if (clickedBlock != null) {
                Material clickedMat = clickedBlock.getType();
                if (Tag.BEDS.isTagged((Keyed)item) && Tag.CROPS.isTagged((Keyed)clickedBlock.getType()) && clickedBlock.getLightLevel() == 0) {
                    event.setCancelled(true);
                    return;
                }
                if ((ItemLists.AXES.contains(item) && (ItemLists.UNSTRIPPED_WOOD.contains(clickedMat) || ItemLists.WAXED_BLOCKS.contains(clickedMat) || ItemLists.WEATHERABLE_BLOCKS.contains(clickedMat)) || ItemLists.DYES.contains(item) && ItemLists.SIGNS.contains(clickedMat) || item == Material.FLINT_AND_STEEL && clickedMat == Material.TNT || item == Material.SHEARS && clickedMat == Material.PUMPKIN || clickedMat == Material.ROOTED_DIRT && ItemLists.HOES.contains(item) || ItemLists.BRUSHABLE_BLOCKS.contains(clickedMat) && item == Material.BRUSH) && !TownyActionEventExecutor.canDestroy(player, loc, clickedMat)) {
                    event.setCancelled(true);
                    return;
                }
                if ((ItemLists.CANDLES.contains(item) && clickedMat == Material.CAKE || ItemLists.PLANTS.contains(item) && clickedMat == Material.FLOWER_POT || item == Material.HONEYCOMB && ItemLists.WEATHERABLE_BLOCKS.contains(clickedMat) || ItemLists.PLACEABLE_BOOKS.contains(item) && ItemLists.BOOK_CONTAINERS.contains(clickedMat) || ItemLists.CAMPFIRES.contains(clickedMat) && item != Material.FLINT_AND_STEEL || item == Material.BONE_MEAL && !TownyActionEventExecutor.canBuild(player, loc, item)) && !TownyActionEventExecutor.canBuild(player, loc, item)) {
                    event.setCancelled(true);
                    return;
                }
                if (!(item != Material.ARMOR_STAND && item != Material.END_CRYSTAL || TownyActionEventExecutor.canBuild(player, clickedBlock.getRelative(event.getBlockFace()).getLocation(), item))) {
                    event.setCancelled(true);
                    return;
                }
                if (!((item != Material.HONEYCOMB || !ItemLists.SIGNS.contains(clickedMat) || this.isSignWaxed(clickedBlock)) && (item != Material.GLASS_BOTTLE && item != Material.SHEARS || clickedMat != Material.BEE_NEST && clickedMat != Material.BEEHIVE) || TownyActionEventExecutor.canItemuse(player, clickedBlock.getLocation(), clickedMat))) {
                    event.setCancelled(true);
                    return;
                }
            }
        }
        if (clickedBlock != null) {
            Material clickedMat = clickedBlock.getType();
            if (TownySettings.isSwitchMaterial(clickedMat, clickedBlock.getLocation()) && !TownyActionEventExecutor.canSwitch(player, clickedBlock.getLocation(), clickedMat)) {
                event.setCancelled(true);
                return;
            }
            if ((ItemLists.POTTED_PLANTS.contains(clickedMat) || ItemLists.HARVESTABLE_BERRIES.contains(clickedMat) || ItemLists.REDSTONE_INTERACTABLES.contains(clickedMat) || ItemLists.CANDLES.contains(clickedMat) || clickedMat == Material.TURTLE_EGG || clickedMat.getKey().equals((Object)NamespacedKey.minecraft((String)"chiseled_bookshelf")) || clickedMat == Material.BEACON || clickedMat == Material.DRAGON_EGG || clickedMat == Material.COMMAND_BLOCK) && !TownyActionEventExecutor.canDestroy(player, clickedBlock.getLocation(), clickedMat)) {
                event.setCancelled(true);
                return;
            }
            if (TownyPaperEvents.SIGN_OPEN_GET_CAUSE == null && ItemLists.SIGNS.contains(clickedMat) && !this.isSignWaxed(clickedBlock) && !TownyActionEventExecutor.canDestroy(player, clickedBlock.getLocation(), clickedMat)) {
                event.setCancelled(true);
            }
        }
    }

    private boolean actionIsNotLeftClickThatCountsAsSwitch(PlayerInteractEvent event, Action action) {
        return action != Action.LEFT_CLICK_BLOCK || !event.hasBlock() || !TownySettings.isSwitchMaterial(event.getClickedBlock().getType(), event.getClickedBlock().getLocation());
    }

    private boolean actionIsNotRightClickOrPhysical(Action action) {
        return action != Action.RIGHT_CLICK_BLOCK && action != Action.RIGHT_CLICK_AIR && action != Action.PHYSICAL;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onDragonEggLeftClick(PlayerInteractEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Player player = event.getPlayer();
        if (!TownyAPI.getInstance().isTownyWorld(player.getWorld())) {
            return;
        }
        if (!event.hasBlock() || event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block.getType() != Material.DRAGON_EGG) {
            return;
        }
        if (TownyActionEventExecutor.canDestroy(player, block)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerBlowsUpBedOrRespawnAnchor(PlayerInteractEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        Block block = event.getClickedBlock();
        Player player = event.getPlayer();
        if (event.hasBlock() && event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            Location blockLoc = block.getLocation();
            if (block.getType() == Material.RESPAWN_ANCHOR && !block.getWorld().isRespawnAnchorWorks()) {
                RespawnAnchor anchor = (RespawnAnchor)block.getBlockData();
                if (anchor.getCharges() > 0) {
                    BukkitTools.fireEvent(new BedExplodeEvent(player, blockLoc, null, block.getType()));
                }
                return;
            }
            if (Tag.BEDS.isTagged((Keyed)block.getType()) && player.getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
                Bed bed = (Bed)block.getBlockData();
                BukkitTools.fireEvent(new BedExplodeEvent(player, blockLoc, block.getRelative(bed.getFacing()).getLocation(), block.getType()));
                return;
            }
            if (TownySettings.getBedUse() && !TownyUniverse.getInstance().getPermissionSource().testPermission((Permissible)player, PermissionNodes.TOWNY_BYPASS_BED_RESTRICTION.getNode()) && (Tag.BEDS.isTagged((Keyed)block.getType()) || this.disallowedAnchorClick(event, block))) {
                PlayerDeniedBedUseEvent pdbue;
                boolean isOwner = false;
                boolean isInnPlot = false;
                boolean isEnemy = false;
                Translatable denialMessage = Translatable.of("msg_err_cant_use_bed");
                if (!TownyAPI.getInstance().isWilderness(blockLoc)) {
                    TownBlock townblock = TownyAPI.getInstance().getTownBlock(blockLoc);
                    Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
                    Town town = townblock.getTownOrNull();
                    if (resident == null || town == null) {
                        return;
                    }
                    isOwner = townblock.isOwner(resident);
                    boolean bl = isInnPlot = townblock.getType() == TownBlockType.INN;
                    if (CombatUtil.isEnemyTownBlock(player, townblock.getWorldCoord()) || town.hasOutlaw(resident)) {
                        isEnemy = true;
                        denialMessage = Translatable.of("msg_err_no_sleep_in_enemy_inn");
                    }
                }
                if ((isEnemy || !isOwner && !isInnPlot) && !BukkitTools.isEventCancelled(pdbue = new PlayerDeniedBedUseEvent(player, blockLoc, isEnemy, denialMessage))) {
                    event.setCancelled(true);
                    TownyMessaging.sendErrorMsg((CommandSender)player, pdbue.getDenialMessage());
                }
            }
        }
    }

    private boolean disallowedAnchorClick(PlayerInteractEvent event, Block block) {
        RespawnAnchor anchor;
        BlockData blockData;
        return block.getWorld().isRespawnAnchorWorks() && (blockData = block.getBlockData()) instanceof RespawnAnchor && (anchor = (RespawnAnchor)blockData).getCharges() > 0 && (event.getItem() == null || event.getItem().getType() != Material.GLOWSTONE || anchor.getCharges() >= anchor.getMaximumCharges());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteractWithArmourStand(PlayerArmorStandManipulateEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        event.setCancelled(!TownyActionEventExecutor.canDestroy(event.getPlayer(), event.getRightClicked().getLocation(), Material.ARMOR_STAND));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getRightClicked() == null) {
            return;
        }
        Player player = event.getPlayer();
        Material mat = null;
        TownyPermission.ActionType actionType = TownyPermission.ActionType.DESTROY;
        EntityType entityType = event.getRightClicked().getType();
        Material item = player.getInventory().getItemInMainHand().getType();
        if (EntityLists.SWITCH_PROTECTED.contains(entityType)) {
            mat = EntityTypeUtil.parseEntityToMaterial(entityType);
            actionType = TownyPermission.ActionType.SWITCH;
        } else if (EntityLists.DYEABLE.contains(entityType) && ItemLists.DYES.contains(item)) {
            mat = item;
        } else if (item == Material.BUCKET && EntityLists.MILKABLE.contains(entityType)) {
            mat = EntityTypeUtil.parseEntityToMaterial(entityType);
            actionType = TownyPermission.ActionType.ITEM_USE;
        } else if (item == Material.COOKIE && EntityType.PARROT.equals((Object)entityType)) {
            mat = EntityTypeUtil.parseEntityToMaterial(entityType);
        } else if ((ItemLists.AXES.contains(item) || item == Material.HONEYCOMB) && entityType.getKey().getKey().equals("copper_golem")) {
            mat = EntityTypeUtil.parseEntityToMaterial(entityType);
            actionType = TownyPermission.ActionType.ITEM_USE;
        } else if (EntityLists.RIGHT_CLICK_PROTECTED.contains(entityType)) {
            mat = EntityTypeUtil.parseEntityToMaterial(entityType);
        }
        if (mat != null) {
            if (actionType == TownyPermission.ActionType.DESTROY) {
                event.setCancelled(!TownyActionEventExecutor.canDestroy(player, event.getRightClicked().getLocation(), mat));
                return;
            }
            if (TownySettings.isSwitchMaterial(mat, event.getRightClicked().getLocation()) && actionType == TownyPermission.ActionType.SWITCH) {
                event.setCancelled(!TownyActionEventExecutor.canSwitch(player, event.getRightClicked().getLocation(), mat));
                return;
            }
        }
        if (item == null) {
            return;
        }
        if (item == Material.SHEARS && !TownyAPI.getInstance().isWilderness(event.getRightClicked().getLocation()) && (event.getRightClicked().getType().equals((Object)EntityType.SHEEP) || EntityLists.MOUNTABLE.contains(entityType))) {
            event.setCancelled(!TownyActionEventExecutor.canDestroy(player, event.getRightClicked().getLocation(), item));
            return;
        }
        if (item == Material.NAME_TAG) {
            event.setCancelled(!TownyActionEventExecutor.canDestroy(player, event.getRightClicked().getLocation(), item));
            return;
        }
        if (TownySettings.isItemUseMaterial(item, event.getRightClicked().getLocation())) {
            event.setCancelled(!TownyActionEventExecutor.canItemuse(player, event.getRightClicked().getLocation(), item));
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Resident resident;
        if (PluginIntegrations.getInstance().isNPC((Entity)event.getPlayer())) {
            return;
        }
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Player player = event.getPlayer();
        Location to = event.getTo();
        Location from = event.getFrom();
        if (to == null || from.getBlockX() == to.getBlockX() && from.getBlockZ() == to.getBlockZ() && from.getBlockY() == to.getBlockY()) {
            return;
        }
        if (this.teleportWarmupTime > 0 && this.isMovementCancellingWarmup && (resident = TownyAPI.getInstance().getResident(player)) != null && resident.hasRequestedTeleport() && !resident.isAdmin() && TeleportWarmupTimerTask.abortTeleportRequest(resident, CancelledTownyTeleportEvent.CancelledTeleportReason.MOVEMENT)) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_teleport_cancelled"));
        }
        if (WorldCoord.cellChanged(from, to)) {
            TownyWorld fromWorld = TownyAPI.getInstance().getTownyWorld(from.getWorld());
            TownyWorld toWorld = TownyAPI.getInstance().getTownyWorld(to.getWorld());
            if (fromWorld == null || toWorld == null) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("not_registered"));
                return;
            }
            WorldCoord fromCoord = WorldCoord.parseWorldCoord(from);
            WorldCoord toCoord = WorldCoord.parseWorldCoord(to);
            this.onPlayerMoveChunk(player, fromCoord, toCoord, event);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Town town;
        TownBlock tb;
        boolean isAdmin;
        if (PluginIntegrations.getInstance().isNPC((Entity)event.getPlayer())) {
            return;
        }
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Player player = event.getPlayer();
        Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (resident == null) {
            return;
        }
        boolean bl = isAdmin = !Towny.getPlugin().hasPlayerMode(player, "adminbypass") && (resident.isAdmin() || resident.hasPermissionNode(PermissionNodes.TOWNY_ADMIN_OUTLAW_TELEPORT_BYPASS.getNode()));
        if (isAdmin) {
            this.onPlayerMove((PlayerMoveEvent)event);
            return;
        }
        if (resident.isJailed()) {
            if (event.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND) {
                TownyMessaging.sendErrorMsg((CommandSender)event.getPlayer(), Translatable.of("msg_err_jailed_players_no_teleport"));
                event.setCancelled(true);
                return;
            }
            if (!(TownySettings.JailAllowsTeleportItems() || event.getCause() != PlayerTeleportEvent.TeleportCause.ENDER_PEARL && event.getCause() != PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT)) {
                TownyMessaging.sendErrorMsg((CommandSender)event.getPlayer(), Translatable.of("msg_err_jailed_players_no_teleport"));
                event.setCancelled(true);
                return;
            }
        }
        if (!TownySettings.canOutlawsTeleportOutOfTowns() && (tb = TownyAPI.getInstance().getTownBlock(event.getFrom())) != null && tb.hasTown() && (town = tb.getTownOrNull()) != null && town.hasOutlaw(resident)) {
            if (event.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND) {
                TownyMessaging.sendErrorMsg((CommandSender)event.getPlayer(), Translatable.of("msg_err_outlawed_players_no_teleport"));
                event.setCancelled(true);
                return;
            }
            if (!(TownySettings.canOutlawsUseTeleportItems() || event.getCause() != PlayerTeleportEvent.TeleportCause.ENDER_PEARL && event.getCause() != PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT)) {
                TownyMessaging.sendErrorMsg((CommandSender)event.getPlayer(), Translatable.of("msg_err_outlawed_players_no_teleport"));
                event.setCancelled(true);
                return;
            }
        }
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT && TownySettings.isItemUseMaterial(Material.CHORUS_FRUIT, event.getTo()) && !TownyActionEventExecutor.canItemuse(event.getPlayer(), event.getTo(), Material.CHORUS_FRUIT)) {
            event.setCancelled(true);
            return;
        }
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL && TownySettings.isItemUseMaterial(Material.ENDER_PEARL, event.getTo()) && !TownyActionEventExecutor.canItemuse(event.getPlayer(), event.getTo(), Material.ENDER_PEARL)) {
            event.setCancelled(true);
            return;
        }
        if (resident.hasRespawnProtection()) {
            resident.removeRespawnProtection();
        }
        this.onPlayerMove((PlayerMoveEvent)event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChangeWorld(PlayerChangedWorldEvent event) {
        if (event.getPlayer().isOnline()) {
            TownyPerms.assignPermissions(null, event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerFishEvent(PlayerFishEvent event) {
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getState().equals((Object)PlayerFishEvent.State.CAUGHT_ENTITY)) {
            Player player = event.getPlayer();
            Entity caught = event.getCaught();
            boolean test = false;
            if (caught == null) {
                return;
            }
            if (caught.getType().equals((Object)EntityType.PLAYER)) {
                TownyWorld world = TownyAPI.getInstance().getTownyWorld(event.getCaught().getWorld());
                if (world == null) {
                    return;
                }
                TownBlock tb = TownyAPI.getInstance().getTownBlock(event.getCaught().getLocation());
                test = !CombatUtil.preventPvP(world, tb);
            } else {
                test = TownyActionEventExecutor.canDestroy(player, caught.getLocation(), Material.DIRT);
            }
            if (!test) {
                event.setCancelled(true);
                event.getHook().remove();
            }
        }
    }

    @EventHandler
    public void onEntityExhaustion(EntityExhaustionEvent event) {
        if (!this.isPreventingSaturationLoss) {
            return;
        }
        HumanEntity humanEntity = event.getEntity();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!TownyAPI.getInstance().isTownyWorld(player.getWorld())) {
            return;
        }
        TownBlock tbAtPlayer = TownyAPI.getInstance().getTownBlock(player);
        if (tbAtPlayer == null) {
            return;
        }
        Town townAtPlayer = tbAtPlayer.getTownOrNull();
        Town playersTown = TownyAPI.getInstance().getTown(player);
        if (playersTown == null) {
            return;
        }
        if (townAtPlayer != null && !townAtPlayer.hasActiveWar() && CombatUtil.isAlly(townAtPlayer, playersTown) && !tbAtPlayer.getType().equals(TownBlockType.ARENA)) {
            event.setCancelled(true);
        }
    }

    private void onPlayerMoveChunk(Player player, WorldCoord from, WorldCoord to, PlayerMoveEvent moveEvent) {
        PlayerCache cache = this.plugin.getCacheOrNull(player.getUniqueId());
        if (cache != null) {
            cache.resetAndUpdate(to);
        }
        PlayerChangePlotEvent event = new PlayerChangePlotEvent(player, from, to, moveEvent);
        BukkitTools.fireEvent(event);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerChangePlotEvent(PlayerChangePlotEvent event) {
        if (!TownyUniverse.getInstance().hasResident(event.getPlayer().getUniqueId())) {
            return;
        }
        WorldCoord from = event.getFrom();
        WorldCoord to = event.getTo();
        if (to.isWilderness() && from.isWilderness()) {
            return;
        }
        if (to.isWilderness()) {
            BukkitTools.fireEvent(new PlayerExitsFromTownBorderEvent(event.getPlayer(), to, from, from.getTownOrNull(), event.getMoveEvent()));
        } else if (from.isWilderness()) {
            BukkitTools.fireEvent(new PlayerEntersIntoTownBorderEvent(event.getPlayer(), to, from, to.getTownOrNull(), event.getMoveEvent()));
        } else {
            if (to.getTownOrNull().equals(from.getTownOrNull())) {
                return;
            }
            BukkitTools.fireEvent(new PlayerEntersIntoTownBorderEvent(event.getPlayer(), to, from, to.getTownOrNull(), event.getMoveEvent()));
            BukkitTools.fireEvent(new PlayerExitsFromTownBorderEvent(event.getPlayer(), to, from, from.getTownOrNull(), event.getMoveEvent()));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerChangeDistricts(PlayerChangePlotEvent event) {
        District toDistrict;
        boolean toHasDistrict;
        if (!TownyUniverse.getInstance().hasResident(event.getPlayer().getUniqueId())) {
            return;
        }
        WorldCoord from = event.getFrom();
        WorldCoord to = event.getTo();
        boolean fromHasDistrict = !from.isWilderness() && from.getTownBlockOrNull().hasDistrict();
        boolean bl = toHasDistrict = !to.isWilderness() && to.getTownBlockOrNull().hasDistrict();
        if (to.isWilderness() && from.isWilderness() || !fromHasDistrict && !toHasDistrict) {
            return;
        }
        District fromDistrict = fromHasDistrict ? from.getTownBlockOrNull().getDistrict() : null;
        District district = toDistrict = toHasDistrict ? to.getTownBlockOrNull().getDistrict() : null;
        if (to.isWilderness() && fromHasDistrict) {
            BukkitTools.fireEvent(new PlayerExitsFromDistrictEvent(event.getPlayer(), to, from, fromDistrict, event.getMoveEvent()));
        } else if (from.isWilderness() && toHasDistrict) {
            BukkitTools.fireEvent(new PlayerEntersIntoDistrictEvent(event.getPlayer(), to, from, toDistrict, event.getMoveEvent()));
        } else if (!to.isWilderness() && !from.isWilderness() && to.getTownOrNull().equals(from.getTownOrNull()) && fromHasDistrict && toHasDistrict && !fromDistrict.equals(toDistrict)) {
            BukkitTools.fireEvent(new PlayerExitsFromDistrictEvent(event.getPlayer(), to, from, fromDistrict, event.getMoveEvent()));
            BukkitTools.fireEvent(new PlayerEntersIntoDistrictEvent(event.getPlayer(), to, from, toDistrict, event.getMoveEvent()));
        } else {
            if (fromHasDistrict) {
                BukkitTools.fireEvent(new PlayerExitsFromDistrictEvent(event.getPlayer(), to, from, fromDistrict, event.getMoveEvent()));
            }
            if (toHasDistrict) {
                BukkitTools.fireEvent(new PlayerEntersIntoDistrictEvent(event.getPlayer(), to, from, toDistrict, event.getMoveEvent()));
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onOutlawEnterTown(PlayerEntersIntoTownBorderEvent event) {
        Resident outlaw = TownyUniverse.getInstance().getResident(event.getPlayer().getUniqueId());
        if (outlaw == null || event.getPlayer().getGameMode().equals((Object)GameMode.SPECTATOR)) {
            return;
        }
        Town town = event.getEnteredTown();
        if (outlaw.isJailed() && outlaw.getJailTown().equals(town)) {
            return;
        }
        if (town.hasOutlaw(outlaw)) {
            ResidentUtil.outlawEnteredTown(outlaw, town, event.getPlayer().getLocation());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDeathHandleKeepLevelAndInventory(PlayerDeathEvent event) {
        Resident resident = TownyAPI.getInstance().getResident(event.getEntity());
        if (resident == null) {
            return;
        }
        TownBlock tb = TownyAPI.getInstance().getTownBlock(event.getEntity().getLocation());
        this.tryKeepInventory(event, resident, tb);
        this.tryKeepExperience(event, tb);
    }

    private boolean tryKeepInventory(PlayerDeathEvent event, Resident resident, TownBlock tb) {
        boolean keepInventory = this.getKeepInventoryValue(event.getKeepInventory(), resident, tb);
        PlayerKeepsInventoryEvent pkie = new PlayerKeepsInventoryEvent(event, keepInventory);
        if (!BukkitTools.isEventCancelled(pkie)) {
            event.setKeepInventory(true);
            event.getDrops().clear();
            return true;
        }
        return false;
    }

    private boolean getKeepInventoryValue(boolean keepInventory, Resident resident, TownBlock tb) {
        boolean bl = keepInventory = TownySettings.getKeepInventoryInTowns() && tb != null;
        if (tb == null) {
            return keepInventory;
        }
        if (resident.hasTown() && !keepInventory) {
            Town town = resident.getTownOrNull();
            Town tbTown = tb.getTownOrNull();
            if (TownySettings.getKeepInventoryInOwnTown() && tbTown.equals(town)) {
                keepInventory = true;
            }
            if (TownySettings.getKeepInventoryInAlliedTowns() && !keepInventory && tbTown.isAlliedWith(town)) {
                keepInventory = true;
            }
        }
        if (TownySettings.getKeepInventoryInArenas() && !keepInventory && tb.getType() == TownBlockType.ARENA) {
            keepInventory = true;
        }
        return keepInventory;
    }

    @EventHandler(ignoreCancelled=true)
    public void onArmourDamageEvent(PlayerItemDamageEvent event) {
        if (!TownySettings.arenaPlotPreventArmourDegrade()) {
            return;
        }
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        TownBlock tb = TownyAPI.getInstance().getTownBlock(event.getPlayer());
        if (tb == null || !tb.getType().equals(TownBlockType.ARENA)) {
            return;
        }
        if (!ItemLists.ARMOURS.contains(event.getItem()) && !ItemLists.WEAPONS.contains(event.getItem())) {
            return;
        }
        event.setCancelled(true);
    }

    private boolean tryKeepExperience(PlayerDeathEvent event, TownBlock tb) {
        boolean keepExperience = this.getKeepExperienceValue(tb != null, tb != null ? tb.getType() : null);
        PlayerKeepsExperienceEvent pkee = new PlayerKeepsExperienceEvent(event, keepExperience);
        if (!BukkitTools.isEventCancelled(pkee)) {
            event.setKeepLevel(true);
            event.setDroppedExp(0);
            return true;
        }
        return false;
    }

    private boolean getKeepExperienceValue(boolean inTown, TownBlockType type) {
        if (!inTown) {
            return false;
        }
        if (TownySettings.getKeepExperienceInTowns()) {
            return true;
        }
        return type != null && type == TownBlockType.ARENA && TownySettings.getKeepExperienceInArenas();
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerEnterTown(PlayerEntersIntoTownBorderEvent event) {
        Resident resident = event.getResident();
        Town town = event.getEnteredTown();
        if (resident == null || town == null) {
            return;
        }
        if (TownySettings.isNotificationUsingTitles() && resident.isSeeingBorderTitles()) {
            TitleNotificationEvent tne = new TitleNotificationEvent(new TitleNotification(town, event.getTo()), event.getPlayer());
            BukkitTools.fireEvent(tne);
            String title = tne.getTitleNotification().getTitleNotification();
            String subtitle = tne.getTitleNotification().getSubtitleNotification();
            TownyMessaging.sendTitleMessageToResident(resident, title, subtitle, TownySettings.getNotificationTitlesDurationTicks());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerLeaveTown(PlayerExitsFromTownBorderEvent event) {
        Resident resident = event.getResident();
        if (resident == null || !event.getTo().isWilderness()) {
            return;
        }
        if (TownySettings.isNotificationUsingTitles() && resident.isSeeingBorderTitles()) {
            TitleNotificationEvent tne = new TitleNotificationEvent(new TitleNotification(event.getLeftTown(), event.getTo()), event.getPlayer());
            BukkitTools.fireEvent(tne);
            String title = tne.getTitleNotification().getTitleNotification();
            String subtitle = tne.getTitleNotification().getSubtitleNotification();
            TownyMessaging.sendTitleMessageToResident(resident, title, subtitle, TownySettings.getNotificationTitlesDurationTicks());
        }
        if (resident.isJailed()) {
            JailUtil.unJailResident(resident, UnJailReason.ESCAPE);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerTakeLecternBookEvent(PlayerTakeLecternBookEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getLectern().getWorld())) {
            return;
        }
        event.setCancelled(!TownyActionEventExecutor.canDestroy(event.getPlayer(), event.getLectern().getLocation(), Material.LECTERN));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerUsesCommand(PlayerCommandPreprocessEvent event) {
        if (this.plugin.isError() || !TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        this.checkForOpDeOpCommand(event);
        Resident resident = TownyUniverse.getInstance().getResident(event.getPlayer().getUniqueId());
        if (resident == null || resident.isAdmin()) {
            return;
        }
        String command = event.getMessage();
        if (this.blockJailedPlayerCommand(event.getPlayer(), resident, command)) {
            event.setCancelled(true);
            return;
        }
        if (this.blockWarPlayerCommand(event.getPlayer(), resident, command)) {
            event.setCancelled(true);
            return;
        }
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(event.getPlayer());
        if (this.blockOutlawedPlayerCommand(event.getPlayer(), resident, townBlock, command) || this.blockCommandInsideTown(event.getPlayer(), resident, townBlock, command)) {
            event.setCancelled(true);
        }
    }

    private void checkForOpDeOpCommand(PlayerCommandPreprocessEvent event) {
        String[] args = CommandList.normalizeCommand(event.getMessage()).split(" ");
        String command = args[0];
        if (!command.equalsIgnoreCase("op") && !command.equalsIgnoreCase("deop") || args.length != 2) {
            return;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null || !target.isOnline()) {
            return;
        }
        if (!event.getPlayer().hasPermission("minecraft.command." + command)) {
            return;
        }
        if (target.isOp() == "op".equalsIgnoreCase(command)) {
            return;
        }
        Towny plugin = Towny.getPlugin();
        plugin.getScheduler().runLater((Entity)target, () -> plugin.deleteCache(target), 1L);
    }

    public boolean blockWarPlayerCommand(Player player, Resident resident, String command) {
        if (resident.hasTown() && resident.getTownOrNull().hasActiveWar() && this.blockedWarCommands.containsCommand(command)) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_command_war_blocked"));
            return true;
        }
        return false;
    }

    public boolean blockOutlawedPlayerCommand(Player player, Resident resident, TownBlock townBlock, String command) {
        Town town;
        if (townBlock != null && townBlock.hasTown() && (town = townBlock.getTownOrNull()) != null && town.hasOutlaw(resident) && this.blockedOutlawCommands.containsCommand(command)) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_you_cannot_use_command_while_in_outlaw_town"));
            return true;
        }
        return false;
    }

    public boolean blockJailedPlayerCommand(Player player, Resident resident, String command) {
        if (!resident.isJailed()) {
            return false;
        }
        if (this.blockedJailCommands.containsCommand(command)) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_you_cannot_use_that_command_while_jailed"));
            return true;
        }
        return false;
    }

    public boolean blockCommandInsideTown(Player player, Resident resident, TownBlock townBlock, String command) {
        Town town;
        if (!TownySettings.allowTownCommandBlacklisting()) {
            return false;
        }
        if (resident.hasPermissionNode(PermissionNodes.TOWNY_ADMIN_TOWN_COMMAND_BLACKLIST_BYPASS.getNode())) {
            return false;
        }
        Town town2 = town = townBlock == null ? null : townBlock.getTownOrNull();
        if (town != null && town.hasActiveWar() && this.blockedWarCommands.containsCommand(command)) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_command_war_blocked"));
            return true;
        }
        if (this.blockedTownCommands.containsCommand(command) && this.blockedTouristCommands.containsCommand(command)) {
            if (town == null) {
                return false;
            }
            if (town.hasResident(resident) || resident.hasPermissionNode(PermissionNodes.TOWNY_ADMIN_TOURIST_COMMAND_LIMITATION_BYPASS.getNode()) || TownySettings.doTrustedResidentsBypassTownBlockedCommands() && town.hasTrustedResident(resident) || resident.hasTown() && TownySettings.doAlliesBypassTownBlockedCommands() && CombatUtil.isAlly(town, resident.getTownOrNull())) {
                return false;
            }
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_command_outsider_blocked", town.getName()));
            return true;
        }
        if (town != null && this.blockedTownCommands.containsCommand(command)) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_command_blocked_inside_towns"));
            return true;
        }
        if (this.ownPlotLimitedCommands.containsCommand(command)) {
            if (town == null) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_command_limited"));
                return true;
            }
            if (town.hasResident(player) && TownyUniverse.getInstance().getPermissionSource().hasOwnTownOverride(player, Material.DIRT, TownyPermission.ActionType.BUILD)) {
                return false;
            }
            Resident owner = townBlock.getResidentOrNull();
            if (owner != null) {
                if (!owner.getName().equals(player.getName())) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_command_limited"));
                    return true;
                }
            } else {
                if (town.hasResident(player) && TownyUniverse.getInstance().getPermissionSource().hasTownOwnedOverride(player, Material.DIRT, TownyPermission.ActionType.BUILD)) {
                    return false;
                }
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_command_limited"));
                return true;
            }
        }
        return false;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onAdminToolUseOnBlocks(PlayerInteractEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (event.getHand() == EquipmentSlot.OFF_HAND || !TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        if (event.hasItem() && event.getPlayer().getInventory().getItemInMainHand().getType().getKey().getKey().equalsIgnoreCase(TownySettings.getTool()) && this.plugin.hasPlayerMode(event.getPlayer(), "infotool") && TownyUniverse.getInstance().getPermissionSource().isTownyAdmin((Permissible)event.getPlayer()) && event.getClickedBlock() != null) {
            Player player = event.getPlayer();
            Block block = event.getClickedBlock();
            BlockState state = block.getState(false);
            BlockData data = state.getBlockData();
            if (ItemLists.SIGNS.contains(block.getType()) && data instanceof Rotatable) {
                Rotatable rotatable = (Rotatable)data;
                TownyMessaging.sendMessage((Object)player, Arrays.asList(ChatTools.formatTitle("Sign Info"), ChatTools.formatCommand("", "Sign Type", "", block.getType().name()), ChatTools.formatCommand("", "Facing", "", rotatable.getRotation().toString())));
            } else if (Tag.DOORS.isTagged((Keyed)block.getType())) {
                Door door = (Door)block.getBlockData();
                TownyMessaging.sendMessage((Object)player, Arrays.asList(ChatTools.formatTitle("Door Info"), ChatTools.formatCommand("", "Door Type", "", block.getType().getKey().toString()), ChatTools.formatCommand("", "hinged on ", "", String.valueOf(door.getHinge())), ChatTools.formatCommand("", "isOpen", "", String.valueOf(door.isOpen())), ChatTools.formatCommand("", "getFacing", "", door.getFacing().name())));
            } else {
                TownyMessaging.sendMessage((Object)player, Arrays.asList(ChatTools.formatTitle("Block Info"), ChatTools.formatCommand("", "Material", "", block.getType().getKey().toString()), ChatTools.formatCommand("", "MaterialData", "", block.getBlockData().getAsString())));
            }
            event.setUseInteractedBlock(Event.Result.DENY);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onAdminToolUseOnEntities(PlayerInteractEntityEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (event.getHand() == EquipmentSlot.OFF_HAND || !TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getRightClicked() != null && event.getPlayer().getInventory().getItemInMainHand().getType().getKey().getKey().equalsIgnoreCase(TownySettings.getTool()) && this.plugin.hasPlayerMode(event.getPlayer(), "infotool") && TownyUniverse.getInstance().getPermissionSource().isTownyAdmin((Permissible)event.getPlayer())) {
            Entity entity = event.getRightClicked();
            TownyMessaging.sendMessage((Object)event.getPlayer(), Arrays.asList(ChatTools.formatTitle("Entity Info"), ChatTools.formatCommand("", "Entity Class", "", entity.getType().getEntityClass().getSimpleName()), ChatTools.formatCommand("", "Entity Type", "", entity.getType().getKey().toString())));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onEggLand(PlayerEggThrowEvent event) {
        if (TownySettings.isItemUseMaterial(Material.EGG, event.getEgg().getLocation()) && !TownyActionEventExecutor.canItemuse(event.getPlayer(), event.getEgg().getLocation(), Material.EGG)) {
            event.setHatching(false);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerPickupItem(EntityPickupItemEvent event) {
        LivingEntity livingEntity;
        if (TownySettings.getRespawnProtectionAllowPickup() || !((livingEntity = event.getEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Resident resident = TownyAPI.getInstance().getResident(player);
        if (resident == null) {
            return;
        }
        if (resident.hasRespawnProtection()) {
            event.setCancelled(true);
            if (!resident.isRespawnPickupWarningShown()) {
                resident.setRespawnPickupWarningShown(true);
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_cannot_pickup_respawn_protection"));
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerChangeGameMode(PlayerGameModeChangeEvent event) {
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        Towny.getPlugin().deleteCache(event.getPlayer());
    }

    private void loadBlockedCommandLists() {
        this.blockedJailCommands = new CommandList(TownySettings.getJailBlacklistedCommands());
        this.blockedTouristCommands = new CommandList(TownySettings.getTouristBlockedCommands());
        this.blockedTownCommands = new CommandList(TownySettings.getTownBlacklistedCommands());
        this.blockedOutlawCommands = new CommandList(TownySettings.getOutlawBlacklistedCommands());
        this.blockedWarCommands = new CommandList(TownySettings.getWarBlacklistedCommands());
        this.ownPlotLimitedCommands = new CommandList(TownySettings.getPlayerOwnedPlotLimitedCommands());
    }

    private boolean isSignWaxed(Block block) {
        BlockState blockState;
        if (MinecraftVersion.CURRENT_VERSION.isOlderThan(MinecraftVersion.MINECRAFT_1_20) || !((blockState = block.getState(false)) instanceof Sign)) {
            return false;
        }
        Sign sign = (Sign)blockState;
        try {
            return sign.isWaxed();
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }
}

