/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.executors.TownyActionEventExecutor;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.utils.BorderUtil;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;

public class TownyWorldListener
implements Listener {
    private final Towny plugin;

    public TownyWorldListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onWorldLoad(WorldLoadEvent event) {
        this.newWorld(event.getWorld());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onWorldInit(WorldInitEvent event) {
        this.newWorld(event.getWorld());
    }

    private void newWorld(World world) {
        this.checkWorlds();
        if (TownyUniverse.getInstance().getWorldIDMap().containsKey(world.getUID())) {
            if (TownyUniverse.getInstance().getWorld(world.getUID()).getName().equalsIgnoreCase(world.getName())) {
                return;
            }
            if (!TownyUniverse.getInstance().getWorldIDMap().get(world.getUID()).getName().equalsIgnoreCase(world.getName())) {
                TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(world.getUID());
                TownyUniverse.getInstance().getWorldMap().remove(townyWorld.getName());
                TownyUniverse.getInstance().getWorldMap().put(world.getName(), townyWorld);
                townyWorld.setName(world.getName());
                townyWorld.save();
                return;
            }
        }
        TownyUniverse.getInstance().newWorld(world);
        TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(world.getUID());
        if (townyWorld == null) {
            TownyMessaging.sendErrorMsg("Could not create data for " + world.getName());
            return;
        }
        TownyUniverse.getInstance().getDataSource().loadWorld(townyWorld);
        if (world.getName().startsWith("DXL_") && Bukkit.getServer().getPluginManager().getPlugin("DungeonsXL") != null) {
            townyWorld.setUsingTowny(false);
            townyWorld.save();
        }
    }

    private void checkWorlds() {
        for (World world : Bukkit.getServer().getWorlds()) {
            TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(world.getName());
            if (townyWorld == null || townyWorld.getUUID() != null) continue;
            townyWorld.setUUID(world.getUID());
            townyWorld.save();
            TownyUniverse.getInstance().getWorldIDMap().putIfAbsent(world.getUID(), townyWorld);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onLightningStrike(LightningStrikeEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (event.getCause().equals((Object)LightningStrikeEvent.Cause.TRIDENT) && event.getLightning().getCausingEntity() != null) {
            return;
        }
        TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(event.getWorld());
        if (townyWorld == null || !townyWorld.isUsingTowny()) {
            return;
        }
        if (event.getCause().equals((Object)LightningStrikeEvent.Cause.TRIDENT)) {
            townyWorld.addTridentStrike(event.getLightning().getUniqueId());
            this.plugin.getScheduler().runLater(event.getLightning().getLocation(), () -> townyWorld.removeTridentStrike(event.getLightning().getUniqueId()), 20L);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onStructureGrow(StructureGrowEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getWorld())) {
            return;
        }
        List<BlockState> disallowed = BorderUtil.disallowedBlocks(event.getBlocks(), event.getLocation().getBlock(), event.getPlayer());
        if (!disallowed.isEmpty()) {
            event.getBlocks().removeAll(disallowed);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPortalCreate(PortalCreateEvent event) {
        Object object;
        if (event.getReason() != PortalCreateEvent.CreateReason.NETHER_PAIR || !TownyAPI.getInstance().isTownyWorld(event.getWorld()) || !((object = event.getEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)object;
        for (BlockState block : event.getBlocks()) {
            if (TownyActionEventExecutor.canBuild(player, block.getLocation(), Material.NETHER_PORTAL)) continue;
            TownyMessaging.sendErrorMsg((CommandSender)event.getEntity(), Translatable.of("msg_err_you_are_not_allowed_to_create_the_other_side_of_this_portal"));
            event.setCancelled(true);
            break;
        }
    }
}

