/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRegistryList<T extends Keyed> {
    private final Registry<T> registry;
    protected final Set<T> tagged = new HashSet<T>();

    public AbstractRegistryList(@NotNull Registry<T> registry, @NotNull Collection<T> collection) {
        this.registry = registry;
        this.tagged.addAll(collection);
    }

    public boolean contains(@NotNull T element) {
        return this.tagged.contains(element);
    }

    public boolean contains(@NotNull NamespacedKey key) {
        Keyed element = this.registry.get(key);
        return element != null && this.contains(element);
    }

    public boolean contains(@NotNull String element) {
        if (element.isEmpty()) {
            return false;
        }
        T matched = BukkitTools.matchRegistry(this.registry, element);
        return matched != null && this.contains(matched);
    }

    protected Collection<T> tagged() {
        return this.tagged;
    }

    public static class Builder<T extends Keyed, F extends AbstractRegistryList<T>> {
        private final Registry<T> registry;
        private final Class<T> clazz;
        private final Function<Collection<T>, F> convertFunction;
        private final Set<Predicate<T>> allMatchPredicates = new HashSet<Predicate<T>>();
        private final Set<Predicate<T>> anyMatchPredicates = new HashSet<Predicate<T>>();

        public Builder(Registry<T> registry, Class<T> clazz, Function<Collection<T>, F> function) {
            this.registry = registry;
            this.clazz = clazz;
            this.convertFunction = function;
        }

        public F build() {
            HashSet<Keyed> matches = new HashSet<Keyed>();
            if (!this.allMatchPredicates.isEmpty() || !this.anyMatchPredicates.isEmpty()) {
                for (Keyed element : this.registry) {
                    if (!this.allMatchPredicates.stream().allMatch(predicate -> predicate.test(element)) || !this.anyMatchPredicates.isEmpty() && !this.anyMatchPredicates.stream().anyMatch(predicate -> predicate.test(element))) continue;
                    matches.add(element);
                }
            }
            return (F)((AbstractRegistryList)this.convertFunction.apply(matches));
        }

        public Builder<T, F> startsWith(String startingWith) {
            this.anyMatchPredicates.add(s -> s.getKey().getKey().regionMatches(true, 0, startingWith, 0, startingWith.length()));
            return this;
        }

        public Builder<T, F> endsWith(@NotNull String endingWith) {
            String endingWithLower = endingWith.toLowerCase(Locale.ROOT);
            this.anyMatchPredicates.add(s -> s.getKey().getKey().endsWith(endingWithLower));
            return this;
        }

        public Builder<T, F> not(@NotNull String name) {
            this.allMatchPredicates.add(s -> !s.getKey().getKey().equalsIgnoreCase(name));
            return this;
        }

        public Builder<T, F> notStartsWith(@NotNull String notStartingWith) {
            this.allMatchPredicates.add(s -> !s.getKey().getKey().regionMatches(true, 0, notStartingWith, 0, notStartingWith.length()));
            return this;
        }

        public Builder<T, F> notEndsWith(@NotNull String notEndingWith) {
            String notEndingLower = notEndingWith.toLowerCase(Locale.ROOT);
            this.allMatchPredicates.add(s -> !s.getKey().getKey().endsWith(notEndingLower));
            return this;
        }

        public Builder<T, F> contains(@NotNull String containing) {
            String containingLower = containing.toLowerCase(Locale.ROOT);
            this.allMatchPredicates.add(s -> s.getKey().getKey().contains(containingLower));
            return this;
        }

        public Builder<T, F> notContains(@NotNull String notContaining) {
            String notContainingLower = notContaining.toLowerCase(Locale.ROOT);
            this.allMatchPredicates.add(s -> !s.getKey().getKey().contains(notContainingLower));
            return this;
        }

        public Builder<T, F> withTag(@NotNull String registry, @NotNull NamespacedKey key) {
            Tag tag = Bukkit.getServer().getTag(registry, key, this.clazz);
            if (tag != null) {
                this.anyMatchPredicates.add(arg_0 -> ((Tag)tag).isTagged(arg_0));
            }
            return this;
        }

        public Builder<T, F> excludeTag(@NotNull String registry, @NotNull NamespacedKey key) {
            Tag tag = Bukkit.getServer().getTag(registry, key, this.clazz);
            if (tag != null) {
                this.allMatchPredicates.add(s -> !tag.isTagged(s));
            }
            return this;
        }

        public Builder<T, F> add(String ... names) {
            for (String name : names) {
                Object match = BukkitTools.matchRegistry(this.registry, name);
                if (match != null) {
                    this.anyMatchPredicates.add(t -> t.equals(match));
                    continue;
                }
                try {
                    TownyMessaging.sendDebugMsg("Expected element with name '" + name + "' was not found in the " + this.clazz.getSimpleName() + " registry.");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.anyMatchPredicates.add(t -> false);
            }
            return this;
        }

        public Builder<T, F> includeList(@NotNull AbstractRegistryList<T> list) {
            for (Keyed element : list.tagged) {
                this.anyMatchPredicates.add(t -> t.equals((Object)element));
            }
            return this;
        }

        public Builder<T, F> filter(@NotNull Predicate<T> predicate) {
            this.allMatchPredicates.add(predicate);
            return this;
        }

        public Builder<T, F> conditionally(@NotNull BooleanSupplier supplier, @NotNull Consumer<Builder<T, F>> consumer) {
            if (supplier.getAsBoolean()) {
                consumer.accept(this);
            }
            return this;
        }
    }
}

