/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyCommandAddonAPI;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.util.StringMgmt;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddonCommand
extends Command {
    private TownyCommandAddonAPI.CommandType commandType;
    private String name;
    private CommandExecutor commandExecutor;
    private TabCompleter tabCompleter = new LegacyTabCompleter(this);
    private Map<Integer, List<String>> tabCompletions = new HashMap<Integer, List<String>>();

    public AddonCommand(TownyCommandAddonAPI.CommandType commandType, String name, CommandExecutor commandExecutor) {
        super(name);
        this.commandType = commandType;
        this.name = name;
        this.commandExecutor = commandExecutor;
        if (commandExecutor instanceof TabCompleter) {
            TabCompleter tabCompleter;
            this.tabCompleter = tabCompleter = (TabCompleter)commandExecutor;
        }
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        return this.execute(sender, args);
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String[] args) {
        return this.commandExecutor.onCommand(sender, (Command)this, this.name, StringMgmt.remFirstArg(args));
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String[] args, TownyObject object) {
        return this.commandExecutor.onCommand(sender, (Command)this, this.name, args);
    }

    public TownyCommandAddonAPI.CommandType getCommandType() {
        return this.commandType;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public TabCompleter getTabCompleter() {
        return this.tabCompleter;
    }

    public Map<Integer, List<String>> getTabCompletions() {
        return this.tabCompletions;
    }

    public void setCommandType(TownyCommandAddonAPI.CommandType commandType) {
        this.commandType = commandType;
    }

    public boolean setName(@NotNull String name) {
        this.name = name;
        return super.setName(name);
    }

    public void setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        if (commandExecutor instanceof TabCompleter) {
            TabCompleter tabCompleter;
            this.tabCompleter = tabCompleter = (TabCompleter)commandExecutor;
        }
    }

    public void setTabCompleter(@Nullable TabCompleter tabCompleter) {
        this.tabCompleter = tabCompleter == null ? new LegacyTabCompleter(this) : tabCompleter;
    }

    public void setTabCompletions(Map<Integer, List<String>> tabCompletions) {
        this.tabCompletions = tabCompletions;
    }

    public void setTabCompletion(int index, List<String> completions) {
        this.tabCompletions.put(index, completions);
    }

    public List<String> getTabCompletion(CommandSender sender, String[] args) {
        return this.tabCompleter.onTabComplete(sender, (Command)this, this.name, StringMgmt.remFirstArg(args));
    }

    private static int getPrecedingArguments(TownyCommandAddonAPI.CommandType type) {
        if (type.equals((Object)TownyCommandAddonAPI.CommandType.TOWNYADMIN_NATION) || type.equals((Object)TownyCommandAddonAPI.CommandType.TOWNYADMIN_TOWN)) {
            return 2;
        }
        return 1;
    }

    private record LegacyTabCompleter(AddonCommand command) implements TabCompleter
    {
        public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
            int precedingArgs = AddonCommand.getPrecedingArguments(this.command().getCommandType());
            return this.command().tabCompletions.get(args.length - precedingArgs) == null ? Collections.emptyList() : this.command().tabCompletions.get(args.length - precedingArgs);
        }
    }
}

