/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.util.DrawUtil;
import java.util.Arrays;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.World;

public class CellBorder
extends WorldCoord {
    public boolean[] border;

    public CellBorder(WorldCoord worldCoord, boolean[] border) {
        super(worldCoord);
        this.border = border;
    }

    public void setBorderAt(Section s, boolean b) {
        this.border[s.ordinal()] = b;
    }

    public boolean hasBorderAt(Section s) {
        return this.border[s.ordinal()];
    }

    public boolean[] getBorder() {
        return this.border;
    }

    public boolean hasAnyBorder() {
        for (boolean b : this.border) {
            if (!b) continue;
            return true;
        }
        return false;
    }

    public int getBlockX() {
        return this.getX() * CellBorder.getCellSize();
    }

    public int getBlockZ() {
        return this.getZ() * CellBorder.getCellSize();
    }

    public void runBorderedOnSurface(int wallHeight, int cornerHeight, Consumer<Location> locationConsumer) {
        int x = this.getBlockX();
        int z = this.getBlockZ();
        int w = Coord.getCellSize() - 1;
        World world = this.getBukkitWorld();
        block10: for (Section section : Section.values()) {
            if (!this.border[section.ordinal()] || (section.getType() != Section.Type.WALL || wallHeight <= 0) && (section.getType() != Section.Type.CORNER || cornerHeight <= 0)) continue;
            switch (section.ordinal()) {
                case 0: {
                    DrawUtil.runOnSurface(world, x, z, x, z + w, wallHeight, locationConsumer);
                    continue block10;
                }
                case 1: {
                    DrawUtil.runOnSurface(world, x, z, x, z, cornerHeight, locationConsumer);
                    continue block10;
                }
                case 2: {
                    DrawUtil.runOnSurface(world, x, z, x + w, z, wallHeight, locationConsumer);
                    continue block10;
                }
                case 3: {
                    DrawUtil.runOnSurface(world, x + w, z, x + w, z, cornerHeight, locationConsumer);
                    continue block10;
                }
                case 4: {
                    DrawUtil.runOnSurface(world, x + w, z, x + w, z + w, wallHeight, locationConsumer);
                    continue block10;
                }
                case 5: {
                    DrawUtil.runOnSurface(world, x + w, z + w, x + w, z + w, cornerHeight, locationConsumer);
                    continue block10;
                }
                case 6: {
                    DrawUtil.runOnSurface(world, x, z + w, x + w, z + w, wallHeight, locationConsumer);
                    continue block10;
                }
                case 7: {
                    DrawUtil.runOnSurface(world, x, z + w, x, z + w, cornerHeight, locationConsumer);
                    continue block10;
                }
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + Arrays.toString(this.getBorder());
    }

    public static enum Section {
        N(Type.WALL),
        NE(Type.CORNER),
        E(Type.WALL),
        SE(Type.CORNER),
        S(Type.WALL),
        SW(Type.CORNER),
        W(Type.WALL),
        NW(Type.CORNER);

        private final Type type;

        private Section(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public static int numParts() {
            return Section.values().length;
        }

        public static enum Type {
            WALL,
            CORNER;

        }
    }
}

