/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.BorderUtil;
import com.palmergames.bukkit.util.BukkitParticle;
import com.palmergames.bukkit.util.DrawSmokeTaskFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Color;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;

public class CellSurface {
    private static final long PARTICLE_DELAY = 1L;
    private final Particle.DustOptions CLAIMING_PARTICLE = new Particle.DustOptions(Color.LIME, 2.0f);
    private final WorldCoord worldCoord;

    public CellSurface(WorldCoord worldCoord) {
        this.worldCoord = worldCoord;
    }

    public static CellSurface getCellSurface(WorldCoord worldCoord) {
        return new CellSurface(worldCoord);
    }

    public void runClaimingParticleOverSurfaceAtPlayer(Player player) {
        World world = this.worldCoord.getBukkitWorld();
        if (world == null) {
            return;
        }
        Map<Integer, Set<BlockPos>> toRender = this.mapRingsOfClaimParticles(this.getX(player.getLocation()), this.getZ(player.getLocation()));
        toRender.forEach((key, value) -> value.forEach(pos -> Towny.getPlugin().getScheduler().runLater((Entity)player, () -> this.drawClaimingParticleOnTopOfBlock(player, world, pos.x, pos.z), (long)key.intValue() * 1L)));
        long finalDelay = (long)toRender.keySet().size() + 1L;
        Towny.getPlugin().getScheduler().runLater((Entity)player, () -> BorderUtil.getPlotBorder(this.worldCoord).runBorderedOnSurface(2, 2, DrawSmokeTaskFactory.showToPlayer(player, Color.GREEN)), finalDelay);
    }

    private Map<Integer, Set<BlockPos>> mapRingsOfClaimParticles(int startingX, int startingZ) {
        HashSet<BlockPos> traveled = new HashSet<BlockPos>();
        HashMap<Integer, Set<BlockPos>> toRender = new HashMap<Integer, Set<BlockPos>>();
        HashSet<BlockPos> localRing = new HashSet<BlockPos>();
        int maxRadius = TownySettings.getTownBlockSize();
        BoundingBox worldCoordBB = this.worldCoord.getBoundingBox();
        for (int ringNum = 1; ringNum <= maxRadius; ++ringNum) {
            for (int x = startingX + Math.negateExact(ringNum); x <= startingX + ringNum; ++x) {
                for (int z = startingZ + Math.negateExact(ringNum); z <= startingZ + ringNum; ++z) {
                    BlockPos pos = new BlockPos(x, z);
                    if (traveled.contains(pos)) continue;
                    traveled.add(pos);
                    if (!worldCoordBB.contains((double)x, 1.0, (double)z)) continue;
                    localRing.add(pos);
                }
            }
            if (localRing.isEmpty()) break;
            toRender.put(ringNum, new HashSet(localRing));
            localRing.clear();
        }
        return toRender;
    }

    private void drawClaimingParticleOnTopOfBlock(Player player, World world, int x, int z) {
        Location loc = this.getParticleLocation(world, x, z);
        Towny.getPlugin().getScheduler().runAsync(() -> player.spawnParticle(BukkitParticle.getBorderParticle(), loc, 5, (Object)this.CLAIMING_PARTICLE));
    }

    private Location getParticleLocation(World world, int x, int z) {
        return new Location(world, (double)x, (double)world.getHighestBlockYAt(x, z, HeightMap.MOTION_BLOCKING_NO_LEAVES), (double)z).add(0.5, 0.95, 0.5);
    }

    private int getX(Location playerLoc) {
        if (WorldCoord.parseWorldCoord(playerLoc).equals(this.worldCoord)) {
            return playerLoc.getBlockX();
        }
        return this.findSuitableXorZ(playerLoc.getBlockX(), this.worldCoord.getBoundingBox().getMaxX(), this.worldCoord.getBoundingBox().getMinX());
    }

    private int getZ(Location playerLoc) {
        if (WorldCoord.parseWorldCoord(playerLoc).equals(this.worldCoord)) {
            return playerLoc.getBlockZ();
        }
        return this.findSuitableXorZ(playerLoc.getBlockZ(), this.worldCoord.getBoundingBox().getMaxZ(), this.worldCoord.getBoundingBox().getMinZ());
    }

    private int findSuitableXorZ(int player, double max, double min) {
        return (int)Math.max(Math.min((double)player, max), min);
    }

    private record BlockPos(int x, int z) {
    }
}

