/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.Nameable;
import com.palmergames.bukkit.towny.object.ObjectGroup;
import com.palmergames.bukkit.towny.object.Savable;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class District
extends ObjectGroup
implements Nameable,
Savable {
    private List<TownBlock> townBlocks;
    private Town town;

    public District(UUID id, String name, Town town) {
        super(id, name);
        this.town = town;
    }

    @Override
    public String toString() {
        return super.toString() + "," + this.getTown().toString();
    }

    @Override
    public boolean exists() {
        return this.town != null && this.town.exists() && this.town.hasDistrictName(this.getName());
    }

    @Override
    public void setName(String name) {
        if (this.getName() == null) {
            super.setName(name);
        } else {
            String oldName = this.getName();
            super.setName(name);
            this.town.renameDistrict(oldName, this);
        }
    }

    public void setTown(Town town) {
        this.town = town;
        try {
            town.addDistrict(this);
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg(e.getMessage());
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.town, this.townBlocks, this.getName());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        District other = (District)obj;
        return Objects.equals(this.town, other.town) && Objects.equals(this.getName(), other.getName());
    }

    public Town getTown() {
        return this.town;
    }

    public String toModeString() {
        return "District{" + this.toString() + "}";
    }

    public void addTownBlock(TownBlock townBlock) {
        if (this.townBlocks == null) {
            this.townBlocks = new ArrayList<TownBlock>();
        }
        this.townBlocks.add(townBlock);
    }

    public void removeTownBlock(TownBlock townBlock) {
        if (this.townBlocks != null) {
            this.townBlocks.remove(townBlock);
        }
    }

    public void setTownblocks(List<TownBlock> townBlocks) {
        this.townBlocks = townBlocks;
    }

    public Collection<TownBlock> getTownBlocks() {
        return Collections.unmodifiableCollection(this.townBlocks);
    }

    public boolean hasTownBlocks() {
        return this.townBlocks != null && !this.townBlocks.isEmpty();
    }

    public boolean hasTownBlock(TownBlock townBlock) {
        return this.townBlocks.contains(townBlock);
    }

    @Override
    public void save() {
        TownyUniverse.getInstance().getDataSource().saveDistrict(this);
    }
}

