/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.WorldCoord;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlayerCache {
    private final Map<Material, Boolean> buildMatPermission = new HashMap<Material, Boolean>();
    private final Map<Material, Boolean> destroyMatPermission = new HashMap<Material, Boolean>();
    private final Map<Material, Boolean> switchMatPermission = new HashMap<Material, Boolean>();
    private final Map<Material, Boolean> itemUseMatPermission = new HashMap<Material, Boolean>();
    private WorldCoord lastWorldCoord;
    private String blockErrMsg;
    private TownBlockStatus townBlockStatus = TownBlockStatus.UNKNOWN;

    public PlayerCache(Player player) {
        this.lastWorldCoord = WorldCoord.parseWorldCoord((Entity)player);
    }

    public void setLastTownBlock(@NotNull WorldCoord worldCoord) {
        this.lastWorldCoord = worldCoord;
    }

    public void resetAndUpdate(@NotNull WorldCoord worldCoord) {
        this.reset(worldCoord);
    }

    @NotNull
    public WorldCoord getLastTownBlock() {
        return this.lastWorldCoord;
    }

    public boolean updateCoord(@NotNull WorldCoord pos) {
        if (!this.getLastTownBlock().equals(pos)) {
            this.reset(pos);
            return true;
        }
        return false;
    }

    public boolean getCachePermission(Material material, TownyPermission.ActionType action) throws NullPointerException {
        return switch (action) {
            default -> throw new IncompatibleClassChangeError();
            case TownyPermission.ActionType.BUILD -> this.getBlockPermission(this.buildMatPermission, material);
            case TownyPermission.ActionType.DESTROY -> this.getBlockPermission(this.destroyMatPermission, material);
            case TownyPermission.ActionType.SWITCH -> this.getBlockPermission(this.switchMatPermission, material);
            case TownyPermission.ActionType.ITEM_USE -> this.getBlockPermission(this.itemUseMatPermission, material);
        };
    }

    public void setBuildPermission(Material material, Boolean value) {
        this.updateMaps(this.buildMatPermission, material, value);
    }

    public void setDestroyPermission(Material material, Boolean value) {
        this.updateMaps(this.destroyMatPermission, material, value);
    }

    public void setSwitchPermission(Material material, Boolean value) {
        this.updateMaps(this.switchMatPermission, material, value);
    }

    public void setItemUsePermission(Material material, Boolean value) {
        this.updateMaps(this.itemUseMatPermission, material, value);
    }

    public boolean getBuildPermission(Material material) throws NullPointerException {
        return this.getBlockPermission(this.buildMatPermission, material);
    }

    public boolean getDestroyPermission(Material material) throws NullPointerException {
        return this.getBlockPermission(this.destroyMatPermission, material);
    }

    public boolean getSwitchPermission(Material material) throws NullPointerException {
        return this.getBlockPermission(this.switchMatPermission, material);
    }

    public boolean getItemUsePermission(Material material) throws NullPointerException {
        return this.getBlockPermission(this.itemUseMatPermission, material);
    }

    private void updateMaps(Map<Material, Boolean> blockMap, Material material, Boolean value) {
        blockMap.putIfAbsent(material, value);
    }

    private boolean getBlockPermission(Map<Material, Boolean> blockMap, Material material) throws NullPointerException {
        return blockMap.get(material);
    }

    private void reset(WorldCoord wc) {
        this.lastWorldCoord = wc;
        this.townBlockStatus = null;
        this.blockErrMsg = null;
        this.buildMatPermission.clear();
        this.destroyMatPermission.clear();
        this.switchMatPermission.clear();
        this.itemUseMatPermission.clear();
    }

    public void setStatus(TownBlockStatus townBlockStatus) {
        this.townBlockStatus = townBlockStatus;
    }

    public TownBlockStatus getStatus() throws NullPointerException {
        if (this.townBlockStatus == null) {
            throw new NullPointerException();
        }
        return this.townBlockStatus;
    }

    public void setBlockErrMsg(String blockErrMsg) {
        this.blockErrMsg = blockErrMsg;
    }

    public String getBlockErrMsg() {
        String temp = this.blockErrMsg;
        this.setBlockErrMsg(null);
        return temp;
    }

    public boolean hasBlockErrMsg() {
        return this.blockErrMsg != null;
    }

    public static enum TownBlockStatus {
        UNKNOWN,
        NOT_REGISTERED,
        OFF_WORLD,
        ADMIN,
        UNCLAIMED_ZONE,
        NATION_ZONE,
        WARZONE,
        OUTSIDER,
        PLOT_OWNER,
        PLOT_FRIEND,
        PLOT_TOWN,
        PLOT_ALLY,
        TOWN_OWNER,
        TOWN_RESIDENT,
        TOWN_ALLY,
        TOWN_NATION,
        ENEMY,
        TOWN_TRUSTED,
        PLOT_TRUSTED;

    }
}

