/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.google.common.base.Preconditions;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.NumberConversions;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class Position {
    private final TownyWorld world;
    private final double x;
    private final double y;
    private final double z;
    private final float pitch;
    private final float yaw;

    @ApiStatus.Internal
    protected Position(TownyWorld world, double x, double y, double z, float pitch, float yaw) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = pitch;
        this.yaw = yaw;
    }

    public TownyWorld world() {
        return this.world;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public float pitch() {
        return this.pitch;
    }

    public float yaw() {
        return this.yaw;
    }

    public int blockX() {
        return NumberConversions.floor((double)this.x);
    }

    public int blockY() {
        return NumberConversions.floor((double)this.y);
    }

    public int blockZ() {
        return NumberConversions.floor((double)this.z);
    }

    public WorldCoord worldCoord() {
        return new WorldCoord(this.world.getName(), this.world.getUUID(), Coord.toCell(this.blockX()), Coord.toCell(this.blockZ()));
    }

    public static Position positionOf(@NotNull TownyWorld world, double x, double y, double z) {
        return Position.positionOf(world, x, y, z, 0.0f, 0.0f);
    }

    public static Position positionOf(@NotNull TownyWorld world, double x, double y, double z, float pitch, float yaw) {
        Preconditions.checkNotNull((Object)world, (Object)"world cannot be null");
        return new Position(world, x, y, z, pitch, yaw);
    }

    @NotNull
    public Location asLocation() {
        return new Location(this.world.getBukkitWorld(), this.x, this.y, this.z, this.yaw, this.pitch);
    }

    @NotNull
    public Position blockPosition() {
        return new Position(this.world, this.blockX(), this.blockY(), this.blockZ(), 0.0f, 0.0f);
    }

    public static Position ofLocation(@NotNull Location location) {
        Preconditions.checkNotNull((Object)location, (Object)"location cannot be null");
        World bukkitWorld = location.getWorld();
        if (bukkitWorld == null) {
            throw new IllegalArgumentException("Cannot instantiate position for a location with no associated bukkit world.");
        }
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(bukkitWorld);
        if (world == null) {
            throw new IllegalArgumentException("Could not find towny world for world " + bukkitWorld.getName() + ".");
        }
        return new Position(world, location.getX(), location.getY(), location.getZ(), location.getPitch(), location.getYaw());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Position)) {
            return false;
        }
        Position position = (Position)o;
        if (Double.compare(position.x, this.x) != 0) {
            return false;
        }
        if (Double.compare(position.y, this.y) != 0) {
            return false;
        }
        if (Double.compare(position.z, this.z) != 0) {
            return false;
        }
        if (Float.compare(position.pitch, this.pitch) != 0) {
            return false;
        }
        if (Float.compare(position.yaw, this.yaw) != 0) {
            return false;
        }
        return this.world.getName().equals(position.world.getName());
    }

    public int hashCode() {
        int result = this.world.hashCode();
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.pitch != 0.0f ? Float.floatToIntBits(this.pitch) : 0);
        result = 31 * result + (this.yaw != 0.0f ? Float.floatToIntBits(this.yaw) : 0);
        return result;
    }

    @NotNull
    public String[] serialize() {
        String[] data = new String[]{this.world.getName(), String.valueOf(this.x), String.valueOf(this.y), String.valueOf(this.z), String.valueOf(this.pitch), String.valueOf(this.yaw)};
        return data;
    }

    public static Position deserialize(@NotNull String[] data) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)data, (Object)"data cannot be null");
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(data[0]);
        if (world == null) {
            throw new IllegalArgumentException("World '" + data[0] + "' is not recognized by towny.");
        }
        double x = NumberConversions.toDouble((Object)data[1]);
        double y = NumberConversions.toDouble((Object)data[2]);
        double z = NumberConversions.toDouble((Object)data[3]);
        float pitch = 0.0f;
        float yaw = 0.0f;
        if (data.length == 6) {
            pitch = NumberConversions.toFloat((Object)data[4]);
            yaw = NumberConversions.toFloat((Object)data[5]);
        }
        return new Position(world, x, y, z, pitch, yaw);
    }
}

