/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.google.common.base.Preconditions;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.event.DeleteTownEvent;
import com.palmergames.bukkit.towny.event.TownAddResidentEvent;
import com.palmergames.bukkit.towny.event.TownRemoveResidentEvent;
import com.palmergames.bukkit.towny.event.TownyObjectFormattedNameEvent;
import com.palmergames.bukkit.towny.event.town.TownPreRemoveResidentEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.invites.InviteReceiver;
import com.palmergames.bukkit.towny.invites.exceptions.TooManyInvitesException;
import com.palmergames.bukkit.towny.object.EconomyAccount;
import com.palmergames.bukkit.towny.object.EconomyHandler;
import com.palmergames.bukkit.towny.object.Identifiable;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.TeleportRequest;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.towny.object.gui.SelectionGUI;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.object.metadata.BooleanDataField;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.object.resident.mode.ResidentModeHandler;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.scheduling.ScheduledTask;
import com.palmergames.bukkit.towny.tasks.TeleportWarmupTimerTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.MetaDataUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Resident
extends TownyObject
implements InviteReceiver,
EconomyHandler,
TownBlockOwner,
Identifiable,
ForwardingAudience.Single {
    private List<Resident> friends = new ArrayList<Resident>();
    private UUID uuid = null;
    private Town town = null;
    private long lastOnline;
    private long registered;
    private long joinedTownAt;
    private boolean isNPC = false;
    private String title = "";
    private String surname = "";
    private String about = TownySettings.getDefaultResidentAbout();
    private transient Confirmation confirmation;
    private final transient List<Invite> receivedInvites = new ArrayList<Invite>();
    private transient EconomyAccount account;
    private Jail jail = null;
    private int jailCell;
    private int jailHours;
    private double jailBail;
    private final List<String> townRanks = new ArrayList<String>();
    private final List<String> nationRanks = new ArrayList<String>();
    private List<TownBlock> townBlocks = new ArrayList<TownBlock>();
    private final TownyPermission permissions = new TownyPermission();
    private ArrayList<Inventory> guiPages;
    private int guiPageNum = 0;
    private SelectionGUI.SelectionType guiSelectionType;
    private ScheduledTask respawnProtectionTask = null;
    private boolean respawnPickupWarningShown = false;
    private String plotGroupName = null;
    private String districtName = null;
    protected CachedTaxOwing cachedTaxOwing = null;

    public Resident(String name) {
        super(name);
        this.permissions.loadDefault(this);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Resident)) {
            return false;
        }
        Resident otherResident = (Resident)other;
        return this.getName().equals(otherResident.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getUUID(), this.getName());
    }

    public void setLastOnline(long lastOnline) {
        this.lastOnline = lastOnline;
    }

    public long getLastOnline() {
        return this.lastOnline;
    }

    public void setNPC(boolean isNPC) {
        this.isNPC = isNPC;
    }

    public boolean isNPC() {
        return this.isNPC;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public boolean hasUUID() {
        return this.uuid != null;
    }

    public Jail getJail() {
        return this.jail;
    }

    public void setJail(Jail jail) {
        this.jail = jail;
    }

    public boolean isJailed() {
        return this.jail != null;
    }

    public int getJailCell() {
        return this.jailCell;
    }

    public void setJailCell(int i) {
        this.jailCell = this.jail.hasJailCell(i) ? i : 0;
    }

    public Town getJailTown() {
        return this.jail.getTown();
    }

    public boolean hasJailTown(String jailtown) {
        return this.getJailTown().getName().equalsIgnoreCase(jailtown);
    }

    public int getJailHours() {
        return this.jailHours;
    }

    public void setJailHours(Integer hours) {
        this.jailHours = hours;
    }

    public double getJailBailCost() {
        return this.jailBail;
    }

    public void setJailBailCost(double bail) {
        this.jailBail = bail;
    }

    public boolean hasJailTime() {
        return this.jailHours > 0;
    }

    public Location getJailSpawn() {
        return this.getJail().getJailCellLocations().get(this.getJailCell());
    }

    public String getPrimaryRankPrefix() {
        return TownyPerms.getResidentPrimaryRankPrefix(this);
    }

    public void setTitle(String title) {
        this.title = title.trim();
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasTitle() {
        return !this.title.isEmpty();
    }

    public void setSurname(String surname) {
        this.surname = surname.trim();
    }

    public String getSurname() {
        return this.surname;
    }

    public boolean hasSurname() {
        return !this.surname.isEmpty();
    }

    public void setAbout(@NotNull String about) {
        Preconditions.checkNotNull((Object)about, (Object)"about");
        this.about = about;
    }

    @NotNull
    public String getAbout() {
        return this.about;
    }

    public boolean isKing() {
        return this.hasNation() && this.town.getNationOrNull().isKing(this);
    }

    public boolean isMayor() {
        return this.hasTown() && this.town.isMayor(this);
    }

    public boolean hasTown() {
        return this.town != null;
    }

    public boolean hasNation() {
        return this.hasTown() && this.town.hasNation();
    }

    public Town getTown() throws NotRegisteredException {
        if (this.hasTown()) {
            return this.town;
        }
        throw new NotRegisteredException(Translation.of("msg_err_resident_doesnt_belong_to_any_town"));
    }

    @Nullable
    public Town getTownOrNull() {
        return this.town;
    }

    public void setTown(Town town) throws AlreadyRegisteredException {
        this.setTown(town, true);
    }

    public void setTown(Town town, boolean updateJoinedAt) throws AlreadyRegisteredException {
        if (this.town == town) {
            return;
        }
        Towny.getPlugin().deleteCache(this);
        this.setTitle("");
        this.setSurname("");
        if (town == null) {
            this.town = null;
            this.updatePerms();
            return;
        }
        if (this.hasTown()) {
            town.addResidentCheck(this);
        }
        this.town = town;
        this.updatePerms();
        town.addResident(this);
        if (updateJoinedAt) {
            this.setJoinedTownAt(System.currentTimeMillis());
            BukkitTools.fireEvent(new TownAddResidentEvent(this, town));
        }
    }

    public void removeTown() {
        this.removeTown(false);
    }

    public void removeTown(boolean townDeleted) {
        block6: {
            if (!this.hasTown()) {
                return;
            }
            Town town = this.town;
            BukkitTools.fireEvent(new TownPreRemoveResidentEvent(this, town));
            for (TownBlock townBlock : town.getTownBlocks()) {
                if (townBlock.getType() == TownBlockType.EMBASSY || !townBlock.hasResident(this) || !townBlock.removeResident()) continue;
                this.townBlocks.remove(townBlock);
                townBlock.setPlotPrice(town.getPlotPrice());
                townBlock.setType(townBlock.getType());
                townBlock.save();
            }
            BukkitTools.fireEvent(new TownRemoveResidentEvent(this, town));
            try {
                town.removeResident(this);
            }
            catch (EmptyTownException e) {
                if (townDeleted) break block6;
                TownyMessaging.sendMsg(Translatable.of("msg_town_being_deleted_because_no_residents", town.getName()));
                TownyUniverse.getInstance().getDataSource().removeTown(town, DeleteTownEvent.Cause.NO_RESIDENTS, null, false);
            }
        }
        try {
            this.setTown(null);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        this.save();
        Towny.getPlugin().resetCache();
    }

    public void setFriends(List<Resident> newFriends) {
        this.friends = newFriends;
    }

    public List<Resident> getFriends() {
        return Collections.unmodifiableList(this.friends);
    }

    public void removeFriend(Resident resident) {
        if (this.hasFriend(resident)) {
            this.friends.remove(resident);
        }
    }

    public boolean hasFriend(Resident resident) {
        return this.friends.contains(resident);
    }

    public void addFriend(Resident resident) {
        if (this.hasFriend(resident) || this.equals(resident) || resident.isNPC()) {
            return;
        }
        this.friends.add(resident);
    }

    public void removeAllFriends() {
        this.friends.clear();
    }

    public void updatePerms() {
        this.townRanks.clear();
        this.nationRanks.clear();
        TownyPerms.assignPermissions(this, null);
    }

    public void updatePermsForNationRemoval() {
        this.nationRanks.clear();
        TownyPerms.assignPermissions(this, null);
    }

    public void setRegistered(long registered) {
        this.registered = registered;
    }

    public long getRegistered() {
        return this.registered;
    }

    @Override
    public List<String> getTreeString(int depth) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.getTreeDepth(depth) + "Resident (" + this.getName() + ")");
        out.add(this.getTreeDepth(depth + 1) + "Registered: " + this.getRegistered());
        out.add(this.getTreeDepth(depth + 1) + "Last Online: " + this.getLastOnline());
        if (this.getFriends().size() > 0) {
            out.add(this.getTreeDepth(depth + 1) + "Friends (" + this.getFriends().size() + "): " + Arrays.toString(this.getFriends().toArray(new Resident[0])));
        }
        return out;
    }

    @ApiStatus.Obsolete
    public long getTeleportRequestTime() {
        TeleportRequest request = TeleportWarmupTimerTask.getTeleportRequest(this);
        return request == null ? -1L : request.requestTime();
    }

    @ApiStatus.Obsolete
    public Location getTeleportDestination() {
        TeleportRequest request = TeleportWarmupTimerTask.getTeleportRequest(this);
        return request == null ? null : request.destinationLocation();
    }

    @ApiStatus.Obsolete
    public int getTeleportCooldown() {
        TeleportRequest request = TeleportWarmupTimerTask.getTeleportRequest(this);
        return request == null ? -1 : request.cooldown();
    }

    public boolean hasRequestedTeleport() {
        return TeleportWarmupTimerTask.hasTeleportRequest(this);
    }

    @ApiStatus.Obsolete
    public double getTeleportCost() {
        TeleportRequest request = TeleportWarmupTimerTask.getTeleportRequest(this);
        return request == null ? 0.0 : request.teleportCost();
    }

    @ApiStatus.Obsolete
    public Account getTeleportAccount() {
        TeleportRequest request = TeleportWarmupTimerTask.getTeleportRequest(this);
        return request == null ? null : request.teleportAccount();
    }

    public boolean hasPermissionNode(String node) {
        return this.getPlayer() != null && TownyUniverse.getInstance().getPermissionSource().testPermission((Permissible)this.getPlayer(), node);
    }

    public boolean isAdmin() {
        return this.getPlayer() != null && TownyUniverse.getInstance().getPermissionSource().isTownyAdmin((Permissible)this.getPlayer());
    }

    public List<String> getModes() {
        return ResidentModeHandler.getResidentModesNames(this);
    }

    public boolean hasMode(String mode) {
        return this.getModes().contains(mode.toLowerCase(Locale.ROOT));
    }

    @Deprecated
    public void toggleMode(String[] newModes, boolean notify) {
        ResidentModeHandler.toggleModes(this, newModes, notify, false);
    }

    @Deprecated
    public void setModes(String[] modes, boolean notify) {
        ResidentModeHandler.toggleModes(this, modes, notify, false);
    }

    public void clearModes() {
        this.clearModes(true);
    }

    public void clearModes(boolean notify) {
        ResidentModeHandler.clearModes(this, notify);
    }

    public void resetModes(String[] modes, boolean notify) {
        ResidentModeHandler.resetModes(this, notify);
    }

    @Nullable
    public Player getPlayer() {
        return BukkitTools.getPlayerExact(this.getName());
    }

    public boolean addTownRank(String rank) {
        if (!this.hasTownRank(rank)) {
            this.townRanks.add(rank);
            if (this.isOnline()) {
                TownyPerms.assignPermissions(this, null);
            }
            return true;
        }
        return false;
    }

    public void setTownRanks(List<String> ranks) {
        for (String rank : ranks) {
            if ((rank = TownyPerms.matchTownRank(rank)) == null || this.hasTownRank(rank)) continue;
            this.townRanks.add(rank);
        }
    }

    public boolean hasTownRank(String rank) {
        if ((rank = TownyPerms.matchTownRank(rank)) != null) {
            for (String ownedRank : this.townRanks) {
                if (!ownedRank.equalsIgnoreCase(rank)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getTownRanks() {
        if (TownyPerms.ranksWithTownLevelRequirementPresent() && !this.townRanks.isEmpty() && this.hasTown()) {
            ArrayList<String> out = new ArrayList<String>();
            int townLevel = this.getTownOrNull().getLevelNumber();
            for (String rank : new ArrayList<String>(this.townRanks)) {
                int requiredTownLevelForRank = TownyPerms.getRankTownLevelReq(rank);
                if (requiredTownLevelForRank != 0 && townLevel < requiredTownLevelForRank) continue;
                out.add(rank);
            }
            return Collections.unmodifiableList(out);
        }
        return Collections.unmodifiableList(this.townRanks);
    }

    @ApiStatus.Internal
    public List<String> getTownRanksForSaving() {
        return Collections.unmodifiableList(this.townRanks);
    }

    public boolean removeTownRank(String rank) {
        if (this.hasTownRank(rank)) {
            this.townRanks.remove(rank);
            if (this.isOnline()) {
                TownyPerms.assignPermissions(this, null);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public String getHighestPriorityTownRank() {
        if (this.getTownRanks().isEmpty()) {
            return null;
        }
        return TownyPerms.getHighestPriorityRank(this, this.getTownRanks(), r -> TownyPerms.getTownRankPermissions(r));
    }

    public boolean addNationRank(String rank) {
        if (!this.hasNationRank(rank)) {
            this.nationRanks.add(rank);
            if (this.isOnline()) {
                TownyPerms.assignPermissions(this, null);
            }
            return true;
        }
        return false;
    }

    public void setNationRanks(List<String> ranks) {
        for (String rank : ranks) {
            if ((rank = TownyPerms.matchNationRank(rank)) == null || this.hasNationRank(rank)) continue;
            this.nationRanks.add(rank);
        }
    }

    public boolean hasNationRank(String rank) {
        if ((rank = TownyPerms.matchNationRank(rank)) != null) {
            for (String ownedRank : this.nationRanks) {
                if (!ownedRank.equalsIgnoreCase(rank)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getNationRanks() {
        if (TownyPerms.ranksWithNationLevelRequirementPresent() && !this.nationRanks.isEmpty() && this.hasNation()) {
            ArrayList<String> out = new ArrayList<String>();
            int nationLevel = this.getNationOrNull().getLevelNumber();
            for (String rank : new ArrayList<String>(this.nationRanks)) {
                int requiredNationLevelForRank = TownyPerms.getRankTownLevelReq(rank);
                if (requiredNationLevelForRank != 0 && nationLevel < requiredNationLevelForRank) continue;
                out.add(rank);
            }
            return Collections.unmodifiableList(out);
        }
        return Collections.unmodifiableList(this.nationRanks);
    }

    @ApiStatus.Internal
    public List<String> getNationRanksForSaving() {
        return Collections.unmodifiableList(this.nationRanks);
    }

    public boolean removeNationRank(String rank) {
        if (this.hasNationRank(rank)) {
            this.nationRanks.remove(rank);
            if (BukkitTools.isOnline(this.getName())) {
                TownyPerms.assignPermissions(this, null);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public String getHighestPriorityNationRank() {
        if (this.getNationRanks().isEmpty()) {
            return null;
        }
        return TownyPerms.getHighestPriorityRank(this, this.getNationRanks(), r -> TownyPerms.getNationRankPermissions(r));
    }

    public boolean isAlliedWith(Resident otherresident) {
        return CombatUtil.isAlly(this, otherresident);
    }

    public List<Invite> getReceivedInvites() {
        return Collections.unmodifiableList(this.receivedInvites);
    }

    @Override
    public void newReceivedInvite(Invite invite) throws TooManyInvitesException {
        if (this.receivedInvites.size() > InviteHandler.getReceivedInvitesMaxAmount(this) - 1) {
            throw new TooManyInvitesException(Translation.of("msg_err_player_has_too_many_invites", this.getName()));
        }
        this.receivedInvites.add(invite);
    }

    @Override
    public void deleteReceivedInvite(Invite invite) {
        this.receivedInvites.remove(invite);
    }

    @Override
    public void addMetaData(@NotNull CustomDataField<?> md) {
        this.addMetaData(md, true);
    }

    @Override
    public void removeMetaData(@NotNull CustomDataField<?> md) {
        this.removeMetaData(md, true);
    }

    @Override
    public Account getAccount() {
        if (this.account == null) {
            String accountName = StringMgmt.trimMaxLength(this.getName(), 32);
            UUID uuid = this.uuid;
            if (this.isNPC()) {
                uuid = TownyEconomyHandler.modifyNPCUUID(uuid);
            }
            this.account = new EconomyAccount(this, accountName, uuid, () -> {
                Player player = this.getPlayer();
                if (player != null) {
                    return TownyAPI.getInstance().getTownyWorld(player.getWorld());
                }
                return TownyUniverse.getInstance().getTownyWorlds().get(0);
            });
        }
        return this.account;
    }

    @Nullable
    public Account getAccountOrNull() {
        return this.account;
    }

    @Override
    public String getFormattedName() {
        String prefix = Colors.translateColorCodes((String)(this.hasTitle() ? this.getTitle() + " " : (this.isKing() && !TownySettings.getKingPrefix(this).isEmpty() ? TownySettings.getKingPrefix(this) : (this.isMayor() && !TownySettings.getMayorPrefix(this).isEmpty() ? TownySettings.getMayorPrefix(this) : ""))));
        String postfix = Colors.translateColorCodes((String)(this.hasSurname() ? " " + this.getSurname() : (this.isKing() && !TownySettings.getKingPostfix(this).isEmpty() ? TownySettings.getKingPostfix(this) : (this.isMayor() && !TownySettings.getMayorPostfix(this).isEmpty() ? TownySettings.getMayorPostfix(this) : ""))));
        TownyObjectFormattedNameEvent event = new TownyObjectFormattedNameEvent(this, prefix, postfix);
        BukkitTools.fireEvent(event);
        return event.getPrefix() + this.getName() + event.getPostfix();
    }

    public String getNamePrefix() {
        if (this.isKing()) {
            return TownySettings.getKingPrefix(this);
        }
        if (this.isMayor()) {
            return TownySettings.getMayorPrefix(this);
        }
        return "";
    }

    public String getNamePostfix() {
        if (this.isKing()) {
            return TownySettings.getKingPostfix(this);
        }
        if (this.isMayor()) {
            return TownySettings.getMayorPostfix(this);
        }
        return "";
    }

    public String getFormattedTitleName() {
        if (!this.hasTitle()) {
            return this.getFormattedName();
        }
        return this.getTitle() + " " + this.getName();
    }

    public void setTownblocks(Collection<TownBlock> townBlocks) {
        this.townBlocks = new ArrayList<TownBlock>(townBlocks);
    }

    @Override
    public Collection<TownBlock> getTownBlocks() {
        return Collections.unmodifiableCollection(this.townBlocks);
    }

    public List<Town> getTownsOutlawedIn() {
        return TownyUniverse.getInstance().getTowns().stream().filter(t -> t.hasOutlaw(this)).collect(Collectors.toList());
    }

    @Override
    public boolean hasTownBlock(TownBlock townBlock) {
        return this.townBlocks.contains(townBlock);
    }

    @Override
    public void addTownBlock(TownBlock townBlock) throws AlreadyRegisteredException {
        if (this.hasTownBlock(townBlock)) {
            throw new AlreadyRegisteredException();
        }
        this.townBlocks.add(townBlock);
    }

    @Override
    public void removeTownBlock(TownBlock townBlock) {
        this.townBlocks.remove(townBlock);
    }

    @Override
    public void setPermissions(String line) {
        this.permissions.load(line);
    }

    @Override
    public TownyPermission getPermissions() {
        return this.permissions;
    }

    public Confirmation getConfirmation() {
        return this.confirmation;
    }

    public void setConfirmation(Confirmation confirmation) {
        this.confirmation = confirmation;
    }

    public Inventory getGUIPage() {
        return this.guiPages.get(this.guiPageNum);
    }

    public ArrayList<Inventory> getGUIPages() {
        return this.guiPages;
    }

    public void setGUIPages(ArrayList<Inventory> inventory) {
        this.guiPages = inventory;
    }

    public int getGUIPageNum() {
        return this.guiPageNum;
    }

    public void setGUIPageNum(int currentInventoryPage) {
        this.guiPageNum = currentInventoryPage;
    }

    public SelectionGUI.SelectionType getGUISelectionType() {
        return this.guiSelectionType;
    }

    public void setGUISelectionType(SelectionGUI.SelectionType selectionType) {
        this.guiSelectionType = selectionType;
    }

    @Override
    public void save() {
        TownyUniverse.getInstance().getDataSource().saveResident(this);
    }

    public List<Town> getEmbassyTowns() {
        ArrayList<Town> townEmbassies = new ArrayList<Town>();
        for (TownBlock tB : this.getTownBlocks()) {
            Town town = tB.getTownOrNull();
            if (town == null || townEmbassies.contains(town) || town.hasResident(this)) continue;
            townEmbassies.add(town);
        }
        return townEmbassies;
    }

    public long getJoinedTownAt() {
        return this.joinedTownAt;
    }

    public void setJoinedTownAt(long joinedTownAt) {
        this.joinedTownAt = joinedTownAt;
    }

    public Nation getNation() throws TownyException {
        return this.getTown().getNation();
    }

    @Nullable
    public Nation getNationOrNull() {
        if (!this.hasNation()) {
            return null;
        }
        return this.getTownOrNull().getNationOrNull();
    }

    public boolean isOnline() {
        return BukkitTools.isOnline(this.getName());
    }

    public boolean hasRespawnProtection() {
        return this.respawnProtectionTask != null && !this.respawnProtectionTask.isCancelled();
    }

    public void addRespawnProtection(long protectionTime) {
        if (protectionTime <= 0L) {
            return;
        }
        if (this.respawnProtectionTask != null) {
            this.respawnProtectionTask.cancel();
        }
        this.respawnPickupWarningShown = false;
        this.respawnProtectionTask = Towny.getPlugin().getScheduler().runAsyncLater(this::removeRespawnProtection, protectionTime);
    }

    public void removeRespawnProtection() {
        if (this.respawnProtectionTask == null) {
            return;
        }
        this.respawnProtectionTask.cancel();
        this.respawnProtectionTask = null;
        TownyMessaging.sendMsg(this, Translatable.of("msg_you_have_lost_your_respawn_protection"));
    }

    public boolean isRespawnPickupWarningShown() {
        return this.respawnPickupWarningShown;
    }

    public void setRespawnPickupWarningShown(boolean respawnPickupWarningShown) {
        this.respawnPickupWarningShown = respawnPickupWarningShown;
    }

    @NotNull
    public Audience audience() {
        Player player = this.getPlayer();
        return player == null ? Audience.empty() : player;
    }

    public boolean isSeeingBorderTitles() {
        BooleanDataField borderMeta = new BooleanDataField("bordertitles");
        return !MetaDataUtil.hasMeta((TownyObject)this, borderMeta) || MetaDataUtil.getBoolean(this, borderMeta);
    }

    public boolean hasPlotGroupName() {
        return this.plotGroupName != null;
    }

    public String getPlotGroupName() {
        return this.plotGroupName;
    }

    public void setPlotGroupName(String plotGroupName) {
        this.plotGroupName = plotGroupName;
    }

    public boolean hasDistrictName() {
        return this.districtName != null;
    }

    public String getDistrictName() {
        return this.districtName;
    }

    public void setDistrictName(String districtName) {
        this.districtName = districtName;
    }

    @Override
    @ApiStatus.Internal
    public boolean exists() {
        return TownyUniverse.getInstance().hasResident(this.getName());
    }

    public double getTaxOwing(boolean useCache) {
        Town town;
        if (useCache) {
            return this.getCachedTaxOwing();
        }
        boolean taxExempt = this.hasPermissionNode("towny.tax_exempt");
        double plotTax = 0.0;
        double townTax = 0.0;
        if (this.hasTown() && !taxExempt) {
            town = this.getTownOrNull();
            townTax = town.getTaxes();
            if (town.isTaxPercentage()) {
                townTax = Math.min(this.getAccount().getHoldingBalance() * townTax / 100.0, town.getMaxPercentTaxAmount());
            }
        }
        if (this.getTownBlocks().size() > 0) {
            for (TownBlock townBlock : new ArrayList<TownBlock>(this.getTownBlocks())) {
                town = townBlock.getTownOrNull();
                if (town == null || taxExempt && town.hasResident(this)) continue;
                plotTax += townBlock.getType().getTax(town);
            }
        }
        return plotTax + townTax;
    }

    public double getCachedTaxOwing() {
        return this.getCachedTaxOwing(true);
    }

    public synchronized double getCachedTaxOwing(boolean refreshIfStale) {
        if (this.cachedTaxOwing == null) {
            this.cachedTaxOwing = new CachedTaxOwing(this.getTaxOwing(false));
        } else if (refreshIfStale && this.cachedTaxOwing.isStale()) {
            this.cachedTaxOwing.updateCache();
        }
        return this.cachedTaxOwing.getOwing();
    }

    public void removeTrustInTown(Town town) {
        if (town.hasTrustedResident(this)) {
            town.removeTrustedResident(this);
            town.save();
        }
        town.getTownBlocks().stream().filter(tb -> tb.hasTrustedResident(this)).forEach(tb -> {
            tb.removeTrustedResident(this);
            tb.save();
        });
    }

    class CachedTaxOwing {
        private double owing = 0.0;
        private long time;

        CachedTaxOwing(double _owing) {
            this.owing = _owing;
            this.time = System.currentTimeMillis();
        }

        double getOwing() {
            return this.owing;
        }

        boolean isStale() {
            return System.currentTimeMillis() - this.time > TownySettings.getCachedBankTimeout();
        }

        void setOwing(double _balance) {
            this.owing = _balance;
            this.time = System.currentTimeMillis();
        }

        void updateCache() {
            this.time = System.currentTimeMillis();
            TownyEconomyHandler.economyExecutor().execute(() -> this.setOwing(Resident.this.getTaxOwing(false)));
        }
    }
}

