/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.object.Position;
import com.palmergames.bukkit.towny.object.SpawnPointLocation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.util.BukkitParticle;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;

public class SpawnPoint {
    private final Position position;
    private final WorldCoord wc;
    private final SpawnPointType type;
    private final SpawnPointLocation spawnLocation;
    private static final List<RingCoord> RING_PATTERN = SpawnPoint.createRingOffsets();
    public static final int RING_POINT_COUNT = 12;
    public static final int RING_DELAY_TICKS = 4;

    public SpawnPoint(Location loc, SpawnPointType type) {
        this(Position.ofLocation(loc), type);
    }

    public SpawnPoint(Position pos, SpawnPointType type) {
        this.position = pos;
        this.type = type;
        this.wc = pos.worldCoord();
        this.spawnLocation = SpawnPointLocation.parsePos(pos);
    }

    public WorldCoord getWorldCoord() {
        return this.wc;
    }

    public SpawnPointType getType() {
        return this.type;
    }

    public Location getBukkitLocation() {
        return this.position.asLocation();
    }

    public Position getPosition() {
        return this.position;
    }

    public SpawnPointLocation getSpawnPointLocation() {
        return this.spawnLocation;
    }

    public void drawParticle() {
        if (!Towny.getPlugin().isEnabled()) {
            return;
        }
        World world = this.position.world().getBukkitWorld();
        if (world == null) {
            return;
        }
        Location origin = this.centreLocation(this.position.asLocation());
        int i = 0;
        for (RingCoord ringPosition : RING_PATTERN) {
            Location point = origin.clone().add(ringPosition.x(), 0.0, ringPosition.z());
            Towny.getPlugin().getScheduler().runAsyncLater(() -> {
                try {
                    world.spawnParticle(BukkitParticle.getSpawnPointParticle(), point, 1, 0.0, 0.0, 0.0, 0.0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, (long)i * 4L);
            ++i;
        }
    }

    private Location centreLocation(Location loc) {
        loc.setX(Math.floor(loc.getX()) + 0.5);
        loc.setY(Math.floor(loc.getY()) + 0.1);
        loc.setZ(Math.floor(loc.getZ()) + 0.5);
        return loc;
    }

    private static List<RingCoord> createRingOffsets() {
        ArrayList<RingCoord> ring = new ArrayList<RingCoord>();
        double radius = 0.45;
        double angleIncrement = 0.5235987755982988;
        for (int i = 0; i < 12; ++i) {
            double angle = (double)i * 0.5235987755982988;
            double x = 0.45 * Math.sin(angle);
            double y = 0.45 * Math.cos(angle);
            ring.add(RingCoord.offset(x, y));
        }
        return ring;
    }

    public static enum SpawnPointType {
        TOWN_SPAWN,
        NATION_SPAWN,
        OUTPOST_SPAWN,
        JAIL_SPAWN;

    }

    private record RingCoord(double x, double z) {
        private static RingCoord offset(double a, double b) {
            return new RingCoord(a, b);
        }
    }
}

