/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.object.Position;
import org.bukkit.Location;

public class SpawnPointLocation
extends Position {
    public SpawnPointLocation(Location loc) {
        super(TownyAPI.getInstance().getTownyWorld(loc.getWorld()), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), 0.0f, 0.0f);
    }

    private SpawnPointLocation(Position position) {
        super(position.world(), position.blockX(), position.blockY(), position.blockZ(), 0.0f, 0.0f);
    }

    public int getX() {
        return this.blockX();
    }

    public int getY() {
        return this.blockY();
    }

    public int getZ() {
        return this.blockZ();
    }

    public static SpawnPointLocation parseSpawnPointLocation(Location loc) {
        return SpawnPointLocation.parsePos(Position.ofLocation(loc));
    }

    public static SpawnPointLocation parsePos(Position position) {
        return new SpawnPointLocation(position);
    }

    public String toString() {
        return this.world().getName() + "," + this.blockX() + "," + this.blockY() + "," + this.blockZ();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SpawnPointLocation)) {
            return false;
        }
        SpawnPointLocation loc = (SpawnPointLocation)other;
        return this.world().equals(loc.world()) && this.blockX() == loc.blockX() && this.blockY() == loc.blockY() && this.blockZ() == loc.blockZ();
    }
}

