/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.utils.MinecraftVersion;
import com.palmergames.bukkit.util.BukkitParticle;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class TeleportWarmupParticle {
    private static final List<RingCoord> RING_PATTERN = TeleportWarmupParticle.createRingOffsets();
    public static final int RING_POINT_COUNT = 12;
    public static final int RING_DELAY_TICKS = 2;

    public static void drawParticles(Player player, double yOffset) {
        Particle spawnParticle = BukkitParticle.getSpawnPointParticle();
        int i = 0;
        for (RingCoord ringPosition : RING_PATTERN) {
            Towny.getPlugin().getScheduler().runLater((Entity)player, () -> {
                Location point = player.getLocation().add(ringPosition.x(), yOffset, ringPosition.z());
                player.spawnParticle(spawnParticle, point, 1, 0.0, 0.0, 0.0, 0.0);
                if (player.isInvisible()) {
                    return;
                }
                if (MinecraftVersion.CURRENT_VERSION.isNewerThanOrEquals(MinecraftVersion.MINECRAFT_1_20_2)) {
                    for (Player trackingPlayer : player.getTrackedBy()) {
                        trackingPlayer.spawnParticle(spawnParticle, point, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                } else if (!BukkitTools.hasVanishedMeta(player)) {
                    player.getWorld().spawnParticle(spawnParticle, point, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }, (long)i * 2L);
            ++i;
        }
    }

    private static List<RingCoord> createRingOffsets() {
        ArrayList<RingCoord> ring = new ArrayList<RingCoord>();
        double radius = 0.45;
        double angleIncrement = 0.5235987755982988;
        for (int i = 0; i < 12; ++i) {
            double angle = (double)i * 0.5235987755982988;
            double x = 0.45 * Math.sin(angle);
            double y = 0.45 * Math.cos(angle);
            ring.add(RingCoord.offset(x, y));
        }
        return ring;
    }

    private record RingCoord(double x, double z) {
        private static RingCoord offset(double a, double b) {
            return new RingCoord(a, b);
        }
    }
}

