/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.google.common.collect.Lists;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.BonusBlockPurchaseCostCalculationEvent;
import com.palmergames.bukkit.towny.event.DeleteNationEvent;
import com.palmergames.bukkit.towny.event.NationAddTownEvent;
import com.palmergames.bukkit.towny.event.NationRemoveTownEvent;
import com.palmergames.bukkit.towny.event.TownBlockClaimCostCalculationEvent;
import com.palmergames.bukkit.towny.event.TownyObjectFormattedNameEvent;
import com.palmergames.bukkit.towny.event.town.TownAddAlliedTownEvent;
import com.palmergames.bukkit.towny.event.town.TownAddEnemiedTownEvent;
import com.palmergames.bukkit.towny.event.town.TownCalculateTownLevelNumberEvent;
import com.palmergames.bukkit.towny.event.town.TownConqueredEvent;
import com.palmergames.bukkit.towny.event.town.TownIsTownOverClaimedEvent;
import com.palmergames.bukkit.towny.event.town.TownMapColourLocalCalculationEvent;
import com.palmergames.bukkit.towny.event.town.TownMapColourNationalCalculationEvent;
import com.palmergames.bukkit.towny.event.town.TownMayorChangedEvent;
import com.palmergames.bukkit.towny.event.town.TownMayorChosenBySuccessionEvent;
import com.palmergames.bukkit.towny.event.town.TownRemoveAlliedTownEvent;
import com.palmergames.bukkit.towny.event.town.TownRemoveEnemiedTownEvent;
import com.palmergames.bukkit.towny.event.town.TownUnconquerEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.District;
import com.palmergames.bukkit.towny.object.Government;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Position;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnPoint;
import com.palmergames.bukkit.towny.object.SpawnPointLocation;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownBlockTypeCache;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.MoneyUtil;
import com.palmergames.bukkit.towny.utils.ProximityUtil;
import com.palmergames.bukkit.towny.utils.TownUtil;
import com.palmergames.bukkit.towny.utils.TownyComponents;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class Town
extends Government
implements TownBlockOwner {
    private static final String ECONOMY_ACCOUNT_PREFIX = TownySettings.getTownAccountPrefix();
    private final List<Resident> residents = new ArrayList<Resident>();
    private final List<Resident> outlaws = new ArrayList<Resident>();
    private Map<UUID, Town> allies = new LinkedHashMap<UUID, Town>();
    private Map<UUID, Town> enemies = new LinkedHashMap<UUID, Town>();
    private final Set<Resident> trustedResidents = new HashSet<Resident>();
    private final Map<UUID, Town> trustedTowns = new LinkedHashMap<UUID, Town>();
    private final List<Position> outpostSpawns = new ArrayList<Position>();
    private List<Jail> jails = null;
    private HashMap<String, PlotGroup> plotGroups = null;
    private TownBlockTypeCache plotTypeCache = new TownBlockTypeCache();
    private HashMap<String, District> districts = null;
    private Resident mayor;
    private String founderName;
    private int bonusBlocks = 0;
    private int purchasedBlocks = 0;
    private double plotTax = TownySettings.getTownDefaultPlotTax();
    private double commercialPlotTax = TownySettings.getTownDefaultShopTax();
    private double plotPrice = 0.0;
    private double embassyPlotTax = TownySettings.getTownDefaultEmbassyTax();
    private double maxPercentTaxAmount = TownySettings.getMaxTownTaxPercentAmount();
    private double commercialPlotPrice;
    private double embassyPlotPrice;
    private double debtBalance = 0.0;
    private Nation nation;
    private boolean hasUpkeep = true;
    private boolean hasUnlimitedClaims = false;
    private boolean isForSale = false;
    private double forSalePrice = 0.0;
    private boolean isTaxPercentage = TownySettings.getTownDefaultTaxPercentage();
    private TownBlock homeBlock;
    private TownyWorld world;
    private boolean adminEnabledMobs = false;
    private boolean adminDisabledPVP = false;
    private boolean adminEnabledPVP = false;
    private boolean allowedToWar = TownySettings.getTownDefaultAllowedToWar();
    private boolean isConquered = false;
    private int conqueredDays;
    private int nationZoneOverride = 0;
    private boolean nationZoneEnabled = true;
    private final ConcurrentHashMap<WorldCoord, TownBlock> townBlocks = new ConcurrentHashMap();
    private final TownyPermission permissions = new TownyPermission();
    private boolean ruined = false;
    private long ruinedTime;
    private long forSaleTime;
    private long joinedNationAt;
    private long movedHomeBlockAt;
    private Jail primaryJail;
    private int manualTownLevel = -1;
    private boolean visibleOnTopLists = true;
    private boolean residentsSorted = false;

    public Town(String name) {
        super(name);
        this.permissions.loadDefault(this);
        this.setTaxes(TownySettings.getTownDefaultTax());
        this.setOpen(TownySettings.getTownDefaultOpen());
        this.setBoard(TownySettings.getTownDefaultBoard());
        this.setNeutral(TownySettings.getTownDefaultNeutral());
        this.setPublic(TownySettings.getTownDefaultPublic());
    }

    public Town(String name, UUID uuid) {
        this(name);
        this.setUUID(uuid);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Town)) {
            return false;
        }
        Town otherTown = (Town)other;
        return this.getName().equals(otherTown.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getUUID(), this.getName());
    }

    @Override
    public Collection<TownBlock> getTownBlocks() {
        return Collections.unmodifiableCollection(this.townBlocks.values());
    }

    public int getNumTownBlocks() {
        return this.getTownBlocks().size();
    }

    @Override
    public boolean hasTownBlock(TownBlock townBlock) {
        return this.hasTownBlock(townBlock.getWorldCoord());
    }

    public boolean hasTownBlock(WorldCoord worldCoord) {
        return this.townBlocks.containsKey(worldCoord);
    }

    @Override
    public void addTownBlock(TownBlock townBlock) throws AlreadyRegisteredException {
        if (this.hasTownBlock(townBlock)) {
            throw new AlreadyRegisteredException();
        }
        this.townBlocks.put(townBlock.getWorldCoord(), townBlock);
        if (this.townBlocks.size() < 2 && !this.hasHomeBlock()) {
            this.setHomeBlock(townBlock);
        }
        this.getTownBlockTypeCache().addTownBlockOfType(townBlock.getType());
    }

    public TownBlock getTownBlock(WorldCoord worldCoord) {
        if (this.hasTownBlock(worldCoord)) {
            return this.townBlocks.get(worldCoord);
        }
        return null;
    }

    public ConcurrentMap<WorldCoord, TownBlock> getTownBlockMap() {
        return this.townBlocks;
    }

    public TownBlockTypeCache getTownBlockTypeCache() {
        return this.plotTypeCache;
    }

    public Resident getMayor() {
        return this.mayor;
    }

    @Override
    public void setTaxes(double taxes) {
        this.taxes = Math.min(taxes, this.isTaxPercentage ? TownySettings.getMaxTownTaxPercent() : TownySettings.getMaxTownTax());
        if (this.taxes < 0.0 && !TownySettings.isNegativeTownTaxAllowed()) {
            this.taxes = TownySettings.getTownDefaultTax();
        }
    }

    public void forceSetMayor(Resident mayor) throws TownyException {
        if (!this.hasResident(mayor)) {
            throw new TownyException(Translation.of("msg_err_mayor_doesnt_belong_to_town"));
        }
        this.setMayor(mayor, false);
    }

    public void setMayor(Resident mayor) {
        this.setMayor(mayor, true);
    }

    public void setMayor(Resident mayor, boolean callEvent) {
        if (!this.hasResident(mayor)) {
            return;
        }
        Resident oldMayor = this.mayor;
        if (callEvent) {
            BukkitTools.fireEvent(new TownMayorChangedEvent(this.mayor, mayor));
        }
        this.mayor = mayor;
        if (oldMayor != null) {
            TownyPerms.assignPermissions(oldMayor, null);
        }
        TownyPerms.assignPermissions(mayor, null);
    }

    public String getFounder() {
        return this.founderName != null ? this.founderName : (this.getMayor() != null ? this.getMayor().getName() : "None");
    }

    public void setFounder(String founderName) {
        this.founderName = founderName;
    }

    public Nation getNation() throws NotRegisteredException {
        if (this.hasNation()) {
            return this.nation;
        }
        throw new NotRegisteredException(Translation.of("msg_err_town_doesnt_belong_to_any_nation"));
    }

    @Nullable
    public Nation getNationOrNull() {
        return this.nation;
    }

    public void removeNation() {
        Nation oldNation;
        block7: {
            if (!this.hasNation()) {
                return;
            }
            oldNation = this.nation;
            for (Resident res : this.getResidents()) {
                if (res.hasTitle() || res.hasSurname()) {
                    res.setTitle("");
                    res.setSurname("");
                }
                res.updatePermsForNationRemoval();
                res.save();
            }
            try {
                oldNation.removeTown(this);
            }
            catch (EmptyNationException e) {
                if (!TownyUniverse.getInstance().getDataSource().removeNation(oldNation, DeleteNationEvent.Cause.NO_TOWNS)) break block7;
                TownyMessaging.sendGlobalMessage(Translatable.of("msg_del_nation", e.getNation().getName()));
            }
        }
        try {
            this.setNation(null);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        this.isConquered = false;
        this.conqueredDays = 0;
        this.setJoinedNationAt(0L);
        this.save();
        BukkitTools.fireEvent(new NationRemoveTownEvent(this, oldNation));
        ProximityUtil.removeOutOfRangeTowns(oldNation);
    }

    public void setNation(Nation nation) throws AlreadyRegisteredException {
        this.setNation(nation, true);
    }

    public void setNation(Nation nation, boolean updateJoinedAt) throws AlreadyRegisteredException {
        if (this.nation == nation) {
            return;
        }
        if (nation == null) {
            this.nation = null;
            if (this.isConquered()) {
                this.setConquered(false);
                this.setConqueredDays(0);
            }
            return;
        }
        if (this.hasNation()) {
            throw new AlreadyRegisteredException();
        }
        this.nation = nation;
        nation.addTown(this);
        if (updateJoinedAt) {
            this.setJoinedNationAt(System.currentTimeMillis());
        }
        TownyPerms.updateTownPerms(this);
        BukkitTools.fireEvent(new NationAddTownEvent(this, nation));
    }

    public List<Resident> getResidents() {
        if (!this.residentsSorted) {
            this.sortResidents();
        }
        return Collections.unmodifiableList(this.residents);
    }

    public List<Resident> getRank(String rank) {
        ArrayList<Resident> residentsWithRank = new ArrayList<Resident>();
        for (Resident resident : this.getResidents()) {
            if (!resident.hasTownRank(rank)) continue;
            residentsWithRank.add(resident);
        }
        return Collections.unmodifiableList(residentsWithRank);
    }

    @Override
    public boolean hasResident(String name) {
        for (Resident resident : this.residents) {
            if (!resident.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasResident(Resident resident) {
        return this.residents.contains(resident);
    }

    public boolean hasResident(Player player) {
        return this.hasResident(player.getUniqueId());
    }

    public boolean hasResident(UUID uuid) {
        Resident resident = TownyAPI.getInstance().getResident(uuid);
        return resident != null && this.hasResident(resident);
    }

    public boolean hasResidentWithRank(Resident resident, String rank) {
        return this.hasResident(resident) && resident.hasTownRank(rank);
    }

    void addResident(Resident resident) {
        this.residents.add(resident);
    }

    public void addResidentCheck(Resident resident) throws AlreadyRegisteredException {
        if (this.hasResident(resident)) {
            throw new AlreadyRegisteredException(Translation.of("msg_err_already_in_town", resident.getName(), this.getFormattedName()));
        }
        Town residentTown = resident.getTownOrNull();
        if (residentTown != null && !this.equals(residentTown)) {
            throw new AlreadyRegisteredException(Translation.of("msg_err_already_in_town", resident.getName(), residentTown.getFormattedName()));
        }
    }

    public boolean isMayor(Resident resident) {
        return resident == this.mayor;
    }

    public boolean hasNation() {
        return this.nation != null;
    }

    public int getNumResidents() {
        return this.residents.size();
    }

    public boolean isCapital() {
        return this.hasNation() && this.nation.isCapital(this);
    }

    public void setHasUpkeep(boolean hasUpkeep) {
        this.hasUpkeep = hasUpkeep;
    }

    public boolean hasUpkeep() {
        return this.hasUpkeep;
    }

    public boolean hasUnlimitedClaims() {
        return TownySettings.areTownBlocksUnlimited() || this.hasUnlimitedClaims;
    }

    public void setHasUnlimitedClaims(boolean hasUnlimitedClaims) {
        this.hasUnlimitedClaims = hasUnlimitedClaims;
    }

    public void setHasMobs(boolean hasMobs) {
        this.permissions.mobs = hasMobs;
    }

    public boolean hasMobs() {
        return this.permissions.mobs;
    }

    public void setAdminEnabledMobs(boolean isMobsForced) {
        this.adminEnabledMobs = isMobsForced;
    }

    public boolean isAdminEnabledMobs() {
        return this.adminEnabledMobs;
    }

    public void setPVP(boolean isPVP) {
        this.permissions.pvp = isPVP;
    }

    public void setAdminDisabledPVP(boolean isPVPDisabled) {
        this.adminDisabledPVP = isPVPDisabled;
    }

    public void setAdminEnabledPVP(boolean isPVPEnabled) {
        this.adminEnabledPVP = isPVPEnabled;
    }

    public boolean isPVP() {
        if (this.isAdminEnabledPVP()) {
            return true;
        }
        if (this.isAdminDisabledPVP()) {
            return false;
        }
        return this.permissions.pvp;
    }

    public boolean isAdminDisabledPVP() {
        return this.adminDisabledPVP;
    }

    public boolean isAdminEnabledPVP() {
        return this.adminEnabledPVP;
    }

    public boolean isAllowedToWar() {
        return this.allowedToWar;
    }

    public void setAllowedToWar(boolean allowedToWar) {
        this.allowedToWar = allowedToWar;
    }

    public void setExplosion(boolean isExplosion) {
        this.permissions.explosion = isExplosion;
    }

    public boolean isExplosion() {
        return this.permissions.explosion;
    }

    public void setTaxPercentage(boolean isPercentage) {
        this.isTaxPercentage = isPercentage;
        if (isPercentage && this.getTaxes() > 100.0) {
            this.setTaxes(0.0);
        }
    }

    public boolean isTaxPercentage() {
        return this.isTaxPercentage;
    }

    public void setFire(boolean isFire) {
        this.permissions.fire = isFire;
    }

    public boolean isFire() {
        return this.permissions.fire;
    }

    public void setBonusBlocks(int bonusBlocks) {
        this.bonusBlocks = bonusBlocks;
    }

    public String getMaxTownBlocksAsAString() {
        if (this.hasUnlimitedClaims()) {
            return "\u221e";
        }
        return String.valueOf(this.getMaxTownBlocks());
    }

    public int getMaxTownBlocks() {
        return TownySettings.getMaxTownBlocks(this);
    }

    public int getBonusBlocks() {
        return this.bonusBlocks;
    }

    public double getBonusBlockCost() {
        double price = Math.pow(TownySettings.getPurchasedBonusBlocksIncreaseValue(), this.getPurchasedBlocks()) * TownySettings.getPurchasedBonusBlocksCost();
        double maxprice = TownySettings.getPurchasedBonusBlocksMaxPrice();
        BonusBlockPurchaseCostCalculationEvent event = new BonusBlockPurchaseCostCalculationEvent(this, maxprice == -1.0 ? price : Math.min(price, maxprice), 1);
        BukkitTools.fireEvent(event);
        return event.getPrice();
    }

    public double getTownBlockCost() {
        double price = Math.round(Math.pow(TownySettings.getClaimPriceIncreaseValue(), this.getTownBlocks().size()) * TownySettings.getClaimPrice());
        double maxprice = TownySettings.getMaxClaimPrice();
        TownBlockClaimCostCalculationEvent event = new TownBlockClaimCostCalculationEvent(this, maxprice == -1.0 ? price : Math.min(price, maxprice), 1);
        BukkitTools.fireEvent(event);
        return event.getPrice();
    }

    public double getTownBlockCostN(int inputN) throws TownyException {
        if (inputN < 0) {
            throw new TownyException(Translation.of("msg_err_negative"));
        }
        if (inputN == 0) {
            return inputN;
        }
        double nextprice = this.getTownBlockCost();
        double cost = nextprice;
        boolean hasmaxprice = TownySettings.getMaxClaimPrice() != -1.0;
        double maxprice = TownySettings.getMaxClaimPrice();
        for (int i = 1; i < inputN; ++i) {
            nextprice = Math.round(Math.pow(TownySettings.getClaimPriceIncreaseValue(), (double)this.getTownBlocks().size() + (double)i) * TownySettings.getClaimPrice());
            if (hasmaxprice && nextprice > maxprice) {
                cost += maxprice * (double)(inputN - i);
                break;
            }
            cost += nextprice;
        }
        TownBlockClaimCostCalculationEvent event = new TownBlockClaimCostCalculationEvent(this, Math.round(cost), inputN);
        BukkitTools.fireEvent(event);
        return event.getPrice();
    }

    public double getBonusBlockCostN(int n) throws TownyException {
        if (n < 0) {
            throw new TownyException(Translation.of("msg_err_negative"));
        }
        double cost = MoneyUtil.returnPurchasedBlocksCost(this.getPurchasedBlocks(), n, this);
        BonusBlockPurchaseCostCalculationEvent event = new BonusBlockPurchaseCostCalculationEvent(this, cost, n);
        BukkitTools.fireEvent(event);
        return event.getPrice();
    }

    public void addBonusBlocks(int bonusBlocks) {
        this.bonusBlocks += bonusBlocks;
    }

    public void setPurchasedBlocks(int purchasedBlocks) {
        this.purchasedBlocks = purchasedBlocks;
    }

    public int getPurchasedBlocks() {
        return this.purchasedBlocks;
    }

    public void addPurchasedBlocks(int purchasedBlocks) {
        this.purchasedBlocks += purchasedBlocks;
    }

    public void playerSetsHomeBlock(TownBlock townBlock, Location location, Player player) {
        this.setHomeBlock(townBlock);
        this.setSpawn(location);
        this.setMovedHomeBlockAt(System.currentTimeMillis());
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_set_town_home", townBlock.getCoord().toString()));
    }

    public void setHomeBlock(@Nullable TownBlock homeBlock) {
        this.homeBlock = homeBlock;
        if (homeBlock == null) {
            return;
        }
        if (this.world == null || !this.getHomeblockWorld().getName().equals(homeBlock.getWorld().getName())) {
            this.setWorld(homeBlock.getWorld());
        }
        if (this.spawn != null && !homeBlock.getWorldCoord().equals(this.spawn.worldCoord())) {
            TownyUniverse.getInstance().removeSpawnPoint(SpawnPointLocation.parsePos(this.spawn));
            this.spawn = null;
        }
        if (!this.hasNation() || TownySettings.getNationProximityToCapital() <= 0.0 || this.isCapital()) {
            return;
        }
        Nation townNation = this.getNationOrNull();
        if (townNation == null || !townNation.getCapital().hasHomeBlock()) {
            return;
        }
        List<Town> outOfRangeTowns = ProximityUtil.gatherOutOfRangeTowns(townNation);
        if (outOfRangeTowns.size() > 0) {
            if (outOfRangeTowns.contains(this)) {
                TownyMessaging.sendNationMessagePrefixed(townNation, Translatable.of("msg_nation_town_moved_their_homeblock_too_far", this.getName()));
            }
            ProximityUtil.removeOutOfRangeTowns(townNation);
        }
    }

    public void forceSetHomeBlock(TownBlock homeBlock) throws TownyException {
        if (homeBlock == null) {
            this.homeBlock = null;
            TownyMessaging.sendErrorMsg("town.forceSetHomeblock() is returning null.");
            return;
        }
        this.homeBlock = homeBlock;
        if (this.world != homeBlock.getWorld()) {
            this.setWorld(homeBlock.getWorld());
        }
    }

    public TownBlock getHomeBlock() throws TownyException {
        if (this.hasHomeBlock()) {
            return this.homeBlock;
        }
        throw new TownyException(this.getName() + " has not set a home block.");
    }

    @Nullable
    public TownBlock getHomeBlockOrNull() {
        return this.homeBlock;
    }

    public void setWorld(TownyWorld world) {
        if (world == null) {
            this.world = null;
            return;
        }
        if (this.world == world) {
            return;
        }
        if (this.hasWorld()) {
            try {
                world.removeTown(this);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        this.world = world;
        this.world.addTown(this);
    }

    public TownyWorld getHomeblockWorld() {
        if (this.world != null) {
            return this.world;
        }
        if (this.homeBlock != null) {
            return this.homeBlock.getWorld();
        }
        return TownyUniverse.getInstance().getTownyWorlds().get(0);
    }

    public boolean hasMayor() {
        return this.mayor != null;
    }

    public void removeResident(Resident resident) throws EmptyTownException {
        if (!this.hasResident(resident)) {
            return;
        }
        this.remove(resident);
        resident.setJoinedTownAt(0L);
        if (this.getNumResidents() == 0) {
            throw new EmptyTownException(this);
        }
    }

    private void remove(Resident resident) {
        if (this.isMayor(resident) && this.residents.size() > 1) {
            this.findNewMayor();
            this.save();
        }
        this.residents.remove(resident);
    }

    public void findNewMayor() {
        for (String rank : TownySettings.getOrderOfMayoralSuccession()) {
            if (!this.findNewMayor(this.getRank(rank))) continue;
            return;
        }
        this.findNewMayor((List<Resident>)this.getResidents());
    }

    private boolean findNewMayor(List<Resident> potentialResidents) {
        for (Resident newMayor : potentialResidents) {
            if (newMayor.equals(this.mayor)) continue;
            TownMayorChosenBySuccessionEvent tmcbse = new TownMayorChosenBySuccessionEvent(this.mayor, newMayor, potentialResidents);
            this.setMayor(tmcbse.getNewMayor());
            return true;
        }
        return false;
    }

    @Override
    public void setSpawn(@Nullable Location spawn) {
        this.spawnPosition(spawn == null ? null : Position.ofLocation(spawn));
    }

    @Override
    @NotNull
    public Location getSpawn() throws TownyException {
        if (this.hasHomeBlock() && this.spawn != null) {
            return this.spawn.asLocation();
        }
        this.spawn = null;
        throw new TownyException(Translation.of("msg_err_town_has_not_set_a_spawn_location"));
    }

    @Override
    @Nullable
    public Location getSpawnOrNull() {
        if (this.spawn != null) {
            return this.spawn.asLocation();
        }
        return null;
    }

    @Override
    @Nullable
    public Position spawnPosition() {
        return this.spawn;
    }

    @Override
    public void spawnPosition(@Nullable Position spawn) {
        if (this.spawn != null) {
            TownyUniverse.getInstance().removeSpawnPoint(SpawnPointLocation.parsePos(this.spawn));
        }
        this.spawn = spawn;
        if (spawn != null) {
            TownyUniverse.getInstance().addSpawnPoint(new SpawnPoint(spawn, SpawnPoint.SpawnPointType.TOWN_SPAWN));
        }
    }

    public boolean hasHomeBlock() {
        return this.homeBlock != null;
    }

    public boolean hasWorld() {
        return this.world != null;
    }

    @Override
    public void removeTownBlock(TownBlock townBlock) {
        if (this.hasTownBlock(townBlock)) {
            if (townBlock.isOutpost() || this.isAnOutpost(townBlock.getCoord())) {
                this.removeOutpostSpawn(townBlock.getCoord());
                townBlock.setOutpost(false);
                townBlock.save();
            }
            if (townBlock.isJail() && townBlock.getJail() != null) {
                this.removeJail(townBlock.getJail());
            }
            try {
                if (this.getHomeBlock() == townBlock) {
                    this.setHomeBlock(null);
                }
            }
            catch (TownyException townyException) {
                // empty catch block
            }
            Nation testNation = this.getNationOrNull();
            try {
                if (this.hasNation() && testNation != null && testNation.hasSpawn() && townBlock.getWorldCoord().equals(WorldCoord.parseWorldCoord(testNation.getSpawn()))) {
                    testNation.setSpawn(null);
                }
            }
            catch (TownyException townyException) {
                // empty catch block
            }
            this.townBlocks.remove(townBlock.getWorldCoord());
            this.getTownBlockTypeCache().removeTownBlockOfType(townBlock.getType());
            if (townBlock.isForSale()) {
                this.getTownBlockTypeCache().removeTownBlockOfTypeForSale(townBlock.getType());
            }
            if (townBlock.hasResident()) {
                this.getTownBlockTypeCache().removeTownBlockOfTypeResidentOwned(townBlock.getType());
            }
            this.save();
        }
    }

    @Override
    public void setPermissions(String line) {
        this.permissions.load(line);
    }

    @Override
    public TownyPermission getPermissions() {
        return this.permissions;
    }

    public void addOutpostSpawn(Location location) {
        this.addOutpostSpawn(Position.ofLocation(location));
    }

    public void addOutpostSpawn(Position position) {
        TownBlock townBlock = position.worldCoord().getTownBlockOrNull();
        if (townBlock == null || !this.equals(townBlock.getTownOrNull())) {
            return;
        }
        this.removeOutpostSpawn(position.worldCoord());
        if (!townBlock.isOutpost()) {
            townBlock.setOutpost(true);
            townBlock.save();
        }
        this.outpostSpawns.add(position);
        TownyUniverse.getInstance().addSpawnPoint(new SpawnPoint(this.spawn, SpawnPoint.SpawnPointType.OUTPOST_SPAWN));
        this.save();
    }

    @ApiStatus.Internal
    public void forceAddOutpostSpawn(Position position) {
        this.outpostSpawns.add(position);
        TownyUniverse.getInstance().addSpawnPoint(new SpawnPoint(position, SpawnPoint.SpawnPointType.OUTPOST_SPAWN));
    }

    public Location getOutpostSpawn(Integer index) throws TownyException {
        if (this.getMaxOutpostSpawn() == 0 && TownySettings.isOutpostsLimitedByLevels()) {
            throw new TownyException(Translation.of("msg_err_town_has_no_outpost_spawns_set"));
        }
        return this.outpostSpawns.get(Math.min(this.getMaxOutpostSpawn() - 1, Math.max(0, index - 1))).asLocation();
    }

    public int getMaxOutpostSpawn() {
        return this.outpostSpawns.size();
    }

    public boolean hasOutpostSpawn() {
        return !this.outpostSpawns.isEmpty();
    }

    private boolean isAnOutpost(Coord coord) {
        return new ArrayList<Position>(this.outpostSpawns).stream().anyMatch(spawn -> spawn.worldCoord().equals(coord));
    }

    public List<Location> getAllOutpostSpawns() {
        return Collections.unmodifiableList(Lists.transform(this.outpostSpawns, Position::asLocation));
    }

    public Collection<Position> getOutpostSpawns() {
        return Collections.unmodifiableList(this.outpostSpawns);
    }

    public void removeOutpostSpawn(Coord coord) {
        new ArrayList<Location>(this.getAllOutpostSpawns()).stream().filter(spawn -> Coord.parseCoord(spawn).equals(coord)).forEach(spawn -> {
            this.removeOutpostSpawn((Location)spawn);
            TownyUniverse.getInstance().removeSpawnPoint((Location)spawn);
        });
    }

    public void removeOutpostSpawn(Location loc) {
        this.outpostSpawns.remove(Position.ofLocation(loc));
    }

    public List<String> getOutpostNames() {
        ArrayList<String> outpostNames = new ArrayList<String>();
        int i = 0;
        Iterator<Position> outpostSpawnIterator = this.outpostSpawns.iterator();
        while (outpostSpawnIterator.hasNext()) {
            String name;
            ++i;
            Position pos = outpostSpawnIterator.next();
            TownBlock tboutpost = TownyAPI.getInstance().getTownBlock(pos.worldCoord());
            if (tboutpost == null) {
                outpostSpawnIterator.remove();
                this.save();
                continue;
            }
            String string = name = !tboutpost.hasPlotObjectGroup() ? tboutpost.getName() : tboutpost.getPlotObjectGroup().getName();
            if (!name.isEmpty()) {
                outpostNames.add(name);
                continue;
            }
            outpostNames.add(String.valueOf(i));
        }
        return outpostNames;
    }

    public final void setForSale(boolean isForSale) {
        this.isForSale = isForSale;
        if (!isForSale) {
            this.forSalePrice = 0.0;
        }
    }

    public final boolean isForSale() {
        return this.isForSale;
    }

    public final void setForSalePrice(double forSalePrice) {
        this.forSalePrice = Math.min(forSalePrice, TownySettings.maxBuyTownPrice());
    }

    public final double getForSalePrice() {
        return this.forSalePrice;
    }

    public void setForSaleTime(long time) {
        this.forSaleTime = time;
    }

    public long getForSaleTime() {
        return this.forSaleTime;
    }

    public void setPlotPrice(double plotPrice) {
        if (plotPrice < 0.0) {
            plotPrice = -1.0;
        }
        this.plotPrice = Math.min(plotPrice, TownySettings.getMaxPlotPrice());
    }

    public double getPlotPrice() {
        return this.plotPrice;
    }

    public double getPlotTypePrice(TownBlockType type) {
        double plotPrice = switch (type.getName().toLowerCase(Locale.ROOT)) {
            case "shop" -> this.getCommercialPlotPrice();
            case "embassy" -> this.getEmbassyPlotPrice();
            default -> this.getPlotPrice();
        };
        return Math.max(plotPrice, 0.0);
    }

    public void setCommercialPlotPrice(double commercialPlotPrice) {
        if (commercialPlotPrice < 0.0) {
            commercialPlotPrice = -1.0;
        }
        this.commercialPlotPrice = Math.min(commercialPlotPrice, TownySettings.getMaxPlotPrice());
    }

    public double getCommercialPlotPrice() {
        return this.commercialPlotPrice;
    }

    public void setEmbassyPlotPrice(double embassyPlotPrice) {
        if (embassyPlotPrice < 0.0) {
            embassyPlotPrice = -1.0;
        }
        this.embassyPlotPrice = Math.min(embassyPlotPrice, TownySettings.getMaxPlotPrice());
    }

    public double getEmbassyPlotPrice() {
        return this.embassyPlotPrice;
    }

    public boolean isHomeBlock(TownBlock townBlock) {
        return this.hasHomeBlock() && townBlock == this.homeBlock;
    }

    public void setPlotTax(double plotTax) {
        this.plotTax = Math.min(plotTax, TownySettings.getMaxPlotTax());
    }

    public double getPlotTax() {
        return this.plotTax;
    }

    public void setCommercialPlotTax(double commercialTax) {
        this.commercialPlotTax = Math.min(commercialTax, TownySettings.getMaxPlotTax());
    }

    public double getCommercialPlotTax() {
        return this.commercialPlotTax;
    }

    public void setEmbassyPlotTax(double embassyPlotTax) {
        this.embassyPlotTax = Math.min(embassyPlotTax, TownySettings.getMaxPlotTax());
    }

    public double getEmbassyPlotTax() {
        return this.embassyPlotTax;
    }

    public void collect(double amount) {
        if (TownyEconomyHandler.isActive()) {
            double bankcap = this.getBankCap();
            if (bankcap > 0.0 && amount + this.getAccount().getHoldingBalance() > bankcap) {
                TownyMessaging.sendPrefixedTownMessage(this, Translatable.of("msg_err_deposit_capped", bankcap));
                return;
            }
            this.getAccount().deposit(amount, null);
        }
    }

    @Override
    public List<String> getTreeString(int depth) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.getTreeDepth(depth) + "Town (" + this.getName() + ")");
        out.add(this.getTreeDepth(depth + 1) + "Mayor: " + (this.hasMayor() ? this.getMayor().getName() : "None"));
        out.add(this.getTreeDepth(depth + 1) + "Home: " + String.valueOf(this.homeBlock));
        out.add(this.getTreeDepth(depth + 1) + "Bonus: " + this.bonusBlocks);
        out.add(this.getTreeDepth(depth + 1) + "TownBlocks (" + this.getTownBlocks().size() + "): ");
        List<Resident> assistants = this.getRank("assistant");
        if (!assistants.isEmpty()) {
            out.add(this.getTreeDepth(depth + 1) + "Assistants (" + assistants.size() + "): " + Arrays.toString(assistants.toArray(new Resident[0])));
        }
        out.add(this.getTreeDepth(depth + 1) + "Residents (" + this.getResidents().size() + "):");
        for (Resident resident : this.getResidents()) {
            out.addAll(resident.getTreeString(depth + 2));
        }
        return out;
    }

    @Override
    public Collection<Resident> getOutlaws() {
        return Collections.unmodifiableList(this.outlaws);
    }

    public boolean hasOutlaw(String name) {
        return this.outlaws.stream().anyMatch(outlaw -> outlaw.getName().equalsIgnoreCase(name));
    }

    public boolean hasOutlaw(Resident outlaw) {
        return this.outlaws.contains(outlaw);
    }

    public void addOutlaw(Resident resident) throws AlreadyRegisteredException {
        this.addOutlawCheck(resident);
        this.outlaws.add(resident);
    }

    public void addOutlawCheck(Resident resident) throws AlreadyRegisteredException {
        if (this.hasOutlaw(resident)) {
            throw new AlreadyRegisteredException(Translation.of("msg_err_resident_already_an_outlaw"));
        }
        Town residentTown = resident.getTownOrNull();
        if (this.equals(residentTown)) {
            throw new AlreadyRegisteredException(Translation.of("msg_err_not_outlaw_in_your_town"));
        }
    }

    public void removeOutlaw(Resident resident) {
        if (this.hasOutlaw(resident)) {
            this.outlaws.remove(resident);
        }
    }

    public void loadOutlaws(List<Resident> outlaws) {
        outlaws.stream().forEach(o -> {
            try {
                this.addOutlaw((Resident)o);
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                // empty catch block
            }
        });
    }

    public boolean hasValidUUID() {
        return this.uuid != null;
    }

    public void setOutpostSpawns(List<Location> outpostSpawns) {
        this.outpostSpawns.clear();
        for (Location location : outpostSpawns) {
            this.addOutpostSpawn(location);
        }
    }

    public boolean isAlliedWith(Town othertown) {
        return CombatUtil.isAlly(this, othertown);
    }

    public int getOutpostLimit() {
        return TownySettings.getMaxOutposts(this);
    }

    public boolean isOverOutpostLimit() {
        return TownySettings.isOutpostsLimitedByLevels() && this.getMaxOutpostSpawn() > this.getOutpostLimit();
    }

    public boolean isOverClaimed() {
        if (this.hasUnlimitedClaims() || this.getTownBlocks().size() <= this.getMaxTownBlocks()) {
            return false;
        }
        TownIsTownOverClaimedEvent event = new TownIsTownOverClaimedEvent(this);
        return !BukkitTools.isEventCancelled(event);
    }

    public int availableTownBlocks() {
        return this.getMaxTownBlocks() - this.getTownBlocks().size();
    }

    @Override
    public void addMetaData(@NotNull CustomDataField<?> md) {
        this.addMetaData(md, true);
    }

    @Override
    public void removeMetaData(@NotNull CustomDataField<?> md) {
        this.removeMetaData(md, true);
    }

    public void setConquered(boolean conquered) {
        this.setConquered(conquered, true);
    }

    public void setConquered(boolean conquered, boolean callEvent) {
        if (conquered == this.isConquered) {
            return;
        }
        this.isConquered = conquered;
        if (!callEvent) {
            return;
        }
        if (TownyPerms.hasConqueredNodes()) {
            TownyPerms.updateTownPerms(this);
        }
        if (this.isConquered) {
            BukkitTools.fireEvent(new TownConqueredEvent(this));
        } else {
            BukkitTools.fireEvent(new TownUnconquerEvent(this));
        }
    }

    public boolean isConquered() {
        return this.isConquered;
    }

    public void setConqueredDays(int conqueredDays) {
        this.conqueredDays = conqueredDays;
    }

    public int getConqueredDays() {
        return this.conqueredDays;
    }

    public void addJail(Jail jail) {
        if (!this.hasJails()) {
            this.jails = new ArrayList<Jail>(1);
        }
        this.jails.add(jail);
    }

    public void removeJail(Jail jail) {
        if (this.hasJails() && this.hasJail(jail)) {
            this.jails.remove(jail);
        }
        if (this.getPrimaryJail() != null && this.getPrimaryJail().getUUID().equals(jail.getUUID())) {
            this.setPrimaryJail(null);
        }
    }

    public boolean hasJails() {
        return this.jails != null;
    }

    public boolean hasJail(Jail jail) {
        return this.jails.contains(jail);
    }

    @Nullable
    public Collection<Jail> getJails() {
        if (!this.hasJails()) {
            return null;
        }
        return Collections.unmodifiableCollection(this.jails);
    }

    @Nullable
    public Jail getJail(int i) {
        if (!this.hasJails() || this.jails.size() < i) {
            return null;
        }
        return this.jails.get(--i);
    }

    public void setPrimaryJail(Jail jail) {
        this.primaryJail = jail;
    }

    @Nullable
    public Jail getPrimaryJail() {
        if (this.primaryJail == null && this.hasJails()) {
            return this.getJail(1);
        }
        return this.primaryJail;
    }

    public int getJailedPlayerCount() {
        return this.getJailedResidents().size();
    }

    public List<Resident> getJailedResidents() {
        return Collections.unmodifiableList(new ArrayList<Resident>(TownyUniverse.getInstance().getJailedResidentMap()).stream().filter(res -> res.hasJailTown(this.getName())).collect(Collectors.toList()));
    }

    public void renamePlotGroup(String oldName, PlotGroup group) {
        this.plotGroups.remove(oldName);
        this.plotGroups.put(group.getName(), group);
    }

    public void addPlotGroup(PlotGroup group) {
        if (!this.hasPlotGroups()) {
            this.plotGroups = new HashMap();
        }
        this.plotGroups.put(group.getName(), group);
    }

    public void removePlotGroup(PlotGroup plotGroup) {
        if (this.hasPlotGroups() && this.plotGroups.remove(plotGroup.getName()) != null) {
            for (TownBlock tb : new ArrayList<TownBlock>(plotGroup.getTownBlocks())) {
                if (!tb.hasPlotObjectGroup() || !tb.getPlotObjectGroup().getUUID().equals(plotGroup.getUUID())) continue;
                plotGroup.removeTownBlock(tb);
                tb.removePlotObjectGroup();
                tb.save();
            }
        }
    }

    public Collection<PlotGroup> getPlotGroups() {
        if (this.plotGroups == null || this.plotGroups.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.plotGroups.values());
    }

    public boolean hasPlotGroups() {
        return this.plotGroups != null;
    }

    public boolean hasPlotGroupName(String name) {
        return this.hasPlotGroups() && this.plotGroups.containsKey(name);
    }

    @Nullable
    public PlotGroup getPlotObjectGroupFromName(String name) {
        if (this.hasPlotGroups() && this.hasPlotGroupName(name)) {
            return this.plotGroups.get(name);
        }
        return null;
    }

    public void renameDistrict(String oldName, District district) {
        this.districts.remove(oldName);
        this.districts.put(district.getName(), district);
    }

    public void addDistrict(District district) {
        if (!this.hasDistricts()) {
            this.districts = new HashMap();
        }
        this.districts.put(district.getName(), district);
    }

    public void removeDistrict(District district) {
        if (this.hasDistricts() && this.districts.remove(district.getName()) != null) {
            for (TownBlock tb : new ArrayList<TownBlock>(district.getTownBlocks())) {
                if (!tb.hasDistrict() || !tb.getDistrict().getUUID().equals(district.getUUID())) continue;
                district.removeTownBlock(tb);
                tb.removeDistrict();
                tb.save();
            }
        }
    }

    public Collection<District> getDistricts() {
        if (this.districts == null || this.districts.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.districts.values());
    }

    public boolean hasDistricts() {
        return this.districts != null;
    }

    public boolean hasDistrictName(String name) {
        return this.hasDistricts() && this.districts.containsKey(name);
    }

    @Nullable
    public District getDistrictFromName(String name) {
        if (this.hasDistricts() && this.hasDistrictName(name)) {
            return this.districts.get(name);
        }
        return null;
    }

    @Override
    public double getBankCap() {
        return TownySettings.getTownBankCap(this);
    }

    @Override
    public World getWorld() {
        return this.hasWorld() ? BukkitTools.getWorld(this.getHomeblockWorld().getName()) : BukkitTools.getWorlds().get(0);
    }

    @Override
    public String getBankAccountPrefix() {
        return ECONOMY_ACCOUNT_PREFIX;
    }

    @Override
    public String getFormattedName() {
        String prefix = this.isCapital() && !TownySettings.getCapitalPrefix(this).isEmpty() ? TownySettings.getCapitalPrefix(this) : TownySettings.getTownPrefix(this);
        String postfix = this.isCapital() && !TownySettings.getCapitalPostfix(this).isEmpty() ? TownySettings.getCapitalPostfix(this) : TownySettings.getTownPostfix(this);
        TownyObjectFormattedNameEvent event = new TownyObjectFormattedNameEvent(this, prefix, postfix);
        BukkitTools.fireEvent(event);
        return event.getPrefix() + this.getName().replace("_", " ") + event.getPostfix();
    }

    public String getPrefix() {
        return TownySettings.getTownPrefix(this);
    }

    public String getPostfix() {
        return TownySettings.getTownPostfix(this);
    }

    public double getMaxPercentTaxAmount() {
        return this.maxPercentTaxAmount;
    }

    public void setMaxPercentTaxAmount(double maxPercentTaxAmount) {
        this.maxPercentTaxAmount = Math.min(maxPercentTaxAmount, TownySettings.getMaxTownTaxPercentAmount());
    }

    public boolean isBankrupt() {
        return TownyEconomyHandler.isActive() && this.debtBalance > 0.0;
    }

    public double getDebtBalance() {
        return this.debtBalance;
    }

    public void setDebtBalance(double balance) {
        this.debtBalance = balance;
    }

    public boolean isRuined() {
        return this.ruined;
    }

    public void setRuined(boolean b) {
        this.ruined = b;
    }

    public void setRuinedTime(long time) {
        this.ruinedTime = time;
    }

    public long getRuinedTime() {
        return this.ruinedTime;
    }

    @Override
    @Nullable
    public String getMapColorHexCode() {
        String rawMapColorHexCode = super.getMapColorHexCode();
        TownMapColourLocalCalculationEvent event = new TownMapColourLocalCalculationEvent(this, rawMapColorHexCode);
        BukkitTools.fireEvent(event);
        return event.getMapColorHexCode();
    }

    @Nullable
    public String getNationMapColorHexCode() {
        String rawMapColorHexCode = this.hasNation() ? this.nation.getMapColorHexCode() : null;
        TownMapColourNationalCalculationEvent event = new TownMapColourNationalCalculationEvent(this, rawMapColorHexCode);
        BukkitTools.fireEvent(event);
        return event.getMapColorHexCode();
    }

    @Override
    public void save() {
        TownyUniverse.getInstance().getDataSource().saveTown(this);
    }

    public void saveTownBlocks() {
        this.townBlocks.values().stream().forEach(tb -> tb.save());
    }

    public int getNationZoneOverride() {
        return this.nationZoneOverride;
    }

    public void setNationZoneOverride(int size) {
        this.nationZoneOverride = size;
    }

    public boolean hasNationZoneOverride() {
        return this.nationZoneOverride > 0;
    }

    public long getJoinedNationAt() {
        return this.joinedNationAt;
    }

    public void setJoinedNationAt(long joinedNationAt) {
        this.joinedNationAt = joinedNationAt;
    }

    public long getMovedHomeBlockAt() {
        return this.movedHomeBlockAt;
    }

    public void setMovedHomeBlockAt(long movedHomeBlockAt) {
        this.movedHomeBlockAt = movedHomeBlockAt;
    }

    private void sortResidents() {
        List sortedResidents = this.residents.stream().sorted(Comparator.comparingLong(Resident::getJoinedTownAt)).collect(Collectors.toList());
        this.residents.clear();
        this.residents.addAll(sortedResidents);
        this.residentsSorted = true;
    }

    public Set<Resident> getTrustedResidents() {
        return this.trustedResidents;
    }

    public boolean hasTrustedResident(Resident resident) {
        Town residentsTown = resident.getTownOrNull();
        return this.trustedResidents.contains(resident) || residentsTown != null && this.hasTrustedTown(residentsTown);
    }

    public void addTrustedResident(Resident resident) {
        this.trustedResidents.add(resident);
    }

    public void removeTrustedResident(Resident resident) {
        this.trustedResidents.remove(resident);
    }

    @Override
    public int getNationZoneSize() {
        if (!TownySettings.getNationZonesEnabled() || !this.hasNation()) {
            return 0;
        }
        if (!this.isCapital() && TownySettings.getNationZonesCapitalsOnly()) {
            return 0;
        }
        if (this.hasNationZoneOverride()) {
            return this.getNationZoneOverride();
        }
        return this.nation.getNationZoneSize() + (this.isCapital() ? TownySettings.getNationZonesCapitalBonusSize() : 0);
    }

    public void loadAllies(List<Town> towns) {
        for (Town town : towns) {
            this.allies.put(town.getUUID(), town);
        }
    }

    public void addAlly(Town town) {
        TownAddAlliedTownEvent taate = new TownAddAlliedTownEvent(this, town);
        if (BukkitTools.isEventCancelled(taate)) {
            TownyMessaging.sendMsg(taate.getCancelMessage());
            return;
        }
        this.enemies.remove(town.getUUID());
        this.allies.put(town.getUUID(), town);
    }

    public void removeAlly(Town town) {
        TownRemoveAlliedTownEvent trate = new TownRemoveAlliedTownEvent(this, town);
        if (BukkitTools.isEventCancelled(trate)) {
            TownyMessaging.sendMsg(trate.getCancelMessage());
            return;
        }
        this.allies.remove(town.getUUID());
    }

    public boolean removeAllAllies() {
        for (Town ally : this.getAllies()) {
            this.removeAlly(ally);
            ally.removeAlly(this);
        }
        return this.getAllies().isEmpty();
    }

    public boolean hasAlly(Town town) {
        return this.allies.containsKey(town.getUUID());
    }

    public boolean hasMutualAlly(Town town) {
        return this.hasAlly(town) && town.hasAlly(this);
    }

    public void loadTrustedTowns(List<Town> towns) {
        for (Town trustTown : towns) {
            this.trustedTowns.put(trustTown.getUUID(), trustTown);
        }
    }

    public void addTrustedTown(Town town) {
        this.trustedTowns.put(town.getUUID(), town);
    }

    public void removeTrustedTown(Town town) {
        this.trustedTowns.remove(town.getUUID());
    }

    public boolean removeAllTrustedTowns() {
        for (Town trusted : this.getTrustedTowns()) {
            this.removeTrustedTown(trusted);
        }
        return this.getTrustedTowns().isEmpty();
    }

    public boolean hasTrustedTown(Town town) {
        return this.trustedTowns.containsKey(town.getUUID());
    }

    public void loadEnemies(List<Town> towns) {
        for (Town town : towns) {
            this.enemies.put(town.getUUID(), town);
        }
    }

    public void addEnemy(Town town) {
        TownAddEnemiedTownEvent taete = new TownAddEnemiedTownEvent(this, town);
        if (BukkitTools.isEventCancelled(taete)) {
            TownyMessaging.sendMsg(taete.getCancelMessage());
            return;
        }
        this.allies.remove(town.getUUID());
        this.enemies.put(town.getUUID(), town);
    }

    public void removeEnemy(Town town) {
        TownRemoveEnemiedTownEvent trete = new TownRemoveEnemiedTownEvent(this, town);
        if (BukkitTools.isEventCancelled(trete)) {
            TownyMessaging.sendMsg(trete.getCancelMessage());
            return;
        }
        this.enemies.remove(town.getUUID());
    }

    public boolean removeAllEnemies() {
        for (Town enemy : this.getEnemies()) {
            this.removeEnemy(enemy);
            enemy.removeEnemy(this);
        }
        return this.getEnemies().isEmpty();
    }

    public boolean hasEnemy(Town town) {
        return this.enemies.containsKey(town.getUUID());
    }

    public @Unmodifiable List<Town> getEnemies() {
        return List.copyOf(this.enemies.values());
    }

    public @Unmodifiable List<Town> getAllies() {
        return List.copyOf(this.allies.values());
    }

    public @Unmodifiable List<Town> getTrustedTowns() {
        return List.copyOf(this.trustedTowns.values());
    }

    public List<Town> getMutualAllies() {
        ArrayList<Town> result = new ArrayList<Town>();
        for (Town ally : this.getAllies()) {
            if (!ally.hasAlly(this)) continue;
            result.add(ally);
        }
        return result;
    }

    public @Unmodifiable List<UUID> getAlliesUUIDs() {
        return List.copyOf(this.allies.keySet());
    }

    public @Unmodifiable List<UUID> getEnemiesUUIDs() {
        return List.copyOf(this.enemies.keySet());
    }

    public @Unmodifiable List<UUID> getTrustedTownsUUIDS() {
        return List.copyOf(this.trustedTowns.keySet());
    }

    public boolean isNationZoneEnabled() {
        return this.nationZoneEnabled;
    }

    public void setNationZoneEnabled(boolean nationZoneEnabled) {
        this.nationZoneEnabled = nationZoneEnabled;
    }

    public boolean isInsideTown(@NotNull Location location) {
        return this.equals(WorldCoord.parseWorldCoord(location).getTownOrNull());
    }

    public boolean isInsideTown(@NotNull Position position) {
        return this.equals(position.worldCoord().getTownOrNull());
    }

    @Override
    public boolean isNeutral() {
        return (!TownySettings.nationCapitalsCantBeNeutral() || !this.isCapital()) && this.isNeutral;
    }

    public TownySettings.TownLevel getTownLevel() {
        return TownySettings.getTownLevel(this);
    }

    public int getLevelNumber() {
        int modifier = TownySettings.isTownLevelDeterminedByTownBlockCount() ? this.getNumTownBlocks() : this.getNumResidents();
        int townLevelNumber = this.getManualTownLevel() > -1 ? Math.min(this.getManualTownLevel(), TownySettings.getTownLevelMax()) : TownySettings.getTownLevelWhichIsNotManuallySet(modifier, this);
        TownCalculateTownLevelNumberEvent tctle = new TownCalculateTownLevelNumberEvent(this, townLevelNumber);
        BukkitTools.fireEvent(tctle);
        return tctle.getTownLevelNumber();
    }

    public int getManualTownLevel() {
        return this.manualTownLevel;
    }

    public void setManualTownLevel(int manualTownLevel) {
        this.manualTownLevel = manualTownLevel;
    }

    public int getTownBlockTypeLimit(TownBlockType type) {
        if (!TownySettings.areLevelTypeLimitsConfigured()) {
            return -1;
        }
        return this.getTownLevel().townBlockTypeLimits().getOrDefault(type.getName().toLowerCase(Locale.ROOT), -1);
    }

    @NotNull
    public Iterable<? extends Audience> audiences() {
        return TownyAPI.getInstance().getOnlinePlayers(this);
    }

    @Override
    @ApiStatus.Internal
    public boolean exists() {
        return TownyUniverse.getInstance().hasTown(this.getName());
    }

    public boolean isVisibleOnTopLists() {
        return this.visibleOnTopLists;
    }

    public void setVisibleOnTopLists(boolean visibleOnTopLists) {
        this.visibleOnTopLists = visibleOnTopLists;
    }

    public void playerBroadCastMessageToTown(Player player, String message) {
        TownyMessaging.sendPrefixedTownMessage(this, Translatable.of("town_say_format", player.getName(), TownyComponents.stripClickTags(message)));
    }

    public void checkTownHasEnoughResidentsForNationRequirements() {
        TownUtil.checkNationResidentsRequirementsOfTown(this);
    }

    public boolean hasEnoughResidentsToJoinANation() {
        return TownUtil.townHasEnoughResidentsToJoinANation(this);
    }

    public boolean hasEnoughResidentsToBeANationCapital() {
        return TownUtil.townHasEnoughResidentsToBeANationCapital(this);
    }

    public boolean isAllowedThisAmountOfResidents(int residentCount, boolean isCapital) {
        return TownUtil.townCanHaveThisAmountOfResidents(this, residentCount, isCapital);
    }

    public int getMaxAllowedNumberOfResidentsWithoutNation() {
        return TownUtil.getMaxAllowedNumberOfResidentsWithoutNation(this);
    }
}

