/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.PlotChangeTypeEvent;
import com.palmergames.bukkit.towny.event.plot.changeowner.PlotClaimEvent;
import com.palmergames.bukkit.towny.event.plot.changeowner.PlotPreClaimEvent;
import com.palmergames.bukkit.towny.event.plot.changeowner.PlotPreUnclaimEvent;
import com.palmergames.bukkit.towny.event.plot.changeowner.PlotUnclaimEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.District;
import com.palmergames.bukkit.towny.object.PermissionData;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlockData;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownBlockTypeCache;
import com.palmergames.bukkit.towny.object.TownBlockTypeHandler;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.utils.JailUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.TimeTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownBlock
extends TownyObject {
    private Town town = null;
    private Resident resident = null;
    private int minTownMembershipDays = -1;
    private int maxTownMembershipDays = -1;
    private TownBlockType type = TownBlockType.RESIDENTIAL;
    private final WorldCoord worldCoord;
    private double plotPrice = -1.0;
    private boolean taxed = true;
    private boolean outpost = false;
    private PlotGroup plotGroup;
    private District district;
    private long claimedAt;
    private Jail jail;
    private Map<Resident, PermissionData> permissionOverrides = new HashMap<Resident, PermissionData>();
    private Set<Resident> trustedResidents = new HashSet<Resident>();
    protected TownyPermission permissions = new TownyPermission();
    protected boolean isChanged = false;

    public TownBlock(int x, int z, TownyWorld world) {
        super("");
        this.worldCoord = new WorldCoord(world.getName(), world.getUUID(), x, z);
    }

    public TownBlock(WorldCoord worldCoord) {
        super("");
        this.worldCoord = worldCoord;
    }

    public void setTown(Town town) {
        this.setTown(town, true);
    }

    public void setTown(Town town, boolean updateClaimedAt) {
        if (this.hasTown()) {
            this.town.removeTownBlock(this);
            this.setTaxed(true);
        }
        this.town = town;
        try {
            TownyUniverse.getInstance().addTownBlock(this);
            town.addTownBlock(this);
            if (updateClaimedAt) {
                this.setClaimedAt(System.currentTimeMillis());
            }
            this.permissionOverrides.clear();
            this.minTownMembershipDays = -1;
            this.maxTownMembershipDays = -1;
        }
        catch (AlreadyRegisteredException | NullPointerException exception) {
            // empty catch block
        }
    }

    public Town getTown() throws NotRegisteredException {
        if (!this.hasTown()) {
            throw new NotRegisteredException(String.format("The TownBlock at (%s, %d, %d) is not registered to a town.", this.getWorld().getName(), this.getX(), this.getZ()));
        }
        return this.town;
    }

    @Nullable
    public Town getTownOrNull() {
        return this.town;
    }

    public boolean hasTown() {
        return this.town != null;
    }

    public boolean removeResident() {
        return this.setResident(null, true);
    }

    public boolean setResident(@Nullable Resident resident) {
        return this.setResident(resident, true);
    }

    public boolean setResident(@Nullable Resident resident, boolean callEvent) {
        if (callEvent) {
            PlotPreClaimEvent plotPreClaimEvent;
            PlotPreUnclaimEvent plotPreUnclaimEvent;
            if (this.resident != null && !this.resident.equals(resident) && BukkitTools.isEventCancelled(plotPreUnclaimEvent = new PlotPreUnclaimEvent(this.resident, resident, this))) {
                if (!plotPreUnclaimEvent.getCancelMessage().isEmpty()) {
                    if (this.resident != null) {
                        TownyMessaging.sendErrorMsg(this.resident, plotPreUnclaimEvent.getCancelMessage());
                    }
                    if (resident != null) {
                        TownyMessaging.sendErrorMsg(resident, plotPreUnclaimEvent.getCancelMessage());
                    }
                }
                return false;
            }
            if (resident != null && !resident.equals(this.resident) && BukkitTools.isEventCancelled(plotPreClaimEvent = new PlotPreClaimEvent(this.resident, resident, this))) {
                if (!plotPreClaimEvent.getCancelMessage().isEmpty()) {
                    TownyMessaging.sendErrorMsg(resident, plotPreClaimEvent.getCancelMessage());
                }
                return false;
            }
        }
        boolean successful = false;
        boolean unclaim = false;
        if (this.hasResident()) {
            this.resident.removeTownBlock(this);
            unclaim = true;
            this.town.getTownBlockTypeCache().removeTownBlockOfTypeResidentOwned(this);
            new ArrayList<Resident>(this.getTrustedResidents()).forEach(this::removeTrustedResident);
        }
        this.resident = resident;
        if (resident != null && !resident.hasTownBlock(this)) {
            try {
                resident.addTownBlock(this);
                successful = true;
                this.town.getTownBlockTypeCache().addTownBlockOfTypeResidentOwned(this);
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                // empty catch block
            }
        }
        if (successful && callEvent) {
            BukkitTools.fireEvent(new PlotClaimEvent(this.resident, resident, this));
        }
        if (unclaim && callEvent) {
            BukkitTools.fireEvent(new PlotUnclaimEvent(this.resident, resident, this));
        }
        this.permissionOverrides.clear();
        return true;
    }

    public Resident getResident() throws NotRegisteredException {
        if (!this.hasResident()) {
            throw new NotRegisteredException(String.format("The TownBlock at (%s, %d, %d) is not registered to a resident.", this.getWorld().getName(), this.getX(), this.getZ()));
        }
        return this.resident;
    }

    @Nullable
    public Resident getResidentOrNull() {
        return this.resident;
    }

    public boolean hasResident() {
        return this.resident != null;
    }

    public boolean isOwner(@NotNull TownBlockOwner owner) {
        if (this.hasTown() && owner == this.getTownOrNull()) {
            return true;
        }
        return this.hasResident() && owner == this.getResidentOrNull();
    }

    public void setPlotPrice(double price) {
        if (this.town != null) {
            if (this.isForSale() && price < 0.0) {
                this.town.getTownBlockTypeCache().removeTownBlockOfTypeForSale(this);
            } else if (!this.isForSale() && price >= 0.0) {
                this.town.getTownBlockTypeCache().addTownBlockOfTypeForSale(this);
            }
        }
        if (price < 0.0) {
            price = -1.0;
        }
        this.plotPrice = price;
    }

    public double getPlotPrice() {
        return this.plotPrice;
    }

    public boolean isForSale() {
        return this.getPlotPrice() >= 0.0;
    }

    public boolean isTaxed() {
        return this.taxed;
    }

    public void setTaxed(boolean value) {
        this.taxed = value;
    }

    public double getPlotTax() {
        return this.getType().getTax(this.town);
    }

    public void setPermissions(String line) {
        this.permissions.load(line);
    }

    public TownyPermission getPermissions() {
        return this.permissions;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    public boolean isOutpost() {
        return this.outpost;
    }

    public void setOutpost(boolean outpost) {
        this.outpost = outpost;
    }

    public TownBlockType getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.type.getName();
    }

    public void setType(@NotNull String type) {
        this.setType(TownBlockTypeHandler.getType(type));
    }

    public void setType(@Nullable TownBlockType type) {
        if (type == null || !TownBlockTypeHandler.exists(type.getName())) {
            type = TownBlockType.RESIDENTIAL;
        }
        if (!type.equals(this.type)) {
            this.permissions.reset();
        }
        if (this.getTownOrNull() != null) {
            this.adjustTownBlockTypeCache(this.getTownOrNull().getTownBlockTypeCache(), type);
        }
        this.type = type;
        BukkitTools.fireEvent(new PlotChangeTypeEvent(this.type, type, this));
        switch (type.getName().toLowerCase(Locale.ROOT)) {
            case "arena": {
                this.setPermissions("pvp");
                break;
            }
            case "jail": {
                this.setPermissions("denyAll");
                break;
            }
            case "farm": 
            case "wilds": {
                this.setPermissions("residentBuild,residentDestroy");
                break;
            }
            default: {
                if (this.hasResident()) {
                    this.setPermissions(this.resident.getPermissions().toString());
                    break;
                }
                this.setPermissions(this.town.getPermissions().toString());
            }
        }
        this.setChanged(false);
    }

    public void setType(TownBlockType type, Resident resident) throws TownyException {
        int typeLimit = this.town.getTownBlockTypeLimit(type);
        if (typeLimit >= 0 && (typeLimit == 0 || this.town.getTownBlockTypeCache().getNumTownBlocks(type, TownBlockTypeCache.CacheType.ALL) >= typeLimit)) {
            throw new TownyException(Translatable.of("msg_town_plot_type_limit_reached", typeLimit, type.getFormattedName()));
        }
        if (this.isJail() && !TownBlockType.JAIL.equals(type) && this.getJail() != null) {
            TownyUniverse.getInstance().getDataSource().removeJail(this.getJail());
            this.setJail(null);
        }
        if (TownBlockType.ARENA.equals(this.type) || TownBlockType.ARENA.equals(type) && TownySettings.getPVPCoolDownTime() > 0 && !TownyUniverse.getInstance().getPermissionSource().isTownyAdmin((Permissible)resident.getPlayer())) {
            if (CooldownTimerTask.hasCooldown(this.town.getUUID().toString(), CooldownTimerTask.CooldownType.PVP)) {
                throw new TownyException(Translatable.of("msg_err_cannot_toggle_pvp_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(this.town.getUUID().toString(), CooldownTimerTask.CooldownType.PVP)));
            }
            if (CooldownTimerTask.hasCooldown(this.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP)) {
                throw new TownyException(Translation.of("msg_err_cannot_toggle_pvp_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(this.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP)));
            }
            this.setType(type);
            CooldownTimerTask.addCooldownTimer(this.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP);
        } else {
            this.setType(type);
        }
        if (this.isJail() && resident.getPlayer() != null) {
            JailUtil.createJailPlot(this, this.getTown(), resident.getPlayer().getLocation());
        }
        this.save();
    }

    private void adjustTownBlockTypeCache(@Nullable TownBlockTypeCache townBlockTypeCache, @NotNull TownBlockType type) {
        if (townBlockTypeCache == null) {
            return;
        }
        if (this.type != null) {
            townBlockTypeCache.removeTownBlockOfType(this.type);
            if (this.isForSale()) {
                townBlockTypeCache.removeTownBlockOfTypeForSale(this.type);
            }
            if (this.hasResident()) {
                townBlockTypeCache.removeTownBlockOfTypeResidentOwned(this.type);
            }
        }
        townBlockTypeCache.addTownBlockOfType(type);
        if (this.isForSale()) {
            townBlockTypeCache.addTownBlockOfTypeForSale(type);
        }
        if (this.hasResident()) {
            townBlockTypeCache.addTownBlockOfTypeResidentOwned(type);
        }
    }

    public boolean isHomeBlock() {
        return this.town != null && this.town.isHomeBlock(this);
    }

    @Override
    public void setName(String newName) {
        super.setName(newName.replace("_", " "));
    }

    public int getX() {
        return this.worldCoord.getX();
    }

    public int getZ() {
        return this.worldCoord.getZ();
    }

    public Coord getCoord() {
        return this.worldCoord;
    }

    public WorldCoord getWorldCoord() {
        return this.worldCoord;
    }

    public TownyWorld getWorld() {
        return this.worldCoord.getTownyWorld();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TownBlock townBlock = (TownBlock)o;
        return this.worldCoord.equals(townBlock.worldCoord);
    }

    public int hashCode() {
        return Objects.hash(this.getWorld(), this.getX(), this.getZ());
    }

    public void clear() {
        this.setTown(null);
        this.removeResident();
    }

    @Override
    public String toString() {
        return this.getWorld().getName() + " (" + String.valueOf(this.getCoord()) + ")";
    }

    public boolean isJail() {
        return this.getType() == TownBlockType.JAIL;
    }

    public Jail getJail() {
        return this.jail;
    }

    public void setJail(Jail _jail) {
        this.jail = _jail;
    }

    @Override
    public void addMetaData(@NotNull CustomDataField<?> md) {
        this.addMetaData(md, true);
    }

    @Override
    public void removeMetaData(@NotNull CustomDataField<?> md) {
        this.removeMetaData(md, true);
    }

    public boolean hasPlotObjectGroup() {
        return this.plotGroup != null;
    }

    public PlotGroup getPlotObjectGroup() {
        return this.plotGroup;
    }

    public void removePlotObjectGroup() {
        this.plotGroup = null;
    }

    public void setPlotObjectGroup(PlotGroup group) {
        this.plotGroup = group;
        try {
            group.addTownBlock(this);
            this.setTrustedResidents(group.getTrustedResidents());
            this.setPermissionOverrides(group.getPermissionOverrides());
        }
        catch (NullPointerException e) {
            TownyMessaging.sendErrorMsg("Townblock failed to setPlotObjectGroup(group), group is null. ");
        }
    }

    public boolean hasDistrict() {
        return this.district != null;
    }

    public District getDistrict() {
        return this.district;
    }

    public void removeDistrict() {
        this.district = null;
    }

    public void setDistrict(District district) {
        this.district = district;
        try {
            district.addTownBlock(this);
        }
        catch (NullPointerException e) {
            TownyMessaging.sendErrorMsg("Townblock failed to setDistrict(district), district is null. ");
        }
    }

    @Override
    public void save() {
        TownyUniverse.getInstance().getDataSource().saveTownBlock(this);
    }

    public long getClaimedAt() {
        return this.claimedAt;
    }

    public void setClaimedAt(long claimedAt) {
        this.claimedAt = claimedAt;
    }

    public Map<Resident, PermissionData> getPermissionOverrides() {
        return this.permissionOverrides;
    }

    public void addTrustedResidents(List<Resident> residents) {
        residents.forEach(this::addTrustedResident);
    }

    public Set<Resident> getTrustedResidents() {
        return this.trustedResidents;
    }

    public boolean hasTrustedResident(Resident resident) {
        return this.trustedResidents.contains(resident);
    }

    public void addTrustedResident(Resident resident) {
        this.trustedResidents.add(resident);
    }

    public void removeTrustedResident(Resident resident) {
        this.trustedResidents.remove(resident);
    }

    public boolean hasResident(Resident resident) {
        if (this.resident == null || resident == null) {
            return false;
        }
        return resident.equals(this.resident);
    }

    public void setTrustedResidents(Set<Resident> trustedResidents) {
        this.trustedResidents = new HashSet<Resident>(trustedResidents);
    }

    public void setPermissionOverrides(Map<Resident, PermissionData> permissionOverrides) {
        this.permissionOverrides = new HashMap<Resident, PermissionData>(permissionOverrides);
    }

    @Nullable
    public TownBlockOwner getTownBlockOwner() {
        if (this.hasResident()) {
            return this.getResidentOrNull();
        }
        return this.getTownOrNull();
    }

    public TownBlockData getData() {
        return this.type.getData();
    }

    public void evictOwnerFromTownBlock() {
        this.evictOwnerFromTownBlock(false);
    }

    public void evictOwnerFromTownBlock(boolean forsale) {
        this.removeResident();
        this.setPlotPrice(forsale ? this.town.getPlotPrice() : -1.0);
        this.setType(this.getType());
        this.save();
    }

    public void testTownMembershipAgePreventsThisClaimOrThrow(Resident resident) throws TownyException {
        if (this.getType().equals(TownBlockType.EMBASSY) && !this.town.hasResident(resident) || !this.hasMinTownMembershipDays() && !this.hasMaxTownMembershipDays()) {
            return;
        }
        Town residentTown = resident.getTownOrNull();
        if (residentTown == null || !residentTown.equals(this.town)) {
            return;
        }
        long joinDate = resident.getJoinedTownAt();
        if (this.hasMaxTownMembershipDays() && TimeTools.getTimeInMillisXDaysAgo(this.getMaxTownMembershipDays()) > joinDate) {
            throw new TownyException(Translatable.of("msg_err_cannot_claim_plot_join_date_too_high", this.getMaxTownMembershipDays()));
        }
        if (this.hasMinTownMembershipDays() && TimeTools.getTimeInMillisXDaysAgo(this.getMinTownMembershipDays()) < joinDate) {
            throw new TownyException(Translatable.of("msg_err_cannot_claim_plot_join_date_too_low", this.getMinTownMembershipDays()));
        }
    }

    public boolean hasMinTownMembershipDays() {
        return this.minTownMembershipDays > 0;
    }

    public int getMinTownMembershipDays() {
        return this.minTownMembershipDays;
    }

    public void setMinTownMembershipDays(int minTownMembershipDays) {
        this.minTownMembershipDays = Math.min(32766, minTownMembershipDays);
    }

    public boolean hasMaxTownMembershipDays() {
        return this.maxTownMembershipDays > 0;
    }

    public int getMaxTownMembershipDays() {
        return this.maxTownMembershipDays;
    }

    public void setMaxTownMembershipDays(int maxTownMembershipDays) {
        this.maxTownMembershipDays = Math.min(32766, maxTownMembershipDays);
    }

    @Override
    @ApiStatus.Internal
    public boolean exists() {
        return TownyUniverse.getInstance().hasTownBlock(this.getWorldCoord());
    }
}

