/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlockData;
import com.palmergames.util.StringMgmt;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TownBlockType {
    public static final TownBlockType RESIDENTIAL = new TownBlockType("Default", new TownBlockData(){

        @Override
        public double getTax(Town town) {
            return town.getPlotTax();
        }
    });
    public static final TownBlockType COMMERCIAL = new TownBlockType("Shop", new TownBlockData(){

        @Override
        public double getTax(Town town) {
            return town.getCommercialPlotTax() + town.getPlotTax();
        }
    });
    public static final TownBlockType ARENA = new TownBlockType("Arena");
    public static final TownBlockType EMBASSY = new TownBlockType("Embassy", new TownBlockData(){

        @Override
        public double getTax(Town town) {
            return town.getEmbassyPlotTax() + town.getPlotTax();
        }
    });
    public static final TownBlockType WILDS = new TownBlockType("Wilds");
    public static final TownBlockType INN = new TownBlockType("Inn");
    public static final TownBlockType JAIL = new TownBlockType("Jail");
    public static final TownBlockType FARM = new TownBlockType("Farm");
    public static final TownBlockType BANK = new TownBlockType("Bank");
    private final String name;
    private final TownBlockData data;
    private static final Map<Integer, String> legacyLookupMap = new HashMap<Integer, String>();

    public TownBlockType(String name, TownBlockData data) {
        this.name = name;
        this.data = data;
    }

    public TownBlockType(String name) {
        this.name = name;
        this.data = new TownBlockData();
    }

    public String toString() {
        return this.name;
    }

    public double getTax(Town town) {
        return this.data.getTax(town);
    }

    public String getAsciiMapKey() {
        return this.data.getMapKey();
    }

    public double getCost() {
        return this.data.getCost();
    }

    public String getName() {
        return this.name;
    }

    public String getFormattedName() {
        return StringMgmt.capitalize(this.name);
    }

    public static Map<Integer, String> getLegacylookupmap() {
        return legacyLookupMap;
    }

    public TownBlockData getData() {
        return this.data;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TownBlockType)) {
            return false;
        }
        TownBlockType townBlockType = (TownBlockType)other;
        return townBlockType.getName().equalsIgnoreCase(this.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.data);
    }

    static {
        legacyLookupMap.put(0, "default");
        legacyLookupMap.put(1, "shop");
        legacyLookupMap.put(2, "arena");
        legacyLookupMap.put(3, "embassy");
        legacyLookupMap.put(4, "wilds");
        legacyLookupMap.put(6, "inn");
        legacyLookupMap.put(7, "jail");
        legacyLookupMap.put(8, "farm");
        legacyLookupMap.put(9, "bank");
    }
}

