/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TownBlockTypeCache {
    private Map<TownBlockType, Integer> typeCache = new ConcurrentHashMap<TownBlockType, Integer>();
    private Map<TownBlockType, Integer> forSaleCache = new ConcurrentHashMap<TownBlockType, Integer>(0);
    private Map<TownBlockType, Integer> residentOwnedCache = new ConcurrentHashMap<TownBlockType, Integer>(0);

    public int getNumTownBlocks(TownBlockType townBlockType, CacheType cacheType) {
        return switch (cacheType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> this.typeCache.getOrDefault(townBlockType, 0);
            case 1 -> this.forSaleCache.getOrDefault(townBlockType, 0);
            case 2 -> this.residentOwnedCache.getOrDefault(townBlockType, 0);
        };
    }

    public Map<TownBlockType, Integer> getCache(CacheType cacheType) {
        return switch (cacheType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> Collections.unmodifiableMap(this.typeCache);
            case 1 -> Collections.unmodifiableMap(this.forSaleCache);
            case 2 -> Collections.unmodifiableMap(this.residentOwnedCache);
        };
    }

    public void removeTownBlockOfType(TownBlock townBlock) {
        this.typeCache.merge(townBlock.getType(), -1, Integer::sum);
    }

    public void addTownBlockOfType(TownBlock townBlock) {
        this.typeCache.merge(townBlock.getType(), 1, Integer::sum);
    }

    public void removeTownBlockOfType(TownBlockType type) {
        this.typeCache.merge(type, -1, Integer::sum);
    }

    public void addTownBlockOfType(TownBlockType type) {
        this.typeCache.merge(type, 1, Integer::sum);
    }

    public void removeTownBlockOfTypeForSale(TownBlock townBlock) {
        this.forSaleCache.merge(townBlock.getType(), -1, Integer::sum);
    }

    public void addTownBlockOfTypeForSale(TownBlock townBlock) {
        this.forSaleCache.merge(townBlock.getType(), 1, Integer::sum);
    }

    public void removeTownBlockOfTypeForSale(TownBlockType type) {
        this.forSaleCache.merge(type, -1, Integer::sum);
    }

    public void addTownBlockOfTypeForSale(TownBlockType type) {
        this.forSaleCache.merge(type, 1, Integer::sum);
    }

    public int getNumberOfResidentOwnedTownBlocks() {
        return this.residentOwnedCache.values().stream().mapToInt(d -> d).sum();
    }

    public void removeTownBlockOfTypeResidentOwned(TownBlock townBlock) {
        this.residentOwnedCache.merge(townBlock.getType(), -1, Integer::sum);
    }

    public void addTownBlockOfTypeResidentOwned(TownBlock townBlock) {
        this.residentOwnedCache.merge(townBlock.getType(), 1, Integer::sum);
    }

    public void removeTownBlockOfTypeResidentOwned(TownBlockType type) {
        this.residentOwnedCache.merge(type, -1, Integer::sum);
    }

    public void addTownBlockOfTypeResidentOwned(TownBlockType type) {
        this.residentOwnedCache.merge(type, 1, Integer::sum);
    }

    public static enum CacheType {
        ALL,
        FORSALE,
        RESIDENTOWNED;

    }
}

