/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.towny.utils.TownyComponents;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class TownyInventory
implements InventoryHolder {
    @NotNull
    public static final NamespacedKey BACK_BUTTON_KEY = Objects.requireNonNull(NamespacedKey.fromString((String)"towny:back_button"));
    @NotNull
    public static final NamespacedKey NEXT_BUTTON_KEY = Objects.requireNonNull(NamespacedKey.fromString((String)"towny:next_button"));
    private static final Sound clickSound = Sound.sound((Key)Key.key((String)"minecraft", (String)"block.stone_button.click_on"), (Sound.Source)Sound.Source.MASTER, (float)1.0f, (float)1.0f);
    private final Inventory inv;

    public TownyInventory(Resident res, Inventory inv, Component name) {
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)54, (Component)name);
        this.inv.setContents(inv.getContents());
        res.getPlayer().openInventory(this.inv);
    }

    @Deprecated(since="0.101.2.6")
    public TownyInventory(Resident res, Inventory inv, String name) {
        this(res, inv, TownyComponents.miniMessage(name));
    }

    @NotNull
    public Inventory getInventory() {
        return this.inv;
    }

    public void playClickSound(Player player) {
        player.playSound(clickSound);
    }

    public void tryPaginate(ItemStack clickedItem, Player player, Resident resident, InventoryView inventoryView) {
        int currentPage = resident.getGUIPageNum();
        ItemMeta clickedItemItemMeta = clickedItem.getItemMeta();
        try {
            if (this.isNextButton(clickedItemItemMeta)) {
                if (resident.getGUIPageNum() >= resident.getGUIPages().size() - 1) {
                    return;
                }
                resident.setGUIPageNum(++currentPage);
                new TownyInventory(resident, resident.getGUIPage(), inventoryView.title());
                this.playClickSound(player);
            } else if (this.isBackButton(clickedItemItemMeta)) {
                if (resident.getGUIPageNum() > 0) {
                    resident.setGUIPageNum(--currentPage);
                    new TownyInventory(resident, resident.getGUIPage(), inventoryView.title());
                    this.playClickSound(player);
                } else if (resident.getGUIPageNum() == 0 && resident.getGUISelectionType() != null) {
                    this.playClickSound(player);
                    ResidentUtil.openSelectionGUI(resident, resident.getGUISelectionType());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean isNextButton(ItemMeta meta) {
        return meta != null && meta.getPersistentDataContainer().has(NEXT_BUTTON_KEY);
    }

    protected boolean isBackButton(ItemMeta meta) {
        return meta != null && meta.getPersistentDataContainer().has(BACK_BUTTON_KEY);
    }
}

