/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.utils.TownyComponents;
import com.palmergames.bukkit.util.Colors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilderApplicable;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.LinearComponents;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Translatable {
    private String key;
    private Object[] args;
    private boolean stripColors;
    private final List<Object> appended = new ArrayList<Object>(0);
    private Locale locale;

    private Translatable(String key) {
        this.key = key;
    }

    private Translatable(String key, Object ... args) {
        this.key = key;
        this.args = args;
    }

    public static Translatable of(String key) {
        return new Translatable(key);
    }

    public static Translatable of(String key, Object ... args) {
        return new Translatable(key, args);
    }

    public static Translatable literal(String text) {
        return new LiteralTranslatable(text);
    }

    public static Translatable literal(ComponentLike component) {
        return new LiteralTranslatable(component.asComponent());
    }

    public String key() {
        return this.key;
    }

    public Object[] args() {
        return this.args;
    }

    @Nullable
    public Locale locale() {
        return this.locale;
    }

    public boolean stripColors() {
        return this.stripColors;
    }

    public String appended() {
        if (this.appended.isEmpty()) {
            return "";
        }
        StringBuilder converted = new StringBuilder();
        for (Object object : this.appended) {
            if (object instanceof String) {
                String string = (String)object;
                converted.append(string);
                continue;
            }
            if (object instanceof Translatable) {
                Translatable translatable = (Translatable)object;
                converted.append(translatable.locale(this.locale).translate());
                continue;
            }
            if (!(object instanceof Component)) continue;
            Component component = (Component)object;
            converted.append(TownyComponents.toLegacy(component));
        }
        return converted.toString();
    }

    protected Component appendedAsComponent() {
        if (this.appended.isEmpty()) {
            return Component.empty();
        }
        ArrayList<Component> components = new ArrayList<Component>();
        for (Object object : this.appended) {
            if (object instanceof String) {
                String string = (String)object;
                components.add(TownyComponents.miniMessage(string));
                continue;
            }
            if (object instanceof Translatable) {
                Translatable translatable = (Translatable)object;
                components.add(translatable.locale(this.locale).component());
                continue;
            }
            if (!(object instanceof ComponentLike)) continue;
            ComponentLike component = (ComponentLike)object;
            components.add(component.asComponent());
        }
        if (components.isEmpty()) {
            return Component.empty();
        }
        return LinearComponents.linear((ComponentBuilderApplicable[])((ComponentBuilderApplicable[])components.toArray(new Component[0])));
    }

    public Translatable key(String key) {
        this.key = key;
        return this;
    }

    public Translatable args(Object ... args) {
        this.args = args;
        return this;
    }

    public Translatable stripColors(boolean strip) {
        this.stripColors = strip;
        return this;
    }

    public Translatable append(String append) {
        this.appended.add(append);
        return this;
    }

    public Translatable append(Component append) {
        this.appended.add(append);
        return this;
    }

    public Translatable append(Translatable translatable) {
        this.appended.add(translatable);
        return this;
    }

    public Translatable locale(@Nullable Locale locale) {
        this.locale = locale;
        return this;
    }

    public Translatable locale(@NotNull Resident resident) {
        this.locale = Translation.getLocale(resident);
        return this;
    }

    public Translatable locale(@NotNull CommandSender commandSender) {
        this.locale = Translation.getLocale(commandSender);
        return this;
    }

    public String translate(@NotNull Locale locale) {
        this.locale = locale;
        return this.translate();
    }

    protected String translateBase() {
        this.translateArgs(this.locale);
        String translated = this.args == null ? (this.locale == null ? Translation.of(this.key) : Translation.of(this.key, this.locale)) : (this.locale == null ? Translation.of(this.key, this.args) : Translation.of(this.key, this.locale, this.args));
        return translated;
    }

    public String translate() {
        String translated = this.translateBase() + this.appended();
        return this.stripColors ? Colors.strip(translated) : translated;
    }

    public Component component(@NotNull Locale locale) {
        this.locale = locale;
        return this.component();
    }

    public Component component() {
        Component translated = TownyComponents.miniMessage(this.translateBase()).append(this.appendedAsComponent()).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
        if (this.stripColors) {
            return Component.text((String)PlainTextComponentSerializer.plainText().serialize(translated));
        }
        return translated;
    }

    public String forLocale(Resident resident) {
        return this.translate(Translation.getLocale(resident));
    }

    public String forLocale(CommandSender sender) {
        return this.translate(Translation.getLocale(sender));
    }

    public String defaultLocale() {
        return this.translate(Translation.getDefaultLocale());
    }

    private void translateArgs(@Nullable Locale locale) {
        if (this.args == null) {
            return;
        }
        for (int i = 0; i < this.args.length; ++i) {
            if (!(this.args[i] instanceof Translatable)) continue;
            this.args[i] = ((Translatable)this.args[i]).locale(locale).translate();
        }
    }

    public String toString() {
        return this.translate();
    }

    public String debug() {
        return "Translatable{key='" + this.key + "', args=" + Arrays.toString(this.args) + ", stripColors=" + this.stripColors + ", appended=" + this.appended() + ", locale=" + String.valueOf(this.locale) + "}";
    }

    private static final class LiteralTranslatable
    extends Translatable {
        private Component component = null;

        private LiteralTranslatable(String key) {
            super(key);
        }

        private LiteralTranslatable(Component component) {
            super(TownyComponents.toMiniMessage(component));
            this.component = component;
        }

        @Override
        public String translateBase() {
            return this.key();
        }

        @Override
        public Component component() {
            if (this.component == null) {
                return super.component();
            }
            Component full = this.component.append(super.appendedAsComponent()).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
            if (this.stripColors()) {
                return Component.text((String)PlainTextComponentSerializer.plainText().serialize(full));
            }
            return full;
        }
    }
}

